/* src/bazaar.p/bz-main-config.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-main-config.h"



struct _BzMainConfig
{
  GObject parent_instance;

  GListModel *txt_blocklist_paths;
  int blocklist_version;
  GListModel *yaml_blocklist_paths;
  int curated_config_version;
  GListModel *curated_config_paths;
  GListModel *hooks;
};

G_DEFINE_FINAL_TYPE (BzMainConfig, bz_main_config, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_TXT_BLOCKLIST_PATHS,
  PROP_BLOCKLIST_VERSION,
  PROP_YAML_BLOCKLIST_PATHS,
  PROP_CURATED_CONFIG_VERSION,
  PROP_CURATED_CONFIG_PATHS,
  PROP_HOOKS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_main_config_dispose (GObject *object)
{
  BzMainConfig *self = BZ_MAIN_CONFIG (object);

  g_clear_pointer (&self->txt_blocklist_paths, g_object_unref);
  g_clear_pointer (&self->yaml_blocklist_paths, g_object_unref);
  g_clear_pointer (&self->curated_config_paths, g_object_unref);
  g_clear_pointer (&self->hooks, g_object_unref);

  G_OBJECT_CLASS (bz_main_config_parent_class)->dispose (object);
}

static void
bz_main_config_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzMainConfig *self = BZ_MAIN_CONFIG (object);

  switch (prop_id)
    {
    case PROP_TXT_BLOCKLIST_PATHS:
      g_value_set_object (value, bz_main_config_get_txt_blocklist_paths (self));
      break;
    case PROP_BLOCKLIST_VERSION:
      g_value_set_int (value, bz_main_config_get_blocklist_version (self));
      break;
    case PROP_YAML_BLOCKLIST_PATHS:
      g_value_set_object (value, bz_main_config_get_yaml_blocklist_paths (self));
      break;
    case PROP_CURATED_CONFIG_VERSION:
      g_value_set_int (value, bz_main_config_get_curated_config_version (self));
      break;
    case PROP_CURATED_CONFIG_PATHS:
      g_value_set_object (value, bz_main_config_get_curated_config_paths (self));
      break;
    case PROP_HOOKS:
      g_value_set_object (value, bz_main_config_get_hooks (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_main_config_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzMainConfig *self = BZ_MAIN_CONFIG (object);

  switch (prop_id)
    {
    case PROP_TXT_BLOCKLIST_PATHS:
      bz_main_config_set_txt_blocklist_paths (self, g_value_get_object (value));
      break;
    case PROP_BLOCKLIST_VERSION:
      bz_main_config_set_blocklist_version (self, g_value_get_int (value));
      break;
    case PROP_YAML_BLOCKLIST_PATHS:
      bz_main_config_set_yaml_blocklist_paths (self, g_value_get_object (value));
      break;
    case PROP_CURATED_CONFIG_VERSION:
      bz_main_config_set_curated_config_version (self, g_value_get_int (value));
      break;
    case PROP_CURATED_CONFIG_PATHS:
      bz_main_config_set_curated_config_paths (self, g_value_get_object (value));
      break;
    case PROP_HOOKS:
      bz_main_config_set_hooks (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_main_config_class_init (BzMainConfigClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_HOOK);
  g_type_ensure (BZ_TYPE_HOOK_DIALOG);
  g_type_ensure (BZ_TYPE_HOOK_DIALOG_OPTION);

  object_class->set_property = bz_main_config_set_property;
  object_class->get_property = bz_main_config_get_property;
  object_class->dispose      = bz_main_config_dispose;

  props[PROP_TXT_BLOCKLIST_PATHS] =
      g_param_spec_object (
          "txt-blocklist-paths",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BLOCKLIST_VERSION] =
      g_param_spec_int (
          "blocklist-version",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_YAML_BLOCKLIST_PATHS] =
      g_param_spec_object (
          "yaml-blocklist-paths",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CURATED_CONFIG_VERSION] =
      g_param_spec_int (
          "curated-config-version",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CURATED_CONFIG_PATHS] =
      g_param_spec_object (
          "curated-config-paths",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_HOOKS] =
      g_param_spec_object (
          "hooks",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_main_config_init (BzMainConfig *self)
{
}

BzMainConfig *
bz_main_config_new (void){
  return g_object_new (BZ_TYPE_MAIN_CONFIG, NULL);
}

GListModel *
bz_main_config_get_txt_blocklist_paths (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), NULL);
  return self->txt_blocklist_paths;
}

int
bz_main_config_get_blocklist_version (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), 0);
  return self->blocklist_version;
}

GListModel *
bz_main_config_get_yaml_blocklist_paths (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), NULL);
  return self->yaml_blocklist_paths;
}

int
bz_main_config_get_curated_config_version (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), 0);
  return self->curated_config_version;
}

GListModel *
bz_main_config_get_curated_config_paths (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), NULL);
  return self->curated_config_paths;
}

GListModel *
bz_main_config_get_hooks (BzMainConfig *self){
  g_return_val_if_fail (BZ_IS_MAIN_CONFIG (self), NULL);
  return self->hooks;
}

void
bz_main_config_set_txt_blocklist_paths (BzMainConfig *self,
    GListModel *txt_blocklist_paths){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (txt_blocklist_paths == self->txt_blocklist_paths)
    return;

  g_clear_pointer (&self->txt_blocklist_paths, g_object_unref);
  if (txt_blocklist_paths != NULL)
    self->txt_blocklist_paths = g_object_ref (txt_blocklist_paths);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TXT_BLOCKLIST_PATHS]);
}

void
bz_main_config_set_blocklist_version (BzMainConfig *self,
    int blocklist_version){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (blocklist_version == self->blocklist_version)
    return;

  self->blocklist_version = blocklist_version;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCKLIST_VERSION]);
}

void
bz_main_config_set_yaml_blocklist_paths (BzMainConfig *self,
    GListModel *yaml_blocklist_paths){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (yaml_blocklist_paths == self->yaml_blocklist_paths)
    return;

  g_clear_pointer (&self->yaml_blocklist_paths, g_object_unref);
  if (yaml_blocklist_paths != NULL)
    self->yaml_blocklist_paths = g_object_ref (yaml_blocklist_paths);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_YAML_BLOCKLIST_PATHS]);
}

void
bz_main_config_set_curated_config_version (BzMainConfig *self,
    int curated_config_version){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (curated_config_version == self->curated_config_version)
    return;

  self->curated_config_version = curated_config_version;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CURATED_CONFIG_VERSION]);
}

void
bz_main_config_set_curated_config_paths (BzMainConfig *self,
    GListModel *curated_config_paths){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (curated_config_paths == self->curated_config_paths)
    return;

  g_clear_pointer (&self->curated_config_paths, g_object_unref);
  if (curated_config_paths != NULL)
    self->curated_config_paths = g_object_ref (curated_config_paths);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CURATED_CONFIG_PATHS]);
}

void
bz_main_config_set_hooks (BzMainConfig *self,
    GListModel *hooks){
  g_return_if_fail (BZ_IS_MAIN_CONFIG (self));

  if (hooks == self->hooks)
    return;

  g_clear_pointer (&self->hooks, g_object_unref);
  if (hooks != NULL)
    self->hooks = g_object_ref (hooks);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HOOKS]);
}

/* End of src/bazaar.p/bz-main-config.c */
