/* src/bazaar.p/bz-age-rating-attribute.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-age-rating-attribute.h"



struct _BzAgeRatingAttribute
{
  GObject parent_instance;

  BzImportance importance;
  char *id;
  char *title;
  char *description;
  char *icon_name;
};

G_DEFINE_FINAL_TYPE (BzAgeRatingAttribute, bz_age_rating_attribute, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_IMPORTANCE,
  PROP_ID,
  PROP_TITLE,
  PROP_DESCRIPTION,
  PROP_ICON_NAME,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_age_rating_attribute_dispose (GObject *object)
{
  BzAgeRatingAttribute *self = BZ_AGE_RATING_ATTRIBUTE (object);

  g_clear_pointer (&self->id, g_free);
  g_clear_pointer (&self->title, g_free);
  g_clear_pointer (&self->description, g_free);
  g_clear_pointer (&self->icon_name, g_free);

  G_OBJECT_CLASS (bz_age_rating_attribute_parent_class)->dispose (object);
}

static void
bz_age_rating_attribute_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzAgeRatingAttribute *self = BZ_AGE_RATING_ATTRIBUTE (object);

  switch (prop_id)
    {
    case PROP_IMPORTANCE:
      g_value_set_enum (value, bz_age_rating_attribute_get_importance (self));
      break;
    case PROP_ID:
      g_value_set_string (value, bz_age_rating_attribute_get_id (self));
      break;
    case PROP_TITLE:
      g_value_set_string (value, bz_age_rating_attribute_get_title (self));
      break;
    case PROP_DESCRIPTION:
      g_value_set_string (value, bz_age_rating_attribute_get_description (self));
      break;
    case PROP_ICON_NAME:
      g_value_set_string (value, bz_age_rating_attribute_get_icon_name (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_age_rating_attribute_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzAgeRatingAttribute *self = BZ_AGE_RATING_ATTRIBUTE (object);

  switch (prop_id)
    {
    case PROP_IMPORTANCE:
      bz_age_rating_attribute_set_importance (self, g_value_get_enum (value));
      break;
    case PROP_ID:
      bz_age_rating_attribute_set_id (self, g_value_get_string (value));
      break;
    case PROP_TITLE:
      bz_age_rating_attribute_set_title (self, g_value_get_string (value));
      break;
    case PROP_DESCRIPTION:
      bz_age_rating_attribute_set_description (self, g_value_get_string (value));
      break;
    case PROP_ICON_NAME:
      bz_age_rating_attribute_set_icon_name (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_age_rating_attribute_class_init (BzAgeRatingAttributeClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_age_rating_attribute_set_property;
  object_class->get_property = bz_age_rating_attribute_get_property;
  object_class->dispose      = bz_age_rating_attribute_dispose;

  props[PROP_IMPORTANCE] =
      g_param_spec_enum (
          "importance",
          NULL, NULL,
          BZ_TYPE_IMPORTANCE, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ID] =
      g_param_spec_string (
          "id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TITLE] =
      g_param_spec_string (
          "title",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DESCRIPTION] =
      g_param_spec_string (
          "description",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ICON_NAME] =
      g_param_spec_string (
          "icon-name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_age_rating_attribute_init (BzAgeRatingAttribute *self)
{
}

BzAgeRatingAttribute *
bz_age_rating_attribute_new (void){
  return g_object_new (BZ_TYPE_AGE_RATING_ATTRIBUTE, NULL);
}

BzImportance
bz_age_rating_attribute_get_importance (BzAgeRatingAttribute *self){
  g_return_val_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self), 0);
  return self->importance;
}

const char *
bz_age_rating_attribute_get_id (BzAgeRatingAttribute *self){
  g_return_val_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self), NULL);
  return self->id;
}

const char *
bz_age_rating_attribute_get_title (BzAgeRatingAttribute *self){
  g_return_val_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self), NULL);
  return self->title;
}

const char *
bz_age_rating_attribute_get_description (BzAgeRatingAttribute *self){
  g_return_val_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self), NULL);
  return self->description;
}

const char *
bz_age_rating_attribute_get_icon_name (BzAgeRatingAttribute *self){
  g_return_val_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self), NULL);
  return self->icon_name;
}

void
bz_age_rating_attribute_set_importance (BzAgeRatingAttribute *self,
    BzImportance importance){
  g_return_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self));

  if (importance == self->importance)
    return;

  self->importance = importance;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_IMPORTANCE]);
}

void
bz_age_rating_attribute_set_id (BzAgeRatingAttribute *self,
    const char *id){
  g_return_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self));

  if (id == self->id || (id != NULL && self->id != NULL && g_strcmp0(id, self->id) == 0))
    return;

  g_clear_pointer (&self->id, g_free);
  if (id != NULL)
    self->id = g_strdup (id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ID]);
}

void
bz_age_rating_attribute_set_title (BzAgeRatingAttribute *self,
    const char *title){
  g_return_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self));

  if (title == self->title || (title != NULL && self->title != NULL && g_strcmp0(title, self->title) == 0))
    return;

  g_clear_pointer (&self->title, g_free);
  if (title != NULL)
    self->title = g_strdup (title);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TITLE]);
}

void
bz_age_rating_attribute_set_description (BzAgeRatingAttribute *self,
    const char *description){
  g_return_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self));

  if (description == self->description || (description != NULL && self->description != NULL && g_strcmp0(description, self->description) == 0))
    return;

  g_clear_pointer (&self->description, g_free);
  if (description != NULL)
    self->description = g_strdup (description);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DESCRIPTION]);
}

void
bz_age_rating_attribute_set_icon_name (BzAgeRatingAttribute *self,
    const char *icon_name){
  g_return_if_fail (BZ_IS_AGE_RATING_ATTRIBUTE (self));

  if (icon_name == self->icon_name || (icon_name != NULL && self->icon_name != NULL && g_strcmp0(icon_name, self->icon_name) == 0))
    return;

  g_clear_pointer (&self->icon_name, g_free);
  if (icon_name != NULL)
    self->icon_name = g_strdup (icon_name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ICON_NAME]);
}

/* End of src/bazaar.p/bz-age-rating-attribute.c */
