
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_workspace.cc"
#include "rna_workspace_api.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_wmOwnerID_rna_properties;
extern PropertyRNA &rna_wmOwnerID_rna_type;
extern PropertyRNA &rna_wmOwnerID_name;


extern PropertyRNA &rna_WorkSpaceTool_rna_properties;
extern PropertyRNA &rna_WorkSpaceTool_rna_type;
extern PropertyRNA &rna_WorkSpaceTool_idname;
extern PropertyRNA &rna_WorkSpaceTool_idname_fallback;
extern PropertyRNA &rna_WorkSpaceTool_index;
extern PropertyRNA &rna_WorkSpaceTool_space_type;
extern PropertyRNA &rna_WorkSpaceTool_mode;
extern PropertyRNA &rna_WorkSpaceTool_use_paint_canvas;
extern PropertyRNA &rna_WorkSpaceTool_has_datablock;
extern PropertyRNA &rna_WorkSpaceTool_use_brushes;
extern PropertyRNA &rna_WorkSpaceTool_brush_type;
extern PropertyRNA &rna_WorkSpaceTool_widget;

extern FunctionRNA rna_WorkSpaceTool_setup_func;
extern PropertyRNA &rna_WorkSpaceTool_setup_idname;
extern PropertyRNA &rna_WorkSpaceTool_setup_cursor;
extern PropertyRNA &rna_WorkSpaceTool_setup_keymap;
extern PropertyRNA &rna_WorkSpaceTool_setup_gizmo_group;
extern PropertyRNA &rna_WorkSpaceTool_setup_brush_type;
extern PropertyRNA &rna_WorkSpaceTool_setup_data_block;
extern PropertyRNA &rna_WorkSpaceTool_setup_operator;
extern PropertyRNA &rna_WorkSpaceTool_setup_index;
extern PropertyRNA &rna_WorkSpaceTool_setup_options;
extern PropertyRNA &rna_WorkSpaceTool_setup_idname_fallback;
extern PropertyRNA &rna_WorkSpaceTool_setup_keymap_fallback;

extern FunctionRNA rna_WorkSpaceTool_operator_properties_func;
extern PropertyRNA &rna_WorkSpaceTool_operator_properties_operator;
extern PropertyRNA &rna_WorkSpaceTool_operator_properties_result;

extern FunctionRNA rna_WorkSpaceTool_gizmo_group_properties_func;
extern PropertyRNA &rna_WorkSpaceTool_gizmo_group_properties_group;
extern PropertyRNA &rna_WorkSpaceTool_gizmo_group_properties_result;

extern FunctionRNA rna_WorkSpaceTool_refresh_from_context_func;


extern PropertyRNA &rna_ID_rna_properties;
extern PropertyRNA &rna_ID_rna_type;
extern PropertyRNA &rna_ID_name;
extern PropertyRNA &rna_ID_name_full;
extern PropertyRNA &rna_ID_id_type;
extern PropertyRNA &rna_ID_session_uid;
extern PropertyRNA &rna_ID_is_evaluated;
extern PropertyRNA &rna_ID_original;
extern PropertyRNA &rna_ID_users;
extern PropertyRNA &rna_ID_use_fake_user;
extern PropertyRNA &rna_ID_use_extra_user;
extern PropertyRNA &rna_ID_is_embedded_data;
extern PropertyRNA &rna_ID_is_linked_packed;
extern PropertyRNA &rna_ID_is_missing;
extern PropertyRNA &rna_ID_is_runtime_data;
extern PropertyRNA &rna_ID_is_editable;
extern PropertyRNA &rna_ID_tag;
extern PropertyRNA &rna_ID_is_library_indirect;
extern PropertyRNA &rna_ID_library;
extern PropertyRNA &rna_ID_library_weak_reference;
extern PropertyRNA &rna_ID_asset_data;
extern PropertyRNA &rna_ID_override_library;
extern PropertyRNA &rna_ID_preview;

extern PropertyRNA &rna_WorkSpace_screens;
extern PropertyRNA &rna_WorkSpace_owner_ids;
extern PropertyRNA &rna_WorkSpace_tools;
extern PropertyRNA &rna_WorkSpace_object_mode;
extern PropertyRNA &rna_WorkSpace_use_pin_scene;
extern PropertyRNA &rna_WorkSpace_use_filter_by_owner;
extern PropertyRNA &rna_WorkSpace_asset_library_reference;
extern PropertyRNA &rna_WorkSpace_sequencer_scene;
extern PropertyRNA &rna_WorkSpace_use_scene_time_sync;

extern FunctionRNA rna_ID_bl_system_properties_get_func;
extern PropertyRNA &rna_ID_bl_system_properties_get_do_create;
extern PropertyRNA &rna_ID_bl_system_properties_get_system_properties;

extern FunctionRNA rna_ID_rename_func;
extern PropertyRNA &rna_ID_rename_name;
extern PropertyRNA &rna_ID_rename_mode;
extern PropertyRNA &rna_ID_rename_id_rename_result;

extern FunctionRNA rna_ID_evaluated_get_func;
extern PropertyRNA &rna_ID_evaluated_get_depsgraph;
extern PropertyRNA &rna_ID_evaluated_get_id;

extern FunctionRNA rna_ID_copy_func;
extern PropertyRNA &rna_ID_copy_id;

extern FunctionRNA rna_ID_asset_mark_func;
extern FunctionRNA rna_ID_asset_clear_func;
extern FunctionRNA rna_ID_asset_generate_preview_func;
extern FunctionRNA rna_ID_override_create_func;
extern PropertyRNA &rna_ID_override_create_id;
extern PropertyRNA &rna_ID_override_create_remap_local_usages;

extern FunctionRNA rna_ID_override_hierarchy_create_func;
extern PropertyRNA &rna_ID_override_hierarchy_create_id;
extern PropertyRNA &rna_ID_override_hierarchy_create_scene;
extern PropertyRNA &rna_ID_override_hierarchy_create_view_layer;
extern PropertyRNA &rna_ID_override_hierarchy_create_reference;
extern PropertyRNA &rna_ID_override_hierarchy_create_do_fully_editable;

extern FunctionRNA rna_ID_user_clear_func;
extern FunctionRNA rna_ID_user_remap_func;
extern PropertyRNA &rna_ID_user_remap_new_id;

extern FunctionRNA rna_ID_make_local_func;
extern PropertyRNA &rna_ID_make_local_clear_proxy;
extern PropertyRNA &rna_ID_make_local_clear_liboverride;
extern PropertyRNA &rna_ID_make_local_clear_asset_data;
extern PropertyRNA &rna_ID_make_local_id;

extern FunctionRNA rna_ID_user_of_id_func;
extern PropertyRNA &rna_ID_user_of_id_id;
extern PropertyRNA &rna_ID_user_of_id_count;

extern FunctionRNA rna_ID_animation_data_create_func;
extern PropertyRNA &rna_ID_animation_data_create_anim_data;

extern FunctionRNA rna_ID_animation_data_clear_func;
extern FunctionRNA rna_ID_update_tag_func;
extern PropertyRNA &rna_ID_update_tag_refresh;

extern FunctionRNA rna_ID_preview_ensure_func;
extern PropertyRNA &rna_ID_preview_ensure_preview_image;


extern FunctionRNA rna_WorkSpace_status_text_set_internal_func;
extern PropertyRNA &rna_WorkSpace_status_text_set_internal_text;



extern PropertyRNA &rna_wmOwnerIDs_rna_properties;
extern PropertyRNA &rna_wmOwnerIDs_rna_type;

extern FunctionRNA rna_wmOwnerIDs_new_func;
extern PropertyRNA &rna_wmOwnerIDs_new_name;
extern PropertyRNA &rna_wmOwnerIDs_new_owner_id;

extern FunctionRNA rna_wmOwnerIDs_remove_func;
extern PropertyRNA &rna_wmOwnerIDs_remove_owner_id;

extern FunctionRNA rna_wmOwnerIDs_clear_func;


extern PropertyRNA &rna_wmTools_rna_properties;
extern PropertyRNA &rna_wmTools_rna_type;

extern FunctionRNA rna_wmTools_from_space_view3d_mode_func;
extern PropertyRNA &rna_wmTools_from_space_view3d_mode_mode;
extern PropertyRNA &rna_wmTools_from_space_view3d_mode_create;
extern PropertyRNA &rna_wmTools_from_space_view3d_mode_result;

extern FunctionRNA rna_wmTools_from_space_image_mode_func;
extern PropertyRNA &rna_wmTools_from_space_image_mode_mode;
extern PropertyRNA &rna_wmTools_from_space_image_mode_create;
extern PropertyRNA &rna_wmTools_from_space_image_mode_result;

extern FunctionRNA rna_wmTools_from_space_node_func;
extern PropertyRNA &rna_wmTools_from_space_node_create;
extern PropertyRNA &rna_wmTools_from_space_node_result;

extern FunctionRNA rna_wmTools_from_space_sequencer_func;
extern PropertyRNA &rna_wmTools_from_space_sequencer_mode;
extern PropertyRNA &rna_wmTools_from_space_sequencer_create;
extern PropertyRNA &rna_wmTools_from_space_sequencer_result;


static PointerRNA wmOwnerID_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void wmOwnerID_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_wmOwnerID_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = wmOwnerID_rna_properties_get(iter);
    }
}

extern void wmOwnerID_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = wmOwnerID_rna_properties_get(iter);
    }
}

extern void wmOwnerID_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool wmOwnerID_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA wmOwnerID_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void wmOwnerID_name_get(PointerRNA *ptr, char *value)
{
    wmOwnerID *data = (wmOwnerID *)(ptr->data);
    strcpy(value, data->name);
}

extern int wmOwnerID_name_length(PointerRNA *ptr)
{
    wmOwnerID *data = (wmOwnerID *)(ptr->data);
    return strlen(data->name);
}

extern void wmOwnerID_name_set(PointerRNA *ptr, const char *value)
{
    wmOwnerID *data = (wmOwnerID *)(ptr->data);
    BLI_strncpy_utf8(data->name, value, 128);
}

static PointerRNA WorkSpaceTool_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void WorkSpaceTool_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_WorkSpaceTool_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = WorkSpaceTool_rna_properties_get(iter);
    }
}

extern void WorkSpaceTool_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = WorkSpaceTool_rna_properties_get(iter);
    }
}

extern void WorkSpaceTool_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool WorkSpaceTool_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA WorkSpaceTool_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void WorkSpaceTool_idname_get(PointerRNA *ptr, char *value)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    strcpy(value, data->idname);
}

extern int WorkSpaceTool_idname_length(PointerRNA *ptr)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    return strlen(data->idname);
}

extern void WorkSpaceTool_idname_set(PointerRNA *ptr, const char *value)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    BLI_strncpy_utf8(data->idname, value, 64);
}

extern void WorkSpaceTool_idname_fallback_get(PointerRNA *ptr, char *value)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    strcpy(value, data->idname_fallback);
}

extern int WorkSpaceTool_idname_fallback_length(PointerRNA *ptr)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    return strlen(data->idname_fallback);
}

extern void WorkSpaceTool_idname_fallback_set(PointerRNA *ptr, const char *value)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    BLI_strncpy_utf8(data->idname_fallback, value, 64);
}

extern int WorkSpaceTool_index_get(PointerRNA *ptr)
{
    PropIntGetFunc fn = rna_WorkSpaceTool_index_get;
    return fn(ptr);
}

extern int WorkSpaceTool_space_type_get(PointerRNA *ptr)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    return (int)(data->space_type);
}

extern int WorkSpaceTool_mode_get(PointerRNA *ptr)
{
    bToolRef *data = (bToolRef *)(ptr->data);
    return (int)(data->mode);
}

extern bool WorkSpaceTool_use_paint_canvas_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_WorkSpaceTool_use_paint_canvas_get;
    return fn(ptr);
}

extern bool WorkSpaceTool_has_datablock_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_WorkSpaceTool_has_datablock_get;
    return fn(ptr);
}

extern bool WorkSpaceTool_use_brushes_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_WorkSpaceTool_use_brushes_get;
    return fn(ptr);
}

extern int WorkSpaceTool_brush_type_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_WorkSpaceTool_brush_type_get;
    return fn(ptr);
}

extern void WorkSpaceTool_widget_get(PointerRNA *ptr, char *value)
{
    PropStringGetFunc fn = rna_WorkSpaceTool_widget_get;
    fn(ptr, value);
}

extern int WorkSpaceTool_widget_length(PointerRNA *ptr)
{
    PropStringLengthFunc fn = rna_WorkSpaceTool_widget_length;
    return fn(ptr);
}

static PointerRNA WorkSpace_screens_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_workspace_screens_item_get;
    return fn(iter);
}

extern void WorkSpace_screens_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_WorkSpace_screens;

    PropCollectionBeginFunc fn = rna_workspace_screens_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = WorkSpace_screens_get(iter);
    }
}

extern void WorkSpace_screens_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = WorkSpace_screens_get(iter);
    }
}

extern void WorkSpace_screens_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool WorkSpace_screens_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    WorkSpace_screens_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = WorkSpace_screens_get(&iter); }
    }

    WorkSpace_screens_end(&iter);

    return found;
}

extern int ID_name_length(PointerRNA *);
extern void ID_name_get(PointerRNA *, char *);

extern bool WorkSpace_screens_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;
    char namebuf[1024];
    char *name;

    WorkSpace_screens_begin(&iter, ptr);

    while (iter.valid) {
        if (iter.ptr.data) {
            int namelen = ID_name_length(&iter.ptr);
            if (namelen < 1024) {
                ID_name_get(&iter.ptr, namebuf);
                if (strcmp(namebuf, key) == 0) {
                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
            }
            else {
                name = MEM_malloc_arrayN<char>(size_t(namelen) + 1,
                                               "name string");
                ID_name_get(&iter.ptr, name);
                if (strcmp(name, key) == 0) {
                    MEM_freeN(name);

                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
                else {
                    MEM_freeN(name);
                }
            }
        }
        WorkSpace_screens_next(&iter);
    }
    WorkSpace_screens_end(&iter);

    return found;
}

static PointerRNA WorkSpace_owner_ids_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_wmOwnerID, rna_iterator_listbase_get(iter));
}

extern void WorkSpace_owner_ids_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_WorkSpace_owner_ids;

    rna_iterator_listbase_begin(iter, ptr, &data->owner_ids, nullptr);

    if (iter->valid) {
        iter->ptr = WorkSpace_owner_ids_get(iter);
    }
}

extern void WorkSpace_owner_ids_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = WorkSpace_owner_ids_get(iter);
    }
}

extern void WorkSpace_owner_ids_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool WorkSpace_owner_ids_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    WorkSpace_owner_ids_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = WorkSpace_owner_ids_get(&iter); }
    }

    WorkSpace_owner_ids_end(&iter);

    return found;
}

extern int wmOwnerID_name_length(PointerRNA *);
extern void wmOwnerID_name_get(PointerRNA *, char *);

extern bool WorkSpace_owner_ids_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;
    char namebuf[1024];
    char *name;

    WorkSpace_owner_ids_begin(&iter, ptr);

    while (iter.valid) {
        if (iter.ptr.data) {
            int namelen = wmOwnerID_name_length(&iter.ptr);
            if (namelen < 1024) {
                wmOwnerID_name_get(&iter.ptr, namebuf);
                if (strcmp(namebuf, key) == 0) {
                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
            }
            else {
                name = MEM_malloc_arrayN<char>(size_t(namelen) + 1,
                                               "name string");
                wmOwnerID_name_get(&iter.ptr, name);
                if (strcmp(name, key) == 0) {
                    MEM_freeN(name);

                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
                else {
                    MEM_freeN(name);
                }
            }
        }
        WorkSpace_owner_ids_next(&iter);
    }
    WorkSpace_owner_ids_end(&iter);

    return found;
}

static PointerRNA WorkSpace_tools_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_WorkSpaceTool, rna_iterator_listbase_get(iter));
}

extern void WorkSpace_tools_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_WorkSpace_tools;

    rna_iterator_listbase_begin(iter, ptr, &data->tools, nullptr);

    if (iter->valid) {
        iter->ptr = WorkSpace_tools_get(iter);
    }
}

extern void WorkSpace_tools_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = WorkSpace_tools_get(iter);
    }
}

extern void WorkSpace_tools_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool WorkSpace_tools_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    WorkSpace_tools_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = WorkSpace_tools_get(&iter); }
    }

    WorkSpace_tools_end(&iter);

    return found;
}

extern int WorkSpaceTool_idname_length(PointerRNA *);
extern void WorkSpaceTool_idname_get(PointerRNA *, char *);

extern bool WorkSpace_tools_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;
    char namebuf[1024];
    char *name;

    WorkSpace_tools_begin(&iter, ptr);

    while (iter.valid) {
        if (iter.ptr.data) {
            int namelen = WorkSpaceTool_idname_length(&iter.ptr);
            if (namelen < 1024) {
                WorkSpaceTool_idname_get(&iter.ptr, namebuf);
                if (strcmp(namebuf, key) == 0) {
                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
            }
            else {
                name = MEM_malloc_arrayN<char>(size_t(namelen) + 1,
                                               "name string");
                WorkSpaceTool_idname_get(&iter.ptr, name);
                if (strcmp(name, key) == 0) {
                    MEM_freeN(name);

                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
                else {
                    MEM_freeN(name);
                }
            }
        }
        WorkSpace_tools_next(&iter);
    }
    WorkSpace_tools_end(&iter);

    return found;
}

extern int WorkSpace_object_mode_get(PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    return (int)(data->object_mode);
}

extern void WorkSpace_object_mode_set(PointerRNA *ptr, int value)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
#ifdef __cplusplus
    data->object_mode = (std::remove_reference_t<decltype(data->object_mode)>)value;
#else
    data->object_mode = value;
#endif
}

extern bool WorkSpace_use_pin_scene_get(PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    return (((data->flags) & 4) != 0);
}

extern void WorkSpace_use_pin_scene_set(PointerRNA *ptr, bool value)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    if (value) { data->flags |= 4; }
    else { data->flags &= ~4; }
}

extern bool WorkSpace_use_filter_by_owner_get(PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    return (((data->flags) & 2) != 0);
}

extern void WorkSpace_use_filter_by_owner_set(PointerRNA *ptr, bool value)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    if (value) { data->flags |= 2; }
    else { data->flags &= ~2; }
}

extern int WorkSpace_asset_library_reference_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_WorkSpace_asset_library_get;
    return fn(ptr);
}

extern void WorkSpace_asset_library_reference_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_WorkSpace_asset_library_set;
    fn(ptr, value);
}

extern PointerRNA WorkSpace_sequencer_scene_get(PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Scene, data->sequencer_scene);
}

extern void WorkSpace_sequencer_scene_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }
    if (value.data) {
        id_lib_extern((ID *)value.data);
    }
    *(void **)&data->sequencer_scene = value.data;
}

extern bool WorkSpace_use_scene_time_sync_get(PointerRNA *ptr)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    return (((data->flags) & 8) != 0);
}

extern void WorkSpace_use_scene_time_sync_set(PointerRNA *ptr, bool value)
{
    WorkSpace *data = (WorkSpace *)(ptr->data);
    if (value) { data->flags |= 8; }
    else { data->flags &= ~8; }
}

static PointerRNA wmOwnerIDs_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void wmOwnerIDs_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_wmOwnerIDs_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = wmOwnerIDs_rna_properties_get(iter);
    }
}

extern void wmOwnerIDs_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = wmOwnerIDs_rna_properties_get(iter);
    }
}

extern void wmOwnerIDs_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool wmOwnerIDs_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA wmOwnerIDs_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA wmTools_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void wmTools_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_wmTools_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = wmTools_rna_properties_get(iter);
    }
}

extern void wmTools_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = wmTools_rna_properties_get(iter);
    }
}

extern void wmTools_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool wmTools_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA wmTools_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}


extern void WorkSpaceTool_setup_func(struct ID *_selfid, struct bToolRef *_self, bContext *C, const char * idname, int cursor, const char * keymap, const char * gizmo_group, int brush_type, const char * data_block, const char * operator_value, int index, int options, const char * idname_fallback, const char * keymap_fallback)
{
	rna_WorkSpaceTool_setup(_selfid, _self, C, idname, cursor, keymap, gizmo_group, brush_type, data_block, operator_value, index, options, idname_fallback, keymap_fallback);
}

static void WorkSpaceTool_setup_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct bToolRef *_self;
	const char * idname;
	int cursor;
	const char * keymap;
	const char * gizmo_group;
	int brush_type;
	const char * data_block;
	const char * operator_value;
	int index;
	int options;
	const char * idname_fallback;
	const char * keymap_fallback;
	char *_data;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct bToolRef *)_ptr->data;
	_data = (char *)_parms->data;
	idname = *((const char * *)_data);
	_data += 8;
	cursor = *((int *)_data);
	_data += 8;
	keymap = *((const char * *)_data);
	_data += 8;
	gizmo_group = *((const char * *)_data);
	_data += 8;
	brush_type = *((int *)_data);
	_data += 8;
	data_block = *((const char * *)_data);
	_data += 8;
	operator_value = *((const char * *)_data);
	_data += 8;
	index = *((int *)_data);
	_data += 8;
	options = *((int *)_data);
	_data += 8;
	idname_fallback = *((const char * *)_data);
	_data += 8;
	keymap_fallback = *((const char * *)_data);
	
	rna_WorkSpaceTool_setup(_selfid, _self, C, idname, cursor, keymap, gizmo_group, brush_type, data_block, operator_value, index, options, idname_fallback, keymap_fallback);
}

extern struct PointerRNA WorkSpaceTool_operator_properties_func(struct bToolRef *_self, ReportList *reports, const char * operator_value)
{
	return rna_WorkSpaceTool_operator_properties(_self, reports, operator_value);
}

static void WorkSpaceTool_operator_properties_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bToolRef *_self;
	const char * operator_value;
	struct PointerRNA result;
	char *_data, *_retdata;
	
	_self = (struct bToolRef *)_ptr->data;
	_data = (char *)_parms->data;
	operator_value = *((const char * *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpaceTool_operator_properties(_self, reports, operator_value);
	*reinterpret_cast<PointerRNA *>(_retdata) = result;
}

extern struct PointerRNA WorkSpaceTool_gizmo_group_properties_func(struct bToolRef *_self, ReportList *reports, const char * group)
{
	return rna_WorkSpaceTool_gizmo_group_properties(_self, reports, group);
}

static void WorkSpaceTool_gizmo_group_properties_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bToolRef *_self;
	const char * group;
	struct PointerRNA result;
	char *_data, *_retdata;
	
	_self = (struct bToolRef *)_ptr->data;
	_data = (char *)_parms->data;
	group = *((const char * *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpaceTool_gizmo_group_properties(_self, reports, group);
	*reinterpret_cast<PointerRNA *>(_retdata) = result;
}

extern void WorkSpaceTool_refresh_from_context_func(struct ID *_selfid, struct bToolRef *_self, Main *bmain)
{
	rna_WorkSpaceTool_refresh_from_context(_selfid, _self, bmain);
}

static void WorkSpaceTool_refresh_from_context_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct bToolRef *_self;
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct bToolRef *)_ptr->data;
	
	rna_WorkSpaceTool_refresh_from_context(_selfid, _self, CTX_data_main(C));
}

/* Repeated prototypes to detect errors */

void rna_WorkSpaceTool_setup(struct ID *_selfid, struct bToolRef *_self, bContext *C, const char * idname, int cursor, const char * keymap, const char * gizmo_group, int brush_type, const char * data_block, const char * operator_value, int index, int options, const char * idname_fallback, const char * keymap_fallback);
struct PointerRNA rna_WorkSpaceTool_operator_properties(struct bToolRef *_self, ReportList *reports, const char * operator_value);
struct PointerRNA rna_WorkSpaceTool_gizmo_group_properties(struct bToolRef *_self, ReportList *reports, const char * group);
void rna_WorkSpaceTool_refresh_from_context(struct ID *_selfid, struct bToolRef *_self, Main *bmain);

extern void WorkSpace_status_text_set_internal_func(bContext *C, const char * text)
{
	ED_workspace_status_text(C, text);
}

static void WorkSpace_status_text_set_internal_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	const char * text;
	char *_data;
	
	_data = (char *)_parms->data;
	text = *((const char * *)_data);
	
	ED_workspace_status_text(C, text);
}

/* Repeated prototypes to detect errors */

void ED_workspace_status_text(bContext *C, const char * text);

extern struct wmOwnerID *wmOwnerIDs_new_func(struct WorkSpace *_self, const char * name)
{
	return rna_WorkSpace_owner_ids_new(_self, name);
}

static void wmOwnerIDs_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	const char * name;
	struct wmOwnerID *owner_id;
	char *_data, *_retdata;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	name = *((const char * *)_data);
	_data += 8;
	_retdata = _data;
	
	owner_id = rna_WorkSpace_owner_ids_new(_self, name);
	*((struct wmOwnerID **)_retdata) = owner_id;
}

extern void wmOwnerIDs_remove_func(struct WorkSpace *_self, ReportList *reports, struct PointerRNA *owner_id)
{
	rna_WorkSpace_owner_ids_remove(_self, reports, owner_id);
}

static void wmOwnerIDs_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	struct PointerRNA *owner_id;
	char *_data;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	owner_id = *((struct PointerRNA **)_data);
	
	rna_WorkSpace_owner_ids_remove(_self, reports, owner_id);
}

extern void wmOwnerIDs_clear_func(struct WorkSpace *_self)
{
	rna_WorkSpace_owner_ids_clear(_self);
}

static void wmOwnerIDs_clear_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	_self = (struct WorkSpace *)_ptr->data;
	
	rna_WorkSpace_owner_ids_clear(_self);
}

/* Repeated prototypes to detect errors */

struct wmOwnerID *rna_WorkSpace_owner_ids_new(struct WorkSpace *_self, const char * name);
void rna_WorkSpace_owner_ids_remove(struct WorkSpace *_self, ReportList *reports, struct PointerRNA *owner_id);
void rna_WorkSpace_owner_ids_clear(struct WorkSpace *_self);

extern struct bToolRef *wmTools_from_space_view3d_mode_func(struct WorkSpace *_self, int mode, bool create)
{
	return rna_WorkSpace_tools_from_space_view3d_mode(_self, mode, create);
}

static void wmTools_from_space_view3d_mode_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	int mode;
	bool create;
	struct bToolRef *result;
	char *_data, *_retdata;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	mode = *((int *)_data);
	_data += 8;
	create = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpace_tools_from_space_view3d_mode(_self, mode, create);
	*((struct bToolRef **)_retdata) = result;
}

extern struct bToolRef *wmTools_from_space_image_mode_func(struct WorkSpace *_self, int mode, bool create)
{
	return rna_WorkSpace_tools_from_space_image_mode(_self, mode, create);
}

static void wmTools_from_space_image_mode_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	int mode;
	bool create;
	struct bToolRef *result;
	char *_data, *_retdata;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	mode = *((int *)_data);
	_data += 8;
	create = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpace_tools_from_space_image_mode(_self, mode, create);
	*((struct bToolRef **)_retdata) = result;
}

extern struct bToolRef *wmTools_from_space_node_func(struct WorkSpace *_self, bool create)
{
	return rna_WorkSpace_tools_from_space_node(_self, create);
}

static void wmTools_from_space_node_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	bool create;
	struct bToolRef *result;
	char *_data, *_retdata;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	create = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpace_tools_from_space_node(_self, create);
	*((struct bToolRef **)_retdata) = result;
}

extern struct bToolRef *wmTools_from_space_sequencer_func(struct WorkSpace *_self, int mode, bool create)
{
	return rna_WorkSpace_tools_from_space_sequencer(_self, mode, create);
}

static void wmTools_from_space_sequencer_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct WorkSpace *_self;
	int mode;
	bool create;
	struct bToolRef *result;
	char *_data, *_retdata;
	
	_self = (struct WorkSpace *)_ptr->data;
	_data = (char *)_parms->data;
	mode = *((int *)_data);
	_data += 8;
	create = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	result = rna_WorkSpace_tools_from_space_sequencer(_self, mode, create);
	*((struct bToolRef **)_retdata) = result;
}

/* Repeated prototypes to detect errors */

struct bToolRef *rna_WorkSpace_tools_from_space_view3d_mode(struct WorkSpace *_self, int mode, bool create);
struct bToolRef *rna_WorkSpace_tools_from_space_image_mode(struct WorkSpace *_self, int mode, bool create);
struct bToolRef *rna_WorkSpace_tools_from_space_node(struct WorkSpace *_self, bool create);
struct bToolRef *rna_WorkSpace_tools_from_space_sequencer(struct WorkSpace *_self, int mode, bool create);

/* Work Space UI Tag */
static CollectionPropertyRNA rna_wmOwnerID_rna_properties_ = {
	{&rna_wmOwnerID_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmOwnerID_rna_properties_begin, wmOwnerID_rna_properties_next, wmOwnerID_rna_properties_end, wmOwnerID_rna_properties_get, nullptr, nullptr, wmOwnerID_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_wmOwnerID_rna_properties = reinterpret_cast<PropertyRNA &>(rna_wmOwnerID_rna_properties_);

static PointerPropertyRNA rna_wmOwnerID_rna_type_ = {
	{&rna_wmOwnerID_name, &rna_wmOwnerID_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmOwnerID_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_wmOwnerID_rna_type = reinterpret_cast<PropertyRNA &>(rna_wmOwnerID_rna_type_);

static StringPropertyRNA rna_wmOwnerID_name_ = {
	{nullptr, &rna_wmOwnerID_rna_type,
	-1, "name", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Name",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {128, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmOwnerID_name_get, wmOwnerID_name_length, wmOwnerID_name_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 128, ""
};
PropertyRNA &rna_wmOwnerID_name = reinterpret_cast<PropertyRNA &>(rna_wmOwnerID_name_);

StructRNA RNA_wmOwnerID = {
	{(ContainerRNA *)&RNA_WorkSpaceTool, (ContainerRNA *)&RNA_GizmoGroupProperties,
	nullptr,
	{&rna_wmOwnerID_rna_properties, &rna_wmOwnerID_name}},
	"wmOwnerID", nullptr, nullptr, 516, nullptr, "Work Space UI Tag",
	"",
	"*", 63,
	&rna_wmOwnerID_name, &rna_wmOwnerID_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Work Space Tool */
static CollectionPropertyRNA rna_WorkSpaceTool_rna_properties_ = {
	{&rna_WorkSpaceTool_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_rna_properties_begin, WorkSpaceTool_rna_properties_next, WorkSpaceTool_rna_properties_end, WorkSpaceTool_rna_properties_get, nullptr, nullptr, WorkSpaceTool_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_WorkSpaceTool_rna_properties = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_rna_properties_);

static PointerPropertyRNA rna_WorkSpaceTool_rna_type_ = {
	{&rna_WorkSpaceTool_idname, &rna_WorkSpaceTool_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_WorkSpaceTool_rna_type = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_rna_type_);

static StringPropertyRNA rna_WorkSpaceTool_idname_ = {
	{&rna_WorkSpaceTool_idname_fallback, &rna_WorkSpaceTool_rna_type,
	-1, "idname", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Identifier",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_idname_get, WorkSpaceTool_idname_length, WorkSpaceTool_idname_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_idname = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_idname_);

static StringPropertyRNA rna_WorkSpaceTool_idname_fallback_ = {
	{&rna_WorkSpaceTool_index, &rna_WorkSpaceTool_idname,
	-1, "idname_fallback", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Identifier Fallback",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_idname_fallback_get, WorkSpaceTool_idname_fallback_length, WorkSpaceTool_idname_fallback_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_idname_fallback = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_idname_fallback_);

static IntPropertyRNA rna_WorkSpaceTool_index_ = {
	{&rna_WorkSpaceTool_space_type, &rna_WorkSpaceTool_idname_fallback,
	-1, "index", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Index",
	"",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_index_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpaceTool_index = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_index_);

static EnumPropertyRNA rna_WorkSpaceTool_space_type_ = {
	{&rna_WorkSpaceTool_mode, &rna_WorkSpaceTool_index,
	-1, "space_type", 2, 0, 0, 4, 0, PropertyPathTemplateType(0), "Space Type",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bToolRef, space_type), RawPropertyType(1), nullptr},
	WorkSpaceTool_space_type_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_space_type_items, 23, 0
};
PropertyRNA &rna_WorkSpaceTool_space_type = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_space_type_);

static EnumPropertyRNA rna_WorkSpaceTool_mode_ = {
	{&rna_WorkSpaceTool_use_paint_canvas, &rna_WorkSpaceTool_space_type,
	-1, "mode", 2, 0, 0, 4, 0, PropertyPathTemplateType(0), "Tool Mode",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bToolRef, mode), RawPropertyType(0), nullptr},
	WorkSpaceTool_mode_get, nullptr, rna_WorkSpace_tools_mode_itemf, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_dummy_DEFAULT_items, 1, 0
};
PropertyRNA &rna_WorkSpaceTool_mode = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_mode_);

static BoolPropertyRNA rna_WorkSpaceTool_use_paint_canvas_ = {
	{&rna_WorkSpaceTool_has_datablock, &rna_WorkSpaceTool_mode,
	-1, "use_paint_canvas", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use Paint Canvas",
	"Does this tool use a painting canvas",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_use_paint_canvas_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpaceTool_use_paint_canvas = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_use_paint_canvas_);

static BoolPropertyRNA rna_WorkSpaceTool_has_datablock_ = {
	{&rna_WorkSpaceTool_use_brushes, &rna_WorkSpaceTool_use_paint_canvas,
	-1, "has_datablock", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Has Data-Block",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_has_datablock_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpaceTool_has_datablock = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_has_datablock_);

static BoolPropertyRNA rna_WorkSpaceTool_use_brushes_ = {
	{&rna_WorkSpaceTool_brush_type, &rna_WorkSpaceTool_has_datablock,
	-1, "use_brushes", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Uses Brushes",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_use_brushes_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpaceTool_use_brushes = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_use_brushes_);

static EnumPropertyRNA rna_WorkSpaceTool_brush_type_ = {
	{&rna_WorkSpaceTool_widget, &rna_WorkSpaceTool_use_brushes,
	-1, "brush_type", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Brush Type",
	"If the tool uses brushes and is limited to a specific brush type, the identifier of the brush type",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_brush_type_get, nullptr, rna_WorkSpaceTool_brush_type_itemf, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_dummy_DEFAULT_items, 1, 0
};
PropertyRNA &rna_WorkSpaceTool_brush_type = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_brush_type_);

static StringPropertyRNA rna_WorkSpaceTool_widget_ = {
	{nullptr, &rna_WorkSpaceTool_brush_type,
	-1, "widget", 262144, 0, 0, 0, 0, PropertyPathTemplateType(0), "Widget",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpaceTool_widget_get, WorkSpaceTool_widget_length, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_WorkSpaceTool_widget = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_widget_);

static StringPropertyRNA rna_WorkSpaceTool_setup_idname_ = {
	{&rna_WorkSpaceTool_setup_cursor, nullptr,
	-1, "idname", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "Identifier",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_idname = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_idname_);

static EnumPropertyRNA rna_WorkSpaceTool_setup_cursor_ = {
	{&rna_WorkSpaceTool_setup_keymap, &rna_WorkSpaceTool_setup_idname,
	-1, "cursor", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "cursor",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_window_cursor_items, 26, 1
};
PropertyRNA &rna_WorkSpaceTool_setup_cursor = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_cursor_);

static StringPropertyRNA rna_WorkSpaceTool_setup_keymap_ = {
	{&rna_WorkSpaceTool_setup_gizmo_group, &rna_WorkSpaceTool_setup_cursor,
	-1, "keymap", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Key Map",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_keymap = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_keymap_);

static StringPropertyRNA rna_WorkSpaceTool_setup_gizmo_group_ = {
	{&rna_WorkSpaceTool_setup_brush_type, &rna_WorkSpaceTool_setup_keymap,
	-1, "gizmo_group", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Gizmo Group",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_gizmo_group = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_gizmo_group_);

static EnumPropertyRNA rna_WorkSpaceTool_setup_brush_type_ = {
	{&rna_WorkSpaceTool_setup_data_block, &rna_WorkSpaceTool_setup_gizmo_group,
	-1, "brush_type", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Brush Type",
	"Limit this tool to a specific type of brush",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, rna_WorkSpaceTool_brush_type_itemf, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_dummy_NULL_items, 0, -1
};
PropertyRNA &rna_WorkSpaceTool_setup_brush_type = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_brush_type_);

static StringPropertyRNA rna_WorkSpaceTool_setup_data_block_ = {
	{&rna_WorkSpaceTool_setup_operator, &rna_WorkSpaceTool_setup_brush_type,
	-1, "data_block", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Data Block",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_data_block = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_data_block_);

static StringPropertyRNA rna_WorkSpaceTool_setup_operator_ = {
	{&rna_WorkSpaceTool_setup_index, &rna_WorkSpaceTool_setup_data_block,
	-1, "operator", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Operator",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_operator = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_operator_);

static IntPropertyRNA rna_WorkSpaceTool_setup_index_ = {
	{&rna_WorkSpaceTool_setup_options, &rna_WorkSpaceTool_setup_operator,
	-1, "index", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Index",
	"",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, INT_MIN, INT_MAX, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpaceTool_setup_index = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_index_);

static const EnumPropertyItem rna_WorkSpaceTool_setup_options_items[3] = {
	{1, "KEYMAP_FALLBACK", 0, "Fallback", ""},
	{2, "USE_BRUSHES", 0, "Uses Brushes", "Allow this tool to use brushes via the asset system"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_WorkSpaceTool_setup_options_ = {
	{&rna_WorkSpaceTool_setup_idname_fallback, &rna_WorkSpaceTool_setup_index,
	-1, "options", 2097155, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tool Options",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_WorkSpaceTool_setup_options_items, 2, 0
};
PropertyRNA &rna_WorkSpaceTool_setup_options = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_options_);

static StringPropertyRNA rna_WorkSpaceTool_setup_idname_fallback_ = {
	{&rna_WorkSpaceTool_setup_keymap_fallback, &rna_WorkSpaceTool_setup_options,
	-1, "idname_fallback", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Fallback Identifier",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_idname_fallback = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_idname_fallback_);

static StringPropertyRNA rna_WorkSpaceTool_setup_keymap_fallback_ = {
	{nullptr, &rna_WorkSpaceTool_setup_idname_fallback,
	-1, "keymap_fallback", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Fallback Key Map",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_WorkSpaceTool_setup_keymap_fallback = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_setup_keymap_fallback_);

FunctionRNA rna_WorkSpaceTool_setup_func = {
	{(FunctionRNA *)&rna_WorkSpaceTool_operator_properties_func, nullptr,
	nullptr,
	{&rna_WorkSpaceTool_setup_idname, &rna_WorkSpaceTool_setup_keymap_fallback}},
	"setup", 2056, "Set the tool settings",
	WorkSpaceTool_setup_call,
	nullptr
};

static StringPropertyRNA rna_WorkSpaceTool_operator_properties_operator_ = {
	{&rna_WorkSpaceTool_operator_properties_result, nullptr,
	-1, "operator", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_WorkSpaceTool_operator_properties_operator = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_operator_properties_operator_);

static PointerPropertyRNA rna_WorkSpaceTool_operator_properties_result_ = {
	{nullptr, &rna_WorkSpaceTool_operator_properties_operator,
	-1, "result", 8650752, 0, 6, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_OperatorProperties
};
PropertyRNA &rna_WorkSpaceTool_operator_properties_result = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_operator_properties_result_);

FunctionRNA rna_WorkSpaceTool_operator_properties_func = {
	{(FunctionRNA *)&rna_WorkSpaceTool_gizmo_group_properties_func, (FunctionRNA *)&rna_WorkSpaceTool_setup_func,
	nullptr,
	{&rna_WorkSpaceTool_operator_properties_operator, &rna_WorkSpaceTool_operator_properties_result}},
	"operator_properties", 16, "operator_properties",
	WorkSpaceTool_operator_properties_call,
	&rna_WorkSpaceTool_operator_properties_result
};

static StringPropertyRNA rna_WorkSpaceTool_gizmo_group_properties_group_ = {
	{&rna_WorkSpaceTool_gizmo_group_properties_result, nullptr,
	-1, "group", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_WorkSpaceTool_gizmo_group_properties_group = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_gizmo_group_properties_group_);

static PointerPropertyRNA rna_WorkSpaceTool_gizmo_group_properties_result_ = {
	{nullptr, &rna_WorkSpaceTool_gizmo_group_properties_group,
	-1, "result", 8650752, 0, 6, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GizmoGroupProperties
};
PropertyRNA &rna_WorkSpaceTool_gizmo_group_properties_result = reinterpret_cast<PropertyRNA &>(rna_WorkSpaceTool_gizmo_group_properties_result_);

FunctionRNA rna_WorkSpaceTool_gizmo_group_properties_func = {
	{(FunctionRNA *)&rna_WorkSpaceTool_refresh_from_context_func, (FunctionRNA *)&rna_WorkSpaceTool_operator_properties_func,
	nullptr,
	{&rna_WorkSpaceTool_gizmo_group_properties_group, &rna_WorkSpaceTool_gizmo_group_properties_result}},
	"gizmo_group_properties", 16, "gizmo_group_properties",
	WorkSpaceTool_gizmo_group_properties_call,
	&rna_WorkSpaceTool_gizmo_group_properties_result
};

FunctionRNA rna_WorkSpaceTool_refresh_from_context_func = {
	{nullptr, (FunctionRNA *)&rna_WorkSpaceTool_gizmo_group_properties_func,
	nullptr,
	{nullptr, nullptr}},
	"refresh_from_context", 2052, "refresh_from_context",
	WorkSpaceTool_refresh_from_context_call,
	nullptr
};

StructRNA RNA_WorkSpaceTool = {
	{(ContainerRNA *)&RNA_WorkSpace, (ContainerRNA *)&RNA_wmOwnerID,
	nullptr,
	{&rna_WorkSpaceTool_rna_properties, &rna_WorkSpaceTool_widget}},
	"WorkSpaceTool", nullptr, nullptr, 516, nullptr, "Work Space Tool",
	"",
	"*", 63,
	&rna_WorkSpaceTool_idname, &rna_WorkSpaceTool_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_WorkSpaceTool_setup_func, (FunctionRNA *)&rna_WorkSpaceTool_refresh_from_context_func}
};

/* Workspace */
static CollectionPropertyRNA rna_WorkSpace_screens_ = {
	{&rna_WorkSpace_owner_ids, nullptr,
	-1, "screens", 128, 0, 0, 0, 0, PropertyPathTemplateType(0), "Screens",
	"Screen layouts of a workspace",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_screens_begin, WorkSpace_screens_next, WorkSpace_screens_end, WorkSpace_screens_get, nullptr, WorkSpace_screens_lookup_int, WorkSpace_screens_lookup_string, nullptr, &RNA_Screen
};
PropertyRNA &rna_WorkSpace_screens = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_screens_);

static CollectionPropertyRNA rna_WorkSpace_owner_ids_ = {
	{&rna_WorkSpace_tools, &rna_WorkSpace_screens,
	-1, "owner_ids", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "UI Tags",
	"",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_wmOwnerIDs},
	WorkSpace_owner_ids_begin, WorkSpace_owner_ids_next, WorkSpace_owner_ids_end, WorkSpace_owner_ids_get, nullptr, WorkSpace_owner_ids_lookup_int, WorkSpace_owner_ids_lookup_string, nullptr, &RNA_wmOwnerID
};
PropertyRNA &rna_WorkSpace_owner_ids = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_owner_ids_);

static CollectionPropertyRNA rna_WorkSpace_tools_ = {
	{&rna_WorkSpace_object_mode, &rna_WorkSpace_owner_ids,
	-1, "tools", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Tools",
	"",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_wmTools},
	WorkSpace_tools_begin, WorkSpace_tools_next, WorkSpace_tools_end, WorkSpace_tools_get, nullptr, WorkSpace_tools_lookup_int, WorkSpace_tools_lookup_string, nullptr, &RNA_WorkSpaceTool
};
PropertyRNA &rna_WorkSpace_tools = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_tools_);

static EnumPropertyRNA rna_WorkSpace_object_mode_ = {
	{&rna_WorkSpace_use_pin_scene, &rna_WorkSpace_tools,
	-1, "object_mode", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Object Mode",
	"Switch to this object mode when activating the workspace",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(WorkSpace, object_mode), RawPropertyType(0), nullptr},
	WorkSpace_object_mode_get, WorkSpace_object_mode_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_workspace_object_mode_items, 13, 0
};
PropertyRNA &rna_WorkSpace_object_mode = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_object_mode_);

static BoolPropertyRNA rna_WorkSpace_use_pin_scene_ = {
	{&rna_WorkSpace_use_filter_by_owner, &rna_WorkSpace_object_mode,
	-1, "use_pin_scene", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Pin Scene",
	"Remember the last used scene for the workspace and switch to it whenever this workspace is activated again",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 50331648, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_use_pin_scene_get, WorkSpace_use_pin_scene_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpace_use_pin_scene = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_use_pin_scene_);

static BoolPropertyRNA rna_WorkSpace_use_filter_by_owner_ = {
	{&rna_WorkSpace_asset_library_reference, &rna_WorkSpace_use_pin_scene,
	-1, "use_filter_by_owner", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Use UI Tags",
	"Filter the UI by tags",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_window_update_all, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_use_filter_by_owner_get, WorkSpace_use_filter_by_owner_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpace_use_filter_by_owner = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_use_filter_by_owner_);

static const EnumPropertyItem rna_WorkSpace_asset_library_reference_items[5] = {
	{2, "ALL", 0, "All Libraries", "Show assets from all of the listed asset libraries"},
	{1, "LOCAL", 0, "Current File", "Show the assets currently available in this Blender session"},
	{3, "ESSENTIALS", 0, "Essentials", "Show the basic building blocks and utilities coming with Blender"},
	{100, "CUSTOM", 0, "Custom", "Show assets from the asset libraries configured in the Preferences"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_WorkSpace_asset_library_reference_ = {
	{&rna_WorkSpace_sequencer_scene, &rna_WorkSpace_use_filter_by_owner,
	-1, "asset_library_reference", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Asset Library",
	"Active asset library to show in the UI, not used by the Asset Browser (which has its own active asset library)",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 453181440, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_asset_library_reference_get, WorkSpace_asset_library_reference_set, rna_asset_library_reference_itemf, nullptr, nullptr, nullptr, nullptr, nullptr, rna_WorkSpace_asset_library_reference_items, 4, 2
};
PropertyRNA &rna_WorkSpace_asset_library_reference = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_asset_library_reference_);

static PointerPropertyRNA rna_WorkSpace_sequencer_scene_ = {
	{&rna_WorkSpace_use_scene_time_sync, &rna_WorkSpace_asset_library_reference,
	-1, "sequencer_scene", 8388737, 0, 0, 0, 0, PropertyPathTemplateType(0), "Sequencer Scene",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_window_update_all, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_sequencer_scene_get, WorkSpace_sequencer_scene_set, nullptr, nullptr,&RNA_Scene
};
PropertyRNA &rna_WorkSpace_sequencer_scene = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_sequencer_scene_);

static BoolPropertyRNA rna_WorkSpace_use_scene_time_sync_ = {
	{nullptr, &rna_WorkSpace_sequencer_scene,
	-1, "use_scene_time_sync", 4194307, 0, 0, 0, 0, PropertyPathTemplateType(0), "Sync Active Scene",
	"Set the active scene and time based on the current scene strip",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	(UpdateFunc)(void *)rna_workspace_sync_scene_time_update, 33554432, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	WorkSpace_use_scene_time_sync_get, WorkSpace_use_scene_time_sync_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_WorkSpace_use_scene_time_sync = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_use_scene_time_sync_);

static StringPropertyRNA rna_WorkSpace_status_text_set_internal_text_ = {
	{nullptr, nullptr,
	-1, "text", 1, 0, 1, 0, 0, PropertyPathTemplateType(0), "Text",
	"New string for the status bar, None clears the text",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_WorkSpace_status_text_set_internal_text = reinterpret_cast<PropertyRNA &>(rna_WorkSpace_status_text_set_internal_text_);

FunctionRNA rna_WorkSpace_status_text_set_internal_func = {
	{nullptr, nullptr,
	nullptr,
	{&rna_WorkSpace_status_text_set_internal_text, &rna_WorkSpace_status_text_set_internal_text}},
	"status_text_set_internal", 9, "Set the status bar text, typically key shortcuts for modal operators",
	WorkSpace_status_text_set_internal_call,
	nullptr
};

StructRNA RNA_WorkSpace = {
	{(ContainerRNA *)&RNA_wmOwnerIDs, (ContainerRNA *)&RNA_WorkSpaceTool,
	nullptr,
	{&rna_WorkSpace_screens, &rna_WorkSpace_use_scene_time_sync}},
	"WorkSpace", nullptr, nullptr, 519, nullptr, "Workspace",
	"Workspace data-block, defining the working environment for the user",
	"*", 109,
	&rna_ID_name, &rna_ID_rna_properties,
	&RNA_ID,
	nullptr,
	rna_ID_refine,
	nullptr,
	nullptr,
	nullptr,
	rna_ID_instance,
	rna_ID_idprops,
	rna_ID_system_idprops,
	{(FunctionRNA *)&rna_WorkSpace_status_text_set_internal_func, (FunctionRNA *)&rna_WorkSpace_status_text_set_internal_func}
};

/* WorkSpace UI Tags */
static CollectionPropertyRNA rna_wmOwnerIDs_rna_properties_ = {
	{&rna_wmOwnerIDs_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmOwnerIDs_rna_properties_begin, wmOwnerIDs_rna_properties_next, wmOwnerIDs_rna_properties_end, wmOwnerIDs_rna_properties_get, nullptr, nullptr, wmOwnerIDs_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_wmOwnerIDs_rna_properties = reinterpret_cast<PropertyRNA &>(rna_wmOwnerIDs_rna_properties_);

static PointerPropertyRNA rna_wmOwnerIDs_rna_type_ = {
	{nullptr, &rna_wmOwnerIDs_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmOwnerIDs_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_wmOwnerIDs_rna_type = reinterpret_cast<PropertyRNA &>(rna_wmOwnerIDs_rna_type_);

static StringPropertyRNA rna_wmOwnerIDs_new_name_ = {
	{&rna_wmOwnerIDs_new_owner_id, nullptr,
	-1, "name", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"New name for the tag",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, "Name"
};
PropertyRNA &rna_wmOwnerIDs_new_name = reinterpret_cast<PropertyRNA &>(rna_wmOwnerIDs_new_name_);

static PointerPropertyRNA rna_wmOwnerIDs_new_owner_id_ = {
	{nullptr, &rna_wmOwnerIDs_new_name,
	-1, "owner_id", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_wmOwnerID
};
PropertyRNA &rna_wmOwnerIDs_new_owner_id = reinterpret_cast<PropertyRNA &>(rna_wmOwnerIDs_new_owner_id_);

FunctionRNA rna_wmOwnerIDs_new_func = {
	{(FunctionRNA *)&rna_wmOwnerIDs_remove_func, nullptr,
	nullptr,
	{&rna_wmOwnerIDs_new_name, &rna_wmOwnerIDs_new_owner_id}},
	"new", 0, "Add ui tag",
	wmOwnerIDs_new_call,
	&rna_wmOwnerIDs_new_owner_id
};

static PointerPropertyRNA rna_wmOwnerIDs_remove_owner_id_ = {
	{nullptr, nullptr,
	-1, "owner_id", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"Tag to remove",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_wmOwnerID
};
PropertyRNA &rna_wmOwnerIDs_remove_owner_id = reinterpret_cast<PropertyRNA &>(rna_wmOwnerIDs_remove_owner_id_);

FunctionRNA rna_wmOwnerIDs_remove_func = {
	{(FunctionRNA *)&rna_wmOwnerIDs_clear_func, (FunctionRNA *)&rna_wmOwnerIDs_new_func,
	nullptr,
	{&rna_wmOwnerIDs_remove_owner_id, &rna_wmOwnerIDs_remove_owner_id}},
	"remove", 16, "Remove ui tag",
	wmOwnerIDs_remove_call,
	nullptr
};

FunctionRNA rna_wmOwnerIDs_clear_func = {
	{nullptr, (FunctionRNA *)&rna_wmOwnerIDs_remove_func,
	nullptr,
	{nullptr, nullptr}},
	"clear", 0, "Remove all tags",
	wmOwnerIDs_clear_call,
	nullptr
};

StructRNA RNA_wmOwnerIDs = {
	{(ContainerRNA *)&RNA_wmTools, (ContainerRNA *)&RNA_WorkSpace,
	nullptr,
	{&rna_wmOwnerIDs_rna_properties, &rna_wmOwnerIDs_rna_type}},
	"wmOwnerIDs", nullptr, nullptr, 516, nullptr, "WorkSpace UI Tags",
	"",
	"*", 63,
	nullptr, &rna_wmOwnerIDs_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_wmOwnerIDs_new_func, (FunctionRNA *)&rna_wmOwnerIDs_clear_func}
};

/* WorkSpace UI Tags */
static CollectionPropertyRNA rna_wmTools_rna_properties_ = {
	{&rna_wmTools_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmTools_rna_properties_begin, wmTools_rna_properties_next, wmTools_rna_properties_end, wmTools_rna_properties_get, nullptr, nullptr, wmTools_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_wmTools_rna_properties = reinterpret_cast<PropertyRNA &>(rna_wmTools_rna_properties_);

static PointerPropertyRNA rna_wmTools_rna_type_ = {
	{nullptr, &rna_wmTools_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	wmTools_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_wmTools_rna_type = reinterpret_cast<PropertyRNA &>(rna_wmTools_rna_type_);

static EnumPropertyRNA rna_wmTools_from_space_view3d_mode_mode_ = {
	{&rna_wmTools_from_space_view3d_mode_create, nullptr,
	-1, "mode", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_context_mode_items, 27, 0
};
PropertyRNA &rna_wmTools_from_space_view3d_mode_mode = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_view3d_mode_mode_);

static BoolPropertyRNA rna_wmTools_from_space_view3d_mode_create_ = {
	{&rna_wmTools_from_space_view3d_mode_result, &rna_wmTools_from_space_view3d_mode_mode,
	-1, "create", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Create",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_wmTools_from_space_view3d_mode_create = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_view3d_mode_create_);

static PointerPropertyRNA rna_wmTools_from_space_view3d_mode_result_ = {
	{nullptr, &rna_wmTools_from_space_view3d_mode_create,
	-1, "result", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_WorkSpaceTool
};
PropertyRNA &rna_wmTools_from_space_view3d_mode_result = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_view3d_mode_result_);

FunctionRNA rna_wmTools_from_space_view3d_mode_func = {
	{(FunctionRNA *)&rna_wmTools_from_space_image_mode_func, nullptr,
	nullptr,
	{&rna_wmTools_from_space_view3d_mode_mode, &rna_wmTools_from_space_view3d_mode_result}},
	"from_space_view3d_mode", 0, "",
	wmTools_from_space_view3d_mode_call,
	&rna_wmTools_from_space_view3d_mode_result
};

static EnumPropertyRNA rna_wmTools_from_space_image_mode_mode_ = {
	{&rna_wmTools_from_space_image_mode_create, nullptr,
	-1, "mode", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_space_image_mode_all_items, 4, 0
};
PropertyRNA &rna_wmTools_from_space_image_mode_mode = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_image_mode_mode_);

static BoolPropertyRNA rna_wmTools_from_space_image_mode_create_ = {
	{&rna_wmTools_from_space_image_mode_result, &rna_wmTools_from_space_image_mode_mode,
	-1, "create", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Create",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_wmTools_from_space_image_mode_create = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_image_mode_create_);

static PointerPropertyRNA rna_wmTools_from_space_image_mode_result_ = {
	{nullptr, &rna_wmTools_from_space_image_mode_create,
	-1, "result", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_WorkSpaceTool
};
PropertyRNA &rna_wmTools_from_space_image_mode_result = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_image_mode_result_);

FunctionRNA rna_wmTools_from_space_image_mode_func = {
	{(FunctionRNA *)&rna_wmTools_from_space_node_func, (FunctionRNA *)&rna_wmTools_from_space_view3d_mode_func,
	nullptr,
	{&rna_wmTools_from_space_image_mode_mode, &rna_wmTools_from_space_image_mode_result}},
	"from_space_image_mode", 0, "",
	wmTools_from_space_image_mode_call,
	&rna_wmTools_from_space_image_mode_result
};

static BoolPropertyRNA rna_wmTools_from_space_node_create_ = {
	{&rna_wmTools_from_space_node_result, nullptr,
	-1, "create", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Create",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_wmTools_from_space_node_create = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_node_create_);

static PointerPropertyRNA rna_wmTools_from_space_node_result_ = {
	{nullptr, &rna_wmTools_from_space_node_create,
	-1, "result", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_WorkSpaceTool
};
PropertyRNA &rna_wmTools_from_space_node_result = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_node_result_);

FunctionRNA rna_wmTools_from_space_node_func = {
	{(FunctionRNA *)&rna_wmTools_from_space_sequencer_func, (FunctionRNA *)&rna_wmTools_from_space_image_mode_func,
	nullptr,
	{&rna_wmTools_from_space_node_create, &rna_wmTools_from_space_node_result}},
	"from_space_node", 0, "",
	wmTools_from_space_node_call,
	&rna_wmTools_from_space_node_result
};

static EnumPropertyRNA rna_wmTools_from_space_sequencer_mode_ = {
	{&rna_wmTools_from_space_sequencer_create, nullptr,
	-1, "mode", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_space_sequencer_view_type_items, 3, 1
};
PropertyRNA &rna_wmTools_from_space_sequencer_mode = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_sequencer_mode_);

static BoolPropertyRNA rna_wmTools_from_space_sequencer_create_ = {
	{&rna_wmTools_from_space_sequencer_result, &rna_wmTools_from_space_sequencer_mode,
	-1, "create", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Create",
	"",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_wmTools_from_space_sequencer_create = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_sequencer_create_);

static PointerPropertyRNA rna_wmTools_from_space_sequencer_result_ = {
	{nullptr, &rna_wmTools_from_space_sequencer_create,
	-1, "result", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_WorkSpaceTool
};
PropertyRNA &rna_wmTools_from_space_sequencer_result = reinterpret_cast<PropertyRNA &>(rna_wmTools_from_space_sequencer_result_);

FunctionRNA rna_wmTools_from_space_sequencer_func = {
	{nullptr, (FunctionRNA *)&rna_wmTools_from_space_node_func,
	nullptr,
	{&rna_wmTools_from_space_sequencer_mode, &rna_wmTools_from_space_sequencer_result}},
	"from_space_sequencer", 0, "",
	wmTools_from_space_sequencer_call,
	&rna_wmTools_from_space_sequencer_result
};

StructRNA RNA_wmTools = {
	{(ContainerRNA *)&RNA_World, (ContainerRNA *)&RNA_wmOwnerIDs,
	nullptr,
	{&rna_wmTools_rna_properties, &rna_wmTools_rna_type}},
	"wmTools", nullptr, nullptr, 516, nullptr, "WorkSpace UI Tags",
	"",
	"*", 63,
	nullptr, &rna_wmTools_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_wmTools_from_space_view3d_mode_func, (FunctionRNA *)&rna_wmTools_from_space_sequencer_func}
};

