/* brightness-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from brightness-manager.vala, do not modify */

/*
* This file is part of budgie-desktop
*
* Copyright Budgie Desktop Developers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_LOGIND_SESSION (budgie_logind_session_get_type ())
#define BUDGIE_LOGIND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_LOGIND_SESSION, BudgieLogindSession))
#define BUDGIE_IS_LOGIND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_LOGIND_SESSION))
#define BUDGIE_LOGIND_SESSION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_LOGIND_SESSION, BudgieLogindSessionIface))

typedef struct _BudgieLogindSession BudgieLogindSession;
typedef struct _BudgieLogindSessionIface BudgieLogindSessionIface;

#define BUDGIE_TYPE_LOGIND_SESSION_PROXY (budgie_logind_session_proxy_get_type ())
typedef GDBusProxy BudgieLogindSessionProxy;
typedef GDBusProxyClass BudgieLogindSessionProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_BRIGHTNESS_MANAGER (budgie_brightness_manager_get_type ())
#define BUDGIE_BRIGHTNESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManager))
#define BUDGIE_BRIGHTNESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManagerClass))
#define BUDGIE_IS_BRIGHTNESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER))
#define BUDGIE_IS_BRIGHTNESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_MANAGER))
#define BUDGIE_BRIGHTNESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManagerClass))

typedef struct _BudgieBrightnessManager BudgieBrightnessManager;
typedef struct _BudgieBrightnessManagerClass BudgieBrightnessManagerClass;
typedef struct _BudgieBrightnessManagerPrivate BudgieBrightnessManagerPrivate;

#define BUDGIE_TYPE_BRIGHTNESS_UTIL (budgie_brightness_util_get_type ())
#define BUDGIE_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil))
#define BUDGIE_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))
#define BUDGIE_IS_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_IS_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_BRIGHTNESS_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))

typedef struct _BudgieBrightnessUtil BudgieBrightnessUtil;
typedef struct _BudgieBrightnessUtilClass BudgieBrightnessUtilClass;
enum  {
	BUDGIE_BRIGHTNESS_MANAGER_0_PROPERTY,
	BUDGIE_BRIGHTNESS_MANAGER_IS_READY_PROPERTY,
	BUDGIE_BRIGHTNESS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_brightness_manager_properties[BUDGIE_BRIGHTNESS_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieBrightnessManagerSetupLogindSessionData BudgieBrightnessManagerSetupLogindSessionData;
enum  {
	BUDGIE_BRIGHTNESS_MANAGER_BRIGHTNESS_CHANGED_SIGNAL,
	BUDGIE_BRIGHTNESS_MANAGER_READY_SIGNAL,
	BUDGIE_BRIGHTNESS_MANAGER_NUM_SIGNALS
};
static guint budgie_brightness_manager_signals[BUDGIE_BRIGHTNESS_MANAGER_NUM_SIGNALS] = {0};

struct _BudgieLogindSessionIface {
	GTypeInterface parent_iface;
	void (*SetBrightness) (BudgieLogindSession* self, const gchar* subsystem, const gchar* name, guint32 brightness, GError** error);
};

struct _BudgieBrightnessManager {
	GObject parent_instance;
	BudgieBrightnessManagerPrivate * priv;
};

struct _BudgieBrightnessManagerClass {
	GObjectClass parent_class;
};

struct _BudgieBrightnessManagerPrivate {
	BudgieBrightnessUtil* util;
	GFileMonitor* brightness_monitor;
	BudgieLogindSession* logind_session;
	gchar* session_path;
	gboolean _is_ready;
};

struct _BudgieBrightnessManagerSetupLogindSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieBrightnessManager* self;
	gchar* session_id;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	BudgieLogindSession* _tmp7_;
	const gchar* _tmp8_;
	BudgieLogindSession* _tmp9_;
	BudgieLogindSession* _tmp10_;
	const gchar* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

static gint BudgieBrightnessManager_private_offset;
static gpointer budgie_brightness_manager_parent_class = NULL;

VALA_EXTERN GType budgie_logind_session_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_logind_session_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType budgie_logind_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieLogindSession, g_object_unref)
VALA_EXTERN void budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                          const gchar* subsystem,
                                          const gchar* name,
                                          guint32 brightness,
                                          GError** error);
static GType budgie_logind_session_get_type_once (void);
static void budgie_logind_session_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static void budgie_logind_session_proxy_SetBrightness (BudgieLogindSession* self,
                                                const gchar* subsystem,
                                                const gchar* name,
                                                guint32 brightness,
                                                GError** error);
static void budgie_logind_session_proxy_budgie_logind_session_interface_init (BudgieLogindSessionIface* iface);
static void _dbus_budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void budgie_logind_session_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* budgie_logind_session_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean budgie_logind_session_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _budgie_logind_session_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_brightness_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessManager, g_object_unref)
VALA_EXTERN GType budgie_brightness_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessUtil, g_object_unref)
VALA_EXTERN BudgieBrightnessManager* budgie_brightness_manager_new (void);
VALA_EXTERN BudgieBrightnessManager* budgie_brightness_manager_construct (GType object_type);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_new (void);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_construct (GType object_type);
VALA_EXTERN gboolean budgie_brightness_util_find_backlight_device (BudgieBrightnessUtil* self);
static void budgie_brightness_manager_setup_logind_session (BudgieBrightnessManager* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void budgie_brightness_manager_setup_logind_session_finish (BudgieBrightnessManager* self,
                                                            GAsyncResult* _res_);
static void __lambda4_ (BudgieBrightnessManager* self,
                 GObject* obj,
                 GAsyncResult* res);
VALA_EXTERN const gchar* budgie_brightness_util_get_backlight_device (BudgieBrightnessUtil* self);
static void budgie_brightness_manager_setup_brightness_monitor (BudgieBrightnessManager* self);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN const gchar* budgie_brightness_util_get_backlight_path (BudgieBrightnessUtil* self);
static void budgie_brightness_manager_on_brightness_file_changed (BudgieBrightnessManager* self,
                                                           GFile* file,
                                                           GFile* other,
                                                           GFileMonitorEvent event);
static void _budgie_brightness_manager_on_brightness_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                   GFile* file,
                                                                                   GFile* other_file,
                                                                                   GFileMonitorEvent event_type,
                                                                                   gpointer self);
static void budgie_brightness_manager_update_current_brightness (BudgieBrightnessManager* self);
VALA_EXTERN gint budgie_brightness_util_get_current_brightness (BudgieBrightnessUtil* self);
VALA_EXTERN void budgie_brightness_util_update_current_brightness (BudgieBrightnessUtil* self);
VALA_EXTERN gint budgie_brightness_util_get_max_brightness (BudgieBrightnessUtil* self);
static void budgie_brightness_manager_setup_logind_session_data_free (gpointer _data);
static gboolean budgie_brightness_manager_setup_logind_session_co (BudgieBrightnessManagerSetupLogindSessionData* _data_);
VALA_EXTERN gchar* budgie_brightness_util_get_session_id (void);
static void budgie_brightness_manager_setup_logind_session_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
VALA_EXTERN void budgie_brightness_manager_set_brightness (BudgieBrightnessManager* self,
                                               guint32 value);
VALA_EXTERN void budgie_brightness_manager_set_brightness_percent (BudgieBrightnessManager* self,
                                                       gdouble percent);
VALA_EXTERN void budgie_brightness_manager_increase_brightness (BudgieBrightnessManager* self,
                                                    gdouble step);
VALA_EXTERN void budgie_brightness_manager_decrease_brightness (BudgieBrightnessManager* self,
                                                    gdouble step);
VALA_EXTERN gdouble budgie_brightness_manager_get_brightness_level (BudgieBrightnessManager* self);
VALA_EXTERN gint budgie_brightness_manager_get_brightness (BudgieBrightnessManager* self);
VALA_EXTERN gint budgie_brightness_manager_get_max_brightness (BudgieBrightnessManager* self);
VALA_EXTERN gboolean budgie_brightness_manager_is_available (BudgieBrightnessManager* self);
VALA_EXTERN gboolean budgie_brightness_manager_get_is_ready (BudgieBrightnessManager* self);
static void budgie_brightness_manager_finalize (GObject * obj);
static GType budgie_brightness_manager_get_type_once (void);
static void _vala_budgie_brightness_manager_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);

static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_subsystem = {-1, "subsystem", "s", NULL};
static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _budgie_logind_session_dbus_arg_info_SetBrightness_brightness = {-1, "brightness", "u", NULL};
static const GDBusArgInfo * const _budgie_logind_session_dbus_arg_info_SetBrightness_in[] = {&_budgie_logind_session_dbus_arg_info_SetBrightness_subsystem, &_budgie_logind_session_dbus_arg_info_SetBrightness_name, &_budgie_logind_session_dbus_arg_info_SetBrightness_brightness, NULL};
static const GDBusArgInfo * const _budgie_logind_session_dbus_arg_info_SetBrightness_out[] = {NULL};
static const GDBusMethodInfo _budgie_logind_session_dbus_method_info_SetBrightness = {-1, "SetBrightness", (GDBusArgInfo **) (&_budgie_logind_session_dbus_arg_info_SetBrightness_in), (GDBusArgInfo **) (&_budgie_logind_session_dbus_arg_info_SetBrightness_out), NULL};
static const GDBusMethodInfo * const _budgie_logind_session_dbus_method_info[] = {&_budgie_logind_session_dbus_method_info_SetBrightness, NULL};
static const GDBusSignalInfo * const _budgie_logind_session_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_logind_session_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_logind_session_dbus_interface_info = {-1, "org.freedesktop.login1.Session", (GDBusMethodInfo **) (&_budgie_logind_session_dbus_method_info), (GDBusSignalInfo **) (&_budgie_logind_session_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_logind_session_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_logind_session_dbus_interface_vtable = {budgie_logind_session_dbus_interface_method_call, budgie_logind_session_dbus_interface_get_property, budgie_logind_session_dbus_interface_set_property};

void
budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                     const gchar* subsystem,
                                     const gchar* name,
                                     guint32 brightness,
                                     GError** error)
{
	BudgieLogindSessionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_LOGIND_SESSION_GET_INTERFACE (self);
	if (_iface_->SetBrightness) {
		_iface_->SetBrightness (self, subsystem, name, brightness, error);
	}
}

static void
budgie_logind_session_default_init (BudgieLogindSessionIface * iface,
                                    gpointer iface_data)
{
}

/**
* DBus interface for logind Session
*/
static GType
budgie_logind_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieLogindSessionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_logind_session_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_logind_session_type_id;
	budgie_logind_session_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieLogindSession", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_logind_session_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_logind_session_proxy_get_type);
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Session");
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_logind_session_dbus_interface_info));
	g_type_set_qdata (budgie_logind_session_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_logind_session_register_object);
	return budgie_logind_session_type_id;
}

GType
budgie_logind_session_get_type (void)
{
	static volatile gsize budgie_logind_session_type_id__once = 0;
	if (g_once_init_enter (&budgie_logind_session_type_id__once)) {
		GType budgie_logind_session_type_id;
		budgie_logind_session_type_id = budgie_logind_session_get_type_once ();
		g_once_init_leave (&budgie_logind_session_type_id__once, budgie_logind_session_type_id);
	}
	return budgie_logind_session_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieLogindSessionProxy, budgie_logind_session_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_LOGIND_SESSION, budgie_logind_session_proxy_budgie_logind_session_interface_init) )
static void
budgie_logind_session_proxy_class_init (BudgieLogindSessionProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_logind_session_proxy_g_signal;
}

static void
budgie_logind_session_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
budgie_logind_session_proxy_init (BudgieLogindSessionProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_logind_session_dbus_interface_info));
}

static void
budgie_logind_session_proxy_SetBrightness (BudgieLogindSession* self,
                                           const gchar* subsystem,
                                           const gchar* name,
                                           guint32 brightness,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Session", "SetBrightness");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (subsystem));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (brightness));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_logind_session_proxy_budgie_logind_session_interface_init (BudgieLogindSessionIface* iface)
{
	iface->SetBrightness = budgie_logind_session_proxy_SetBrightness;
}

static void
_dbus_budgie_logind_session_SetBrightness (BudgieLogindSession* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* subsystem = NULL;
	GVariant* _tmp0_;
	gchar* name = NULL;
	GVariant* _tmp1_;
	guint32 brightness = 0U;
	GVariant* _tmp2_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	subsystem = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	brightness = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	budgie_logind_session_SetBrightness (self, subsystem, name, brightness, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (subsystem);
	_g_free0 (name);
	;
}

static void
budgie_logind_session_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetBrightness") == 0) {
		_dbus_budgie_logind_session_SetBrightness (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_logind_session_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_logind_session_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_logind_session_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_logind_session_dbus_interface_info), &_budgie_logind_session_dbus_interface_vtable, data, _budgie_logind_session_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_logind_session_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_brightness_manager_get_instance_private (BudgieBrightnessManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBrightnessManager_private_offset);
}

static void
__lambda4_ (BudgieBrightnessManager* self,
            GObject* obj,
            GAsyncResult* res)
{
	const gchar* _tmp0_ = NULL;
	BudgieBrightnessUtil* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	BudgieLogindSession* _tmp5_;
	gboolean _tmp6_ = FALSE;
	BudgieBrightnessUtil* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (res != NULL);
	budgie_brightness_manager_setup_logind_session_finish (self, res);
	_tmp1_ = self->priv->util;
	_tmp2_ = budgie_brightness_util_get_backlight_device (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "null";
	}
	_tmp5_ = self->priv->logind_session;
	if (_tmp5_ != NULL) {
		_tmp4_ = "connected";
	} else {
		_tmp4_ = "null";
	}
	g_debug ("brightness-manager.vala:48: setup_logind_session completed - device=%s" \
", session=%s", _tmp0_, _tmp4_);
	_tmp7_ = self->priv->util;
	_tmp8_ = budgie_brightness_util_get_backlight_device (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		BudgieLogindSession* _tmp10_;
		_tmp10_ = self->priv->logind_session;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		budgie_brightness_manager_setup_brightness_monitor (self);
		self->priv->_is_ready = TRUE;
		g_debug ("brightness-manager.vala:56: Initialization complete, firing ready sign" \
"al");
		g_signal_emit (self, budgie_brightness_manager_signals[BUDGIE_BRIGHTNESS_MANAGER_READY_SIGNAL], 0);
	} else {
		const gchar* _tmp11_ = NULL;
		BudgieBrightnessUtil* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		BudgieLogindSession* _tmp16_;
		_tmp12_ = self->priv->util;
		_tmp13_ = budgie_brightness_util_get_backlight_device (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = _tmp14_;
		if (_tmp11_ == NULL) {
			_tmp11_ = "null";
		}
		_tmp16_ = self->priv->logind_session;
		if (_tmp16_ != NULL) {
			_tmp15_ = "connected";
		} else {
			_tmp15_ = "null";
		}
		g_debug ("brightness-manager.vala:59: BrightnessManager not available: device=%s" \
", session=%s", _tmp11_, _tmp15_);
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((BudgieBrightnessManager*) self, source_object, res);
	g_object_unref (self);
}

BudgieBrightnessManager*
budgie_brightness_manager_construct (GType object_type)
{
	BudgieBrightnessManager * self = NULL;
	BudgieBrightnessUtil* _tmp0_;
	BudgieBrightnessUtil* _tmp1_;
	self = (BudgieBrightnessManager*) g_object_new (object_type, NULL);
	g_debug ("brightness-manager.vala:41: Constructor called");
	_tmp0_ = budgie_brightness_util_new ();
	_g_object_unref0 (self->priv->util);
	self->priv->util = _tmp0_;
	_tmp1_ = self->priv->util;
	budgie_brightness_util_find_backlight_device (_tmp1_);
	budgie_brightness_manager_setup_logind_session (self, ___lambda4__gasync_ready_callback, g_object_ref (self));
	return self;
}

BudgieBrightnessManager*
budgie_brightness_manager_new (void)
{
	return budgie_brightness_manager_construct (BUDGIE_TYPE_BRIGHTNESS_MANAGER);
}

/**
* Set up inotify monitoring on brightness file
*/
static void
_budgie_brightness_manager_on_brightness_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                              GFile* file,
                                                                              GFile* other_file,
                                                                              GFileMonitorEvent event_type,
                                                                              gpointer self)
{
	budgie_brightness_manager_on_brightness_file_changed ((BudgieBrightnessManager*) self, file, other_file, event_type);
}

static void
budgie_brightness_manager_setup_brightness_monitor (BudgieBrightnessManager* self)
{
	BudgieBrightnessUtil* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_backlight_path (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		g_debug ("brightness-manager.vala:71: Cannot setup brightness monitor: no backli" \
"ght path");
		return;
	}
	{
		GFile* brightness_file = NULL;
		BudgieBrightnessUtil* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFileMonitor* _tmp10_ = NULL;
		GFile* _tmp11_;
		GFileMonitor* _tmp12_;
		GFileMonitor* _tmp13_;
		GFileMonitor* _tmp14_;
		BudgieBrightnessUtil* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp3_ = self->priv->util;
		_tmp4_ = budgie_brightness_util_get_backlight_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_build_filename (_tmp5_, "brightness", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		brightness_file = _tmp9_;
		_tmp11_ = brightness_file;
		_tmp12_ = g_file_monitor_file (_tmp11_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (brightness_file);
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (self->priv->brightness_monitor);
		self->priv->brightness_monitor = _tmp13_;
		_tmp14_ = self->priv->brightness_monitor;
		g_signal_connect_object (_tmp14_, "changed", (GCallback) _budgie_brightness_manager_on_brightness_file_changed_g_file_monitor_changed, self, 0);
		_tmp15_ = self->priv->util;
		_tmp16_ = budgie_brightness_util_get_backlight_path (_tmp15_);
		_tmp17_ = _tmp16_;
		g_debug ("brightness-manager.vala:79: Monitoring brightness changes on %s/bright" \
"ness", _tmp17_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (brightness_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("brightness-manager.vala:81: Failed to monitor brightness file: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
* Called when brightness file changes
*/
static void
budgie_brightness_manager_on_brightness_file_changed (BudgieBrightnessManager* self,
                                                      GFile* file,
                                                      GFile* other,
                                                      GFileMonitorEvent event)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (event == G_FILE_MONITOR_EVENT_CHANGED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT;
	}
	if (_tmp0_) {
		budgie_brightness_manager_update_current_brightness (self);
	}
}

/**
* Read current brightness from sysfs
*/
static void
budgie_brightness_manager_update_current_brightness (BudgieBrightnessManager* self)
{
	BudgieBrightnessUtil* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint old_brightness = 0;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	BudgieBrightnessUtil* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_backlight_path (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	old_brightness = _tmp5_;
	_tmp6_ = self->priv->util;
	budgie_brightness_util_update_current_brightness (_tmp6_);
	_tmp7_ = self->priv->util;
	_tmp8_ = budgie_brightness_util_get_current_brightness (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != old_brightness) {
		gdouble level = 0.0;
		BudgieBrightnessUtil* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		BudgieBrightnessUtil* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		BudgieBrightnessUtil* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		BudgieBrightnessUtil* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp10_ = self->priv->util;
		_tmp11_ = budgie_brightness_util_get_current_brightness (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->util;
		_tmp14_ = budgie_brightness_util_get_max_brightness (_tmp13_);
		_tmp15_ = _tmp14_;
		level = ((gdouble) _tmp12_) / ((gdouble) _tmp15_);
		_tmp16_ = self->priv->util;
		_tmp17_ = budgie_brightness_util_get_current_brightness (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->util;
		_tmp20_ = budgie_brightness_util_get_max_brightness (_tmp19_);
		_tmp21_ = _tmp20_;
		g_debug ("brightness-manager.vala:105: Brightness changed to %d/%d (%.2f%%)", _tmp18_, _tmp21_, level * 100);
		g_signal_emit (self, budgie_brightness_manager_signals[BUDGIE_BRIGHTNESS_MANAGER_BRIGHTNESS_CHANGED_SIGNAL], 0, level);
	}
}

static void
budgie_brightness_manager_setup_logind_session_data_free (gpointer _data)
{
	BudgieBrightnessManagerSetupLogindSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieBrightnessManagerSetupLogindSessionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_brightness_manager_setup_logind_session (BudgieBrightnessManager* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	BudgieBrightnessManagerSetupLogindSessionData* _data_;
	BudgieBrightnessManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieBrightnessManagerSetupLogindSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_brightness_manager_setup_logind_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_brightness_manager_setup_logind_session_co (_data_);
}

static void
budgie_brightness_manager_setup_logind_session_finish (BudgieBrightnessManager* self,
                                                       GAsyncResult* _res_)
{
	BudgieBrightnessManagerSetupLogindSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
* Set up connection to logind session
*/
static void
budgie_brightness_manager_setup_logind_session_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	BudgieBrightnessManagerSetupLogindSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_brightness_manager_setup_logind_session_co (_data_);
}

static gboolean
budgie_brightness_manager_setup_logind_session_co (BudgieBrightnessManagerSetupLogindSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = budgie_brightness_util_get_session_id ();
		_data_->session_id = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->session_id;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp1_ = TRUE;
		} else {
			_data_->_tmp3_ = _data_->session_id;
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp3_, "") == 0;
		}
		if (_data_->_tmp1_) {
			g_warning ("brightness-manager.vala:119: Could not determine session ID");
			_g_free0 (_data_->session_id);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->session_id;
		_data_->_tmp5_ = g_build_filename ("/org/freedesktop/login1/session", _data_->_tmp4_, NULL);
		_g_free0 (_data_->self->priv->session_path);
		_data_->self->priv->session_path = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->session_path;
		g_debug ("brightness-manager.vala:124: Connecting to logind session at %s...", _data_->_tmp6_);
		_data_->_tmp8_ = _data_->self->priv->session_path;
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_LOGIND_SESSION_PROXY, 0, NULL, budgie_brightness_manager_setup_logind_session_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp8_, "g-interface-name", "org.freedesktop.login1.Session", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = (BudgieLogindSession*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp7_ = (BudgieLogindSession*) _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->session_id);
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_object_unref0 (_data_->self->priv->logind_session);
		_data_->self->priv->logind_session = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->self->priv->session_path;
		g_debug ("brightness-manager.vala:132: Successfully connected to logind session:" \
" %s", _data_->_tmp11_);
		_g_object_unref0 (_data_->_tmp7_);
		_g_free0 (_data_->session_id);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("brightness-manager.vala:134: Failed to connect to logind session: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
* Set brightness to absolute value (0 to max_brightness)
*/
void
budgie_brightness_manager_set_brightness (BudgieBrightnessManager* self,
                                          guint32 value)
{
	gboolean _tmp0_ = FALSE;
	BudgieLogindSession* _tmp1_;
	guint32 clamped = 0U;
	BudgieBrightnessUtil* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->_is_ready) {
		g_debug ("brightness-manager.vala:143: Cannot set brightness: BrightnessManager " \
"not ready yet");
		return;
	}
	_tmp1_ = self->priv->logind_session;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BudgieBrightnessUtil* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->util;
		_tmp3_ = budgie_brightness_util_get_backlight_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		const gchar* _tmp5_ = NULL;
		BudgieLogindSession* _tmp6_;
		const gchar* _tmp7_ = NULL;
		BudgieBrightnessUtil* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->logind_session;
		if (_tmp6_ != NULL) {
			_tmp5_ = "ok";
		} else {
			_tmp5_ = "null";
		}
		_tmp8_ = self->priv->util;
		_tmp9_ = budgie_brightness_util_get_backlight_device (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = _tmp10_;
		if (_tmp7_ == NULL) {
			_tmp7_ = "null";
		}
		g_warning ("brightness-manager.vala:148: Cannot set brightness: not initialized (s" \
"ession=%s, device=%s)", _tmp5_, _tmp7_);
		return;
	}
	_tmp11_ = self->priv->util;
	_tmp12_ = budgie_brightness_util_get_max_brightness (_tmp11_);
	_tmp13_ = _tmp12_;
	clamped = MIN (value, (guint32) _tmp13_);
	{
		BudgieBrightnessUtil* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		BudgieLogindSession* _tmp17_;
		BudgieBrightnessUtil* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp14_ = self->priv->util;
		_tmp15_ = budgie_brightness_util_get_max_brightness (_tmp14_);
		_tmp16_ = _tmp15_;
		g_debug ("brightness-manager.vala:157: Setting brightness to %u (max: %d)", (guint) clamped, _tmp16_);
		_tmp17_ = self->priv->logind_session;
		_tmp18_ = self->priv->util;
		_tmp19_ = budgie_brightness_util_get_backlight_device (_tmp18_);
		_tmp20_ = _tmp19_;
		budgie_logind_session_SetBrightness (_tmp17_, "backlight", _tmp20_, clamped, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("brightness-manager.vala:160: Failed to set brightness: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
* Set brightness as percentage (0.0 to 1.0)
*/
void
budgie_brightness_manager_set_brightness_percent (BudgieBrightnessManager* self,
                                                  gdouble percent)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble clamped = 0.0;
	guint32 value = 0U;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		g_warning ("brightness-manager.vala:169: Cannot set brightness: max_brightness is " \
"0");
		return;
	}
	clamped = CLAMP (percent, 0.0, 1.0);
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_max_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	value = (guint32) (clamped * _tmp5_);
	budgie_brightness_manager_set_brightness (self, value);
}

/**
* Increase brightness by percentage step
*/
void
budgie_brightness_manager_increase_brightness (BudgieBrightnessManager* self,
                                               gdouble step)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble current_percent = 0.0;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gdouble new_percent = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->util;
	_tmp7_ = budgie_brightness_util_get_max_brightness (_tmp6_);
	_tmp8_ = _tmp7_;
	current_percent = ((gdouble) _tmp5_) / ((gdouble) _tmp8_);
	new_percent = CLAMP (current_percent + step, 0.0, 1.0);
	budgie_brightness_manager_set_brightness_percent (self, new_percent);
}

/**
* Decrease brightness by percentage step
*/
void
budgie_brightness_manager_decrease_brightness (BudgieBrightnessManager* self,
                                               gdouble step)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble current_percent = 0.0;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gdouble new_percent = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->util;
	_tmp7_ = budgie_brightness_util_get_max_brightness (_tmp6_);
	_tmp8_ = _tmp7_;
	current_percent = ((gdouble) _tmp5_) / ((gdouble) _tmp8_);
	new_percent = CLAMP (current_percent - step, 0.0, 1.0);
	budgie_brightness_manager_set_brightness_percent (self, new_percent);
}

/**
* Get current brightness level (0.0 to 1.0)
*/
gdouble
budgie_brightness_manager_get_brightness_level (BudgieBrightnessManager* self)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BudgieBrightnessUtil* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BudgieBrightnessUtil* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = 0.0;
		return result;
	}
	_tmp3_ = self->priv->util;
	_tmp4_ = budgie_brightness_util_get_current_brightness (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->util;
	_tmp7_ = budgie_brightness_util_get_max_brightness (_tmp6_);
	_tmp8_ = _tmp7_;
	result = ((gdouble) _tmp5_) / ((gdouble) _tmp8_);
	return result;
}

/**
* Get current brightness value
*/
gint
budgie_brightness_manager_get_brightness (BudgieBrightnessManager* self)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_current_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
* Get max brightness value
*/
gint
budgie_brightness_manager_get_max_brightness (BudgieBrightnessManager* self)
{
	BudgieBrightnessUtil* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->util;
	_tmp1_ = budgie_brightness_util_get_max_brightness (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
* Check if brightness control is available
*/
gboolean
budgie_brightness_manager_is_available (BudgieBrightnessManager* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_is_ready) {
		BudgieBrightnessUtil* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->util;
		_tmp3_ = budgie_brightness_util_get_backlight_device (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BudgieLogindSession* _tmp5_;
		_tmp5_ = self->priv->logind_session;
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
budgie_brightness_manager_get_is_ready (BudgieBrightnessManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_ready;
	return result;
}

static void
budgie_brightness_manager_class_init (BudgieBrightnessManagerClass * klass,
                                      gpointer klass_data)
{
	budgie_brightness_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBrightnessManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_brightness_manager_get_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_brightness_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BRIGHTNESS_MANAGER_IS_READY_PROPERTY, budgie_brightness_manager_properties[BUDGIE_BRIGHTNESS_MANAGER_IS_READY_PROPERTY] = g_param_spec_boolean ("is-ready", "is-ready", "is-ready", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	budgie_brightness_manager_signals[BUDGIE_BRIGHTNESS_MANAGER_BRIGHTNESS_CHANGED_SIGNAL] = g_signal_new ("brightness-changed", BUDGIE_TYPE_BRIGHTNESS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	budgie_brightness_manager_signals[BUDGIE_BRIGHTNESS_MANAGER_READY_SIGNAL] = g_signal_new ("ready", BUDGIE_TYPE_BRIGHTNESS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_brightness_manager_instance_init (BudgieBrightnessManager * self,
                                         gpointer klass)
{
	self->priv = budgie_brightness_manager_get_instance_private (self);
	self->priv->brightness_monitor = NULL;
	self->priv->logind_session = NULL;
	self->priv->session_path = NULL;
	self->priv->_is_ready = FALSE;
}

static void
budgie_brightness_manager_finalize (GObject * obj)
{
	BudgieBrightnessManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManager);
	_g_object_unref0 (self->priv->util);
	_g_object_unref0 (self->priv->brightness_monitor);
	_g_object_unref0 (self->priv->logind_session);
	_g_free0 (self->priv->session_path);
	G_OBJECT_CLASS (budgie_brightness_manager_parent_class)->finalize (obj);
}

/**
* BrightnessManager handles monitoring and controlling system brightness
* using kernel sysfs and logind DBus interface
*/
static GType
budgie_brightness_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBrightnessManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_brightness_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBrightnessManager), 0, (GInstanceInitFunc) budgie_brightness_manager_instance_init, NULL };
	GType budgie_brightness_manager_type_id;
	budgie_brightness_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieBrightnessManager", &g_define_type_info, 0);
	BudgieBrightnessManager_private_offset = g_type_add_instance_private (budgie_brightness_manager_type_id, sizeof (BudgieBrightnessManagerPrivate));
	return budgie_brightness_manager_type_id;
}

GType
budgie_brightness_manager_get_type (void)
{
	static volatile gsize budgie_brightness_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_brightness_manager_type_id__once)) {
		GType budgie_brightness_manager_type_id;
		budgie_brightness_manager_type_id = budgie_brightness_manager_get_type_once ();
		g_once_init_leave (&budgie_brightness_manager_type_id__once, budgie_brightness_manager_type_id);
	}
	return budgie_brightness_manager_type_id__once;
}

static void
_vala_budgie_brightness_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BudgieBrightnessManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BRIGHTNESS_MANAGER, BudgieBrightnessManager);
	switch (property_id) {
		case BUDGIE_BRIGHTNESS_MANAGER_IS_READY_PROPERTY:
		g_value_set_boolean (value, budgie_brightness_manager_get_is_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

