// Code generated by smithy-go-codegen DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// An API operation used by the Systems Manager console to display information
// about Systems Manager managed nodes.
func (c *Client) DescribeInstanceProperties(ctx context.Context, params *DescribeInstancePropertiesInput, optFns ...func(*Options)) (*DescribeInstancePropertiesOutput, error) {
	if params == nil {
		params = &DescribeInstancePropertiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInstanceProperties", params, optFns, c.addOperationDescribeInstancePropertiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInstancePropertiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInstancePropertiesInput struct {

	// The request filters to use with the operator.
	FiltersWithOperator []types.InstancePropertyStringFilter

	// An array of instance property filters.
	InstancePropertyFilterList []types.InstancePropertyFilter

	// The maximum number of items to return for the call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	MaxResults *int32

	// The token provided by a previous request to use to return the next set of
	// properties.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeInstancePropertiesOutput struct {

	// Properties for the managed instances.
	InstanceProperties []types.InstanceProperty

	// The token for the next set of properties to return. Use this token to get the
	// next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInstancePropertiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeInstanceProperties{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeInstanceProperties{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeInstanceProperties"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeInstancePropertiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInstanceProperties(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeInstancePropertiesPaginatorOptions is the paginator options for
// DescribeInstanceProperties
type DescribeInstancePropertiesPaginatorOptions struct {
	// The maximum number of items to return for the call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeInstancePropertiesPaginator is a paginator for
// DescribeInstanceProperties
type DescribeInstancePropertiesPaginator struct {
	options   DescribeInstancePropertiesPaginatorOptions
	client    DescribeInstancePropertiesAPIClient
	params    *DescribeInstancePropertiesInput
	nextToken *string
	firstPage bool
}

// NewDescribeInstancePropertiesPaginator returns a new
// DescribeInstancePropertiesPaginator
func NewDescribeInstancePropertiesPaginator(client DescribeInstancePropertiesAPIClient, params *DescribeInstancePropertiesInput, optFns ...func(*DescribeInstancePropertiesPaginatorOptions)) *DescribeInstancePropertiesPaginator {
	if params == nil {
		params = &DescribeInstancePropertiesInput{}
	}

	options := DescribeInstancePropertiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeInstancePropertiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeInstancePropertiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeInstanceProperties page.
func (p *DescribeInstancePropertiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeInstancePropertiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeInstanceProperties(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeInstancePropertiesAPIClient is a client that implements the
// DescribeInstanceProperties operation.
type DescribeInstancePropertiesAPIClient interface {
	DescribeInstanceProperties(context.Context, *DescribeInstancePropertiesInput, ...func(*Options)) (*DescribeInstancePropertiesOutput, error)
}

var _ DescribeInstancePropertiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeInstanceProperties(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInstanceProperties",
	}
}
