#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomPropertyRegisteredEvent = 975,
  CSSFontFaceRule = 1008,
  CSSFontFeatureValuesRule = 1024,
  CSSFontPaletteValuesRule = 1049,
  CSSGroupingRule = 1074,
  CSSHSL = 1090,
  CSSHWB = 1097,
  CSSImageValue = 1104,
  CSSImportRule = 1118,
  CSSKeyframeRule = 1132,
  CSSKeyframesRule = 1148,
  CSSKeywordValue = 1165,
  CSSLCH = 1181,
  CSSLab = 1188,
  CSSLayerBlockRule = 1195,
  CSSLayerStatementRule = 1213,
  CSSMarginRule = 1235,
  CSSMathClamp = 1249,
  CSSMathInvert = 1262,
  CSSMathMax = 1276,
  CSSMathMin = 1287,
  CSSMathNegate = 1298,
  CSSMathProduct = 1312,
  CSSMathSum = 1327,
  CSSMathValue = 1338,
  CSSMatrixComponent = 1351,
  CSSMediaRule = 1370,
  CSSMozDocumentRule = 1383,
  CSSNamespaceRule = 1402,
  CSSNestedDeclarations = 1419,
  CSSNumericArray = 1441,
  CSSNumericValue = 1457,
  CSSOKLCH = 1473,
  CSSOKLab = 1482,
  CSSPageDescriptors = 1491,
  CSSPageRule = 1510,
  CSSPerspective = 1522,
  CSSPositionTryDescriptors = 1537,
  CSSPositionTryRule = 1563,
  CSSPropertyRule = 1582,
  CSSPseudoElement = 1598,
  CSSRGB = 1615,
  CSSRotate = 1622,
  CSSRule = 1632,
  CSSRuleList = 1640,
  CSSScale = 1652,
  CSSScopeRule = 1661,
  CSSSkew = 1674,
  CSSSkewX = 1682,
  CSSSkewY = 1691,
  CSSStartingStyleRule = 1700,
  CSSStyleDeclaration = 1721,
  CSSStyleProperties = 1741,
  CSSStyleRule = 1760,
  CSSStyleSheet = 1773,
  CSSStyleValue = 1787,
  CSSSupportsRule = 1801,
  CSSTransformComponent = 1817,
  CSSTransformValue = 1839,
  CSSTransition = 1857,
  CSSTranslate = 1871,
  CSSUnitValue = 1884,
  CSSUnparsedValue = 1897,
  CSSVariableReferenceValue = 1914,
  Cache = 1940,
  CacheStorage = 1946,
  CallbackDebuggerNotification = 1959,
  CanonicalBrowsingContext = 1988,
  CanvasCaptureMediaStream = 2013,
  CanvasGradient = 2038,
  CanvasPattern = 2053,
  CanvasRenderingContext2D = 2067,
  CaretPosition = 2092,
  CaretStateChangedEvent = 2106,
  ChannelMergerNode = 2129,
  ChannelSplitterNode = 2147,
  ChannelWrapper = 2167,
  CharacterData = 2182,
  CheckerboardReportService = 2196,
  ChildProcessMessageManager = 2222,
  ChildSHistory = 2249,
  ChromeMessageBroadcaster = 2263,
  ChromeMessageSender = 2288,
  ChromeNodeList = 2308,
  ChromeUtils = 2323,
  ChromeWorker = 2335,
  Client = 2348,
  Clients = 2355,
  Clipboard = 2363,
  ClipboardEvent = 2373,
  ClipboardItem = 2388,
  ClonedErrorHolder = 2402,
  CloseEvent = 2420,
  CloseWatcher = 2431,
  CommandEvent = 2444,
  Comment = 2457,
  CompositionEvent = 2465,
  CompressionStream = 2482,
  ConsoleInstance = 2500,
  ConstantSourceNode = 2516,
  ContentFrameMessageManager = 2535,
  ContentProcessMessageManager = 2562,
  ContentVisibilityAutoStateChangeEvent = 2591,
  ConvolverNode = 2629,
  CookieChangeEvent = 2643,
  CookieStore = 2661,
  CookieStoreManager = 2673,
  CountQueuingStrategy = 2692,
  CreateOfferRequest = 2713,
  Credential = 2732,
  CredentialsContainer = 2743,
  Crypto = 2764,
  CryptoKey = 2771,
  CustomElementRegistry = 2781,
  CustomEvent = 2803,
  CustomStateSet = 2815,
  DOMException = 2830,
  DOMImplementation = 2843,
  DOMLocalization = 2861,
  DOMMatrix = 2877,
  DOMMatrixReadOnly = 2887,
  DOMParser = 2905,
  DOMPoint = 2915,
  DOMPointReadOnly = 2924,
  DOMQuad = 2941,
  DOMRect = 2949,
  DOMRectList = 2957,
  DOMRectReadOnly = 2969,
  DOMStringList = 2985,
  DOMStringMap = 2999,
  DOMTokenList = 3012,
  DataTransfer = 3025,
  DataTransferItem = 3038,
  DataTransferItemList = 3055,
  DebuggerNotification = 3076,
  DebuggerNotificationObserver = 3097,
  DecompressionStream = 3126,
  DedicatedWorkerGlobalScope = 3146,
  DelayNode = 3173,
  DeprecationReportBody = 3183,
  DeviceAcceleration = 3205,
  DeviceLightEvent = 3224,
  DeviceMotionEvent = 3241,
  DeviceOrientationEvent = 3259,
  DeviceRotationRate = 3282,
  Directory = 3301,
  Document = 3311,
  DocumentFragment = 3320,
  DocumentL10n = 3337,
  DocumentTimeline = 3350,
  DocumentType = 3367,
  DominatorTree = 3380,
  DragEvent = 3394,
  DynamicsCompressorNode = 3404,
  EXT_blend_minmax = 3427,
  EXT_color_buffer_float = 3444,
  EXT_color_buffer_half_float = 3467,
  EXT_depth_clamp = 3495,
  EXT_disjoint_timer_query = 3511,
  EXT_float_blend = 3536,
  EXT_frag_depth = 3552,
  EXT_sRGB = 3567,
  EXT_shader_texture_lod = 3576,
  EXT_texture_compression_bptc = 3599,
  EXT_texture_compression_rgtc = 3628,
  EXT_texture_filter_anisotropic = 3657,
  EXT_texture_norm16 = 3688,
  Element = 3707,
  ElementInternals = 3715,
  EncodedAudioChunk = 3732,
  EncodedVideoChunk = 3750,
  ErrorEvent = 3768,
  Event = 3779,
  EventCallbackDebuggerNotification = 3785,
  EventCounts = 3819,
  EventSource = 3831,
  EventTarget = 3843,
  Exception = 3855,
  ExtendableCookieChangeEvent = 3865,
  ExtendableEvent = 3893,
  ExtendableMessageEvent = 3909,
  ExtensionAlarms = 3932,
  ExtensionBrowser = 3948,
  ExtensionBrowserSettings = 3965,
  ExtensionBrowserSettingsColorManagement = 3990,
  ExtensionDns = 4030,
  ExtensionEventManager = 4043,
  ExtensionMockAPI = 4065,
  ExtensionPort = 4082,
  ExtensionProxy = 4096,
  ExtensionRuntime = 4111,
  ExtensionScripting = 4128,
  ExtensionSetting = 4147,
  ExtensionTest = 4164,
  External = 4178,
  FeaturePolicy = 4187,
  FeaturePolicyViolationReportBody = 4201,
  FetchEvent = 4234,
  FetchObserver = 4245,
  File = 4259,
  FileList = 4264,
  FileReader = 4273,
  FileReaderSync = 4284,
  FileSystem = 4299,
  FileSystemDirectoryEntry = 4310,
  FileSystemDirectoryHandle = 4335,
  FileSystemDirectoryHandle_AsyncIterator = 4361,
  FileSystemDirectoryIterator = 4401,
  FileSystemDirectoryReader = 4429,
  FileSystemEntry = 4455,
  FileSystemFileEntry = 4471,
  FileSystemFileHandle = 4491,
  FileSystemHandle = 4512,
  FileSystemSyncAccessHandle = 4529,
  FileSystemWritableFileStream = 4556,
  Flex = 4585,
  FlexItemValues = 4590,
  FlexLineValues = 4605,
  FluentBundle = 4620,
  FluentBundleAsyncIterator = 4633,
  FluentBundleIterator = 4659,
  FluentPattern = 4680,
  FluentResource = 4694,
  FocusEvent = 4709,
  FontFace = 4720,
  FontFaceSet = 4729,
  FontFaceSetIterator = 4741,
  FontFaceSetLoadEvent = 4761,
  FormData = 4782,
  FormData_Iterator = 4791,
  FormDataEvent = 4809,
  FragmentDirective = 4823,
  FrameCrashedEvent = 4841,
  FrameLoader = 4859,
  GPU = 4871,
  GPUAdapter = 4875,
  GPUAdapterInfo = 4886,
  GPUBindGroup = 4901,
  GPUBindGroupLayout = 4914,
  GPUBuffer = 4933,
  GPUBufferUsage = 4943,
  GPUCanvasContext = 4958,
  GPUColorWrite = 4975,
  GPUCommandBuffer = 4989,
  GPUCommandEncoder = 5006,
  GPUCompilationInfo = 5024,
  GPUCompilationMessage = 5043,
  GPUComputePassEncoder = 5065,
  GPUComputePipeline = 5087,
  GPUDevice = 5106,
  GPUDeviceLostInfo = 5116,
  GPUError = 5134,
  GPUExternalTexture = 5143,
  GPUInternalError = 5162,
  GPUMapMode = 5179,
  GPUOutOfMemoryError = 5190,
  GPUPipelineError = 5210,
  GPUPipelineLayout = 5227,
  GPUQuerySet = 5245,
  GPUQueue = 5257,
  GPURenderBundle = 5266,
  GPURenderBundleEncoder = 5282,
  GPURenderPassEncoder = 5305,
  GPURenderPipeline = 5326,
  GPUSampler = 5344,
  GPUShaderModule = 5355,
  GPUShaderStage = 5371,
  GPUSupportedFeatures = 5386,
  GPUSupportedLimits = 5407,
  GPUTexture = 5426,
  GPUTextureUsage = 5437,
  GPUTextureView = 5453,
  GPUUncapturedErrorEvent = 5468,
  GPUValidationError = 5492,
  GainNode = 5511,
  Gamepad = 5520,
  GamepadAxisMoveEvent = 5528,
  GamepadButton = 5549,
  GamepadButtonEvent = 5563,
  GamepadEvent = 5582,
  GamepadHapticActuator = 5595,
  GamepadLightIndicator = 5617,
  GamepadPose = 5639,
  GamepadServiceTest = 5651,
  GamepadTouch = 5670,
  Geolocation = 5683,
  GeolocationCoordinates = 5695,
  GeolocationPosition = 5718,
  GeolocationPositionError = 5738,
  GetUserMediaRequest = 5763,
  GleanBoolean = 5783,
  GleanCategory = 5796,
  GleanCounter = 5810,
  GleanCustomDistribution = 5823,
  GleanDatetime = 5847,
  GleanDenominator = 5861,
  GleanDualLabeledCounter = 5878,
  GleanEvent = 5902,
  GleanImpl = 5913,
  GleanLabeled = 5923,
  GleanMemoryDistribution = 5936,
  GleanMetric = 5960,
  GleanNumerator = 5972,
  GleanObject = 5987,
  GleanPingsImpl = 5999,
  GleanQuantity = 6014,
  GleanRate = 6028,
  GleanString = 6038,
  GleanStringList = 6050,
  GleanText = 6066,
  GleanTimespan = 6076,
  GleanTimingDistribution = 6090,
  GleanUrl = 6114,
  GleanUuid = 6123,
  Grid = 6133,
  GridArea = 6138,
  GridDimension = 6147,
  GridLine = 6161,
  GridLines = 6170,
  GridTrack = 6180,
  GridTracks = 6190,
  HTMLAllCollection = 6201,
  HTMLAnchorElement = 6219,
  HTMLAreaElement = 6237,
  HTMLAudioElement = 6253,
  HTMLBRElement = 6270,
  HTMLBaseElement = 6284,
  HTMLBodyElement = 6300,
  HTMLButtonElement = 6316,
  HTMLCanvasElement = 6334,
  HTMLCollection = 6352,
  HTMLDListElement = 6367,
  HTMLDataElement = 6384,
  HTMLDataListElement = 6400,
  HTMLDetailsElement = 6420,
  HTMLDialogElement = 6439,
  HTMLDirectoryElement = 6457,
  HTMLDivElement = 6478,
  HTMLDocument = 6493,
  HTMLElement = 6506,
  HTMLEmbedElement = 6518,
  HTMLFieldSetElement = 6535,
  HTMLFontElement = 6555,
  HTMLFormControlsCollection = 6571,
  HTMLFormElement = 6598,
  HTMLFrameElement = 6614,
  HTMLFrameSetElement = 6631,
  HTMLHRElement = 6651,
  HTMLHeadElement = 6665,
  HTMLHeadingElement = 6681,
  HTMLHtmlElement = 6700,
  HTMLIFrameElement = 6716,
  HTMLImageElement = 6734,
  HTMLInputElement = 6751,
  HTMLLIElement = 6768,
  HTMLLabelElement = 6782,
  HTMLLegendElement = 6799,
  HTMLLinkElement = 6817,
  HTMLMapElement = 6833,
  HTMLMarqueeElement = 6848,
  HTMLMediaElement = 6867,
  HTMLMenuElement = 6884,
  HTMLMetaElement = 6900,
  HTMLMeterElement = 6916,
  HTMLModElement = 6933,
  HTMLOListElement = 6948,
  HTMLObjectElement = 6965,
  HTMLOptGroupElement = 6983,
  HTMLOptionElement = 7003,
  HTMLOptionsCollection = 7021,
  HTMLOutputElement = 7043,
  HTMLParagraphElement = 7061,
  HTMLParamElement = 7082,
  HTMLPictureElement = 7099,
  HTMLPreElement = 7118,
  HTMLProgressElement = 7133,
  HTMLQuoteElement = 7153,
  HTMLScriptElement = 7170,
  HTMLSelectElement = 7188,
  HTMLSlotElement = 7206,
  HTMLSourceElement = 7222,
  HTMLSpanElement = 7240,
  HTMLStyleElement = 7256,
  HTMLTableCaptionElement = 7273,
  HTMLTableCellElement = 7297,
  HTMLTableColElement = 7318,
  HTMLTableElement = 7338,
  HTMLTableRowElement = 7355,
  HTMLTableSectionElement = 7375,
  HTMLTemplateElement = 7399,
  HTMLTextAreaElement = 7419,
  HTMLTimeElement = 7439,
  HTMLTitleElement = 7455,
  HTMLTrackElement = 7472,
  HTMLUListElement = 7489,
  HTMLUnknownElement = 7506,
  HTMLVideoElement = 7525,
  HashChangeEvent = 7542,
  Headers = 7558,
  Headers_Iterator = 7566,
  HeapSnapshot = 7583,
  Highlight = 7596,
  HighlightRegistry = 7606,
  History = 7624,
  IDBCursor = 7632,
  IDBCursorWithValue = 7642,
  IDBDatabase = 7661,
  IDBFactory = 7673,
  IDBIndex = 7684,
  IDBKeyRange = 7693,
  IDBObjectStore = 7705,
  IDBOpenDBRequest = 7720,
  IDBRequest = 7737,
  IDBTransaction = 7748,
  IDBVersionChangeEvent = 7763,
  IIRFilterNode = 7785,
  IOUtils = 7799,
  IdentityCredential = 7807,
  IdentityProvider = 7826,
  IdleDeadline = 7843,
  Image = 7856,
  ImageBitmap = 7862,
  ImageBitmapRenderingContext = 7874,
  ImageCapture = 7902,
  ImageCaptureError = 7915,
  ImageCaptureErrorEvent = 7933,
  ImageData = 7956,
  ImageDecoder = 7966,
  ImageDocument = 7979,
  ImageTrack = 7993,
  ImageTrackList = 8004,
  InferenceSession = 8019,
  InputEvent = 8036,
  InspectorCSSParser = 8047,
  InspectorFontFace = 8066,
  InspectorUtils = 8084,
  IntersectionObserver = 8099,
  IntersectionObserverEntry = 8120,
  IntlUtils = 8146,
  JSProcessActorChild = 8156,
  JSProcessActorParent = 8176,
  JSWindowActorChild = 8197,
  JSWindowActorParent = 8216,
  KeyEvent = 8236,
  KeyboardEvent = 8245,
  KeyframeEffect = 8259,
  L10nFileSource = 8274,
  L10nOverlays = 8289,
  L10nRegistry = 8302,
  LargestContentfulPaint = 8315,
  LegacyMozTCPSocket = 8338,
  LlamaRunner = 8357,
  Localization = 8369,
  Location = 8382,
  Lock = 8391,
  LockManager = 8396,
  MIDIAccess = 8408,
  MIDIConnectionEvent = 8419,
  MIDIInput = 8439,
  MIDIInputMap = 8449,
  MIDIMessageEvent = 8462,
  MIDIOutput = 8479,
  MIDIOutputMap = 8490,
  MIDIPort = 8504,
  MLS = 8513,
  MLSGroupView = 8517,
  MOZ_debug = 8530,
  MatchGlob = 8540,
  MatchPattern = 8550,
  MatchPatternSet = 8563,
  MathMLElement = 8579,
  MediaCapabilities = 8593,
  MediaControlService = 8611,
  MediaController = 8631,
  MediaDeviceInfo = 8647,
  MediaDevices = 8663,
  MediaElementAudioSourceNode = 8676,
  MediaEncryptedEvent = 8704,
  MediaError = 8724,
  MediaKeyError = 8735,
  MediaKeyMessageEvent = 8749,
  MediaKeySession = 8770,
  MediaKeyStatusMap = 8786,
  MediaKeyStatusMap_Iterator = 8804,
  MediaKeySystemAccess = 8831,
  MediaKeys = 8852,
  MediaList = 8862,
  MediaMetadata = 8872,
  MediaQueryList = 8886,
  MediaQueryListEvent = 8901,
  MediaRecorder = 8921,
  MediaRecorderErrorEvent = 8935,
  MediaSession = 8959,
  MediaSource = 8972,
  MediaStream = 8984,
  MediaStreamAudioDestinationNode = 8996,
  MediaStreamAudioSourceNode = 9028,
  MediaStreamError = 9055,
  MediaStreamEvent = 9072,
  MediaStreamTrack = 9089,
  MediaStreamTrackAudioSourceNode = 9106,
  MediaStreamTrackEvent = 9138,
  MerchantValidationEvent = 9160,
  MessageBroadcaster = 9184,
  MessageChannel = 9203,
  MessageEvent = 9218,
  MessageListenerManager = 9231,
  MessagePort = 9254,
  MessageSender = 9266,
  MimeType = 9280,
  MimeTypeArray = 9289,
  MouseEvent = 9303,
  MouseScrollEvent = 9314,
  MozCanvasPrintState = 9331,
  MozDocumentMatcher = 9351,
  MozDocumentObserver = 9370,
  MozQueryInterface = 9390,
  MozSharedMap = 9408,
  MozSharedMap_Iterator = 9421,
  MozSharedMapChangeEvent = 9443,
  MozStorageAsyncStatementParams = 9467,
  MozStorageStatementParams = 9498,
  MozStorageStatementRow = 9524,
  MozWritableSharedMap = 9547,
  MutationObserver = 9568,
  MutationRecord = 9585,
  NamedNodeMap = 9600,
  NavigateEvent = 9613,
  Navigation = 9627,
  NavigationActivation = 9638,
  NavigationCurrentEntryChangeEvent = 9659,
  NavigationDestination = 9693,
  NavigationHistoryEntry = 9715,
  NavigationPreloadManager = 9738,
  NavigationTransition = 9763,
  Navigator = 9784,
  NavigatorLogin = 9794,
  NetworkInformation = 9809,
  Node = 9828,
  NodeFilter = 9833,
  NodeIterator = 9844,
  NodeList = 9857,
  Notification = 9866,
  NotificationEvent = 9879,
  NotifyPaintEvent = 9897,
  OES_draw_buffers_indexed = 9914,
  OES_element_index_uint = 9939,
  OES_fbo_render_mipmap = 9962,
  OES_standard_derivatives = 9984,
  OES_texture_float = 10009,
  OES_texture_float_linear = 10027,
  OES_texture_half_float = 10052,
  OES_texture_half_float_linear = 10075,
  OES_vertex_array_object = 10105,
  OVR_multiview2 = 10129,
  OfflineAudioCompletionEvent = 10144,
  OfflineAudioContext = 10172,
  OffscreenCanvas = 10192,
  OffscreenCanvasRenderingContext2D = 10208,
  Option = 10242,
  OscillatorNode = 10249,
  PageTransitionEvent = 10264,
  PaintRequest = 10284,
  PaintRequestList = 10297,
  PaintWorkletGlobalScope = 10314,
  PannerNode = 10338,
  ParentProcessMessageManager = 10349,
  Path2D = 10377,
  PathUtils = 10384,
  PaymentAddress = 10394,
  PaymentMethodChangeEvent = 10409,
  PaymentRequest = 10434,
  PaymentRequestUpdateEvent = 10449,
  PaymentResponse = 10475,
  PeerConnectionImpl = 10491,
  PeerConnectionObserver = 10510,
  Performance = 10533,
  PerformanceEntry = 10545,
  PerformanceEntryEvent = 10562,
  PerformanceEventTiming = 10584,
  PerformanceMark = 10607,
  PerformanceMeasure = 10623,
  PerformanceNavigation = 10642,
  PerformanceNavigationTiming = 10664,
  PerformanceObserver = 10692,
  PerformanceObserverEntryList = 10712,
  PerformancePaintTiming = 10741,
  PerformanceResourceTiming = 10764,
  PerformanceServerTiming = 10790,
  PerformanceTiming = 10814,
  PeriodicWave = 10832,
  PermissionStatus = 10845,
  Permissions = 10862,
  PlacesBookmark = 10874,
  PlacesBookmarkAddition = 10889,
  PlacesBookmarkChanged = 10912,
  PlacesBookmarkGuid = 10934,
  PlacesBookmarkKeyword = 10953,
  PlacesBookmarkMoved = 10975,
  PlacesBookmarkRemoved = 10995,
  PlacesBookmarkTags = 11017,
  PlacesBookmarkTime = 11036,
  PlacesBookmarkTitle = 11055,
  PlacesBookmarkUrl = 11075,
  PlacesEvent = 11093,
  PlacesEventCounts = 11105,
  PlacesFavicon = 11123,
  PlacesHistoryCleared = 11137,
  PlacesObservers = 11158,
  PlacesPurgeCaches = 11174,
  PlacesRanking = 11192,
  PlacesVisit = 11206,
  PlacesVisitRemoved = 11218,
  PlacesVisitTitle = 11237,
  PlacesWeakCallbackWrapper = 11254,
  Plugin = 11280,
  PluginArray = 11287,
  PluginCrashedEvent = 11299,
  PointerEvent = 11318,
  PopStateEvent = 11331,
  PopupBlockedEvent = 11345,
  PopupPositionedEvent = 11363,
  PositionStateEvent = 11384,
  PrecompiledScript = 11403,
  PrivateAttribution = 11421,
  ProcessMessageManager = 11440,
  ProcessingInstruction = 11462,
  ProgressEvent = 11484,
  PromiseDebugging = 11498,
  PromiseNativeHandler = 11515,
  PromiseRejectionEvent = 11536,
  PublicKeyCredential = 11558,
  PushEvent = 11578,
  PushManager = 11588,
  PushManagerImpl = 11600,
  PushMessageData = 11616,
  PushSubscription = 11632,
  PushSubscriptionChangeEvent = 11649,
  PushSubscriptionOptions = 11677,
  RTCCertificate = 11701,
  RTCDTMFSender = 11716,
  RTCDTMFToneChangeEvent = 11730,
  RTCDataChannel = 11753,
  RTCDataChannelEvent = 11768,
  RTCDtlsTransport = 11788,
  RTCEncodedAudioFrame = 11805,
  RTCEncodedVideoFrame = 11826,
  RTCIceCandidate = 11847,
  RTCIceTransport = 11863,
  RTCIdentityProviderRegistrar = 11879,
  RTCPeerConnection = 11908,
  RTCPeerConnectionIceEvent = 11926,
  RTCPeerConnectionStatic = 11952,
  RTCRtpReceiver = 11976,
  RTCRtpScriptTransform = 11991,
  RTCRtpScriptTransformer = 12013,
  RTCRtpSender = 12037,
  RTCRtpTransceiver = 12050,
  RTCSctpTransport = 12068,
  RTCSessionDescription = 12085,
  RTCStatsReport = 12107,
  RTCTrackEvent = 12122,
  RTCTransformEvent = 12136,
  RadioNodeList = 12154,
  Range = 12168,
  ReadableByteStreamController = 12174,
  ReadableStream = 12203,
  ReadableStream_AsyncIterator = 12218,
  ReadableStreamBYOBReader = 12247,
  ReadableStreamBYOBRequest = 12272,
  ReadableStreamDefaultController = 12298,
  ReadableStreamDefaultReader = 12330,
  RedirectBlockedEvent = 12358,
  Report = 12379,
  ReportBody = 12386,
  ReportingObserver = 12397,
  Request = 12415,
  ResizeObserver = 12423,
  ResizeObserverEntry = 12438,
  ResizeObserverSize = 12458,
  Response = 12477,
  SVGAElement = 12486,
  SVGAngle = 12498,
  SVGAnimateElement = 12507,
  SVGAnimateMotionElement = 12525,
  SVGAnimateTransformElement = 12549,
  SVGAnimatedAngle = 12576,
  SVGAnimatedBoolean = 12593,
  SVGAnimatedEnumeration = 12612,
  SVGAnimatedInteger = 12635,
  SVGAnimatedLength = 12654,
  SVGAnimatedLengthList = 12672,
  SVGAnimatedNumber = 12694,
  SVGAnimatedNumberList = 12712,
  SVGAnimatedPreserveAspectRatio = 12734,
  SVGAnimatedRect = 12765,
  SVGAnimatedString = 12781,
  SVGAnimatedTransformList = 12799,
  SVGAnimationElement = 12824,
  SVGCircleElement = 12844,
  SVGClipPathElement = 12861,
  SVGComponentTransferFunctionElement = 12880,
  SVGDefsElement = 12916,
  SVGDescElement = 12931,
  SVGElement = 12946,
  SVGEllipseElement = 12957,
  SVGFEBlendElement = 12975,
  SVGFEColorMatrixElement = 12993,
  SVGFEComponentTransferElement = 13017,
  SVGFECompositeElement = 13047,
  SVGFEConvolveMatrixElement = 13069,
  SVGFEDiffuseLightingElement = 13096,
  SVGFEDisplacementMapElement = 13124,
  SVGFEDistantLightElement = 13152,
  SVGFEDropShadowElement = 13177,
  SVGFEFloodElement = 13200,
  SVGFEFuncAElement = 13218,
  SVGFEFuncBElement = 13236,
  SVGFEFuncGElement = 13254,
  SVGFEFuncRElement = 13272,
  SVGFEGaussianBlurElement = 13290,
  SVGFEImageElement = 13315,
  SVGFEMergeElement = 13333,
  SVGFEMergeNodeElement = 13351,
  SVGFEMorphologyElement = 13373,
  SVGFEOffsetElement = 13396,
  SVGFEPointLightElement = 13415,
  SVGFESpecularLightingElement = 13438,
  SVGFESpotLightElement = 13467,
  SVGFETileElement = 13489,
  SVGFETurbulenceElement = 13506,
  SVGFilterElement = 13529,
  SVGForeignObjectElement = 13546,
  SVGGElement = 13570,
  SVGGeometryElement = 13582,
  SVGGradientElement = 13601,
  SVGGraphicsElement = 13620,
  SVGImageElement = 13639,
  SVGLength = 13655,
  SVGLengthList = 13665,
  SVGLineElement = 13679,
  SVGLinearGradientElement = 13694,
  SVGMPathElement = 13719,
  SVGMarkerElement = 13735,
  SVGMaskElement = 13752,
  SVGMatrix = 13767,
  SVGMetadataElement = 13777,
  SVGNumber = 13796,
  SVGNumberList = 13806,
  SVGPathElement = 13820,
  SVGPathSegment = 13835,
  SVGPatternElement = 13850,
  SVGPoint = 13868,
  SVGPointList = 13877,
  SVGPolygonElement = 13890,
  SVGPolylineElement = 13908,
  SVGPreserveAspectRatio = 13927,
  SVGRadialGradientElement = 13950,
  SVGRect = 13975,
  SVGRectElement = 13983,
  SVGSVGElement = 13998,
  SVGScriptElement = 14012,
  SVGSetElement = 14029,
  SVGStopElement = 14043,
  SVGStringList = 14058,
  SVGStyleElement = 14072,
  SVGSwitchElement = 14088,
  SVGSymbolElement = 14105,
  SVGTSpanElement = 14122,
  SVGTextContentElement = 14138,
  SVGTextElement = 14160,
  SVGTextPathElement = 14175,
  SVGTextPositioningElement = 14194,
  SVGTitleElement = 14220,
  SVGTransform = 14236,
  SVGTransformList = 14249,
  SVGUnitTypes = 14266,
  SVGUseElement = 14279,
  SVGViewElement = 14293,
  Sanitizer = 14308,
  Scheduler = 14318,
  Screen = 14328,
  ScreenLuminance = 14335,
  ScreenOrientation = 14351,
  ScriptProcessorNode = 14369,
  ScrollAreaEvent = 14389,
  SecurityPolicyViolationEvent = 14405,
  Selection = 14434,
  ServiceWorker = 14444,
  ServiceWorkerContainer = 14458,
  ServiceWorkerGlobalScope = 14481,
  ServiceWorkerRegistration = 14506,
  SessionStoreFormData = 14532,
  SessionStoreScrollData = 14553,
  SessionStoreUtils = 14576,
  ShadowRealmGlobalScope = 14594,
  ShadowRoot = 14617,
  SharedWorker = 14628,
  SharedWorkerGlobalScope = 14641,
  SimpleGestureEvent = 14665,
  SourceBuffer = 14684,
  SourceBufferList = 14697,
  SpeechGrammar = 14714,
  SpeechGrammarList = 14728,
  SpeechRecognition = 14746,
  SpeechRecognitionAlternative = 14764,
  SpeechRecognitionError = 14793,
  SpeechRecognitionEvent = 14816,
  SpeechRecognitionResult = 14839,
  SpeechRecognitionResultList = 14863,
  SpeechSynthesis = 14891,
  SpeechSynthesisErrorEvent = 14907,
  SpeechSynthesisEvent = 14933,
  SpeechSynthesisUtterance = 14954,
  SpeechSynthesisVoice = 14979,
  StaticRange = 15000,
  StereoPannerNode = 15012,
  Storage = 15029,
  StorageEvent = 15037,
  StorageManager = 15050,
  StreamFilter = 15065,
  StreamFilterDataEvent = 15078,
  StructuredCloneHolder = 15100,
  StructuredCloneTester = 15122,
  StylePropertyMap = 15144,
  StylePropertyMapReadOnly = 15161,
  StylePropertyMapReadOnly_Iterator = 15186,
  StyleSheet = 15220,
  StyleSheetApplicableStateChangeEvent = 15231,
  StyleSheetList = 15268,
  StyleSheetRemovedEvent = 15283,
  SubmitEvent = 15306,
  SubtleCrypto = 15318,
  SyncMessageSender = 15331,
  SyncReadFile = 15349,
  TCPServerSocket = 15362,
  TCPServerSocketEvent = 15378,
  TCPSocket = 15399,
  TCPSocketErrorEvent = 15409,
  TCPSocketEvent = 15429,
  TaskController = 15444,
  TaskPriorityChangeEvent = 15459,
  TaskSignal = 15483,
  Tensor = 15494,
  TestUtils = 15501,
  TestingDeprecatedInterface = 15511,
  Text = 15538,
  TextClause = 15543,
  TextDecoder = 15554,
  TextDecoderStream = 15566,
  TextEncoder = 15584,
  TextEncoderStream = 15596,
  TextEvent = 15614,
  TextMetrics = 15624,
  TextTrack = 15636,
  TextTrackCue = 15646,
  TextTrackCueList = 15659,
  TextTrackList = 15676,
  TimeEvent = 15690,
  TimeRanges = 15700,
  ToggleEvent = 15711,
  Touch = 15723,
  TouchEvent = 15729,
  TouchList = 15740,
  TrackEvent = 15750,
  TransformStream = 15761,
  TransformStreamDefaultController = 15777,
  TransitionEvent = 15810,
  TreeColumn = 15826,
  TreeColumns = 15837,
  TreeContentView = 15849,
  TreeWalker = 15865,
  TrustedHTML = 15876,
  TrustedScript = 15888,
  TrustedScriptURL = 15902,
  TrustedTypePolicy = 15919,
  TrustedTypePolicyFactory = 15937,
  UDPMessageEvent = 15962,
  UDPSocket = 15978,
  UIEvent = 15988,
  URL = 15996,
  URLPattern = 16000,
  URLSearchParams = 16011,
  URLSearchParams_Iterator = 16027,
  UniFFIPointer = 16052,
  UniFFIScaffolding = 16066,
  UserActivation = 16084,
  UserInteraction = 16099,
  UserProximityEvent = 16115,
  VRDisplay = 16134,
  VRDisplayCapabilities = 16144,
  VRDisplayEvent = 16166,
  VREyeParameters = 16181,
  VRFieldOfView = 16197,
  VRFrameData = 16211,
  VRMockController = 16223,
  VRMockDisplay = 16240,
  VRPose = 16254,
  VRServiceTest = 16261,
  VRStageParameters = 16275,
  VTTCue = 16293,
  VTTRegion = 16300,
  ValidityState = 16310,
  VideoColorSpace = 16324,
  VideoDecoder = 16340,
  VideoEncoder = 16353,
  VideoFrame = 16366,
  VideoPlaybackQuality = 16377,
  VideoTrack = 16398,
  VideoTrackList = 16409,
  ViewTransition = 16424,
  VisualViewport = 16439,
  WEBGL_color_buffer_float = 16454,
  WEBGL_compressed_texture_astc = 16479,
  WEBGL_compressed_texture_etc = 16509,
  WEBGL_compressed_texture_etc1 = 16538,
  WEBGL_compressed_texture_pvrtc = 16568,
  WEBGL_compressed_texture_s3tc = 16599,
  WEBGL_compressed_texture_s3tc_srgb = 16629,
  WEBGL_debug_renderer_info = 16664,
  WEBGL_debug_shaders = 16690,
  WEBGL_depth_texture = 16710,
  WEBGL_draw_buffers = 16730,
  WEBGL_explicit_present = 16749,
  WEBGL_lose_context = 16772,
  WEBGL_provoking_vertex = 16791,
  WGSLLanguageFeatures = 16814,
  WakeLock = 16835,
  WakeLockSentinel = 16844,
  WaveShaperNode = 16861,
  WebExtensionContentScript = 16876,
  WebExtensionPolicy = 16902,
  WebGL2RenderingContext = 16921,
  WebGLActiveInfo = 16944,
  WebGLBuffer = 16960,
  WebGLContextEvent = 16972,
  WebGLFramebuffer = 16990,
  WebGLProgram = 17007,
  WebGLQuery = 17020,
  WebGLRenderbuffer = 17031,
  WebGLRenderingContext = 17049,
  WebGLSampler = 17071,
  WebGLShader = 17084,
  WebGLShaderPrecisionFormat = 17096,
  WebGLSync = 17123,
  WebGLTexture = 17133,
  WebGLTransformFeedback = 17146,
  WebGLUniformLocation = 17169,
  WebGLVertexArrayObject = 17190,
  WebKitCSSMatrix = 17213,
  WebSocket = 17229,
  WebTransport = 17239,
  WebTransportBidirectionalStream = 17252,
  WebTransportDatagramDuplexStream = 17284,
  WebTransportError = 17317,
  WebTransportReceiveStream = 17335,
  WebTransportSendStream = 17361,
  WebrtcGlobalInformation = 17384,
  WheelEvent = 17408,
  Window = 17419,
  WindowClient = 17426,
  WindowContext = 17439,
  WindowGlobalChild = 17453,
  WindowGlobalParent = 17471,
  WindowRoot = 17490,
  Worker = 17501,
  WorkerDebuggerGlobalScope = 17508,
  WorkerGlobalScope = 17534,
  WorkerLocation = 17552,
  WorkerNavigator = 17567,
  WorkerTestUtils = 17583,
  Worklet = 17599,
  WorkletGlobalScope = 17607,
  WritableStream = 17626,
  WritableStreamDefaultController = 17641,
  WritableStreamDefaultWriter = 17673,
  XMLDocument = 17701,
  XMLHttpRequest = 17713,
  XMLHttpRequestEventTarget = 17728,
  XMLHttpRequestUpload = 17754,
  XMLSerializer = 17775,
  XPathEvaluator = 17789,
  XPathExpression = 17804,
  XPathResult = 17820,
  XRBoundedReferenceSpace = 17832,
  XRFrame = 17856,
  XRInputSource = 17864,
  XRInputSourceArray = 17878,
  XRInputSourceEvent = 17897,
  XRInputSourcesChangeEvent = 17916,
  XRPose = 17942,
  XRReferenceSpace = 17949,
  XRReferenceSpaceEvent = 17966,
  XRRenderState = 17988,
  XRRigidTransform = 18002,
  XRSession = 18019,
  XRSessionEvent = 18029,
  XRSpace = 18044,
  XRSystem = 18052,
  XRView = 18061,
  XRViewerPose = 18068,
  XRViewport = 18081,
  XRWebGLLayer = 18092,
  XSLTProcessor = 18105,
  XULCommandEvent = 18119,
  XULElement = 18135,
  XULFrameElement = 18146,
  XULMenuElement = 18162,
  XULPopupElement = 18177,
  XULResizerElement = 18193,
  XULTextElement = 18211,
  XULTreeElement = 18226,
  console = 18241,
  webkitSpeechGrammar = 18249,
  webkitSpeechGrammarList = 18269,
  webkitSpeechRecognition = 18293,
  webkitURL = 18317,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
