/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "ErrorEvent.h"
#include "ErrorEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/ErrorEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(ErrorEvent)

NS_IMPL_ADDREF_INHERITED(ErrorEvent, Event)
NS_IMPL_RELEASE_INHERITED(ErrorEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(ErrorEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(ErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mError)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(ErrorEvent, Event)
  tmp->mError.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(ErrorEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

ErrorEvent::ErrorEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ErrorEvent::~ErrorEvent()
{
  mozilla::DropJSObjects(this);
}

void
ErrorEvent::GetError(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mError);
  aRetVal.set(mError);
}

ErrorEvent*
ErrorEvent::AsErrorEvent()
{
  return this;
}

JSObject*
ErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ErrorEvent>
ErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ErrorEventInit& aEventInitDict)
{
  RefPtr<ErrorEvent> e = new ErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mMessage = aEventInitDict.mMessage;
  e->mFilename = aEventInitDict.mFilename;
  e->mLineno = aEventInitDict.mLineno;
  e->mColno = aEventInitDict.mColno;
  e->mError = aEventInitDict.mError;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<ErrorEvent>
ErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ErrorEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
ErrorEvent::GetMessage(nsString& aRetVal) const
{
  aRetVal = mMessage;
}

void
ErrorEvent::GetFilename(nsCString& aRetVal) const
{
  aRetVal = mFilename;
}

uint32_t
ErrorEvent::Lineno() const
{
  return mLineno;
}

uint32_t
ErrorEvent::Colno() const
{
  return mColno;
}

void
ErrorEvent::GetError(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetError(aRetVal);
}


} // namespace mozilla::dom
