//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/PRemoteMediaManagerChild.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/RemoteMediaManagerChild.h"
#include "mozilla/dom/MediaIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"

#include "mozilla/layers/PTextureChild.h"
#include "mozilla/PRemoteCDMChild.h"
#include "mozilla/PRemoteDecoderChild.h"
#include "mozilla/PRemoteEncoderChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {


auto PRemoteMediaManagerChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PRemoteMediaManagerChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PRemoteMediaManagerChild::PRemoteMediaManagerChild() :
    mozilla::ipc::IToplevelProtocol("PRemoteMediaManagerChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PRemoteMediaManagerChild);
}

PRemoteMediaManagerChild::~PRemoteMediaManagerChild()
{
    MOZ_COUNT_DTOR(PRemoteMediaManagerChild);
}

auto PRemoteMediaManagerChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PRemoteMediaManagerChild'");
    AddRef();
}

auto PRemoteMediaManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PRemoteMediaManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteMediaManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteMediaManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteMediaManagerChild::ManagedPRemoteCDMChild(nsTArray<PRemoteCDMChild*>& aArr) const -> void
{
    mManagedPRemoteCDMChild.ToArray(aArr);
}

auto PRemoteMediaManagerChild::ManagedPRemoteCDMChild() const -> const ManagedContainer<PRemoteCDMChild>&
{
    return mManagedPRemoteCDMChild;
}

auto PRemoteMediaManagerChild::ManagedPRemoteDecoderChild(nsTArray<PRemoteDecoderChild*>& aArr) const -> void
{
    mManagedPRemoteDecoderChild.ToArray(aArr);
}

auto PRemoteMediaManagerChild::ManagedPRemoteDecoderChild() const -> const ManagedContainer<PRemoteDecoderChild>&
{
    return mManagedPRemoteDecoderChild;
}

auto PRemoteMediaManagerChild::ManagedPRemoteEncoderChild(nsTArray<PRemoteEncoderChild*>& aArr) const -> void
{
    mManagedPRemoteEncoderChild.ToArray(aArr);
}

auto PRemoteMediaManagerChild::ManagedPRemoteEncoderChild() const -> const ManagedContainer<PRemoteEncoderChild>&
{
    return mManagedPRemoteEncoderChild;
}

auto PRemoteMediaManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PRemoteCDMMsgStart,
        PRemoteDecoderMsgStart,
        PRemoteEncoderMsgStart
    };
    return sIds;
}

auto PRemoteMediaManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PRemoteCDMMsgStart:
        return (&(mManagedPRemoteCDMChild));
    case PRemoteDecoderMsgStart:
        return (&(mManagedPRemoteDecoderChild));
    case PRemoteEncoderMsgStart:
        return (&(mManagedPRemoteEncoderChild));
    default:
        return nullptr;
    }
}

auto PRemoteMediaManagerChild::OpenPRemoteCDMEndpoint(PRemoteCDMChild* aActor) -> ManagedEndpoint<PRemoteCDMParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteCDMChild actor");
        return ManagedEndpoint<PRemoteCDMParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteCDMChild actor");
        return ManagedEndpoint<PRemoteCDMParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteCDMParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteMediaManagerChild::BindPRemoteCDMEndpoint(
        ManagedEndpoint<PRemoteCDMChild> aEndpoint,
        PRemoteCDMChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteMediaManagerChild::OpenPRemoteDecoderEndpoint(PRemoteDecoderChild* aActor) -> ManagedEndpoint<PRemoteDecoderParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteDecoderChild actor");
        return ManagedEndpoint<PRemoteDecoderParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteDecoderChild actor");
        return ManagedEndpoint<PRemoteDecoderParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteDecoderParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteMediaManagerChild::BindPRemoteDecoderEndpoint(
        ManagedEndpoint<PRemoteDecoderChild> aEndpoint,
        PRemoteDecoderChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteMediaManagerChild::OpenPRemoteEncoderEndpoint(PRemoteEncoderChild* aActor) -> ManagedEndpoint<PRemoteEncoderParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PRemoteEncoderChild actor");
        return ManagedEndpoint<PRemoteEncoderParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteEncoderChild actor");
        return ManagedEndpoint<PRemoteEncoderParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PRemoteEncoderParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PRemoteMediaManagerChild::BindPRemoteEncoderEndpoint(
        ManagedEndpoint<PRemoteEncoderChild> aEndpoint,
        PRemoteEncoderChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PRemoteMediaManagerChild::SendPRemoteDecoderConstructor(
        const RemoteDecoderInfoIPDL& info,
        const OptionSet& options,
        const mozilla::Maybe<TextureFactoryIdentifier>& identifier,
        const mozilla::Maybe<uint64_t>& mediaEngineId,
        const mozilla::Maybe<TrackingId>& trackingId,
        PRemoteCDMChild* cdm) -> PRemoteDecoderChild*
{
    PRemoteDecoderChild* actor = (static_cast<RemoteMediaManagerChild*>(this))->AllocPRemoteDecoderChild(info, options, identifier, mediaEngineId, trackingId, cdm);
    return SendPRemoteDecoderConstructor(std::move(actor), std::move(info), std::move(options), std::move(identifier), std::move(mediaEngineId), std::move(trackingId), cdm);
}

auto PRemoteMediaManagerChild::SendPRemoteDecoderConstructor(
        PRemoteDecoderChild* actor,
        const RemoteDecoderInfoIPDL& info,
        const OptionSet& options,
        const mozilla::Maybe<TextureFactoryIdentifier>& identifier,
        const mozilla::Maybe<uint64_t>& mediaEngineId,
        const mozilla::Maybe<TrackingId>& trackingId,
        PRemoteCDMChild* cdm) -> PRemoteDecoderChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PRemoteDecoderChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteDecoderChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_PRemoteDecoderConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), info);
    // Sentinel = 'info'
    ((&(writer__)))->WriteSentinel(70058413);
    IPC::WriteParam((&(writer__)), options);
    // Sentinel = 'options'
    ((&(writer__)))->WriteSentinel(204735245);
    IPC::WriteParam((&(writer__)), identifier);
    // Sentinel = 'identifier'
    ((&(writer__)))->WriteSentinel(379978788);
    IPC::WriteParam((&(writer__)), mediaEngineId);
    // Sentinel = 'mediaEngineId'
    ((&(writer__)))->WriteSentinel(597624068);
    IPC::WriteParam((&(writer__)), trackingId);
    // Sentinel = 'trackingId'
    ((&(writer__)))->WriteSentinel(381879297);
    IPC::WriteParam((&(writer__)), cdm);
    // Sentinel = 'cdm'
    ((&(writer__)))->WriteSentinel(39911733);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_PRemoteDecoderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PRemoteDecoderChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PRemoteMediaManagerChild::SendPRemoteEncoderConstructor(
        PRemoteEncoderChild* actor,
        const EncoderConfig& config) -> PRemoteEncoderChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PRemoteEncoderChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteEncoderChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_PRemoteEncoderConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), config);
    // Sentinel = 'config'
    ((&(writer__)))->WriteSentinel(145097335);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_PRemoteEncoderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PRemoteEncoderChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PRemoteMediaManagerChild::SendPRemoteCDMConstructor(
        PRemoteCDMChild* actor,
        const nsAString& keySystem) -> PRemoteCDMChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PRemoteCDMChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PRemoteCDMChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_PRemoteCDMConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), keySystem);
    // Sentinel = 'keySystem'
    ((&(writer__)))->WriteSentinel(317785039);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_PRemoteCDMConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PRemoteCDMChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PRemoteMediaManagerChild::SendReadback(
        const SurfaceDescriptorGPUVideo& sd,
        SurfaceDescriptor* aResult) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_Readback(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sd);
    // Sentinel = 'sd'
    ((&(writer__)))->WriteSentinel(21758168);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_Readback", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_TRACING_MARKER("Sync IPC", "PRemoteMediaManager::Msg_Readback", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__aResult__reply = IPC::ReadParam<SurfaceDescriptor>((&(reader__)));
    if (!maybe__aResult__reply) {
        FatalError("Error deserializing 'SurfaceDescriptor'");
        return false;

    }
    auto& aResult__reply = *maybe__aResult__reply;
    // Sentinel = 'aResult'
    if ((!(((&(reader__)))->ReadSentinel(185205473)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'SurfaceDescriptor'");
        return false;
    }
    (*(aResult)) = std::move(aResult__reply);
    reader__.EndRead();

    return true;
}

auto PRemoteMediaManagerChild::SendDeallocateSurfaceDescriptorGPUVideo(const SurfaceDescriptorGPUVideo& sd) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_DeallocateSurfaceDescriptorGPUVideo(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sd);
    // Sentinel = 'sd'
    ((&(writer__)))->WriteSentinel(21758168);


    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_DeallocateSurfaceDescriptorGPUVideo", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteMediaManagerChild::SendOnSetCurrent(const SurfaceDescriptorGPUVideo& sd) -> bool
{
    UniquePtr<IPC::Message> msg__ = PRemoteMediaManager::Msg_OnSetCurrent(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sd);
    // Sentinel = 'sd'
    ((&(writer__)))->WriteSentinel(21758168);


    if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PRemoteMediaManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PRemoteMediaManager::Msg_OnSetCurrent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PRemoteMediaManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PRemoteDecoderMsgStart:
        static_cast<RemoteMediaManagerChild*>(this)->DeallocPRemoteDecoderChild(static_cast<PRemoteDecoderChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PRemoteMediaManagerChild::OnMessageReceived(const Message& msg__) -> PRemoteMediaManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteMediaManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteMediaManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PRemoteMediaManager::Reply_PRemoteDecoderConstructor__ID:
        {
            return MsgProcessed;
        }
    case PRemoteMediaManager::Reply_PRemoteEncoderConstructor__ID:
        {
            return MsgProcessed;
        }
    case PRemoteMediaManager::Reply_PRemoteCDMConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PRemoteMediaManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteMediaManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::PRemoteMediaManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PRemoteMediaManager'
    (aWriter)->WriteSentinel(1213597528);
}

auto ParamTraits<::mozilla::PRemoteMediaManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PRemoteMediaManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PRemoteMediaManager'
    if ((!((aReader)->ReadSentinel(1213597528)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PRemoteMediaManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PRemoteMediaManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PRemoteMediaManager)");

        return {};
    }
    return static_cast<::mozilla::PRemoteMediaManagerChild*>(actor);
}

} // namespace IPC
