/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM RTCTransformEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "RTCTransformEvent.h"
#include "RTCTransformEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RTCRtpScriptTransformer.h"
#include "mozilla/dom/RTCTransformEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(RTCTransformEvent)

NS_IMPL_ADDREF_INHERITED(RTCTransformEvent, Event)
NS_IMPL_RELEASE_INHERITED(RTCTransformEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(RTCTransformEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTransformer)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(RTCTransformEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(RTCTransformEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTransformer)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RTCTransformEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

RTCTransformEvent::RTCTransformEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

RTCTransformEvent::~RTCTransformEvent()
{
}

RTCTransformEvent*
RTCTransformEvent::AsRTCTransformEvent()
{
  return this;
}

JSObject*
RTCTransformEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return RTCTransformEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<RTCTransformEvent>
RTCTransformEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const RTCTransformEventInit& aEventInitDict)
{
  RefPtr<RTCTransformEvent> e = new RTCTransformEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mTransformer = aEventInitDict.mTransformer;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<RTCTransformEvent>
RTCTransformEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const RTCTransformEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

RTCRtpScriptTransformer*
RTCTransformEvent::Transformer() const
{
  return mTransformer;
}


} // namespace mozilla::dom
