/* THIS FILE IS AUTOGENERATED FROM IDBCursor.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_IDBCURSORBINDING_H_
#define DOM_IDBCURSORBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class IDBCursor;
class IDBIndex;
class IDBObjectStore;
struct NativePropertyHooks;
class OwningIDBObjectStoreOrIDBIndex;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class IDBCursorDirection : uint8_t {
  Next,
  Nextunique,
  Prev,
  Prevunique,
};

namespace binding_detail {
template <> struct EnumStrings<IDBCursorDirection> {
  static constexpr nsLiteralCString Values[4] {
    "next"_ns,
    "nextunique"_ns,
    "prev"_ns,
    "prevunique"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, IDBCursorDirection aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningIDBObjectStoreOrIDBIndex& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndex& aUnion);


class IDBObjectStoreOrIDBIndex : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex
  };
public:
  enum class Type
  {
    eIDBObjectStore = TypeOrUninit::eIDBObjectStore,
    eIDBIndex = TypeOrUninit::eIDBIndex
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<NonNull<mozilla::dom::IDBIndex> > mIDBIndex;

  };

  TypeOrUninit mType;
  Value mValue;

  IDBObjectStoreOrIDBIndex(const IDBObjectStoreOrIDBIndex&) = delete;
  IDBObjectStoreOrIDBIndex& operator=(const IDBObjectStoreOrIDBIndex&) = delete;
public:
  explicit inline IDBObjectStoreOrIDBIndex()
    : mType(eUninitialized)
  {
  }

  inline ~IDBObjectStoreOrIDBIndex()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    Uninit();
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline mozilla::dom::IDBObjectStore&
  GetAsIDBObjectStore() const
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    Uninit();
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline mozilla::dom::IDBIndex&
  GetAsIDBIndex() const
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eIDBObjectStore: {
        DestroyIDBObjectStore();
        break;
      }
      case eIDBIndex: {
        DestroyIDBIndex();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToIDBObjectStore(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBObjectStore(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    mValue.mIDBObjectStore.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToIDBIndex(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBIndex(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    mValue.mIDBIndex.Destroy();
    mType = eUninitialized;
  }
};


class OwningIDBObjectStoreOrIDBIndex : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndex& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex
  };
public:
  enum class Type
  {
    eIDBObjectStore = TypeOrUninit::eIDBObjectStore,
    eIDBIndex = TypeOrUninit::eIDBIndex
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<OwningNonNull<mozilla::dom::IDBIndex> > mIDBIndex;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningIDBObjectStoreOrIDBIndex()
    : mType(eUninitialized)
  {
  }

  OwningIDBObjectStoreOrIDBIndex(OwningIDBObjectStoreOrIDBIndex&& aOther);

  explicit inline OwningIDBObjectStoreOrIDBIndex(const OwningIDBObjectStoreOrIDBIndex& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningIDBObjectStoreOrIDBIndex()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore();

  [[nodiscard]] OwningNonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore();

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore> const &
  GetAsIDBObjectStore() const
  {
    MOZ_RELEASE_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex();

  [[nodiscard]] OwningNonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex();

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline OwningNonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBIndex> const &
  GetAsIDBIndex() const
  {
    MOZ_RELEASE_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningIDBObjectStoreOrIDBIndex&
  operator=(OwningIDBObjectStoreOrIDBIndex&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningIDBObjectStoreOrIDBIndex&
  operator=(const OwningIDBObjectStoreOrIDBIndex& aOther);

private:
  bool
  TrySetToIDBObjectStore(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBObjectStore(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyIDBObjectStore();

  bool
  TrySetToIDBIndex(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToIDBIndex(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyIDBIndex();
};


namespace IDBCursor_Binding {

  typedef mozilla::dom::IDBCursor NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::IDBCursor* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::IDBCursor,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace IDBCursor_Binding



namespace IDBCursorWithValue_Binding {

  typedef mozilla::dom::IDBCursor NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::IDBCursor* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::IDBCursorWithValue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace IDBCursorWithValue_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::IDBCursorDirection>
{
  static constexpr dom::IDBCursorDirection value = dom::IDBCursorDirection::Prevunique;

  static_assert(static_cast<uint8_t>(dom::IDBCursorDirection::Next) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::IDBCursorDirection>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_IDBCURSORBINDING_H_
