/* THIS FILE IS AUTOGENERATED FROM SessionStoreUtils.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "SessionStoreUtilsBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CanonicalBrowsingContext.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/EventTarget.h"
#include "mozilla/dom/File.h"
#include "mozilla/dom/FormData.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SessionStoreUtils.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/WindowProxyHolder.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsGlobalWindowInner.h"
#include "nsIDocShell.h"
#include "nsISessionStoreRestoreData.h"
#include "nsISupports.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



CollectedCustomElementValue::CollectedCustomElementValue()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CollectedCustomElementValue::InitIds(JSContext* cx, CollectedCustomElementValueAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->state_id.init(cx, "state")) {
    return false;
  }
  return true;
}

bool
CollectedCustomElementValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CollectedCustomElementValueAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CollectedCustomElementValueAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->state_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mState.SetNull();
  } else {
    if (!mState.SetValue().Init(cx, temp.ref(), "'state' member of CollectedCustomElementValue", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->value_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mValue.SetNull();
  } else {
    if (!mValue.SetValue().Init(cx, temp.ref(), "'value' member of CollectedCustomElementValue", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
CollectedCustomElementValue::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CollectedCustomElementValue::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CollectedCustomElementValueAtoms* atomsCache = GetAtomCache<CollectedCustomElementValueAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Nullable<OwningFileOrUSVStringOrFormData > const & currentValue = mState;
    if (currentValue.IsNull()) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->state_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    if (!currentValue.Value().ToJSVal(cx, obj, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->state_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Nullable<OwningFileOrUSVStringOrFormData > const & currentValue = mValue;
    if (currentValue.IsNull()) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    if (!currentValue.Value().ToJSVal(cx, obj, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
CollectedCustomElementValue::TraceDictionary(JSTracer* trc)
{
}



CollectedCustomElementValue&
CollectedCustomElementValue::operator=(const CollectedCustomElementValue& aOther)
{
  DictionaryBase::operator=(aOther);
  mState = aOther.mState;
  mValue = aOther.mValue;
  return *this;
}



CollectedData::CollectedData()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
CollectedData::InitIds(JSContext* cx, CollectedDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->xpath_id.init(cx, "xpath") ||
      !atomsCache->url_id.init(cx, "url") ||
      !atomsCache->scroll_id.init(cx, "scroll") ||
      !atomsCache->innerHTML_id.init(cx, "innerHTML") ||
      !atomsCache->id_id.init(cx, "id") ||
      !atomsCache->children_id.init(cx, "children")) {
    return false;
  }
  return true;
}

bool
CollectedData::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CollectedDataAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CollectedDataAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->children_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChildren.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'children' member of CollectedData", "sequence");
        return false;
      }
      Sequence<JSObject*> &arr = (mChildren.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        JSObject** slotPtr = arr.AppendElement(nullptr, mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        JSObject*& slot = *slotPtr;
        if (temp.isObject()) {
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
          if ((passedToJSImpl) && !CallerSubsumes(temp)) {
            cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("element of 'children' member of CollectedData");
            return false;
          }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
          slot = &temp.toObject();
        } else if (temp.isNullOrUndefined()) {
          slot = nullptr;
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'children' member of CollectedData");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'children' member of CollectedData", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->id_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mId.Construct();
    if (temp.ref().isObject()) {
      auto& recordEntries = (mId.Value()).Entries();

      JS::Rooted<JSObject*> recordObj(cx, &temp.ref().toObject());
      JS::RootedVector<jsid> ids(cx);
      if (!js::GetPropertyKeys(cx, recordObj,
                               JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
        return false;
      }
      if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      JS::Rooted<JS::Value> propNameValue(cx);
      JS::Rooted<JS::Value> temp(cx);
      JS::Rooted<jsid> curId(cx);
      JS::Rooted<JS::Value> idVal(cx);
      // Use a hashset to keep track of ids seen, to avoid
      // introducing nasty O(N^2) behavior scanning for them all the
      // time.  Ideally we'd use a data structure with O(1) lookup
      // _and_ ordering for the MozMap, but we don't have one lying
      // around.
      nsTHashtable<nsStringHashKey> idsSeen;
      for (size_t i = 0; i < ids.length(); ++i) {
        curId = ids[i];

        JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
        if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                             &desc)) {
          return false;
        }

        if (desc.isNothing() || !desc->enumerable()) {
          continue;
        }

        idVal = js::IdToValue(curId);
        nsString propName;
        // This will just throw if idVal is a Symbol, like the spec says
        // to do.
        if (!ConvertJSValueToString(cx, idVal, "key of 'id' member of CollectedData", propName)) {
          return false;
        }

        if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
          return false;
        }

        Record<nsString, OwningStringOrBooleanOrObject>::EntryType* entry;
        if (!idsSeen.EnsureInserted(propName)) {
          // Find the existing entry.
          auto idx = recordEntries.IndexOf(propName);
          MOZ_ASSERT(idx != recordEntries.NoIndex,
                     "Why is it not found?");
          // Now blow it away to make it look like it was just added
          // to the array, because it's not obvious that it's
          // safe to write to its already-initialized mValue via our
          // normal codegen conversions.  For example, the value
          // could be a union and this would change its type, but
          // codegen assumes we won't do that.
          entry = recordEntries.ReconstructElementAt(idx);
        } else {
          // Safe to do an infallible append here, because we did a
          // SetCapacity above to the right capacity.
          entry = recordEntries.AppendElement();
        }
        entry->mKey = propName;
        OwningStringOrBooleanOrObject& slot = entry->mValue;
        if (!slot.Init(cx, temp, "Value in 'id' member of CollectedData", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'id' member of CollectedData");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->innerHTML_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mInnerHTML.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mInnerHTML.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->scroll_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mScroll.Construct();
    if (!ConvertJSValueToByteString(cx, temp.ref(), false, "'scroll' member of CollectedData", (mScroll.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->url_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUrl.Construct();
    if (!ConvertJSValueToByteString(cx, temp.ref(), false, "'url' member of CollectedData", (mUrl.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->xpath_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mXpath.Construct();
    if (temp.ref().isObject()) {
      auto& recordEntries = (mXpath.Value()).Entries();

      JS::Rooted<JSObject*> recordObj(cx, &temp.ref().toObject());
      JS::RootedVector<jsid> ids(cx);
      if (!js::GetPropertyKeys(cx, recordObj,
                               JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
        return false;
      }
      if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      JS::Rooted<JS::Value> propNameValue(cx);
      JS::Rooted<JS::Value> temp(cx);
      JS::Rooted<jsid> curId(cx);
      JS::Rooted<JS::Value> idVal(cx);
      // Use a hashset to keep track of ids seen, to avoid
      // introducing nasty O(N^2) behavior scanning for them all the
      // time.  Ideally we'd use a data structure with O(1) lookup
      // _and_ ordering for the MozMap, but we don't have one lying
      // around.
      nsTHashtable<nsStringHashKey> idsSeen;
      for (size_t i = 0; i < ids.length(); ++i) {
        curId = ids[i];

        JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
        if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                             &desc)) {
          return false;
        }

        if (desc.isNothing() || !desc->enumerable()) {
          continue;
        }

        idVal = js::IdToValue(curId);
        nsString propName;
        // This will just throw if idVal is a Symbol, like the spec says
        // to do.
        if (!ConvertJSValueToString(cx, idVal, "key of 'xpath' member of CollectedData", propName)) {
          return false;
        }

        if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
          return false;
        }

        Record<nsString, OwningStringOrBooleanOrObject>::EntryType* entry;
        if (!idsSeen.EnsureInserted(propName)) {
          // Find the existing entry.
          auto idx = recordEntries.IndexOf(propName);
          MOZ_ASSERT(idx != recordEntries.NoIndex,
                     "Why is it not found?");
          // Now blow it away to make it look like it was just added
          // to the array, because it's not obvious that it's
          // safe to write to its already-initialized mValue via our
          // normal codegen conversions.  For example, the value
          // could be a union and this would change its type, but
          // codegen assumes we won't do that.
          entry = recordEntries.ReconstructElementAt(idx);
        } else {
          // Safe to do an infallible append here, because we did a
          // SetCapacity above to the right capacity.
          entry = recordEntries.AppendElement();
        }
        entry->mKey = propName;
        OwningStringOrBooleanOrObject& slot = entry->mValue;
        if (!slot.Init(cx, temp, "Value in 'xpath' member of CollectedData", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'xpath' member of CollectedData");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
CollectedData::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CollectedData::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CollectedDataAtoms* atomsCache = GetAtomCache<CollectedDataAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mChildren.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<JSObject*> const & currentValue = mChildren.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (currentValue[sequenceIdx0]) {
                          JS::ExposeObjectToActiveJS(currentValue[sequenceIdx0]);
                        }
                        tmp.setObjectOrNull(currentValue[sequenceIdx0]);
            if (!MaybeWrapObjectOrNullValue(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->children_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Record<nsString, OwningStringOrBooleanOrObject> const & currentValue = mId.InternalValue();

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : currentValue.Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            if (!recordValue0.ToJSVal(cx, returnObj, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   entry.mKey.BeginReading(),
                                   entry.mKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnObj);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->id_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mInnerHTML.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mInnerHTML.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->innerHTML_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mScroll.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mScroll.InternalValue();
      if (!NonVoidByteStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->scroll_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUrl.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mUrl.InternalValue();
      if (!NonVoidByteStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->url_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mXpath.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Record<nsString, OwningStringOrBooleanOrObject> const & currentValue = mXpath.InternalValue();

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : currentValue.Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            if (!recordValue0.ToJSVal(cx, returnObj, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   entry.mKey.BeginReading(),
                                   entry.mKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnObj);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->xpath_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
CollectedData::TraceDictionary(JSTracer* trc)
{
  if (mChildren.WasPassed()) {
    DoTraceSequence(trc, mChildren.Value());
  }

  if (mId.WasPassed()) {
    TraceRecord(trc, mId.Value());
  }

  if (mXpath.WasPassed()) {
    TraceRecord(trc, mXpath.Value());
  }
}



CollectedFileListValue::CollectedFileListValue()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CollectedFileListValue::InitIds(JSContext* cx, CollectedFileListValueAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->fileList_id.init(cx, "fileList")) {
    return false;
  }
  return true;
}

bool
CollectedFileListValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CollectedFileListValueAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CollectedFileListValueAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->fileList_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'fileList' member of CollectedFileListValue", "sequence");
        return false;
      }
      Sequence<nsString> &arr = mFileList;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        nsString* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        nsString& slot = *slotPtr;
        if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'fileList' member of CollectedFileListValue", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'fileList' member of CollectedFileListValue");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mType)) {
      return false;
    }
  } else {
    mType.AssignLiteral(u"file");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
CollectedFileListValue::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CollectedFileListValue::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CollectedFileListValueAtoms* atomsCache = GetAtomCache<CollectedFileListValueAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<nsString> const & currentValue = mFileList;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->fileList_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mType;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
CollectedFileListValue::TraceDictionary(JSTracer* trc)
{
}

CollectedFileListValue&
CollectedFileListValue::operator=(const CollectedFileListValue& aOther)
{
  DictionaryBase::operator=(aOther);
  mFileList = aOther.mFileList;
  mType = aOther.mType;
  return *this;
}



CollectedNonMultipleSelectValue::CollectedNonMultipleSelectValue()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
CollectedNonMultipleSelectValue::InitIds(JSContext* cx, CollectedNonMultipleSelectValueAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->selectedIndex_id.init(cx, "selectedIndex")) {
    return false;
  }
  return true;
}

bool
CollectedNonMultipleSelectValue::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  CollectedNonMultipleSelectValueAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<CollectedNonMultipleSelectValueAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->selectedIndex_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'selectedIndex' member of CollectedNonMultipleSelectValue", &mSelectedIndex)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'selectedIndex' member of CollectedNonMultipleSelectValue");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->value_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mValue)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'value' member of CollectedNonMultipleSelectValue");
  }
  return true;
}

bool
CollectedNonMultipleSelectValue::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
CollectedNonMultipleSelectValue::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  CollectedNonMultipleSelectValueAtoms* atomsCache = GetAtomCache<CollectedNonMultipleSelectValueAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    int32_t const & currentValue = mSelectedIndex;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->selectedIndex_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mValue;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
CollectedNonMultipleSelectValue::TraceDictionary(JSTracer* trc)
{
}

CollectedNonMultipleSelectValue&
CollectedNonMultipleSelectValue::operator=(const CollectedNonMultipleSelectValue& aOther)
{
  DictionaryBase::operator=(aOther);
  mSelectedIndex = aOther.mSelectedIndex;
  mValue = aOther.mValue;
  return *this;
}



InputElementData::InputElementData()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InputElementData::InitIds(JSContext* cx, InputElementDataAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->valueIdx_id.init(cx, "valueIdx") ||
      !atomsCache->type_id.init(cx, "type") ||
      !atomsCache->strVal_id.init(cx, "strVal") ||
      !atomsCache->selectedIndex_id.init(cx, "selectedIndex") ||
      !atomsCache->selectVal_id.init(cx, "selectVal") ||
      !atomsCache->id_id.init(cx, "id") ||
      !atomsCache->boolVal_id.init(cx, "boolVal")) {
    return false;
  }
  return true;
}

bool
InputElementData::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

void
InputElementData::TraceDictionary(JSTracer* trc)
{
}

InputElementData&
InputElementData::operator=(const InputElementData& aOther)
{
  DictionaryBase::operator=(aOther);
  mBoolVal.Reset();
  if (aOther.mBoolVal.WasPassed()) {
    mBoolVal.Construct(aOther.mBoolVal.Value());
  }
  mId.Reset();
  if (aOther.mId.WasPassed()) {
    mId.Construct(aOther.mId.Value());
  }
  mSelectVal.Reset();
  if (aOther.mSelectVal.WasPassed()) {
    mSelectVal.Construct(aOther.mSelectVal.Value());
  }
  mSelectedIndex.Reset();
  if (aOther.mSelectedIndex.WasPassed()) {
    mSelectedIndex.Construct(aOther.mSelectedIndex.Value());
  }
  mStrVal.Reset();
  if (aOther.mStrVal.WasPassed()) {
    mStrVal.Construct(aOther.mStrVal.Value());
  }
  mType.Reset();
  if (aOther.mType.WasPassed()) {
    mType.Construct(aOther.mType.Value());
  }
  mValueIdx.Reset();
  if (aOther.mValueIdx.WasPassed()) {
    mValueIdx.Construct(aOther.mValueIdx.Value());
  }
  return *this;
}


MOZ_CAN_RUN_SCRIPT void
SessionStoreUtilsFrameCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const WindowProxyHolder& frame, uint32_t index, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 2;

  do {
    argv[1].setNumber(index);
    break;
  } while (false);

  do {
    if (!WrapObject(cx, frame, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



namespace SessionStoreUtils_Binding {

MOZ_CAN_RUN_SCRIPT static bool
forEachNonDynamicChildFrame(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.forEachNonDynamicChildFrame");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "forEachNonDynamicChildFrame", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.forEachNonDynamicChildFrame", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  mozilla::dom::WindowProxyHolder arg0;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapWindowProxyArg(cx, source, arg0))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
        return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastSessionStoreUtilsFrameCallback>> arg1(cx);
  if (args[1].isObject()) {
    if (JS::IsCallable(&args[1].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg1 = new binding_detail::FastSessionStoreUtilsFrameCallback(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::ForEachNonDynamicChildFrame(global, MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::ForEachNonDynamicChildFrame(global, MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SessionStoreUtils.forEachNonDynamicChildFrame"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
addDynamicFrameFilteredListener(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.addDynamicFrameFilteredListener");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "addDynamicFrameFilteredListener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.addDynamicFrameFilteredListener", 4)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::EventTarget> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::EventTarget, mozilla::dom::EventTarget>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "EventTarget");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> arg2(cx);
  arg2 = args[2];
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  bool arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsISupports>(mozilla::dom::SessionStoreUtils::AddDynamicFrameFilteredListener(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), arg2, arg3, arg4, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SessionStoreUtils.addDynamicFrameFilteredListener"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapObject(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
removeDynamicFrameFilteredListener(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.removeDynamicFrameFilteredListener");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "removeDynamicFrameFilteredListener", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.removeDynamicFrameFilteredListener", 4)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::EventTarget> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::EventTarget, mozilla::dom::EventTarget>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "EventTarget");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  nsISupports* arg2;
  RefPtr<nsISupports> arg2_holder;
  if (args[2].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[2].toObject());
    if (NS_FAILED(UnwrapArg<nsISupports>(cx, source, getter_AddRefs(arg2_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "nsISupports");
      return false;
    }
    MOZ_ASSERT(arg2_holder);
    arg2 = arg2_holder;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  bool arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::RemoveDynamicFrameFilteredListener(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), arg3, arg4, rv))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::RemoveDynamicFrameFilteredListener(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), arg3, arg4, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SessionStoreUtils.removeDynamicFrameFilteredListener"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
collectDocShellCapabilities(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.collectDocShellCapabilities");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "collectDocShellCapabilities", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.collectDocShellCapabilities", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  nsIDocShell* arg0;
  RefPtr<nsIDocShell> arg0_holder;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapArg<nsIDocShell>(cx, source, getter_AddRefs(arg0_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "nsIDocShell");
      return false;
    }
    MOZ_ASSERT(arg0_holder);
    arg0 = arg0_holder;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::CollectDocShellCapabilities(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::CollectDocShellCapabilities(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidByteStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
restoreDocShellCapabilities(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.restoreDocShellCapabilities");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "restoreDocShellCapabilities", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.restoreDocShellCapabilities", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  nsIDocShell* arg0;
  RefPtr<nsIDocShell> arg0_holder;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapArg<nsIDocShell>(cx, source, getter_AddRefs(arg0_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "nsIDocShell");
      return false;
    }
    MOZ_ASSERT(arg0_holder);
    arg0 = arg0_holder;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsCString arg1;
  if (!ConvertJSValueToByteString(cx, args[1], false, "argument 2", arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::RestoreDocShellCapabilities(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1)))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::RestoreDocShellCapabilities(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
collectScrollPosition(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.collectScrollPosition");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "collectScrollPosition", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.collectScrollPosition", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  mozilla::dom::WindowProxyHolder arg0;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapWindowProxyArg(cx, source, arg0))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
        return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
    return false;
  }
  NullableRootedDictionary<CollectedData> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::CollectScrollPosition(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::CollectScrollPosition(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
restoreScrollPosition(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.restoreScrollPosition");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "restoreScrollPosition", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.restoreScrollPosition", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<nsGlobalWindowInner> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Window");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  RootedDictionary<binding_detail::FastCollectedData> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::RestoreScrollPosition(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1)))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::RestoreScrollPosition(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
collectFormData(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.collectFormData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "collectFormData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.collectFormData", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  mozilla::dom::WindowProxyHolder arg0;
  if (args[0].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[0].toObject());
    if (NS_FAILED(UnwrapWindowProxyArg(cx, source, arg0))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
        return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WindowProxy");
    return false;
  }
  NullableRootedDictionary<CollectedData> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::CollectFormData(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::CollectFormData(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
restoreFormData(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.restoreFormData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "restoreFormData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.restoreFormData", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  RootedDictionary<binding_detail::FastCollectedData> arg1(cx);
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  bool result(mozilla::dom::SessionStoreUtils::RestoreFormData(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
constructSessionStoreRestoreData(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "constructSessionStoreRestoreData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  auto result(StrongOrRawPtr<nsISessionStoreRestoreData>(mozilla::dom::SessionStoreUtils::ConstructSessionStoreRestoreData(global)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!WrapObject(cx, result, &NS_GET_IID(nsISessionStoreRestoreData), args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
initializeRestore(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.initializeRestore");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "initializeRestore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.initializeRestore", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::CanonicalBrowsingContext> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CanonicalBrowsingContext, mozilla::dom::CanonicalBrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CanonicalBrowsingContext");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsISessionStoreRestoreData* arg1;
  RefPtr<nsISessionStoreRestoreData> arg1_holder;
  if (args[1].isObject()) {
    JS::Rooted<JSObject*> source(cx, &args[1].toObject());
    if (NS_FAILED(UnwrapArg<nsISessionStoreRestoreData>(cx, source, getter_AddRefs(arg1_holder)))) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "nsISessionStoreRestoreData");
      return false;
    }
    MOZ_ASSERT(arg1_holder);
    arg1 = arg1_holder;
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(mozilla::dom::SessionStoreUtils::InitializeRestore(global, MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SessionStoreUtils.initializeRestore"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}


static const JSJitInfo initializeRestore_methodinfo = {
  { (JSJitGetterOp)initializeRestore },
  { prototypes::id::_ID_Count }, { 0 }, JSJitInfo::StaticMethod,
  JSJitInfo::AliasEverything, JSVAL_TYPE_OBJECT, false, false,
  false, false, 0
};

MOZ_CAN_RUN_SCRIPT static bool
restoreDocShellState(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.restoreDocShellState");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "restoreDocShellState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.restoreDocShellState", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::CanonicalBrowsingContext> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CanonicalBrowsingContext, mozilla::dom::CanonicalBrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CanonicalBrowsingContext");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eNull, eNull, arg1)) {
    return false;
  }
  nsCString arg2;
  if (!ConvertJSValueToByteString(cx, args[2], true, "argument 3", arg2)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(mozilla::dom::SessionStoreUtils::RestoreDocShellState(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "SessionStoreUtils.restoreDocShellState"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}


static const JSJitInfo restoreDocShellState_methodinfo = {
  { (JSJitGetterOp)restoreDocShellState },
  { prototypes::id::_ID_Count }, { 0 }, JSJitInfo::StaticMethod,
  JSJitInfo::AliasEverything, JSVAL_TYPE_OBJECT, false, false,
  false, false, 0
};

MOZ_CAN_RUN_SCRIPT static bool
restoreSessionStorageFromParent(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "SessionStoreUtils.restoreSessionStorageFromParent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "SessionStoreUtils", "restoreSessionStorageFromParent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "SessionStoreUtils.restoreSessionStorageFromParent", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::CanonicalBrowsingContext> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CanonicalBrowsingContext, mozilla::dom::CanonicalBrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CanonicalBrowsingContext");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Record<nsCString, Record<nsString, nsString>> arg1;
  if (args[1].isObject()) {
    auto& recordEntries = arg1.Entries();

    JS::Rooted<JSObject*> recordObj(cx, &args[1].toObject());
    JS::RootedVector<jsid> ids(cx);
    if (!js::GetPropertyKeys(cx, recordObj,
                             JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
      return false;
    }
    if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    JS::Rooted<JS::Value> propNameValue(cx);
    JS::Rooted<JS::Value> temp(cx);
    JS::Rooted<jsid> curId(cx);
    JS::Rooted<JS::Value> idVal(cx);
    // Use a hashset to keep track of ids seen, to avoid
    // introducing nasty O(N^2) behavior scanning for them all the
    // time.  Ideally we'd use a data structure with O(1) lookup
    // _and_ ordering for the MozMap, but we don't have one lying
    // around.
    nsTHashtable<nsCStringHashKey> idsSeen;
    for (size_t i = 0; i < ids.length(); ++i) {
      curId = ids[i];

      JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
      if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                           &desc)) {
        return false;
      }

      if (desc.isNothing() || !desc->enumerable()) {
        continue;
      }

      idVal = js::IdToValue(curId);
      nsCString propName;
      // This will just throw if idVal is a Symbol, like the spec says
      // to do.
      if (!ConvertJSValueToString(cx, idVal, "key of argument 2", propName)) {
        return false;
      }

      if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
        return false;
      }

      Record<nsCString, Record<nsString, nsString>>::EntryType* entry;
      if (!idsSeen.EnsureInserted(propName)) {
        // Find the existing entry.
        auto idx = recordEntries.IndexOf(propName);
        MOZ_ASSERT(idx != recordEntries.NoIndex,
                   "Why is it not found?");
        // Now blow it away to make it look like it was just added
        // to the array, because it's not obvious that it's
        // safe to write to its already-initialized mValue via our
        // normal codegen conversions.  For example, the value
        // could be a union and this would change its type, but
        // codegen assumes we won't do that.
        entry = recordEntries.ReconstructElementAt(idx);
      } else {
        // Safe to do an infallible append here, because we did a
        // SetCapacity above to the right capacity.
        entry = recordEntries.AppendElement();
      }
      entry->mKey = propName;
      Record<nsString, nsString>& slot = entry->mValue;
      if (temp.isObject()) {
        auto& recordEntries = slot.Entries();

        JS::Rooted<JSObject*> recordObj(cx, &temp.toObject());
        JS::RootedVector<jsid> ids(cx);
        if (!js::GetPropertyKeys(cx, recordObj,
                                 JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
          return false;
        }
        if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        JS::Rooted<JS::Value> propNameValue(cx);
        JS::Rooted<JS::Value> temp(cx);
        JS::Rooted<jsid> curId(cx);
        JS::Rooted<JS::Value> idVal(cx);
        // Use a hashset to keep track of ids seen, to avoid
        // introducing nasty O(N^2) behavior scanning for them all the
        // time.  Ideally we'd use a data structure with O(1) lookup
        // _and_ ordering for the MozMap, but we don't have one lying
        // around.
        nsTHashtable<nsStringHashKey> idsSeen;
        for (size_t i = 0; i < ids.length(); ++i) {
          curId = ids[i];

          JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
          if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                               &desc)) {
            return false;
          }

          if (desc.isNothing() || !desc->enumerable()) {
            continue;
          }

          idVal = js::IdToValue(curId);
          nsString propName;
          // This will just throw if idVal is a Symbol, like the spec says
          // to do.
          if (!ConvertJSValueToString(cx, idVal, "key of value in argument 2", propName)) {
            return false;
          }

          if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
            return false;
          }

          Record<nsString, nsString>::EntryType* entry;
          if (!idsSeen.EnsureInserted(propName)) {
            // Find the existing entry.
            auto idx = recordEntries.IndexOf(propName);
            MOZ_ASSERT(idx != recordEntries.NoIndex,
                       "Why is it not found?");
            // Now blow it away to make it look like it was just added
            // to the array, because it's not obvious that it's
            // safe to write to its already-initialized mValue via our
            // normal codegen conversions.  For example, the value
            // could be a union and this would change its type, but
            // codegen assumes we won't do that.
            entry = recordEntries.ReconstructElementAt(idx);
          } else {
            // Safe to do an infallible append here, because we did a
            // SetCapacity above to the right capacity.
            entry = recordEntries.AppendElement();
          }
          entry->mKey = propName;
          nsString& slot = entry->mValue;
          if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Value in argument 2");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::SessionStoreUtils::RestoreSessionStorageFromParent(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1)))>, "Should be returning void here");
  mozilla::dom::SessionStoreUtils::RestoreSessionStorageFromParent(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("forEachNonDynamicChildFrame", forEachNonDynamicChildFrame, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addDynamicFrameFilteredListener", addDynamicFrameFilteredListener, nullptr, 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeDynamicFrameFilteredListener", removeDynamicFrameFilteredListener, nullptr, 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("collectDocShellCapabilities", collectDocShellCapabilities, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restoreDocShellCapabilities", restoreDocShellCapabilities, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("collectScrollPosition", collectScrollPosition, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restoreScrollPosition", restoreScrollPosition, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("collectFormData", collectFormData, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restoreFormData", restoreFormData, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("constructSessionStoreRestoreData", constructSessionStoreRestoreData, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("initializeRestore", StaticMethodPromiseWrapper, &initializeRestore_methodinfo, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restoreDocShellState", StaticMethodPromiseWrapper, &restoreDocShellState_methodinfo, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restoreSessionStorageFromParent", restoreSessionStorageFromParent, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(13 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[13];
static PropertyInfo sNativeProperties_propertyInfos[13];

static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  13,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(13 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::SessionStoreUtils,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "SessionStoreUtils",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::SessionStoreUtils);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             nullptr,
                             "SessionStoreUtils",
                             ShouldExpose<SessionStoreUtils_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal));
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::SessionStoreUtils,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace SessionStoreUtils_Binding



} // namespace mozilla::dom
