/* auto-generated, do not modify */
#include "config.h"

#include "fu-steelseries-sonic-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_steelseries_sonic_wireless_status_to_string(FuSteelseriesSonicWirelessStatus val)
{
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_OFF)
        return "off";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_IDLE)
        return "idle";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_SEARCH)
        return "search";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_LOCKED)
        return "locked";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_CONNECTED)
        return "connected";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_TERMINATED)
        return "terminated";
    return NULL;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_wireless_status_req_set_opcode: (skip):
 **/
static void
fu_struct_steelseries_sonic_wireless_status_req_set_opcode(FuStructSteelseriesSonicWirelessStatusReq *st, FuSteelseriesSonicOpcode8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_steelseries_sonic_wireless_status_req_new: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusReq *
fu_struct_steelseries_sonic_wireless_status_req_new(void)
{
    FuStructSteelseriesSonicWirelessStatusReq *st = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st, 1, 0x0);
    fu_struct_steelseries_sonic_wireless_status_req_set_opcode(st, FU_STEELSERIES_SONIC_OPCODE8_WIRELESS_STATUS);
    return st;
}
/* getters */
/**
 * fu_struct_steelseries_sonic_wireless_status_res_get_status: (skip):
 **/
FuSteelseriesSonicWirelessStatus
fu_struct_steelseries_sonic_wireless_status_res_get_status(const FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}

/* setters */
/**
 * fu_struct_steelseries_sonic_wireless_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_wireless_status_res_to_string(const FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicWirelessStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_steelseries_sonic_wireless_status_to_string(fu_struct_steelseries_sonic_wireless_status_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_steelseries_sonic_wireless_status_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_steelseries_sonic_wireless_status_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_wireless_status_res_validate_internal(FuStructSteelseriesSonicWirelessStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_wireless_status_res_parse_internal(FuStructSteelseriesSonicWirelessStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_wireless_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_wireless_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_wireless_status_res_parse: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusRes *
fu_struct_steelseries_sonic_wireless_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicWirelessStatusRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 1);
    if (!fu_struct_steelseries_sonic_wireless_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_battery_req_set_opcode: (skip):
 **/
static void
fu_struct_steelseries_sonic_battery_req_set_opcode(FuStructSteelseriesSonicBatteryReq *st, FuSteelseriesSonicOpcode8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_steelseries_sonic_battery_req_set_bat_mode: (skip):
 **/
static void
fu_struct_steelseries_sonic_battery_req_set_bat_mode(FuStructSteelseriesSonicBatteryReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_steelseries_sonic_battery_req_new: (skip):
 **/
FuStructSteelseriesSonicBatteryReq *
fu_struct_steelseries_sonic_battery_req_new(void)
{
    FuStructSteelseriesSonicBatteryReq *st = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st, 2, 0x0);
    fu_struct_steelseries_sonic_battery_req_set_opcode(st, FU_STEELSERIES_SONIC_OPCODE8_BATTERY);
    fu_struct_steelseries_sonic_battery_req_set_bat_mode(st, 0x01);
    return st;
}
/* getters */
/**
 * fu_struct_steelseries_sonic_battery_res_get_value: (skip):
 **/
guint16
fu_struct_steelseries_sonic_battery_res_get_value(const FuStructSteelseriesSonicBatteryRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_steelseries_sonic_battery_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_battery_res_to_string(const FuStructSteelseriesSonicBatteryRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicBatteryRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  value: 0x%x\n",
                           (guint) fu_struct_steelseries_sonic_battery_res_get_value(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_battery_res_validate_internal(FuStructSteelseriesSonicBatteryRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_battery_res_parse_internal(FuStructSteelseriesSonicBatteryRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_battery_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_battery_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_battery_res_parse: (skip):
 **/
FuStructSteelseriesSonicBatteryRes *
fu_struct_steelseries_sonic_battery_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicBatteryRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 2);
    if (!fu_struct_steelseries_sonic_battery_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_restart_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_restart_req_set_opcode(FuStructSteelseriesSonicRestartReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_restart_req_new: (skip):
 **/
FuStructSteelseriesSonicRestartReq *
fu_struct_steelseries_sonic_restart_req_new(void)
{
    FuStructSteelseriesSonicRestartReq *st = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st, 2, 0x0);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_erase_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_erase_req_set_opcode(FuStructSteelseriesSonicEraseReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_erase_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_erase_req_set_chipid(FuStructSteelseriesSonicEraseReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_erase_req_new: (skip):
 **/
FuStructSteelseriesSonicEraseReq *
fu_struct_steelseries_sonic_erase_req_new(void)
{
    FuStructSteelseriesSonicEraseReq *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_opcode(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_offset(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_size(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_new: (skip):
 **/
FuStructSteelseriesSonicReadFromRamReq *
fu_struct_steelseries_sonic_read_from_ram_req_new(void)
{
    FuStructSteelseriesSonicReadFromRamReq *st = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st, 6, 0x0);
    return st;
}
/* getters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_get_data: (skip):
 **/
const guint8 *
fu_struct_steelseries_sonic_read_from_ram_res_get_data(const FuStructSteelseriesSonicReadFromRamRes *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 48;
    return st->data + 0;
}

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_read_from_ram_res_to_string(const FuStructSteelseriesSonicReadFromRamRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicReadFromRamRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_steelseries_sonic_read_from_ram_res_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_read_from_ram_res_validate_internal(FuStructSteelseriesSonicReadFromRamRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_read_from_ram_res_parse_internal(FuStructSteelseriesSonicReadFromRamRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_read_from_ram_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_read_from_ram_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_read_from_ram_res_parse: (skip):
 **/
FuStructSteelseriesSonicReadFromRamRes *
fu_struct_steelseries_sonic_read_from_ram_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicReadFromRamRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 48);
    if (!fu_struct_steelseries_sonic_read_from_ram_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_opcode(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_chipid(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_offset(FuStructSteelseriesSonicReadFromFlashReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_size(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_new: (skip):
 **/
FuStructSteelseriesSonicReadFromFlashReq *
fu_struct_steelseries_sonic_read_from_flash_req_new(void)
{
    FuStructSteelseriesSonicReadFromFlashReq *st = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st, 10, 0x0);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_opcode(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_offset(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_size(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_data: (skip):
 **/
gboolean
fu_struct_steelseries_sonic_write_to_ram_req_set_data(FuStructSteelseriesSonicWriteToRamReq *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 6, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_new: (skip):
 **/
FuStructSteelseriesSonicWriteToRamReq *
fu_struct_steelseries_sonic_write_to_ram_req_new(void)
{
    FuStructSteelseriesSonicWriteToRamReq *st = g_byte_array_sized_new(54);
    fu_byte_array_set_size(st, 54, 0x0);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_opcode(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_chipid(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_offset(FuStructSteelseriesSonicWriteToFlashReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_size(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_new: (skip):
 **/
FuStructSteelseriesSonicWriteToFlashReq *
fu_struct_steelseries_sonic_write_to_flash_req_new(void)
{
    FuStructSteelseriesSonicWriteToFlashReq *st = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st, 10, 0x0);
    return st;
}
