/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-elf-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_elf_file_header_type_to_string(FuElfFileHeaderType val)
{
    if (val == FU_ELF_FILE_HEADER_TYPE_NONE)
        return "none";
    if (val == FU_ELF_FILE_HEADER_TYPE_REL)
        return "rel";
    if (val == FU_ELF_FILE_HEADER_TYPE_EXEC)
        return "exec";
    if (val == FU_ELF_FILE_HEADER_TYPE_DYN)
        return "dyn";
    if (val == FU_ELF_FILE_HEADER_TYPE_CORE)
        return "core";
    return NULL;
}

const gchar *
fu_elf_section_header_type_to_string(FuElfSectionHeaderType val)
{
    if (val == FU_ELF_SECTION_HEADER_TYPE_NULL)
        return "null";
    if (val == FU_ELF_SECTION_HEADER_TYPE_PROGBITS)
        return "progbits";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SYMTAB)
        return "symtab";
    if (val == FU_ELF_SECTION_HEADER_TYPE_STRTAB)
        return "strtab";
    if (val == FU_ELF_SECTION_HEADER_TYPE_RELA)
        return "rela";
    if (val == FU_ELF_SECTION_HEADER_TYPE_HASH)
        return "hash";
    if (val == FU_ELF_SECTION_HEADER_TYPE_DYNAMIC)
        return "dynamic";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NOTE)
        return "note";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NOBITS)
        return "nobits";
    if (val == FU_ELF_SECTION_HEADER_TYPE_REL)
        return "rel";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SHLIB)
        return "shlib";
    if (val == FU_ELF_SECTION_HEADER_TYPE_DYNSYM)
        return "dynsym";
    if (val == FU_ELF_SECTION_HEADER_TYPE_INIT_ARRAY)
        return "init-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_FINI_ARRAY)
        return "fini-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_PREINIT_ARRAY)
        return "preinit-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_GROUP)
        return "group";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SYMTAB_SHNDX)
        return "symtab-shndx";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NUM)
        return "num";
    return NULL;
}
/**
 * fu_struct_elf_file_header64le_ref: (skip):
 **/
FuStructElfFileHeader64le *
fu_struct_elf_file_header64le_ref(FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elf_file_header64le_unref: (skip):
 **/
void
fu_struct_elf_file_header64le_unref(FuStructElfFileHeader64le *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElfFileHeader64le refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructElfFileHeader64le *
fu_struct_elf_file_header64le_new_internal(void)
{
    FuStructElfFileHeader64le *st = g_new0(FuStructElfFileHeader64le, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elf_file_header64le_get_ei_magic: (skip):
 **/
static gchar *
fu_struct_elf_file_header64le_get_ei_magic(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_elf_file_header64le_get_ei_class: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_class(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_elf_file_header64le_get_ei_data: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_data(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_elf_file_header64le_get_ei_version: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_version(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_elf_file_header64le_get_ei_osabi: (skip):
 **/
guint8
fu_struct_elf_file_header64le_get_ei_osabi(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_elf_file_header64le_get_ei_abiversion: (skip):
 **/
guint8
fu_struct_elf_file_header64le_get_ei_abiversion(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_elf_file_header64le_get_type: (skip):
 **/
FuElfFileHeaderType
fu_struct_elf_file_header64le_get_type(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_machine: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_machine(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_version: (skip):
 **/
static guint32
fu_struct_elf_file_header64le_get_version(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_entry: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_entry(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phoff: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_phoff(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shoff: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_shoff(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_flags: (skip):
 **/
guint32
fu_struct_elf_file_header64le_get_flags(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_ehsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_ehsize(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 52, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phentsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_phentsize(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 54, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phnum: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_phnum(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 56, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shentsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shentsize(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 58, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shnum: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shnum(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 60, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shstrndx: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shstrndx(const FuStructElfFileHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 62, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_file_header64le_set_ei_magic: (skip):
 **/
static gboolean
fu_struct_elf_file_header64le_set_ei_magic(FuStructElfFileHeader64le *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructElfFileHeader64le.ei_magic (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_elf_file_header64le_set_ei_class: (skip):
 **/
static void
fu_struct_elf_file_header64le_set_ei_class(FuStructElfFileHeader64le *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_elf_file_header64le_set_ei_data: (skip):
 **/
static void
fu_struct_elf_file_header64le_set_ei_data(FuStructElfFileHeader64le *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_elf_file_header64le_set_ei_version: (skip):
 **/
static void
fu_struct_elf_file_header64le_set_ei_version(FuStructElfFileHeader64le *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_elf_file_header64le_set_ei_osabi: (skip):
 **/
void
fu_struct_elf_file_header64le_set_ei_osabi(FuStructElfFileHeader64le *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_elf_file_header64le_set_ei_abiversion: (skip):
 **/
void
fu_struct_elf_file_header64le_set_ei_abiversion(FuStructElfFileHeader64le *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_elf_file_header64le_set_type: (skip):
 **/
void
fu_struct_elf_file_header64le_set_type(FuStructElfFileHeader64le *st, FuElfFileHeaderType value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_machine: (skip):
 **/
void
fu_struct_elf_file_header64le_set_machine(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_version: (skip):
 **/
static void
fu_struct_elf_file_header64le_set_version(FuStructElfFileHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_entry: (skip):
 **/
void
fu_struct_elf_file_header64le_set_entry(FuStructElfFileHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_phoff: (skip):
 **/
void
fu_struct_elf_file_header64le_set_phoff(FuStructElfFileHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_shoff: (skip):
 **/
void
fu_struct_elf_file_header64le_set_shoff(FuStructElfFileHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_flags: (skip):
 **/
void
fu_struct_elf_file_header64le_set_flags(FuStructElfFileHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_ehsize: (skip):
 **/
void
fu_struct_elf_file_header64le_set_ehsize(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 52, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_phentsize: (skip):
 **/
void
fu_struct_elf_file_header64le_set_phentsize(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 54, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_phnum: (skip):
 **/
void
fu_struct_elf_file_header64le_set_phnum(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 56, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_shentsize: (skip):
 **/
void
fu_struct_elf_file_header64le_set_shentsize(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 58, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_shnum: (skip):
 **/
void
fu_struct_elf_file_header64le_set_shnum(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 60, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_set_shstrndx: (skip):
 **/
void
fu_struct_elf_file_header64le_set_shstrndx(FuStructElfFileHeader64le *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 62, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_new: (skip):
 **/
FuStructElfFileHeader64le *
fu_struct_elf_file_header64le_new(void)
{
    FuStructElfFileHeader64le *st = fu_struct_elf_file_header64le_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_elf_file_header64le_set_ei_magic(st, "\x7F\x45\x4C\x46", NULL);
    fu_struct_elf_file_header64le_set_ei_class(st, 0x2);
    fu_struct_elf_file_header64le_set_ei_data(st, 0x1);
    fu_struct_elf_file_header64le_set_ei_version(st, 0x1);
    fu_struct_elf_file_header64le_set_ei_osabi(st, 0x3);
    fu_struct_elf_file_header64le_set_version(st, 0x1);
    fu_struct_elf_file_header64le_set_phoff(st, 64);
    fu_struct_elf_file_header64le_set_ehsize(st, 64);
    return st;
}
/**
 * fu_struct_elf_file_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_file_header64le_to_string(const FuStructElfFileHeader64le *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElfFileHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ei_osabi: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ei_osabi(st));
    g_string_append_printf(str, "  ei_abiversion: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ei_abiversion(st));
    {
        const gchar *tmp = fu_elf_file_header_type_to_string(fu_struct_elf_file_header64le_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_elf_file_header64le_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_elf_file_header64le_get_type(st));
        }
    }
    g_string_append_printf(str, "  machine: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_machine(st));
    g_string_append_printf(str, "  entry: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_entry(st));
    g_string_append_printf(str, "  phoff: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phoff(st));
    g_string_append_printf(str, "  shoff: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shoff(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_flags(st));
    g_string_append_printf(str, "  ehsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ehsize(st));
    g_string_append_printf(str, "  phentsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phentsize(st));
    g_string_append_printf(str, "  phnum: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phnum(st));
    g_string_append_printf(str, "  shentsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shentsize(st));
    g_string_append_printf(str, "  shnum: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shnum(st));
    g_string_append_printf(str, "  shstrndx: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shstrndx(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elf_file_header64le_validate_internal(FuStructElfFileHeader64le *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "\x7F\x45\x4C\x46", 4) != 0) {
        g_autofree gchar *str = fu_struct_elf_file_header64le_get_ei_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructElfFileHeader64le.ei_magic was not valid, "
                    "expected '\x7F\x45\x4C\x46' and got '%s'",
                    str);
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_class(st) != 0x2) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructElfFileHeader64le.ei_class was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_data(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructElfFileHeader64le.ei_data was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_version(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructElfFileHeader64le.ei_version was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_version(st) != 0x1) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructElfFileHeader64le.version was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x1,
                    (guint) fu_struct_elf_file_header64le_get_version(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_elf_file_header64le_validate_stream: (skip):
 **/
gboolean
fu_struct_elf_file_header64le_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructElfFileHeader64le) st = fu_struct_elf_file_header64le_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 64, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructElfFileHeader64le failed read of 0x%x: ", (guint) 64);
        return FALSE;
    }
    if (st->buf->len != 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructElfFileHeader64le requested 0x%x and got 0x%x",
                    (guint) 64,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_elf_file_header64le_validate_internal(st, error);
}
static gboolean
fu_struct_elf_file_header64le_parse_internal(FuStructElfFileHeader64le *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elf_file_header64le_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elf_file_header64le_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_elf_file_header64le_parse_stream: (skip):
 **/
FuStructElfFileHeader64le *
fu_struct_elf_file_header64le_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructElfFileHeader64le) st = fu_struct_elf_file_header64le_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 64, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructElfFileHeader64le failed read of 0x%x: ", (guint) 64);
        return NULL;
    }
    if (st->buf->len != 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructElfFileHeader64le requested 0x%x and got 0x%x",
                    (guint) 64,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_elf_file_header64le_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elf_program_header64le_ref: (skip):
 **/
FuStructElfProgramHeader64le *
fu_struct_elf_program_header64le_ref(FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elf_program_header64le_unref: (skip):
 **/
void
fu_struct_elf_program_header64le_unref(FuStructElfProgramHeader64le *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElfProgramHeader64le refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructElfProgramHeader64le *
fu_struct_elf_program_header64le_new_internal(void)
{
    FuStructElfProgramHeader64le *st = g_new0(FuStructElfProgramHeader64le, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elf_program_header64le_get_flags: (skip):
 **/
guint32
fu_struct_elf_program_header64le_get_flags(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_offset: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_offset(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_vaddr: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_vaddr(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_paddr: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_paddr(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_filesz: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_filesz(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_memsz: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_memsz(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_flags2: (skip):
 **/
guint32
fu_struct_elf_program_header64le_get_flags2(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_align: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_align(const FuStructElfProgramHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 48, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_program_header64le_set_flags: (skip):
 **/
void
fu_struct_elf_program_header64le_set_flags(FuStructElfProgramHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_offset: (skip):
 **/
void
fu_struct_elf_program_header64le_set_offset(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_vaddr: (skip):
 **/
void
fu_struct_elf_program_header64le_set_vaddr(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_paddr: (skip):
 **/
void
fu_struct_elf_program_header64le_set_paddr(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_filesz: (skip):
 **/
void
fu_struct_elf_program_header64le_set_filesz(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_memsz: (skip):
 **/
void
fu_struct_elf_program_header64le_set_memsz(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_flags2: (skip):
 **/
void
fu_struct_elf_program_header64le_set_flags2(FuStructElfProgramHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_set_align: (skip):
 **/
void
fu_struct_elf_program_header64le_set_align(FuStructElfProgramHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_new: (skip):
 **/
FuStructElfProgramHeader64le *
fu_struct_elf_program_header64le_new(void)
{
    FuStructElfProgramHeader64le *st = fu_struct_elf_program_header64le_new_internal();
    st->buf = g_byte_array_sized_new(56);
    fu_byte_array_set_size(st->buf, 56, 0x0);
    return st;
}
/**
 * fu_struct_elf_program_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_program_header64le_to_string(const FuStructElfProgramHeader64le *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElfProgramHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_flags(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_offset(st));
    g_string_append_printf(str, "  vaddr: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_vaddr(st));
    g_string_append_printf(str, "  paddr: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_paddr(st));
    g_string_append_printf(str, "  filesz: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_filesz(st));
    g_string_append_printf(str, "  memsz: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_memsz(st));
    g_string_append_printf(str, "  flags2: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_flags2(st));
    g_string_append_printf(str, "  align: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_align(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elf_program_header64le_validate_internal(FuStructElfProgramHeader64le *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elf_program_header64le_parse_internal(FuStructElfProgramHeader64le *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elf_program_header64le_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elf_program_header64le_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_elf_program_header64le_parse_stream: (skip):
 **/
FuStructElfProgramHeader64le *
fu_struct_elf_program_header64le_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructElfProgramHeader64le) st = fu_struct_elf_program_header64le_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 56, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructElfProgramHeader64le failed read of 0x%x: ", (guint) 56);
        return NULL;
    }
    if (st->buf->len != 56) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructElfProgramHeader64le requested 0x%x and got 0x%x",
                    (guint) 56,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_elf_program_header64le_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elf_section_header64le_ref: (skip):
 **/
FuStructElfSectionHeader64le *
fu_struct_elf_section_header64le_ref(FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_elf_section_header64le_unref: (skip):
 **/
void
fu_struct_elf_section_header64le_unref(FuStructElfSectionHeader64le *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructElfSectionHeader64le refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructElfSectionHeader64le *
fu_struct_elf_section_header64le_new_internal(void)
{
    FuStructElfSectionHeader64le *st = g_new0(FuStructElfSectionHeader64le, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_elf_section_header64le_get_name: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_name(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_type: (skip):
 **/
FuElfSectionHeaderType
fu_struct_elf_section_header64le_get_type(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_flags: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_flags(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_addr: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_addr(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_offset: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_offset(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_size: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_size(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_link: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_link(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_info: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_info(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_addralign: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_addralign(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_entsize: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_entsize(const FuStructElfSectionHeader64le *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 56, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_section_header64le_set_name: (skip):
 **/
void
fu_struct_elf_section_header64le_set_name(FuStructElfSectionHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_type: (skip):
 **/
void
fu_struct_elf_section_header64le_set_type(FuStructElfSectionHeader64le *st, FuElfSectionHeaderType value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_flags: (skip):
 **/
void
fu_struct_elf_section_header64le_set_flags(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_addr: (skip):
 **/
void
fu_struct_elf_section_header64le_set_addr(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_offset: (skip):
 **/
void
fu_struct_elf_section_header64le_set_offset(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_size: (skip):
 **/
void
fu_struct_elf_section_header64le_set_size(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_link: (skip):
 **/
void
fu_struct_elf_section_header64le_set_link(FuStructElfSectionHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_info: (skip):
 **/
void
fu_struct_elf_section_header64le_set_info(FuStructElfSectionHeader64le *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_addralign: (skip):
 **/
void
fu_struct_elf_section_header64le_set_addralign(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_set_entsize: (skip):
 **/
void
fu_struct_elf_section_header64le_set_entsize(FuStructElfSectionHeader64le *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 56, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_new: (skip):
 **/
FuStructElfSectionHeader64le *
fu_struct_elf_section_header64le_new(void)
{
    FuStructElfSectionHeader64le *st = fu_struct_elf_section_header64le_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    return st;
}
/**
 * fu_struct_elf_section_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_section_header64le_to_string(const FuStructElfSectionHeader64le *st)
{
    g_autoptr(GString) str = g_string_new("FuStructElfSectionHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  name: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_name(st));
    {
        const gchar *tmp = fu_elf_section_header_type_to_string(fu_struct_elf_section_header64le_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_elf_section_header64le_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_elf_section_header64le_get_type(st));
        }
    }
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_flags(st));
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_addr(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_offset(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_size(st));
    g_string_append_printf(str, "  link: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_link(st));
    g_string_append_printf(str, "  info: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_info(st));
    g_string_append_printf(str, "  addralign: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_addralign(st));
    g_string_append_printf(str, "  entsize: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_entsize(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_elf_section_header64le_validate_internal(FuStructElfSectionHeader64le *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_elf_section_header64le_parse_internal(FuStructElfSectionHeader64le *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_elf_section_header64le_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_elf_section_header64le_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_elf_section_header64le_parse_stream: (skip):
 **/
FuStructElfSectionHeader64le *
fu_struct_elf_section_header64le_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructElfSectionHeader64le) st = fu_struct_elf_section_header64le_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 64, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructElfSectionHeader64le failed read of 0x%x: ", (guint) 64);
        return NULL;
    }
    if (st->buf->len != 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructElfSectionHeader64le requested 0x%x and got 0x%x",
                    (guint) 64,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_elf_section_header64le_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
