/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaptics-cape-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_synaptics_cape_error_to_string(FuSynapticsCapeError val)
{
    if (val == FU_SYNAPTICS_CAPE_ERROR_EAGAIN)
        return "eagain";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_FAIL)
        return "sfu-fail";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_WRITE_FAIL)
        return "sfu-write-fail";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_READ_FAIL)
        return "sfu-read-fail";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_CRC_ERROR)
        return "sfu-crc-error";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_USB_ID_NOT_MATCH)
        return "sfu-usb-id-not-match";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_VERSION_DOWNGRADE)
        return "sfu-version-downgrade";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_HEADER_CORRUPTION)
        return "sfu-header-corruption";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_IMAGE_CORRUPTION)
        return "sfu-image-corruption";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_ALREADY_ACTIVE)
        return "sfu-already-active";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_NOT_READY)
        return "sfu-not-ready";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_SIGN_TRANSFER_CORRUPTION)
        return "sfu-sign-transfer-corruption";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_SIGNATURE_VERIFICATION)
        return "sfu-signature-verification";
    if (val == FU_SYNAPTICS_CAPE_ERROR_SFU_TASK_NOT_RUNNING)
        return "sfu-task-not-running";
    if (val == FU_SYNAPTICS_CAPE_ERROR_GENERIC_FAILURE)
        return "generic-failure";
    if (val == FU_SYNAPTICS_CAPE_ERROR_ALREADY_EXISTS)
        return "already-exists";
    if (val == FU_SYNAPTICS_CAPE_ERROR_NULL_APP_POINTER)
        return "null-app-pointer";
    if (val == FU_SYNAPTICS_CAPE_ERROR_NULL_MODULE_POINTER)
        return "null-module-pointer";
    if (val == FU_SYNAPTICS_CAPE_ERROR_NULL_STREAM_POINTER)
        return "null-stream-pointer";
    if (val == FU_SYNAPTICS_CAPE_ERROR_NULL_POINTER)
        return "null-pointer";
    if (val == FU_SYNAPTICS_CAPE_ERROR_BAD_APP_ID)
        return "bad-app-id";
    if (val == FU_SYNAPTICS_CAPE_ERROR_MODULE_TYPE_HAS_NO_API)
        return "module-type-has-no-api";
    if (val == FU_SYNAPTICS_CAPE_ERROR_BAD_MAGIC_NUMBER)
        return "bad-magic-number";
    if (val == FU_SYNAPTICS_CAPE_ERROR_CMD_MODE_UNSUPPORTED)
        return "cmd-mode-unsupported";
    return NULL;
}



/**
 * fu_synaptics_cape_msg_ref: (skip):
 **/
FuSynapticsCapeMsg *
fu_synaptics_cape_msg_ref(FuSynapticsCapeMsg *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_synaptics_cape_msg_unref: (skip):
 **/
void
fu_synaptics_cape_msg_unref(FuSynapticsCapeMsg *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuSynapticsCapeMsg refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuSynapticsCapeMsg *
fu_synaptics_cape_msg_new_internal(void)
{
    FuSynapticsCapeMsg *st = g_new0(FuSynapticsCapeMsg, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_synaptics_cape_msg_get_data_len: (skip):
 **/
guint16
fu_synaptics_cape_msg_get_data_len(const FuSynapticsCapeMsg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_get_cmd_id: (skip):
 **/
FuSynapticsCapeCmd
fu_synaptics_cape_msg_get_cmd_id(const FuSynapticsCapeMsg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_get_module_id: (skip):
 **/
FuSynapticsCapeModuleId
fu_synaptics_cape_msg_get_module_id(const FuSynapticsCapeMsg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_get_data: (skip):
 **/
guint32
fu_synaptics_cape_msg_get_data(const FuSynapticsCapeMsg *st, guint idx)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8 + (sizeof(guint32) * idx),
                                        G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_synaptics_cape_msg_set_data_len: (skip):
 **/
void
fu_synaptics_cape_msg_set_data_len(FuSynapticsCapeMsg *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_set_cmd_id: (skip):
 **/
void
fu_synaptics_cape_msg_set_cmd_id(FuSynapticsCapeMsg *st, FuSynapticsCapeCmd value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_set_module_id: (skip):
 **/
void
fu_synaptics_cape_msg_set_module_id(FuSynapticsCapeMsg *st, FuSynapticsCapeModuleId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_set_data: (skip):
 **/
void
fu_synaptics_cape_msg_set_data(FuSynapticsCapeMsg *st, guint idx, guint32 value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(idx < 13);
    fu_memwrite_uint32(st->buf->data + 8 + (sizeof(guint32) * idx),
                                  value,
                                  G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_msg_new: (skip):
 **/
FuSynapticsCapeMsg *
fu_synaptics_cape_msg_new(void)
{
    FuSynapticsCapeMsg *st = fu_synaptics_cape_msg_new_internal();
    st->buf = g_byte_array_sized_new(60);
    fu_byte_array_set_size(st->buf, 60, 0x0);
    fu_synaptics_cape_msg_set_module_id(st, FU_SYNAPTICS_CAPE_MODULE_ID_APP_CTRL);
    return st;
}
/**
 * fu_synaptics_cape_cmd_hid_report_ref: (skip):
 **/
FuSynapticsCapeCmdHidReport *
fu_synaptics_cape_cmd_hid_report_ref(FuSynapticsCapeCmdHidReport *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_synaptics_cape_cmd_hid_report_unref: (skip):
 **/
void
fu_synaptics_cape_cmd_hid_report_unref(FuSynapticsCapeCmdHidReport *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuSynapticsCapeCmdHidReport refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuSynapticsCapeCmdHidReport *
fu_synaptics_cape_cmd_hid_report_new_internal(void)
{
    FuSynapticsCapeCmdHidReport *st = g_new0(FuSynapticsCapeCmdHidReport, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_synaptics_cape_cmd_hid_report_get_msg: (skip):
 **/
FuSynapticsCapeMsg *
fu_synaptics_cape_cmd_hid_report_get_msg(const FuSynapticsCapeCmdHidReport *st)
{
    g_autoptr(FuSynapticsCapeMsg) st_tmp = fu_synaptics_cape_msg_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_SYNAPTICS_CAPE_CMD_HID_REPORT_OFFSET_MSG, 60);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_synaptics_cape_cmd_hid_report_set_report_id: (skip):
 **/
static void
fu_synaptics_cape_cmd_hid_report_set_report_id(FuSynapticsCapeCmdHidReport *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_synaptics_cape_cmd_hid_report_set_msg: (skip):
 **/
gboolean
fu_synaptics_cape_cmd_hid_report_set_msg(FuSynapticsCapeCmdHidReport *st, const FuSynapticsCapeMsg *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_SYNAPTICS_CAPE_MSG_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuSynapticsCapeMsg' (0x%x bytes) does not fit in "
                    "FuSynapticsCapeCmdHidReport.msg (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_SYNAPTICS_CAPE_MSG_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_SYNAPTICS_CAPE_CMD_HID_REPORT_OFFSET_MSG, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_synaptics_cape_cmd_hid_report_new: (skip):
 **/
FuSynapticsCapeCmdHidReport *
fu_synaptics_cape_cmd_hid_report_new(void)
{
    FuSynapticsCapeCmdHidReport *st = fu_synaptics_cape_cmd_hid_report_new_internal();
    st->buf = g_byte_array_sized_new(62);
    fu_byte_array_set_size(st->buf, 62, 0x0);
    {
        g_autoptr(FuSynapticsCapeMsg) st_donor = fu_synaptics_cape_msg_new();
        memcpy(st->buf->data + 0x2, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_synaptics_cape_cmd_hid_report_set_report_id(st, 1);
    return st;
}
/**
 * fu_struct_synaptics_cape_hid_hdr_ref: (skip):
 **/
FuStructSynapticsCapeHidHdr *
fu_struct_synaptics_cape_hid_hdr_ref(FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cape_hid_hdr_unref: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_unref(FuStructSynapticsCapeHidHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCapeHidHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCapeHidHdr *
fu_struct_synaptics_cape_hid_hdr_new_internal(void)
{
    FuStructSynapticsCapeHidHdr *st = g_new0(FuStructSynapticsCapeHidHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cape_hid_hdr_get_vid: (skip):
 **/
guint32
fu_struct_synaptics_cape_hid_hdr_get_vid(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_pid: (skip):
 **/
guint32
fu_struct_synaptics_cape_hid_hdr_get_pid(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_update_type: (skip):
 **/
guint32
fu_struct_synaptics_cape_hid_hdr_get_update_type(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_signature: (skip):
 **/
static guint32
fu_struct_synaptics_cape_hid_hdr_get_signature(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_crc: (skip):
 **/
guint32
fu_struct_synaptics_cape_hid_hdr_get_crc(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_ver_w: (skip):
 **/
guint16
fu_struct_synaptics_cape_hid_hdr_get_ver_w(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_ver_x: (skip):
 **/
guint16
fu_struct_synaptics_cape_hid_hdr_get_ver_x(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_ver_y: (skip):
 **/
guint16
fu_struct_synaptics_cape_hid_hdr_get_ver_y(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_get_ver_z: (skip):
 **/
guint16
fu_struct_synaptics_cape_hid_hdr_get_ver_z(const FuStructSynapticsCapeHidHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_cape_hid_hdr_set_vid: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_vid(FuStructSynapticsCapeHidHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_pid: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_pid(FuStructSynapticsCapeHidHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_update_type: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_update_type(FuStructSynapticsCapeHidHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_signature: (skip):
 **/
static void
fu_struct_synaptics_cape_hid_hdr_set_signature(FuStructSynapticsCapeHidHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_crc: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_crc(FuStructSynapticsCapeHidHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_ver_w: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_ver_w(FuStructSynapticsCapeHidHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_ver_x: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_ver_x(FuStructSynapticsCapeHidHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_ver_y: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_ver_y(FuStructSynapticsCapeHidHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_set_ver_z: (skip):
 **/
void
fu_struct_synaptics_cape_hid_hdr_set_ver_z(FuStructSynapticsCapeHidHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_hid_hdr_new: (skip):
 **/
FuStructSynapticsCapeHidHdr *
fu_struct_synaptics_cape_hid_hdr_new(void)
{
    FuStructSynapticsCapeHidHdr *st = fu_struct_synaptics_cape_hid_hdr_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_synaptics_cape_hid_hdr_set_signature(st, 0x43534645);
    return st;
}
/**
 * fu_struct_synaptics_cape_hid_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cape_hid_hdr_to_string(const FuStructSynapticsCapeHidHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCapeHidHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_pid(st));
    g_string_append_printf(str, "  update_type: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_update_type(st));
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_crc(st));
    g_string_append_printf(str, "  ver_w: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_ver_w(st));
    g_string_append_printf(str, "  ver_x: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_ver_x(st));
    g_string_append_printf(str, "  ver_y: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_ver_y(st));
    g_string_append_printf(str, "  ver_z: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_hid_hdr_get_ver_z(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cape_hid_hdr_validate_internal(FuStructSynapticsCapeHidHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_synaptics_cape_hid_hdr_get_signature(st) != 0x43534645) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructSynapticsCapeHidHdr.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x43534645,
                    (guint) fu_struct_synaptics_cape_hid_hdr_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_synaptics_cape_hid_hdr_parse_internal(FuStructSynapticsCapeHidHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cape_hid_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cape_hid_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaptics_cape_hid_hdr_parse_stream: (skip):
 **/
FuStructSynapticsCapeHidHdr *
fu_struct_synaptics_cape_hid_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCapeHidHdr) st = fu_struct_synaptics_cape_hid_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapticsCapeHidHdr failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapticsCapeHidHdr requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaptics_cape_hid_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_ref: (skip):
 **/
FuStructSynapticsCapeSnglHdr *
fu_struct_synaptics_cape_sngl_hdr_ref(FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_unref: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_unref(FuStructSynapticsCapeSnglHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCapeSnglHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCapeSnglHdr *
fu_struct_synaptics_cape_sngl_hdr_new_internal(void)
{
    FuStructSynapticsCapeSnglHdr *st = g_new0(FuStructSynapticsCapeSnglHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_magic: (skip):
 **/
static guint32
fu_struct_synaptics_cape_sngl_hdr_get_magic(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_file_crc: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_file_crc(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_file_size: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_file_size(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_magic2: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_magic2(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_img_type: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_img_type(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_fw_version: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_fw_version(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_vid: (skip):
 **/
guint16
fu_struct_synaptics_cape_sngl_hdr_get_vid(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_pid: (skip):
 **/
guint16
fu_struct_synaptics_cape_sngl_hdr_get_pid(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_fw_file_num: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_fw_file_num(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_version: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_version(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_fw_crc: (skip):
 **/
guint32
fu_struct_synaptics_cape_sngl_hdr_get_fw_crc(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_machine_name: (skip):
 **/
gchar *
fu_struct_synaptics_cape_sngl_hdr_get_machine_name(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 48, 16, NULL);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_get_time_stamp: (skip):
 **/
gchar *
fu_struct_synaptics_cape_sngl_hdr_get_time_stamp(const FuStructSynapticsCapeSnglHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 64, 16, NULL);
}

/* setters */
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_magic: (skip):
 **/
static void
fu_struct_synaptics_cape_sngl_hdr_set_magic(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_file_crc: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_file_crc(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_file_size: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_file_size(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_magic2: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_magic2(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_img_type: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_img_type(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_fw_version: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_fw_version(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_vid: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_vid(FuStructSynapticsCapeSnglHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_pid: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_pid(FuStructSynapticsCapeSnglHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_fw_file_num: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_fw_file_num(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_version: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_version(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_fw_crc: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_hdr_set_fw_crc(FuStructSynapticsCapeSnglHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_machine_name: (skip):
 **/
gboolean
fu_struct_synaptics_cape_sngl_hdr_set_machine_name(FuStructSynapticsCapeSnglHdr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 48, 0x0, 16);
        return TRUE;
    }
    len = strlen(value);
    if (len > 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructSynapticsCapeSnglHdr.machine_name (0x%x bytes)",
                    value, (guint) len, (guint) 16);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 48, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_set_time_stamp: (skip):
 **/
gboolean
fu_struct_synaptics_cape_sngl_hdr_set_time_stamp(FuStructSynapticsCapeSnglHdr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 64, 0x0, 16);
        return TRUE;
    }
    len = strlen(value);
    if (len > 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructSynapticsCapeSnglHdr.time_stamp (0x%x bytes)",
                    value, (guint) len, (guint) 16);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 64, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_new: (skip):
 **/
FuStructSynapticsCapeSnglHdr *
fu_struct_synaptics_cape_sngl_hdr_new(void)
{
    FuStructSynapticsCapeSnglHdr *st = fu_struct_synaptics_cape_sngl_hdr_new_internal();
    st->buf = g_byte_array_sized_new(80);
    fu_byte_array_set_size(st->buf, 80, 0x0);
    fu_struct_synaptics_cape_sngl_hdr_set_magic(st, 0x4C474E53);
    return st;
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cape_sngl_hdr_to_string(const FuStructSynapticsCapeSnglHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCapeSnglHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  file_crc: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_file_crc(st));
    g_string_append_printf(str, "  file_size: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_file_size(st));
    g_string_append_printf(str, "  magic2: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_magic2(st));
    g_string_append_printf(str, "  img_type: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_img_type(st));
    g_string_append_printf(str, "  fw_version: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_fw_version(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_pid(st));
    g_string_append_printf(str, "  fw_file_num: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_fw_file_num(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_version(st));
    g_string_append_printf(str, "  fw_crc: 0x%x\n",
                           (guint) fu_struct_synaptics_cape_sngl_hdr_get_fw_crc(st));
    {
        g_autofree gchar *tmp = fu_struct_synaptics_cape_sngl_hdr_get_machine_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  machine_name: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_synaptics_cape_sngl_hdr_get_time_stamp(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  time_stamp: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cape_sngl_hdr_validate_internal(FuStructSynapticsCapeSnglHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_synaptics_cape_sngl_hdr_get_magic(st) != 0x4C474E53) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructSynapticsCapeSnglHdr.magic was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x4C474E53,
                    (guint) fu_struct_synaptics_cape_sngl_hdr_get_magic(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_synaptics_cape_sngl_hdr_parse_internal(FuStructSynapticsCapeSnglHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cape_sngl_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cape_sngl_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaptics_cape_sngl_hdr_parse_stream: (skip):
 **/
FuStructSynapticsCapeSnglHdr *
fu_struct_synaptics_cape_sngl_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCapeSnglHdr) st = fu_struct_synaptics_cape_sngl_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 80, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapticsCapeSnglHdr failed read of 0x%x: ", (guint) 80);
        return NULL;
    }
    if (st->buf->len != 80) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapticsCapeSnglHdr requested 0x%x and got 0x%x",
                    (guint) 80,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaptics_cape_sngl_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_cape_sngl_file_ref: (skip):
 **/
FuStructSynapticsCapeSnglFile *
fu_struct_synaptics_cape_sngl_file_ref(FuStructSynapticsCapeSnglFile *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cape_sngl_file_unref: (skip):
 **/
void
fu_struct_synaptics_cape_sngl_file_unref(FuStructSynapticsCapeSnglFile *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCapeSnglFile refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
