/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-engine-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

FuReleasePriority
fu_release_priority_from_string(const gchar *val)
{
    if (g_strcmp0(val, "none") == 0)
        return FU_RELEASE_PRIORITY_NONE;
    if (g_strcmp0(val, "local") == 0)
        return FU_RELEASE_PRIORITY_LOCAL;
    if (g_strcmp0(val, "remote") == 0)
        return FU_RELEASE_PRIORITY_REMOTE;
    return FU_RELEASE_PRIORITY_NONE;
}

FuP2pPolicy
fu_p2p_policy_from_string(const gchar *val)
{
    if (g_strcmp0(val, "nothing") == 0)
        return FU_P2P_POLICY_NOTHING;
    if (g_strcmp0(val, "metadata") == 0)
        return FU_P2P_POLICY_METADATA;
    if (g_strcmp0(val, "firmware") == 0)
        return FU_P2P_POLICY_FIRMWARE;
    return FU_P2P_POLICY_NOTHING;
}

const gchar *
fu_engine_emulator_phase_to_string(FuEngineEmulatorPhase val)
{
    if (val == FU_ENGINE_EMULATOR_PHASE_SETUP)
        return "setup";
    if (val == FU_ENGINE_EMULATOR_PHASE_INSTALL)
        return "install";
    if (val == FU_ENGINE_EMULATOR_PHASE_ATTACH)
        return "attach";
    if (val == FU_ENGINE_EMULATOR_PHASE_DETACH)
        return "detach";
    if (val == FU_ENGINE_EMULATOR_PHASE_PREPARE)
        return "prepare";
    if (val == FU_ENGINE_EMULATOR_PHASE_CLEANUP)
        return "cleanup";
    if (val == FU_ENGINE_EMULATOR_PHASE_RELOAD)
        return "reload";
    if (val == FU_ENGINE_EMULATOR_PHASE_COMPOSITE_PREPARE)
        return "composite-prepare";
    if (val == FU_ENGINE_EMULATOR_PHASE_COMPOSITE_CLEANUP)
        return "composite-cleanup";
    return NULL;
}

gchar *
fu_engine_request_flags_to_string(FuEngineRequestFlags val)
{
    const gchar *data[3] = {0};
    guint idx = 0;
    if (val == FU_ENGINE_REQUEST_FLAG_NONE)
        return g_strdup("none");
    if (val & FU_ENGINE_REQUEST_FLAG_NO_REQUIREMENTS)
        data[idx++] = "no-requirements";
    if (val & FU_ENGINE_REQUEST_FLAG_ANY_RELEASE)
        data[idx++] = "any-release";
    return g_strjoinv(",", (gchar **)data);
}


gchar *
fu_idle_inhibit_to_string(FuIdleInhibit val)
{
    const gchar *data[3] = {0};
    guint idx = 0;
    if (val == FU_IDLE_INHIBIT_NONE)
        return g_strdup("none");
    if (val & FU_IDLE_INHIBIT_TIMEOUT)
        data[idx++] = "timeout";
    if (val & FU_IDLE_INHIBIT_SIGNALS)
        data[idx++] = "signals";
    return g_strjoinv(",", (gchar **)data);
}


FuEngineCapabilityFlags
fu_engine_capability_flags_from_string(const gchar *val)
{
    FuEngineCapabilityFlags value = 0;
    g_auto(GStrv) split = NULL;
    g_return_val_if_fail(val != NULL, 0);
    split = g_strsplit(val, ",", -1);
    for (guint i = 0; split[i] != NULL; i++) {
        if (g_strcmp0(split[i], "unknown") == 0) {
            value |= FU_ENGINE_CAPABILITY_FLAG_UNKNOWN;
            continue;
        }
        if (g_strcmp0(split[i], "id-requirement-glob") == 0) {
            value |= FU_ENGINE_CAPABILITY_FLAG_ID_REQUIREMENT_GLOB;
            continue;
        }
    }
    return value;
}


FuUdevAction
fu_udev_action_from_string(const gchar *val)
{
    if (g_strcmp0(val, "unknown") == 0)
        return FU_UDEV_ACTION_UNKNOWN;
    if (g_strcmp0(val, "add") == 0)
        return FU_UDEV_ACTION_ADD;
    if (g_strcmp0(val, "remove") == 0)
        return FU_UDEV_ACTION_REMOVE;
    if (g_strcmp0(val, "change") == 0)
        return FU_UDEV_ACTION_CHANGE;
    if (g_strcmp0(val, "move") == 0)
        return FU_UDEV_ACTION_MOVE;
    if (g_strcmp0(val, "online") == 0)
        return FU_UDEV_ACTION_ONLINE;
    if (g_strcmp0(val, "offline") == 0)
        return FU_UDEV_ACTION_OFFLINE;
    if (g_strcmp0(val, "bind") == 0)
        return FU_UDEV_ACTION_BIND;
    if (g_strcmp0(val, "unbind") == 0)
        return FU_UDEV_ACTION_UNBIND;
    return FU_UDEV_ACTION_UNKNOWN;
}
/**
 * fu_struct_udev_monitor_netlink_header_ref: (skip):
 **/
FuStructUdevMonitorNetlinkHeader *
fu_struct_udev_monitor_netlink_header_ref(FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_udev_monitor_netlink_header_unref: (skip):
 **/
void
fu_struct_udev_monitor_netlink_header_unref(FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUdevMonitorNetlinkHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructUdevMonitorNetlinkHeader *
fu_struct_udev_monitor_netlink_header_new_internal(void)
{
    FuStructUdevMonitorNetlinkHeader *st = g_new0(FuStructUdevMonitorNetlinkHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_udev_monitor_netlink_header_get_prefix: (skip):
 **/
static gchar *
fu_struct_udev_monitor_netlink_header_get_prefix(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 8, NULL);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_magic: (skip):
 **/
static guint32
fu_struct_udev_monitor_netlink_header_get_magic(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_header_size: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_header_size(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_properties_off: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_properties_off(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_properties_len: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_properties_len(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_filter_subsystem_hash: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_filter_subsystem_hash(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_filter_devtype_hash: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_filter_devtype_hash(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_hi: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_hi(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_lo: (skip):
 **/
guint32
fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_lo(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_udev_monitor_netlink_header_to_string: (skip):
 **/
static gchar *
fu_struct_udev_monitor_netlink_header_to_string(const FuStructUdevMonitorNetlinkHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUdevMonitorNetlinkHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  header_size: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_header_size(st));
    g_string_append_printf(str, "  properties_off: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_properties_off(st));
    g_string_append_printf(str, "  properties_len: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_properties_len(st));
    g_string_append_printf(str, "  filter_subsystem_hash: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_filter_subsystem_hash(st));
    g_string_append_printf(str, "  filter_devtype_hash: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_filter_devtype_hash(st));
    g_string_append_printf(str, "  filter_tag_bloom_hi: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_hi(st));
    g_string_append_printf(str, "  filter_tag_bloom_lo: 0x%x\n",
                           (guint) fu_struct_udev_monitor_netlink_header_get_filter_tag_bloom_lo(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_udev_monitor_netlink_header_validate_internal(FuStructUdevMonitorNetlinkHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "libudev", 8) != 0) {
        g_autofree gchar *str = fu_struct_udev_monitor_netlink_header_get_prefix(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUdevMonitorNetlinkHeader.prefix was not valid, "
                    "expected 'libudev' and got '%s'",
                    str);
        return FALSE;
    }
    if (fu_struct_udev_monitor_netlink_header_get_magic(st) != 0xFEEDCAFE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructUdevMonitorNetlinkHeader.magic was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0xFEEDCAFE,
                    (guint) fu_struct_udev_monitor_netlink_header_get_magic(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_udev_monitor_netlink_header_parse_internal(FuStructUdevMonitorNetlinkHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_udev_monitor_netlink_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_udev_monitor_netlink_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_udev_monitor_netlink_header_parse: (skip):
 **/
static FuStructUdevMonitorNetlinkHeader *
fu_struct_udev_monitor_netlink_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructUdevMonitorNetlinkHeader) st = fu_struct_udev_monitor_netlink_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 40, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructUdevMonitorNetlinkHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 40);
    if (!fu_struct_udev_monitor_netlink_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_udev_monitor_netlink_header_parse_bytes: (skip):
 **/
FuStructUdevMonitorNetlinkHeader *
fu_struct_udev_monitor_netlink_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_udev_monitor_netlink_header_parse(buf, bufsz, offset, error);
}
