/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define MINE_WINDOW_KEY_THEME "theme"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MINE_WINDOW (mine_window_get_type ())
#define MINE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINE_WINDOW, MineWindow))
#define MINE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINE_WINDOW, MineWindowClass))
#define IS_MINE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINE_WINDOW))
#define IS_MINE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINE_WINDOW))
#define MINE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINE_WINDOW, MineWindowClass))

typedef struct _MineWindow MineWindow;
typedef struct _MineWindowClass MineWindowClass;
typedef struct _MineWindowPrivate MineWindowPrivate;
enum  {
	MINE_WINDOW_0_PROPERTY,
	MINE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* mine_window_properties[MINE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MineWindow {
	AdwApplicationWindow parent_instance;
	MineWindowPrivate * priv;
};

struct _MineWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _MineWindowPrivate {
	GSettings* settings;
	GtkCssProvider* theme_provider;
};

static gint MineWindow_private_offset;
static gpointer mine_window_parent_class = NULL;

VALA_EXTERN GType mine_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MineWindow, g_object_unref)
static gboolean mine_window_real_close_request (GtkWindow* base);
static void mine_window_save_window_state (MineWindow* self);
static void mine_window_load_window_state (MineWindow* self);
static void mine_window_set_game_theme (MineWindow* self,
                                 const gchar* theme);
VALA_EXTERN MineWindow* mine_window_new (void);
VALA_EXTERN MineWindow* mine_window_construct (GType object_type);
static GObject * mine_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _mine_window___lambda4_ (MineWindow* self);
static void __mine_window___lambda4__g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self);
static void mine_window_finalize (GObject * obj);
static GType mine_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mine_window_get_instance_private (MineWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MineWindow_private_offset);
}

static gboolean
mine_window_real_close_request (GtkWindow* base)
{
	MineWindow * self;
	gboolean result;
	self = (MineWindow*) base;
	mine_window_save_window_state (self);
	result = GTK_WINDOW_CLASS (mine_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
mine_window_load_window_state (MineWindow* self)
{
	gboolean window_maximized = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	window_maximized = g_settings_get_boolean (_tmp0_, "window-is-maximized");
	if (window_maximized) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gint width = 0;
		GSettings* _tmp1_;
		gint height = 0;
		GSettings* _tmp2_;
		_tmp1_ = self->priv->settings;
		width = g_settings_get_int (_tmp1_, "window-width");
		_tmp2_ = self->priv->settings;
		height = g_settings_get_int (_tmp2_, "window-height");
		gtk_window_set_default_size ((GtkWindow*) self, width, height);
	}
}

static void
mine_window_save_window_state (MineWindow* self)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	g_debug ("window.vala:58: Saving window geometry: %i × %i", width, height);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-width", width);
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "window-height", height);
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", gtk_window_is_maximized ((GtkWindow*) self));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mine_window_set_game_theme (MineWindow* self,
                            const gchar* theme)
{
	gchar* theme_path = NULL;
	gchar* _tmp0_;
	gboolean is_switch = FALSE;
	GtkCssProvider* _tmp1_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	const gchar* _tmp4_;
	gchar* theme_css_path = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GtkCssProvider* _tmp25_;
	GtkCssProvider* _tmp26_;
	const gchar* _tmp27_;
	GdkDisplay* _tmp28_;
	GtkCssProvider* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = g_strdup (theme);
	theme_path = _tmp0_;
	_tmp1_ = self->priv->theme_provider;
	is_switch = _tmp1_ != NULL;
	_tmp2_ = gtk_root_get_display ((GtkRoot*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	display = _tmp3_;
	_tmp4_ = theme_path;
	if (!g_path_is_absolute (_tmp4_)) {
		gchar* _tmp5_;
		_tmp5_ = g_build_path (G_DIR_SEPARATOR_S, DATA_DIRECTORY, "themes", theme, NULL);
		_g_free0 (theme_path);
		theme_path = _tmp5_;
	}
	if (!is_switch) {
		GdkDisplay* _tmp6_;
		GtkIconTheme* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = display;
		_tmp7_ = gtk_icon_theme_get_for_display (_tmp6_);
		_tmp8_ = theme_path;
		gtk_icon_theme_add_search_path (_tmp7_, _tmp8_);
	} else {
		GtkIconTheme* icon_theme = NULL;
		GdkDisplay* _tmp9_;
		GtkIconTheme* _tmp10_;
		GtkIconTheme* _tmp11_;
		gchar** icon_search_path = NULL;
		GtkIconTheme* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint icon_search_path_length1;
		gint _icon_search_path_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		GtkIconTheme* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp9_ = display;
		_tmp10_ = gtk_icon_theme_get_for_display (_tmp9_);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		icon_theme = _tmp11_;
		_tmp12_ = icon_theme;
		_tmp14_ = _tmp13_ = gtk_icon_theme_get_search_path (_tmp12_);
		icon_search_path = _tmp14_;
		icon_search_path_length1 = _vala_array_length (_tmp13_);
		_icon_search_path_size_ = icon_search_path_length1;
		_tmp15_ = icon_search_path;
		_tmp15__length1 = icon_search_path_length1;
		_tmp16_ = icon_search_path;
		_tmp16__length1 = icon_search_path_length1;
		_tmp17_ = theme_path;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (_tmp15_[_tmp16__length1 - 1]);
		_tmp15_[_tmp16__length1 - 1] = _tmp18_;
		_tmp19_ = icon_theme;
		_tmp20_ = icon_search_path;
		_tmp20__length1 = icon_search_path_length1;
		gtk_icon_theme_set_search_path (_tmp19_, _tmp20_);
		icon_search_path = (_vala_array_free (icon_search_path, icon_search_path_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (icon_theme);
	}
	_tmp21_ = theme_path;
	_tmp22_ = g_build_filename (_tmp21_, "theme.css", NULL);
	theme_css_path = _tmp22_;
	if (is_switch) {
		GdkDisplay* _tmp23_;
		GtkCssProvider* _tmp24_;
		_tmp23_ = display;
		_tmp24_ = self->priv->theme_provider;
		gtk_style_context_remove_provider_for_display (_tmp23_, (GtkStyleProvider*) _tmp24_);
	}
	_tmp25_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->theme_provider);
	self->priv->theme_provider = _tmp25_;
	_tmp26_ = self->priv->theme_provider;
	_tmp27_ = theme_css_path;
	gtk_css_provider_load_from_path (_tmp26_, _tmp27_);
	_tmp28_ = display;
	_tmp29_ = self->priv->theme_provider;
	gtk_style_context_add_provider_for_display (_tmp28_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_free0 (theme_css_path);
	_g_object_unref0 (display);
	_g_free0 (theme_path);
}

MineWindow*
mine_window_construct (GType object_type)
{
	MineWindow * self = NULL;
	self = (MineWindow*) g_object_new (object_type, NULL);
	return self;
}

MineWindow*
mine_window_new (void)
{
	return mine_window_construct (TYPE_MINE_WINDOW);
}

static void
_mine_window___lambda4_ (MineWindow* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, MINE_WINDOW_KEY_THEME);
	_tmp2_ = _tmp1_;
	mine_window_set_game_theme (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__mine_window___lambda4__g_settings_changed (GSettings* _sender,
                                             const gchar* key,
                                             gpointer self)
{
	_mine_window___lambda4_ ((MineWindow*) self);
}

static GObject *
mine_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MineWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	parent_class = G_OBJECT_CLASS (mine_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINE_WINDOW, MineWindow);
	_tmp0_ = g_settings_new ("org.gnome.Mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, MINE_WINDOW_KEY_THEME);
	_tmp3_ = _tmp2_;
	mine_window_set_game_theme (self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_strconcat ("changed::", MINE_WINDOW_KEY_THEME, NULL);
	g_signal_connect_object (_tmp4_, _tmp5_, (GCallback) __mine_window___lambda4__g_settings_changed, self, 0);
	_g_free0 (_tmp5_);
	mine_window_load_window_state (self);
	return obj;
}

static void
mine_window_class_init (MineWindowClass * klass,
                        gpointer klass_data)
{
	mine_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MineWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) mine_window_real_close_request;
	G_OBJECT_CLASS (klass)->constructor = mine_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = mine_window_finalize;
}

static void
mine_window_instance_init (MineWindow * self,
                           gpointer klass)
{
	self->priv = mine_window_get_instance_private (self);
}

static void
mine_window_finalize (GObject * obj)
{
	MineWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINE_WINDOW, MineWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->theme_provider);
	G_OBJECT_CLASS (mine_window_parent_class)->finalize (obj);
}

static GType
mine_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MineWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mine_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MineWindow), 0, (GInstanceInitFunc) mine_window_instance_init, NULL };
	GType mine_window_type_id;
	mine_window_type_id = g_type_register_static (adw_application_window_get_type (), "MineWindow", &g_define_type_info, 0);
	MineWindow_private_offset = g_type_add_instance_private (mine_window_type_id, sizeof (MineWindowPrivate));
	return mine_window_type_id;
}

GType
mine_window_get_type (void)
{
	static volatile gsize mine_window_type_id__once = 0;
	if (g_once_init_enter (&mine_window_type_id__once)) {
		GType mine_window_type_id;
		mine_window_type_id = mine_window_get_type_once ();
		g_once_init_leave (&mine_window_type_id__once, mine_window_type_id);
	}
	return mine_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

