/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_usrp_source = R"doc(USRP Source  Radio Receiver


The USRP source block receives samples and writes to a stream. The source block also provides API calls for receiver settings. See also gr::uhd::usrp_block for more public API calls.


RX Stream tagging:


The following tag keys will be produced by the work function:



The timestamp tag value is a pmt tuple of the following: (uint64 seconds, and double fractional seconds). A timestamp tag is produced at start() and after overflows.



Command interfaceThis block has a message port, which consumes UHD PMT commands. For a description of the command syntax, see Section Command Syntax.


For a more general description of the gr-uhd components, see UHD Interface.

Constructor Specific Documentation:



Args:
    device_addr : the address to identify the hardware
    stream_args : the IO format and channel specification
    issue_stream_cmd_on_start : enable or disable continuous streaming when flowgraph starts (default true))doc";


static const char* __doc_gr_uhd_usrp_source_usrp_source_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_source_usrp_source_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_source_make = R"doc(USRP Source  Radio Receiver


The USRP source block receives samples and writes to a stream. The source block also provides API calls for receiver settings. See also gr::uhd::usrp_block for more public API calls.


RX Stream tagging:


The following tag keys will be produced by the work function:



The timestamp tag value is a pmt tuple of the following: (uint64 seconds, and double fractional seconds). A timestamp tag is produced at start() and after overflows.



Command interfaceThis block has a message port, which consumes UHD PMT commands. For a description of the command syntax, see Section Command Syntax.


For a more general description of the gr-uhd components, see UHD Interface.

Constructor Specific Documentation:



Args:
    device_addr : the address to identify the hardware
    stream_args : the IO format and channel specification
    issue_stream_cmd_on_start : enable or disable continuous streaming when flowgraph starts (default true))doc";


static const char* __doc_gr_uhd_usrp_source_set_start_time = R"doc(Set the start time for incoming samples. To control when samples are received, set this value before starting the flow graph. The value is cleared after each run. When not specified, the start time will be:)doc";


static const char* __doc_gr_uhd_usrp_source_issue_stream_cmd = R"doc(Issue a stream command to all channels in this source block.


This method is intended to override the default \"always on\" behavior. After starting the flow graph, the user should call stop() on this block, then issue any desired arbitrary stream_cmd_t structs to the device. The USRP will be able to enqueue several stream commands in the FPGA.)doc";


static const char* __doc_gr_uhd_usrp_source_set_recv_timeout = R"doc(Configure the timeout value on the UHD recv() call


This is an advanced use parameter. Changing the timeout value affects the latency of this block; a high timeout value can be more optimal for high-throughput applications (e.g., 1 second) and setting it to zero will have the best latency. Changing the timeout value may also be useful for custom FPGA modifications, where traffic might not be continuously streaming. For specialized high-performance use cases, twiddling these knobs may improve performance, but changes are not generally applicable.


Note that UHD's recv() call may block until the timeout is over, which means this block might also block for up to the timeout value.)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_names = R"doc(Get a list of possible LO stage names)doc";


static const char* __doc_gr_uhd_usrp_source_set_lo_source = R"doc(Set the LO source for the usrp device. For usrps that support selectable LOs, this function allows switching between them. Typical options for source: internal, external.)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_source = R"doc(Get the currently set LO source.)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_sources = R"doc(Get a list of possible LO sources.)doc";


static const char* __doc_gr_uhd_usrp_source_set_lo_export_enabled = R"doc(Set whether the LO used by the usrp device is exported For usrps that support exportable LOs, this function configures if the LO used by chan is exported or not.)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_export_enabled = R"doc(Returns true if the currently selected LO is being exported.)doc";


static const char* __doc_gr_uhd_usrp_source_set_lo_freq = R"doc(Set the RX LO frequency (Advanced).)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_freq = R"doc(Get the current RX LO frequency (Advanced).)doc";


static const char* __doc_gr_uhd_usrp_source_get_lo_freq_range = R"doc(Get the LO frequency range of the RX LO.)doc";


static const char* __doc_gr_uhd_usrp_source_set_auto_dc_offset = R"doc(Enable/disable the automatic DC offset correction. The automatic correction subtracts out the long-run average.


When disabled, the averaging option operation is halted. Once halted, the average value will be held constant until the user re-enables the automatic correction or overrides the value by manually setting the offset.)doc";


static const char* __doc_gr_uhd_usrp_source_set_dc_offset = R"doc(Set a constant DC offset value. The value is complex to control both I and Q. Only set this when automatic correction is disabled.)doc";


static const char* __doc_gr_uhd_usrp_source_set_auto_iq_balance = R"doc(Enable/Disable the RX frontend IQ imbalance correction.)doc";


static const char* __doc_gr_uhd_usrp_source_set_iq_balance = R"doc(Set the RX frontend IQ imbalance correction. Use this to adjust the magnitude and phase of I and Q.)doc";


static const char* __doc_gr_uhd_usrp_source_set_rx_agc = R"doc(Enable/disable the RX AGC module. If AGC is turned on, all manual gain settings are ignored.)doc";


static const char* __doc_gr_uhd_usrp_source_finite_acquisition = R"doc(Convenience function for finite data acquisition. This is not to be used with the scheduler; rather, one can request samples from the USRP in python. //TODO assumes fc32)doc";


static const char* __doc_gr_uhd_usrp_source_finite_acquisition_v = R"doc(Convenience function for finite data acquisition. This is the multi-channel version of finite_acquisition; This is not to be used with the scheduler; rather, one can request samples from the USRP in python. //TODO assumes fc32)doc";
