// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
	applyconfigurationmonitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	v1 "k8s.io/api/core/v1"
)

// ScalewaySDConfigApplyConfiguration represents a declarative configuration of the ScalewaySDConfig type for use
// with apply.
type ScalewaySDConfigApplyConfiguration struct {
	AccessKey                                                    *string                          `json:"accessKey,omitempty"`
	SecretKey                                                    *v1.SecretKeySelector            `json:"secretKey,omitempty"`
	ProjectID                                                    *string                          `json:"projectID,omitempty"`
	Role                                                         *monitoringv1alpha1.ScalewayRole `json:"role,omitempty"`
	Port                                                         *int32                           `json:"port,omitempty"`
	ApiURL                                                       *string                          `json:"apiURL,omitempty"`
	Zone                                                         *string                          `json:"zone,omitempty"`
	NameFilter                                                   *string                          `json:"nameFilter,omitempty"`
	TagsFilter                                                   []string                         `json:"tagsFilter,omitempty"`
	RefreshInterval                                              *monitoringv1.Duration           `json:"refreshInterval,omitempty"`
	applyconfigurationmonitoringv1.ProxyConfigApplyConfiguration `json:",inline"`
	FollowRedirects                                              *bool                                                           `json:"followRedirects,omitempty"`
	EnableHTTP2                                                  *bool                                                           `json:"enableHTTP2,omitempty"`
	TLSConfig                                                    *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration `json:"tlsConfig,omitempty"`
}

// ScalewaySDConfigApplyConfiguration constructs a declarative configuration of the ScalewaySDConfig type for use with
// apply.
func ScalewaySDConfig() *ScalewaySDConfigApplyConfiguration {
	return &ScalewaySDConfigApplyConfiguration{}
}

// WithAccessKey sets the AccessKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AccessKey field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithAccessKey(value string) *ScalewaySDConfigApplyConfiguration {
	b.AccessKey = &value
	return b
}

// WithSecretKey sets the SecretKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretKey field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithSecretKey(value v1.SecretKeySelector) *ScalewaySDConfigApplyConfiguration {
	b.SecretKey = &value
	return b
}

// WithProjectID sets the ProjectID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProjectID field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithProjectID(value string) *ScalewaySDConfigApplyConfiguration {
	b.ProjectID = &value
	return b
}

// WithRole sets the Role field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Role field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithRole(value monitoringv1alpha1.ScalewayRole) *ScalewaySDConfigApplyConfiguration {
	b.Role = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithPort(value int32) *ScalewaySDConfigApplyConfiguration {
	b.Port = &value
	return b
}

// WithApiURL sets the ApiURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApiURL field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithApiURL(value string) *ScalewaySDConfigApplyConfiguration {
	b.ApiURL = &value
	return b
}

// WithZone sets the Zone field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Zone field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithZone(value string) *ScalewaySDConfigApplyConfiguration {
	b.Zone = &value
	return b
}

// WithNameFilter sets the NameFilter field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NameFilter field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithNameFilter(value string) *ScalewaySDConfigApplyConfiguration {
	b.NameFilter = &value
	return b
}

// WithTagsFilter adds the given value to the TagsFilter field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TagsFilter field.
func (b *ScalewaySDConfigApplyConfiguration) WithTagsFilter(values ...string) *ScalewaySDConfigApplyConfiguration {
	for i := range values {
		b.TagsFilter = append(b.TagsFilter, values[i])
	}
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithRefreshInterval(value monitoringv1.Duration) *ScalewaySDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}

// WithProxyURL sets the ProxyURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProxyURL field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithProxyURL(value string) *ScalewaySDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.ProxyURL = &value
	return b
}

// WithNoProxy sets the NoProxy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NoProxy field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithNoProxy(value string) *ScalewaySDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.NoProxy = &value
	return b
}

// WithProxyFromEnvironment sets the ProxyFromEnvironment field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProxyFromEnvironment field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithProxyFromEnvironment(value bool) *ScalewaySDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.ProxyFromEnvironment = &value
	return b
}

// WithProxyConnectHeader puts the entries into the ProxyConnectHeader field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ProxyConnectHeader field,
// overwriting an existing map entries in ProxyConnectHeader field with the same key.
func (b *ScalewaySDConfigApplyConfiguration) WithProxyConnectHeader(entries map[string][]v1.SecretKeySelector) *ScalewaySDConfigApplyConfiguration {
	if b.ProxyConfigApplyConfiguration.ProxyConnectHeader == nil && len(entries) > 0 {
		b.ProxyConfigApplyConfiguration.ProxyConnectHeader = make(map[string][]v1.SecretKeySelector, len(entries))
	}
	for k, v := range entries {
		b.ProxyConfigApplyConfiguration.ProxyConnectHeader[k] = v
	}
	return b
}

// WithFollowRedirects sets the FollowRedirects field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FollowRedirects field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithFollowRedirects(value bool) *ScalewaySDConfigApplyConfiguration {
	b.FollowRedirects = &value
	return b
}

// WithEnableHTTP2 sets the EnableHTTP2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableHTTP2 field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithEnableHTTP2(value bool) *ScalewaySDConfigApplyConfiguration {
	b.EnableHTTP2 = &value
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *ScalewaySDConfigApplyConfiguration) WithTLSConfig(value *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration) *ScalewaySDConfigApplyConfiguration {
	b.TLSConfig = value
	return b
}
