{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An auxiliary class used by @GtkStack@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StackPage
    ( 

-- * Exported types
    StackPage(..)                           ,
    IsStackPage                             ,
    toStackPage                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getChild]("GI.Gtk.Objects.StackPage#g:method:getChild"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getIconName]("GI.Gtk.Objects.StackPage#g:method:getIconName"), [getName]("GI.Gtk.Objects.StackPage#g:method:getName"), [getNeedsAttention]("GI.Gtk.Objects.StackPage#g:method:getNeedsAttention"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTitle]("GI.Gtk.Objects.StackPage#g:method:getTitle"), [getUseUnderline]("GI.Gtk.Objects.StackPage#g:method:getUseUnderline"), [getVisible]("GI.Gtk.Objects.StackPage#g:method:getVisible").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setIconName]("GI.Gtk.Objects.StackPage#g:method:setIconName"), [setName]("GI.Gtk.Objects.StackPage#g:method:setName"), [setNeedsAttention]("GI.Gtk.Objects.StackPage#g:method:setNeedsAttention"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTitle]("GI.Gtk.Objects.StackPage#g:method:setTitle"), [setUseUnderline]("GI.Gtk.Objects.StackPage#g:method:setUseUnderline"), [setVisible]("GI.Gtk.Objects.StackPage#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveStackPageMethod                  ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    StackPageGetChildMethodInfo             ,
#endif
    stackPageGetChild                       ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    StackPageGetIconNameMethodInfo          ,
#endif
    stackPageGetIconName                    ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    StackPageGetNameMethodInfo              ,
#endif
    stackPageGetName                        ,


-- ** getNeedsAttention #method:getNeedsAttention#

#if defined(ENABLE_OVERLOADING)
    StackPageGetNeedsAttentionMethodInfo    ,
#endif
    stackPageGetNeedsAttention              ,


-- ** getTitle #method:getTitle#

#if defined(ENABLE_OVERLOADING)
    StackPageGetTitleMethodInfo             ,
#endif
    stackPageGetTitle                       ,


-- ** getUseUnderline #method:getUseUnderline#

#if defined(ENABLE_OVERLOADING)
    StackPageGetUseUnderlineMethodInfo      ,
#endif
    stackPageGetUseUnderline                ,


-- ** getVisible #method:getVisible#

#if defined(ENABLE_OVERLOADING)
    StackPageGetVisibleMethodInfo           ,
#endif
    stackPageGetVisible                     ,


-- ** setIconName #method:setIconName#

#if defined(ENABLE_OVERLOADING)
    StackPageSetIconNameMethodInfo          ,
#endif
    stackPageSetIconName                    ,


-- ** setName #method:setName#

#if defined(ENABLE_OVERLOADING)
    StackPageSetNameMethodInfo              ,
#endif
    stackPageSetName                        ,


-- ** setNeedsAttention #method:setNeedsAttention#

#if defined(ENABLE_OVERLOADING)
    StackPageSetNeedsAttentionMethodInfo    ,
#endif
    stackPageSetNeedsAttention              ,


-- ** setTitle #method:setTitle#

#if defined(ENABLE_OVERLOADING)
    StackPageSetTitleMethodInfo             ,
#endif
    stackPageSetTitle                       ,


-- ** setUseUnderline #method:setUseUnderline#

#if defined(ENABLE_OVERLOADING)
    StackPageSetUseUnderlineMethodInfo      ,
#endif
    stackPageSetUseUnderline                ,


-- ** setVisible #method:setVisible#

#if defined(ENABLE_OVERLOADING)
    StackPageSetVisibleMethodInfo           ,
#endif
    stackPageSetVisible                     ,




 -- * Properties


-- ** child #attr:child#
-- | The child that this page is for.

#if defined(ENABLE_OVERLOADING)
    StackPageChildPropertyInfo              ,
#endif
    constructStackPageChild                 ,
    getStackPageChild                       ,
#if defined(ENABLE_OVERLOADING)
    stackPageChild                          ,
#endif


-- ** iconName #attr:iconName#
-- | The icon name of the child page.

#if defined(ENABLE_OVERLOADING)
    StackPageIconNamePropertyInfo           ,
#endif
    constructStackPageIconName              ,
    getStackPageIconName                    ,
    setStackPageIconName                    ,
#if defined(ENABLE_OVERLOADING)
    stackPageIconName                       ,
#endif


-- ** name #attr:name#
-- | The name of the child page.

#if defined(ENABLE_OVERLOADING)
    StackPageNamePropertyInfo               ,
#endif
    constructStackPageName                  ,
    getStackPageName                        ,
    setStackPageName                        ,
#if defined(ENABLE_OVERLOADING)
    stackPageName                           ,
#endif


-- ** needsAttention #attr:needsAttention#
-- | Whether the page requires the user attention.
-- 
-- This is used by the t'GI.Gtk.Objects.StackSwitcher.StackSwitcher' to change the
-- appearance of the corresponding button when a page needs
-- attention and it is not the current one.

#if defined(ENABLE_OVERLOADING)
    StackPageNeedsAttentionPropertyInfo     ,
#endif
    constructStackPageNeedsAttention        ,
    getStackPageNeedsAttention              ,
    setStackPageNeedsAttention              ,
#if defined(ENABLE_OVERLOADING)
    stackPageNeedsAttention                 ,
#endif


-- ** title #attr:title#
-- | The title of the child page.

#if defined(ENABLE_OVERLOADING)
    StackPageTitlePropertyInfo              ,
#endif
    constructStackPageTitle                 ,
    getStackPageTitle                       ,
    setStackPageTitle                       ,
#if defined(ENABLE_OVERLOADING)
    stackPageTitle                          ,
#endif


-- ** useUnderline #attr:useUnderline#
-- | If set, an underline in the title indicates a mnemonic.

#if defined(ENABLE_OVERLOADING)
    StackPageUseUnderlinePropertyInfo       ,
#endif
    constructStackPageUseUnderline          ,
    getStackPageUseUnderline                ,
    setStackPageUseUnderline                ,
#if defined(ENABLE_OVERLOADING)
    stackPageUseUnderline                   ,
#endif


-- ** visible #attr:visible#
-- | Whether this page is visible.

#if defined(ENABLE_OVERLOADING)
    StackPageVisiblePropertyInfo            ,
#endif
    constructStackPageVisible               ,
    getStackPageVisible                     ,
    setStackPageVisible                     ,
#if defined(ENABLE_OVERLOADING)
    stackPageVisible                        ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype StackPage = StackPage (SP.ManagedPtr StackPage)
    deriving (Eq)

instance SP.ManagedPtrNewtype StackPage where
    toManagedPtr (StackPage p) = p

foreign import ccall "gtk_stack_page_get_type"
    c_gtk_stack_page_get_type :: IO B.Types.GType

instance B.Types.TypedObject StackPage where
    glibType = c_gtk_stack_page_get_type

instance B.Types.GObject StackPage

-- | Type class for types which can be safely cast to t'StackPage', for instance with `toStackPage`.
class (SP.GObject o, O.IsDescendantOf StackPage o) => IsStackPage o
instance (SP.GObject o, O.IsDescendantOf StackPage o) => IsStackPage o

instance O.HasParentTypes StackPage
type instance O.ParentTypes StackPage = '[GObject.Object.Object, Gtk.Accessible.Accessible]

-- | Cast to t'StackPage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStackPage :: (MIO.MonadIO m, IsStackPage o) => o -> m StackPage
toStackPage = MIO.liftIO . B.ManagedPtr.unsafeCastTo StackPage

-- | Convert t'StackPage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StackPage) where
    gvalueGType_ = c_gtk_stack_page_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StackPage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StackPage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StackPage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStackPageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStackPageMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveStackPageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStackPageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStackPageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStackPageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStackPageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStackPageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStackPageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStackPageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStackPageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStackPageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStackPageMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveStackPageMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveStackPageMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveStackPageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStackPageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStackPageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStackPageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStackPageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStackPageMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveStackPageMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveStackPageMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveStackPageMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveStackPageMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveStackPageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStackPageMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveStackPageMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveStackPageMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveStackPageMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveStackPageMethod "getChild" o = StackPageGetChildMethodInfo
    ResolveStackPageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStackPageMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveStackPageMethod "getIconName" o = StackPageGetIconNameMethodInfo
    ResolveStackPageMethod "getName" o = StackPageGetNameMethodInfo
    ResolveStackPageMethod "getNeedsAttention" o = StackPageGetNeedsAttentionMethodInfo
    ResolveStackPageMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveStackPageMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveStackPageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStackPageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStackPageMethod "getTitle" o = StackPageGetTitleMethodInfo
    ResolveStackPageMethod "getUseUnderline" o = StackPageGetUseUnderlineMethodInfo
    ResolveStackPageMethod "getVisible" o = StackPageGetVisibleMethodInfo
    ResolveStackPageMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveStackPageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStackPageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStackPageMethod "setIconName" o = StackPageSetIconNameMethodInfo
    ResolveStackPageMethod "setName" o = StackPageSetNameMethodInfo
    ResolveStackPageMethod "setNeedsAttention" o = StackPageSetNeedsAttentionMethodInfo
    ResolveStackPageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStackPageMethod "setTitle" o = StackPageSetTitleMethodInfo
    ResolveStackPageMethod "setUseUnderline" o = StackPageSetUseUnderlineMethodInfo
    ResolveStackPageMethod "setVisible" o = StackPageSetVisibleMethodInfo
    ResolveStackPageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStackPageMethod t StackPage, O.OverloadedMethod info StackPage p) => OL.IsLabel t (StackPage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStackPageMethod t StackPage, O.OverloadedMethod info StackPage p, R.HasField t StackPage p) => R.HasField t StackPage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStackPageMethod t StackPage, O.OverloadedMethodInfo info StackPage) => OL.IsLabel t (O.MethodProxy info StackPage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #child
-- @
getStackPageChild :: (MonadIO m, IsStackPage o) => o -> m Gtk.Widget.Widget
getStackPageChild obj = MIO.liftIO $ checkUnexpectedNothing "getStackPageChild" $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageChild :: (IsStackPage o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructStackPageChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackPageChildPropertyInfo
instance AttrInfo StackPageChildPropertyInfo where
    type AttrAllowedOps StackPageChildPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StackPageChildPropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint StackPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType StackPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType StackPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrLabel StackPageChildPropertyInfo = "child"
    type AttrOrigin StackPageChildPropertyInfo = StackPage
    attrGet = getStackPageChild
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructStackPageChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:child"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #iconName
-- @
getStackPageIconName :: (MonadIO m, IsStackPage o) => o -> m (Maybe T.Text)
getStackPageIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageIconName :: (MonadIO m, IsStackPage o) => o -> T.Text -> m ()
setStackPageIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageIconName :: (IsStackPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructStackPageIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackPageIconNamePropertyInfo
instance AttrInfo StackPageIconNamePropertyInfo where
    type AttrAllowedOps StackPageIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackPageIconNamePropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint StackPageIconNamePropertyInfo = (~) T.Text
    type AttrTransferType StackPageIconNamePropertyInfo = T.Text
    type AttrGetType StackPageIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel StackPageIconNamePropertyInfo = "icon-name"
    type AttrOrigin StackPageIconNamePropertyInfo = StackPage
    attrGet = getStackPageIconName
    attrSet = setStackPageIconName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageIconName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:iconName"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #name
-- @
getStackPageName :: (MonadIO m, IsStackPage o) => o -> m (Maybe T.Text)
getStackPageName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "name"

-- | Set the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageName :: (MonadIO m, IsStackPage o) => o -> T.Text -> m ()
setStackPageName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageName :: (IsStackPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructStackPageName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackPageNamePropertyInfo
instance AttrInfo StackPageNamePropertyInfo where
    type AttrAllowedOps StackPageNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackPageNamePropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint StackPageNamePropertyInfo = (~) T.Text
    type AttrTransferType StackPageNamePropertyInfo = T.Text
    type AttrGetType StackPageNamePropertyInfo = (Maybe T.Text)
    type AttrLabel StackPageNamePropertyInfo = "name"
    type AttrOrigin StackPageNamePropertyInfo = StackPage
    attrGet = getStackPageName
    attrSet = setStackPageName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:name"
        })
#endif

-- VVV Prop "needs-attention"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@needs-attention@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #needsAttention
-- @
getStackPageNeedsAttention :: (MonadIO m, IsStackPage o) => o -> m Bool
getStackPageNeedsAttention obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "needs-attention"

-- | Set the value of the “@needs-attention@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #needsAttention 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageNeedsAttention :: (MonadIO m, IsStackPage o) => o -> Bool -> m ()
setStackPageNeedsAttention obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "needs-attention" val

-- | Construct a t'GValueConstruct' with valid value for the “@needs-attention@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageNeedsAttention :: (IsStackPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackPageNeedsAttention val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "needs-attention" val

#if defined(ENABLE_OVERLOADING)
data StackPageNeedsAttentionPropertyInfo
instance AttrInfo StackPageNeedsAttentionPropertyInfo where
    type AttrAllowedOps StackPageNeedsAttentionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint StackPageNeedsAttentionPropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageNeedsAttentionPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackPageNeedsAttentionPropertyInfo = (~) Bool
    type AttrTransferType StackPageNeedsAttentionPropertyInfo = Bool
    type AttrGetType StackPageNeedsAttentionPropertyInfo = Bool
    type AttrLabel StackPageNeedsAttentionPropertyInfo = "needs-attention"
    type AttrOrigin StackPageNeedsAttentionPropertyInfo = StackPage
    attrGet = getStackPageNeedsAttention
    attrSet = setStackPageNeedsAttention
    attrPut = setStackPageNeedsAttention
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageNeedsAttention
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.needsAttention"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:needsAttention"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #title
-- @
getStackPageTitle :: (MonadIO m, IsStackPage o) => o -> m (Maybe T.Text)
getStackPageTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageTitle :: (MonadIO m, IsStackPage o) => o -> T.Text -> m ()
setStackPageTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageTitle :: (IsStackPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructStackPageTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackPageTitlePropertyInfo
instance AttrInfo StackPageTitlePropertyInfo where
    type AttrAllowedOps StackPageTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackPageTitlePropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint StackPageTitlePropertyInfo = (~) T.Text
    type AttrTransferType StackPageTitlePropertyInfo = T.Text
    type AttrGetType StackPageTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel StackPageTitlePropertyInfo = "title"
    type AttrOrigin StackPageTitlePropertyInfo = StackPage
    attrGet = getStackPageTitle
    attrSet = setStackPageTitle
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageTitle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:title"
        })
#endif

-- VVV Prop "use-underline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #useUnderline
-- @
getStackPageUseUnderline :: (MonadIO m, IsStackPage o) => o -> m Bool
getStackPageUseUnderline obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-underline"

-- | Set the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #useUnderline 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageUseUnderline :: (MonadIO m, IsStackPage o) => o -> Bool -> m ()
setStackPageUseUnderline obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-underline" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-underline@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageUseUnderline :: (IsStackPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackPageUseUnderline val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-underline" val

#if defined(ENABLE_OVERLOADING)
data StackPageUseUnderlinePropertyInfo
instance AttrInfo StackPageUseUnderlinePropertyInfo where
    type AttrAllowedOps StackPageUseUnderlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint StackPageUseUnderlinePropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackPageUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferType StackPageUseUnderlinePropertyInfo = Bool
    type AttrGetType StackPageUseUnderlinePropertyInfo = Bool
    type AttrLabel StackPageUseUnderlinePropertyInfo = "use-underline"
    type AttrOrigin StackPageUseUnderlinePropertyInfo = StackPage
    attrGet = getStackPageUseUnderline
    attrSet = setStackPageUseUnderline
    attrPut = setStackPageUseUnderline
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageUseUnderline
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.useUnderline"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:useUnderline"
        })
#endif

-- VVV Prop "visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stackPage #visible
-- @
getStackPageVisible :: (MonadIO m, IsStackPage o) => o -> m Bool
getStackPageVisible obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "visible"

-- | Set the value of the “@visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stackPage [ #visible 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackPageVisible :: (MonadIO m, IsStackPage o) => o -> Bool -> m ()
setStackPageVisible obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "visible" val

-- | Construct a t'GValueConstruct' with valid value for the “@visible@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackPageVisible :: (IsStackPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackPageVisible val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "visible" val

#if defined(ENABLE_OVERLOADING)
data StackPageVisiblePropertyInfo
instance AttrInfo StackPageVisiblePropertyInfo where
    type AttrAllowedOps StackPageVisiblePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint StackPageVisiblePropertyInfo = IsStackPage
    type AttrSetTypeConstraint StackPageVisiblePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackPageVisiblePropertyInfo = (~) Bool
    type AttrTransferType StackPageVisiblePropertyInfo = Bool
    type AttrGetType StackPageVisiblePropertyInfo = Bool
    type AttrLabel StackPageVisiblePropertyInfo = "visible"
    type AttrOrigin StackPageVisiblePropertyInfo = StackPage
    attrGet = getStackPageVisible
    attrSet = setStackPageVisible
    attrPut = setStackPageVisible
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackPageVisible
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.visible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#g:attr:visible"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StackPage
type instance O.AttributeList StackPage = StackPageAttributeList
type StackPageAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("child", StackPageChildPropertyInfo), '("iconName", StackPageIconNamePropertyInfo), '("name", StackPageNamePropertyInfo), '("needsAttention", StackPageNeedsAttentionPropertyInfo), '("title", StackPageTitlePropertyInfo), '("useUnderline", StackPageUseUnderlinePropertyInfo), '("visible", StackPageVisiblePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stackPageChild :: AttrLabelProxy "child"
stackPageChild = AttrLabelProxy

stackPageIconName :: AttrLabelProxy "iconName"
stackPageIconName = AttrLabelProxy

stackPageName :: AttrLabelProxy "name"
stackPageName = AttrLabelProxy

stackPageNeedsAttention :: AttrLabelProxy "needsAttention"
stackPageNeedsAttention = AttrLabelProxy

stackPageTitle :: AttrLabelProxy "title"
stackPageTitle = AttrLabelProxy

stackPageUseUnderline :: AttrLabelProxy "useUnderline"
stackPageUseUnderline = AttrLabelProxy

stackPageVisible :: AttrLabelProxy "visible"
stackPageVisible = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StackPage = StackPageSignalList
type StackPageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StackPage::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_child" gtk_stack_page_get_child :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the stack child to which /@self@/ belongs.
stackPageGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the child to which /@self@/ belongs
stackPageGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_child self'
    checkUnexpectedReturnNULL "stackPageGetChild" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StackPageGetChildMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetChildMethodInfo a signature where
    overloadedMethod = stackPageGetChild

instance O.OverloadedMethodInfo StackPageGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetChild"
        })


#endif

-- method StackPage::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_icon_name" gtk_stack_page_get_icon_name :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CString

-- | Returns the icon name of the page.
stackPageGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The value of the [StackPage:iconName]("GI.Gtk.Objects.StackPage#g:attr:iconName") property
stackPageGetIconName self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_icon_name self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackPageGetIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetIconNameMethodInfo a signature where
    overloadedMethod = stackPageGetIconName

instance O.OverloadedMethodInfo StackPageGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetIconName"
        })


#endif

-- method StackPage::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_name" gtk_stack_page_get_name :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CString

-- | Returns the name of the page.
stackPageGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The value of the [StackPage:name]("GI.Gtk.Objects.StackPage#g:attr:name") property
stackPageGetName self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_name self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackPageGetNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetNameMethodInfo a signature where
    overloadedMethod = stackPageGetName

instance O.OverloadedMethodInfo StackPageGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetName"
        })


#endif

-- method StackPage::get_needs_attention
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_needs_attention" gtk_stack_page_get_needs_attention :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CInt

-- | Returns whether the page is marked as “needs attention”.
stackPageGetNeedsAttention ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m Bool
    -- ^ __Returns:__ The value of the [StackPage:needsAttention]("GI.Gtk.Objects.StackPage#g:attr:needsAttention")
    --   property.
stackPageGetNeedsAttention self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_needs_attention self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StackPageGetNeedsAttentionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetNeedsAttentionMethodInfo a signature where
    overloadedMethod = stackPageGetNeedsAttention

instance O.OverloadedMethodInfo StackPageGetNeedsAttentionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetNeedsAttention",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetNeedsAttention"
        })


#endif

-- method StackPage::get_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_title" gtk_stack_page_get_title :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CString

-- | Gets the page title.
stackPageGetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The value of the [StackPage:title]("GI.Gtk.Objects.StackPage#g:attr:title") property
stackPageGetTitle self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_title self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackPageGetTitleMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetTitleMethodInfo a signature where
    overloadedMethod = stackPageGetTitle

instance O.OverloadedMethodInfo StackPageGetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetTitle"
        })


#endif

-- method StackPage::get_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_use_underline" gtk_stack_page_get_use_underline :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CInt

-- | Gets whether underlines in the page title indicate mnemonics.
stackPageGetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m Bool
    -- ^ __Returns:__ The value of the [StackPage:useUnderline]("GI.Gtk.Objects.StackPage#g:attr:useUnderline") property
stackPageGetUseUnderline self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_use_underline self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StackPageGetUseUnderlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetUseUnderlineMethodInfo a signature where
    overloadedMethod = stackPageGetUseUnderline

instance O.OverloadedMethodInfo StackPageGetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetUseUnderline"
        })


#endif

-- method StackPage::get_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_get_visible" gtk_stack_page_get_visible :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    IO CInt

-- | Returns whether /@page@/ is visible in its @GtkStack@.
-- 
-- This is independent from the [Widget:visible]("GI.Gtk.Objects.Widget#g:attr:visible")
-- property of its widget.
stackPageGetVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@page@/ is visible
stackPageGetVisible self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_stack_page_get_visible self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StackPageGetVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageGetVisibleMethodInfo a signature where
    overloadedMethod = stackPageGetVisible

instance O.OverloadedMethodInfo StackPageGetVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageGetVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageGetVisible"
        })


#endif

-- method StackPage::set_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_icon_name" gtk_stack_page_set_icon_name :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CString ->                              -- setting : TBasicType TUTF8
    IO ()

-- | Sets the icon name of the page.
stackPageSetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> T.Text
    -- ^ /@setting@/: the new value to set
    -> m ()
stackPageSetIconName self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    setting' <- textToCString setting
    gtk_stack_page_set_icon_name self' setting'
    touchManagedPtr self
    freeMem setting'
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetIconNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetIconNameMethodInfo a signature where
    overloadedMethod = stackPageSetIconName

instance O.OverloadedMethodInfo StackPageSetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetIconName"
        })


#endif

-- method StackPage::set_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_name" gtk_stack_page_set_name :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CString ->                              -- setting : TBasicType TUTF8
    IO ()

-- | Sets the name of the page.
stackPageSetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> T.Text
    -- ^ /@setting@/: the new value to set
    -> m ()
stackPageSetName self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    setting' <- textToCString setting
    gtk_stack_page_set_name self' setting'
    touchManagedPtr self
    freeMem setting'
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetNameMethodInfo a signature where
    overloadedMethod = stackPageSetName

instance O.OverloadedMethodInfo StackPageSetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetName"
        })


#endif

-- method StackPage::set_needs_attention
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_needs_attention" gtk_stack_page_set_needs_attention :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether the page is marked as “needs attention”.
stackPageSetNeedsAttention ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> Bool
    -- ^ /@setting@/: the new value to set
    -> m ()
stackPageSetNeedsAttention self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_stack_page_set_needs_attention self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetNeedsAttentionMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetNeedsAttentionMethodInfo a signature where
    overloadedMethod = stackPageSetNeedsAttention

instance O.OverloadedMethodInfo StackPageSetNeedsAttentionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetNeedsAttention",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetNeedsAttention"
        })


#endif

-- method StackPage::set_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_title" gtk_stack_page_set_title :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CString ->                              -- setting : TBasicType TUTF8
    IO ()

-- | Sets the page title.
stackPageSetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> T.Text
    -- ^ /@setting@/: the new value to set
    -> m ()
stackPageSetTitle self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    setting' <- textToCString setting
    gtk_stack_page_set_title self' setting'
    touchManagedPtr self
    freeMem setting'
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetTitleMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetTitleMethodInfo a signature where
    overloadedMethod = stackPageSetTitle

instance O.OverloadedMethodInfo StackPageSetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetTitle"
        })


#endif

-- method StackPage::set_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_use_underline" gtk_stack_page_set_use_underline :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether underlines in the page title indicate mnemonics.
stackPageSetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> Bool
    -- ^ /@setting@/: the new value to set
    -> m ()
stackPageSetUseUnderline self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_stack_page_set_use_underline self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetUseUnderlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetUseUnderlineMethodInfo a signature where
    overloadedMethod = stackPageSetUseUnderline

instance O.OverloadedMethodInfo StackPageSetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetUseUnderline"
        })


#endif

-- method StackPage::set_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StackPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStackPage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "visible"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new property value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_page_set_visible" gtk_stack_page_set_visible :: 
    Ptr StackPage ->                        -- self : TInterface (Name {namespace = "Gtk", name = "StackPage"})
    CInt ->                                 -- visible : TBasicType TBoolean
    IO ()

-- | Sets whether /@page@/ is visible in its @GtkStack@.
stackPageSetVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsStackPage a) =>
    a
    -- ^ /@self@/: a @GtkStackPage@
    -> Bool
    -- ^ /@visible@/: The new property value
    -> m ()
stackPageSetVisible self visible = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let visible' = (P.fromIntegral . P.fromEnum) visible
    gtk_stack_page_set_visible self' visible'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StackPageSetVisibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStackPage a) => O.OverloadedMethod StackPageSetVisibleMethodInfo a signature where
    overloadedMethod = stackPageSetVisible

instance O.OverloadedMethodInfo StackPageSetVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StackPage.stackPageSetVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StackPage.html#v:stackPageSetVisible"
        })


#endif


