/*
 * Copyright (C) 2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "level_zero/ddi/ze_ddi_tables.h"

#include "level_zero/api/core/ze_core_all_api_entrypoints.h"
#include "level_zero/api/driver_experimental/tracing/zet_tracing.h"
#include "level_zero/api/extensions/public/ze_exp_ext.h"
#include "level_zero/api/runtime/ze_runtime_all_api_entrypoints.h"
#include "level_zero/api/sysman/zes_sysman_all_api_entrypoints.h"
#include "level_zero/api/tools/zet_tools_all_api_entrypoints.h"

namespace L0 {

DriverDispatch globalDriverDispatch;

DriverDispatch::DriverDispatch() {
    this->core.isValidFlag = true;
    this->core.version = ZE_API_VERSION_1_14;
    this->core.RTASBuilderExp = &this->coreRTASBuilderExp;
    this->core.RTASBuilder = &this->coreRTASBuilder;
    this->core.RTASParallelOperationExp = &this->coreRTASParallelOperationExp;
    this->core.RTASParallelOperation = &this->coreRTASParallelOperation;
    this->core.Global = &this->coreGlobal;
    this->core.Driver = &this->coreDriver;
    this->core.DriverExp = &this->coreDriverExp;
    this->core.Device = &this->coreDevice;
    this->core.DeviceExp = &this->coreDeviceExp;
    this->core.Context = &this->coreContext;
    this->core.CommandQueue = &this->coreCommandQueue;
    this->core.CommandList = &this->coreCommandList;
    this->core.CommandListExp = &this->coreCommandListExp;
    this->core.Image = &this->coreImage;
    this->core.ImageExp = &this->coreImageExp;
    this->core.Mem = &this->coreMem;
    this->core.MemExp = &this->coreMemExp;
    this->core.Fence = &this->coreFence;
    this->core.EventPool = &this->coreEventPool;
    this->core.Event = &this->coreEvent;
    this->core.EventExp = &this->coreEventExp;
    this->core.Module = &this->coreModule;
    this->core.ModuleBuildLog = &this->coreModuleBuildLog;
    this->core.Kernel = &this->coreKernel;
    this->core.KernelExp = &this->coreKernelExp;
    this->core.Sampler = &this->coreSampler;
    this->core.PhysicalMem = &this->corePhysicalMem;
    this->core.VirtualMem = &this->coreVirtualMem;
    this->core.FabricVertexExp = &this->coreFabricVertexExp;
    this->core.FabricEdgeExp = &this->coreFabricEdgeExp;

    this->tools.isValidFlag = true;
    this->tools.version = ZE_API_VERSION_1_13;
    this->tools.MetricProgrammableExp = &this->toolsMetricProgrammableExp;
    this->tools.MetricTracerExp = &this->toolsMetricTracerExp;
    this->tools.MetricDecoderExp = &this->toolsMetricDecoderExp;
    this->tools.Device = &this->toolsDevice;
    this->tools.DeviceExp = &this->toolsDeviceExp;
    this->tools.Context = &this->toolsContext;
    this->tools.CommandList = &this->toolsCommandList;
    this->tools.CommandListExp = &this->toolsCommandListExp;
    this->tools.Module = &this->toolsModule;
    this->tools.Kernel = &this->toolsKernel;
    this->tools.Metric = &this->toolsMetric;
    this->tools.MetricExp = &this->toolsMetricExp;
    this->tools.MetricGroup = &this->toolsMetricGroup;
    this->tools.MetricGroupExp = &this->toolsMetricGroupExp;
    this->tools.MetricStreamer = &this->toolsMetricStreamer;
    this->tools.MetricQueryPool = &this->toolsMetricQueryPool;
    this->tools.MetricQuery = &this->toolsMetricQuery;
    this->tools.TracerExp = &this->toolsTracerExp;
    this->tools.Debug = &this->toolsDebug;

    this->sysman.isValidFlag = true;
    this->sysman.version = ZE_API_VERSION_1_12;
    this->sysman.Global = &this->sysmanGlobal;
    this->sysman.Device = &this->sysmanDevice;
    this->sysman.DeviceExp = &this->sysmanDeviceExp;
    this->sysman.Driver = &this->sysmanDriver;
    this->sysman.DriverExp = &this->sysmanDriverExp;
    this->sysman.Overclock = &this->sysmanOverclock;
    this->sysman.Scheduler = &this->sysmanScheduler;
    this->sysman.PerformanceFactor = &this->sysmanPerformanceFactor;
    this->sysman.Power = &this->sysmanPower;
    this->sysman.Frequency = &this->sysmanFrequency;
    this->sysman.Engine = &this->sysmanEngine;
    this->sysman.Standby = &this->sysmanStandby;
    this->sysman.Firmware = &this->sysmanFirmware;
    this->sysman.FirmwareExp = &this->sysmanFirmwareExp;
    this->sysman.Memory = &this->sysmanMemory;
    this->sysman.FabricPort = &this->sysmanFabricPort;
    this->sysman.Temperature = &this->sysmanTemperature;
    this->sysman.Psu = &this->sysmanPsu;
    this->sysman.Fan = &this->sysmanFan;
    this->sysman.Led = &this->sysmanLed;
    this->sysman.Ras = &this->sysmanRas;
    this->sysman.RasExp = &this->sysmanRasExp;
    this->sysman.Diagnostics = &this->sysmanDiagnostics;
    this->sysman.VFManagementExp = &this->sysmanVFManagementExp;

    this->runtime.isValidFlag = true;
    this->runtime.version = ZE_API_VERSION_1_14;
    this->runtime.Global = &this->runtimeGlobal;

    this->coreRTASBuilder.pfnCreateExt = L0::zeRTASBuilderCreateExt;
    this->coreRTASBuilder.pfnGetBuildPropertiesExt = L0::zeRTASBuilderGetBuildPropertiesExt;
    this->coreRTASBuilder.pfnBuildExt = L0::zeRTASBuilderBuildExt;
    this->coreRTASBuilder.pfnDestroyExt = L0::zeRTASBuilderDestroyExt;
    this->coreRTASBuilder.pfnCommandListAppendCopyExt = L0::zeRTASBuilderCommandListAppendCopyExt;
    this->coreRTASBuilderExp.pfnCreateExp = L0::zeRTASBuilderCreateExp;
    this->coreRTASBuilderExp.pfnGetBuildPropertiesExp = L0::zeRTASBuilderGetBuildPropertiesExp;
    this->coreRTASBuilderExp.pfnBuildExp = L0::zeRTASBuilderBuildExp;
    this->coreRTASBuilderExp.pfnDestroyExp = L0::zeRTASBuilderDestroyExp;
    this->coreRTASParallelOperationExp.pfnCreateExp = L0::zeRTASParallelOperationCreateExp;
    this->coreRTASParallelOperationExp.pfnGetPropertiesExp = L0::zeRTASParallelOperationGetPropertiesExp;
    this->coreRTASParallelOperationExp.pfnJoinExp = L0::zeRTASParallelOperationJoinExp;
    this->coreRTASParallelOperationExp.pfnDestroyExp = L0::zeRTASParallelOperationDestroyExp;
    this->coreRTASParallelOperation.pfnCreateExt = L0::zeRTASParallelOperationCreateExt;
    this->coreRTASParallelOperation.pfnGetPropertiesExt = L0::zeRTASParallelOperationGetPropertiesExt;
    this->coreRTASParallelOperation.pfnJoinExt = L0::zeRTASParallelOperationJoinExt;
    this->coreRTASParallelOperation.pfnDestroyExt = L0::zeRTASParallelOperationDestroyExt;
    this->coreGlobal.pfnInit = L0::zeInit;
    this->coreGlobal.pfnInitDrivers = L0::zeInitDrivers;
    this->coreDriver.pfnGet = L0::zeDriverGet;
    this->coreDriver.pfnGetApiVersion = L0::zeDriverGetApiVersion;
    this->coreDriver.pfnGetProperties = L0::zeDriverGetProperties;
    this->coreDriver.pfnGetIpcProperties = L0::zeDriverGetIpcProperties;
    this->coreDriver.pfnGetExtensionProperties = L0::zeDriverGetExtensionProperties;
    this->coreDriver.pfnGetExtensionFunctionAddress = L0::zeDriverGetExtensionFunctionAddress;
    this->coreDriver.pfnGetLastErrorDescription = L0::zeDriverGetLastErrorDescription;
    this->coreDriver.pfnRTASFormatCompatibilityCheckExt = L0::zeDriverRTASFormatCompatibilityCheckExt;
    this->coreDriver.pfnGetDefaultContext = L0::zeDriverGetDefaultContext;
    this->coreDriverExp.pfnRTASFormatCompatibilityCheckExp = L0::zeDriverRTASFormatCompatibilityCheckExp;
    this->coreDevice.pfnGet = L0::zeDeviceGet;
    this->coreDevice.pfnGetSubDevices = L0::zeDeviceGetSubDevices;
    this->coreDevice.pfnGetProperties = L0::zeDeviceGetProperties;
    this->coreDevice.pfnGetComputeProperties = L0::zeDeviceGetComputeProperties;
    this->coreDevice.pfnGetModuleProperties = L0::zeDeviceGetModuleProperties;
    this->coreDevice.pfnGetCommandQueueGroupProperties = L0::zeDeviceGetCommandQueueGroupProperties;
    this->coreDevice.pfnGetMemoryProperties = L0::zeDeviceGetMemoryProperties;
    this->coreDevice.pfnGetMemoryAccessProperties = L0::zeDeviceGetMemoryAccessProperties;
    this->coreDevice.pfnGetCacheProperties = L0::zeDeviceGetCacheProperties;
    this->coreDevice.pfnGetImageProperties = L0::zeDeviceGetImageProperties;
    this->coreDevice.pfnGetExternalMemoryProperties = L0::zeDeviceGetExternalMemoryProperties;
    this->coreDevice.pfnGetP2PProperties = L0::zeDeviceGetP2PProperties;
    this->coreDevice.pfnCanAccessPeer = L0::zeDeviceCanAccessPeer;
    this->coreDevice.pfnGetStatus = L0::zeDeviceGetStatus;
    this->coreDevice.pfnGetGlobalTimestamps = L0::zeDeviceGetGlobalTimestamps;
    this->coreDevice.pfnReserveCacheExt = L0::zeDeviceReserveCacheExt;
    this->coreDevice.pfnSetCacheAdviceExt = L0::zeDeviceSetCacheAdviceExt;
    this->coreDevice.pfnPciGetPropertiesExt = L0::zeDevicePciGetPropertiesExt;
    this->coreDevice.pfnGetRootDevice = L0::zeDeviceGetRootDevice;
    this->coreDevice.pfnImportExternalSemaphoreExt = L0::zeDeviceImportExternalSemaphoreExt;
    this->coreDevice.pfnReleaseExternalSemaphoreExt = L0::zeDeviceReleaseExternalSemaphoreExt;
    this->coreDevice.pfnGetVectorWidthPropertiesExt = L0::zeDeviceGetVectorWidthPropertiesExt;
    this->coreDevice.pfnSynchronize = L0::zeDeviceSynchronize;
    this->coreDeviceExp.pfnGetFabricVertexExp = L0::zeDeviceGetFabricVertexExp;
    this->coreContext.pfnCreate = L0::zeContextCreate;
    this->coreContext.pfnDestroy = L0::zeContextDestroy;
    this->coreContext.pfnGetStatus = L0::zeContextGetStatus;
    this->coreContext.pfnSystemBarrier = L0::zeContextSystemBarrier;
    this->coreContext.pfnMakeMemoryResident = L0::zeContextMakeMemoryResident;
    this->coreContext.pfnEvictMemory = L0::zeContextEvictMemory;
    this->coreContext.pfnMakeImageResident = L0::zeContextMakeImageResident;
    this->coreContext.pfnEvictImage = L0::zeContextEvictImage;
    this->coreContext.pfnCreateEx = L0::zeContextCreateEx;
    this->coreCommandQueue.pfnCreate = L0::zeCommandQueueCreate;
    this->coreCommandQueue.pfnDestroy = L0::zeCommandQueueDestroy;
    this->coreCommandQueue.pfnExecuteCommandLists = L0::zeCommandQueueExecuteCommandLists;
    this->coreCommandQueue.pfnSynchronize = L0::zeCommandQueueSynchronize;
    this->coreCommandQueue.pfnGetOrdinal = L0::zeCommandQueueGetOrdinal;
    this->coreCommandQueue.pfnGetIndex = L0::zeCommandQueueGetIndex;
    this->coreCommandList.pfnCreate = L0::zeCommandListCreate;
    this->coreCommandList.pfnCreateImmediate = L0::zeCommandListCreateImmediate;
    this->coreCommandList.pfnDestroy = L0::zeCommandListDestroy;
    this->coreCommandList.pfnClose = L0::zeCommandListClose;
    this->coreCommandList.pfnReset = L0::zeCommandListReset;
    this->coreCommandList.pfnAppendWriteGlobalTimestamp = L0::zeCommandListAppendWriteGlobalTimestamp;
    this->coreCommandList.pfnAppendBarrier = L0::zeCommandListAppendBarrier;
    this->coreCommandList.pfnAppendMemoryRangesBarrier = L0::zeCommandListAppendMemoryRangesBarrier;
    this->coreCommandList.pfnAppendMemoryCopy = L0::zeCommandListAppendMemoryCopy;
    this->coreCommandList.pfnAppendMemoryFill = L0::zeCommandListAppendMemoryFill;
    this->coreCommandList.pfnAppendMemoryCopyRegion = L0::zeCommandListAppendMemoryCopyRegion;
    this->coreCommandList.pfnAppendMemoryCopyFromContext = L0::zeCommandListAppendMemoryCopyFromContext;
    this->coreCommandList.pfnAppendImageCopy = L0::zeCommandListAppendImageCopy;
    this->coreCommandList.pfnAppendImageCopyRegion = L0::zeCommandListAppendImageCopyRegion;
    this->coreCommandList.pfnAppendImageCopyToMemory = L0::zeCommandListAppendImageCopyToMemory;
    this->coreCommandList.pfnAppendImageCopyFromMemory = L0::zeCommandListAppendImageCopyFromMemory;
    this->coreCommandList.pfnAppendMemoryPrefetch = L0::zeCommandListAppendMemoryPrefetch;
    this->coreCommandList.pfnAppendMemAdvise = L0::zeCommandListAppendMemAdvise;
    this->coreCommandList.pfnAppendSignalEvent = L0::zeCommandListAppendSignalEvent;
    this->coreCommandList.pfnAppendWaitOnEvents = L0::zeCommandListAppendWaitOnEvents;
    this->coreCommandList.pfnAppendEventReset = L0::zeCommandListAppendEventReset;
    this->coreCommandList.pfnAppendQueryKernelTimestamps = L0::zeCommandListAppendQueryKernelTimestamps;
    this->coreCommandList.pfnAppendLaunchKernel = L0::zeCommandListAppendLaunchKernel;
    this->coreCommandList.pfnAppendLaunchCooperativeKernel = L0::zeCommandListAppendLaunchCooperativeKernel;
    this->coreCommandList.pfnAppendLaunchKernelIndirect = L0::zeCommandListAppendLaunchKernelIndirect;
    this->coreCommandList.pfnAppendLaunchMultipleKernelsIndirect = L0::zeCommandListAppendLaunchMultipleKernelsIndirect;
    this->coreCommandList.pfnAppendImageCopyToMemoryExt = L0::zeCommandListAppendImageCopyToMemoryExt;
    this->coreCommandList.pfnAppendImageCopyFromMemoryExt = L0::zeCommandListAppendImageCopyFromMemoryExt;
    this->coreCommandList.pfnHostSynchronize = L0::zeCommandListHostSynchronize;
    this->coreCommandList.pfnGetDeviceHandle = L0::zeCommandListGetDeviceHandle;
    this->coreCommandList.pfnGetContextHandle = L0::zeCommandListGetContextHandle;
    this->coreCommandList.pfnGetOrdinal = L0::zeCommandListGetOrdinal;
    this->coreCommandList.pfnImmediateGetIndex = L0::zeCommandListImmediateGetIndex;
    this->coreCommandList.pfnIsImmediate = L0::zeCommandListIsImmediate;
    this->coreCommandList.pfnAppendSignalExternalSemaphoreExt = L0::zeCommandListAppendSignalExternalSemaphoreExt;
    this->coreCommandList.pfnAppendWaitExternalSemaphoreExt = L0::zeCommandListAppendWaitExternalSemaphoreExt;
    this->coreCommandList.pfnAppendLaunchKernelWithParameters = L0::zeCommandListAppendLaunchKernelWithParameters;
    this->coreCommandList.pfnAppendLaunchKernelWithArguments = L0::zeCommandListAppendLaunchKernelWithArguments;
    this->coreCommandListExp.pfnCreateCloneExp = L0::zeCommandListCreateCloneExp;
    this->coreCommandListExp.pfnImmediateAppendCommandListsExp = L0::zeCommandListImmediateAppendCommandListsExp;
    this->coreCommandListExp.pfnGetNextCommandIdExp = L0::zeCommandListGetNextCommandIdExp;
    this->coreCommandListExp.pfnUpdateMutableCommandsExp = L0::zeCommandListUpdateMutableCommandsExp;
    this->coreCommandListExp.pfnUpdateMutableCommandSignalEventExp = L0::zeCommandListUpdateMutableCommandSignalEventExp;
    this->coreCommandListExp.pfnUpdateMutableCommandWaitEventsExp = L0::zeCommandListUpdateMutableCommandWaitEventsExp;
    this->coreCommandListExp.pfnGetNextCommandIdWithKernelsExp = L0::zeCommandListGetNextCommandIdWithKernelsExp;
    this->coreCommandListExp.pfnUpdateMutableCommandKernelsExp = L0::zeCommandListUpdateMutableCommandKernelsExp;
    this->coreImage.pfnGetProperties = L0::zeImageGetProperties;
    this->coreImage.pfnCreate = L0::zeImageCreate;
    this->coreImage.pfnDestroy = L0::zeImageDestroy;
    this->coreImage.pfnGetAllocPropertiesExt = L0::zeImageGetAllocPropertiesExt;
    this->coreImage.pfnViewCreateExt = L0::zeImageViewCreateExt;
    this->coreImageExp.pfnGetMemoryPropertiesExp = L0::zeImageGetMemoryPropertiesExp;
    this->coreImageExp.pfnViewCreateExp = L0::zeImageViewCreateExp;
    this->coreImageExp.pfnGetDeviceOffsetExp = L0::zeImageGetDeviceOffsetExp;
    this->coreMem.pfnAllocShared = L0::zeMemAllocShared;
    this->coreMem.pfnAllocDevice = L0::zeMemAllocDevice;
    this->coreMem.pfnAllocHost = L0::zeMemAllocHost;
    this->coreMem.pfnFree = L0::zeMemFree;
    this->coreMem.pfnGetAllocProperties = L0::zeMemGetAllocProperties;
    this->coreMem.pfnGetAddressRange = L0::zeMemGetAddressRange;
    this->coreMem.pfnGetIpcHandle = L0::zeMemGetIpcHandle;
    this->coreMem.pfnOpenIpcHandle = L0::zeMemOpenIpcHandle;
    this->coreMem.pfnCloseIpcHandle = L0::zeMemCloseIpcHandle;
    this->coreMem.pfnFreeExt = L0::zeMemFreeExt;
    this->coreMem.pfnPutIpcHandle = L0::zeMemPutIpcHandle;
    this->coreMem.pfnGetPitchFor2dImage = L0::zeMemGetPitchFor2dImage;
    this->coreMemExp.pfnGetIpcHandleFromFileDescriptorExp = L0::zeMemGetIpcHandleFromFileDescriptorExp;
    this->coreMemExp.pfnGetFileDescriptorFromIpcHandleExp = L0::zeMemGetFileDescriptorFromIpcHandleExp;
    this->coreMemExp.pfnSetAtomicAccessAttributeExp = L0::zeMemSetAtomicAccessAttributeExp;
    this->coreMemExp.pfnGetAtomicAccessAttributeExp = L0::zeMemGetAtomicAccessAttributeExp;
    this->coreFence.pfnCreate = L0::zeFenceCreate;
    this->coreFence.pfnDestroy = L0::zeFenceDestroy;
    this->coreFence.pfnHostSynchronize = L0::zeFenceHostSynchronize;
    this->coreFence.pfnQueryStatus = L0::zeFenceQueryStatus;
    this->coreFence.pfnReset = L0::zeFenceReset;
    this->coreEventPool.pfnCreate = L0::zeEventPoolCreate;
    this->coreEventPool.pfnDestroy = L0::zeEventPoolDestroy;
    this->coreEventPool.pfnGetIpcHandle = L0::zeEventPoolGetIpcHandle;
    this->coreEventPool.pfnOpenIpcHandle = L0::zeEventPoolOpenIpcHandle;
    this->coreEventPool.pfnCloseIpcHandle = L0::zeEventPoolCloseIpcHandle;
    this->coreEventPool.pfnPutIpcHandle = L0::zeEventPoolPutIpcHandle;
    this->coreEventPool.pfnGetContextHandle = L0::zeEventPoolGetContextHandle;
    this->coreEventPool.pfnGetFlags = L0::zeEventPoolGetFlags;
    this->coreEvent.pfnCreate = L0::zeEventCreate;
    this->coreEvent.pfnDestroy = L0::zeEventDestroy;
    this->coreEvent.pfnHostSignal = L0::zeEventHostSignal;
    this->coreEvent.pfnHostSynchronize = L0::zeEventHostSynchronize;
    this->coreEvent.pfnQueryStatus = L0::zeEventQueryStatus;
    this->coreEvent.pfnHostReset = L0::zeEventHostReset;
    this->coreEvent.pfnQueryKernelTimestamp = L0::zeEventQueryKernelTimestamp;
    this->coreEvent.pfnQueryKernelTimestampsExt = L0::zeEventQueryKernelTimestampsExt;
    this->coreEvent.pfnGetEventPool = L0::zeEventGetEventPool;
    this->coreEvent.pfnGetSignalScope = L0::zeEventGetSignalScope;
    this->coreEvent.pfnGetWaitScope = L0::zeEventGetWaitScope;
    this->coreEventExp.pfnQueryTimestampsExp = L0::zeEventQueryTimestampsExp;
    this->coreModule.pfnCreate = L0::zeModuleCreate;
    this->coreModule.pfnDestroy = L0::zeModuleDestroy;
    this->coreModule.pfnDynamicLink = L0::zeModuleDynamicLink;
    this->coreModule.pfnGetNativeBinary = L0::zeModuleGetNativeBinary;
    this->coreModule.pfnGetGlobalPointer = L0::zeModuleGetGlobalPointer;
    this->coreModule.pfnGetKernelNames = L0::zeModuleGetKernelNames;
    this->coreModule.pfnGetProperties = L0::zeModuleGetProperties;
    this->coreModule.pfnGetFunctionPointer = L0::zeModuleGetFunctionPointer;
    this->coreModule.pfnInspectLinkageExt = L0::zeModuleInspectLinkageExt;
    this->coreModuleBuildLog.pfnDestroy = L0::zeModuleBuildLogDestroy;
    this->coreModuleBuildLog.pfnGetString = L0::zeModuleBuildLogGetString;
    this->coreKernel.pfnCreate = L0::zeKernelCreate;
    this->coreKernel.pfnDestroy = L0::zeKernelDestroy;
    this->coreKernel.pfnSetCacheConfig = L0::zeKernelSetCacheConfig;
    this->coreKernel.pfnSetGroupSize = L0::zeKernelSetGroupSize;
    this->coreKernel.pfnSuggestGroupSize = L0::zeKernelSuggestGroupSize;
    this->coreKernel.pfnSuggestMaxCooperativeGroupCount = L0::zeKernelSuggestMaxCooperativeGroupCount;
    this->coreKernel.pfnSetArgumentValue = L0::zeKernelSetArgumentValue;
    this->coreKernel.pfnSetIndirectAccess = L0::zeKernelSetIndirectAccess;
    this->coreKernel.pfnGetIndirectAccess = L0::zeKernelGetIndirectAccess;
    this->coreKernel.pfnGetSourceAttributes = L0::zeKernelGetSourceAttributes;
    this->coreKernel.pfnGetProperties = L0::zeKernelGetProperties;
    this->coreKernel.pfnGetName = L0::zeKernelGetName;
    this->coreKernelExp.pfnSetGlobalOffsetExp = L0::zeKernelSetGlobalOffsetExp;
    this->coreKernelExp.pfnSchedulingHintExp = L0::zeKernelSchedulingHintExp;
    this->coreKernelExp.pfnGetBinaryExp = L0::zeKernelGetBinaryExp;
    this->coreKernelExp.pfnGetAllocationPropertiesExp = L0::zeKernelGetAllocationPropertiesExp;
    this->coreSampler.pfnCreate = L0::zeSamplerCreate;
    this->coreSampler.pfnDestroy = L0::zeSamplerDestroy;
    this->corePhysicalMem.pfnCreate = L0::zePhysicalMemCreate;
    this->corePhysicalMem.pfnDestroy = L0::zePhysicalMemDestroy;
    this->coreVirtualMem.pfnReserve = L0::zeVirtualMemReserve;
    this->coreVirtualMem.pfnFree = L0::zeVirtualMemFree;
    this->coreVirtualMem.pfnQueryPageSize = L0::zeVirtualMemQueryPageSize;
    this->coreVirtualMem.pfnMap = L0::zeVirtualMemMap;
    this->coreVirtualMem.pfnUnmap = L0::zeVirtualMemUnmap;
    this->coreVirtualMem.pfnSetAccessAttribute = L0::zeVirtualMemSetAccessAttribute;
    this->coreVirtualMem.pfnGetAccessAttribute = L0::zeVirtualMemGetAccessAttribute;
    this->coreFabricVertexExp.pfnGetExp = L0::zeFabricVertexGetExp;
    this->coreFabricVertexExp.pfnGetSubVerticesExp = L0::zeFabricVertexGetSubVerticesExp;
    this->coreFabricVertexExp.pfnGetPropertiesExp = L0::zeFabricVertexGetPropertiesExp;
    this->coreFabricVertexExp.pfnGetDeviceExp = L0::zeFabricVertexGetDeviceExp;
    this->coreFabricEdgeExp.pfnGetExp = L0::zeFabricEdgeGetExp;
    this->coreFabricEdgeExp.pfnGetVerticesExp = L0::zeFabricEdgeGetVerticesExp;
    this->coreFabricEdgeExp.pfnGetPropertiesExp = L0::zeFabricEdgeGetPropertiesExp;

    this->toolsMetricProgrammableExp.pfnGetExp = L0::zetMetricProgrammableGetExp;
    this->toolsMetricProgrammableExp.pfnGetPropertiesExp = L0::zetMetricProgrammableGetPropertiesExp;
    this->toolsMetricProgrammableExp.pfnGetParamInfoExp = L0::zetMetricProgrammableGetParamInfoExp;
    this->toolsMetricProgrammableExp.pfnGetParamValueInfoExp = L0::zetMetricProgrammableGetParamValueInfoExp;
    this->toolsMetricTracerExp.pfnCreateExp = L0::zetMetricTracerCreateExp;
    this->toolsMetricTracerExp.pfnDestroyExp = L0::zetMetricTracerDestroyExp;
    this->toolsMetricTracerExp.pfnEnableExp = L0::zetMetricTracerEnableExp;
    this->toolsMetricTracerExp.pfnDisableExp = L0::zetMetricTracerDisableExp;
    this->toolsMetricTracerExp.pfnReadDataExp = L0::zetMetricTracerReadDataExp;
    this->toolsMetricTracerExp.pfnDecodeExp = L0::zetMetricTracerDecodeExp;
    this->toolsMetricDecoderExp.pfnCreateExp = L0::zetMetricDecoderCreateExp;
    this->toolsMetricDecoderExp.pfnDestroyExp = L0::zetMetricDecoderDestroyExp;
    this->toolsMetricDecoderExp.pfnGetDecodableMetricsExp = L0::zetMetricDecoderGetDecodableMetricsExp;
    this->toolsDevice.pfnGetDebugProperties = L0::zetDeviceGetDebugProperties;
    this->toolsDeviceExp.pfnGetConcurrentMetricGroupsExp = L0::zetDeviceGetConcurrentMetricGroupsExp;
    this->toolsDeviceExp.pfnCreateMetricGroupsFromMetricsExp = L0::zetDeviceCreateMetricGroupsFromMetricsExp;
    this->toolsDeviceExp.pfnEnableMetricsExp = L0::zetDeviceEnableMetricsExp;
    this->toolsDeviceExp.pfnDisableMetricsExp = L0::zetDeviceDisableMetricsExp;
    this->toolsContext.pfnActivateMetricGroups = L0::zetContextActivateMetricGroups;
    this->toolsCommandList.pfnAppendMetricStreamerMarker = L0::zetCommandListAppendMetricStreamerMarker;
    this->toolsCommandList.pfnAppendMetricQueryBegin = L0::zetCommandListAppendMetricQueryBegin;
    this->toolsCommandList.pfnAppendMetricQueryEnd = L0::zetCommandListAppendMetricQueryEnd;
    this->toolsCommandList.pfnAppendMetricMemoryBarrier = L0::zetCommandListAppendMetricMemoryBarrier;
    this->toolsCommandListExp.pfnAppendMarkerExp = L0::zetCommandListAppendMarkerExp;
    this->toolsModule.pfnGetDebugInfo = L0::zetModuleGetDebugInfo;
    this->toolsKernel.pfnGetProfileInfo = L0::zetKernelGetProfileInfo;
    this->toolsMetric.pfnGet = L0::zetMetricGet;
    this->toolsMetric.pfnGetProperties = L0::zetMetricGetProperties;
    this->toolsMetricExp.pfnCreateFromProgrammableExp = L0::zetMetricCreateFromProgrammableExp;
    this->toolsMetricExp.pfnDestroyExp = L0::zetMetricDestroyExp;
    this->toolsMetricExp.pfnCreateFromProgrammableExp2 = L0::zetMetricCreateFromProgrammableExp2;
    this->toolsMetricGroup.pfnGet = L0::zetMetricGroupGet;
    this->toolsMetricGroup.pfnGetProperties = L0::zetMetricGroupGetProperties;
    this->toolsMetricGroup.pfnCalculateMetricValues = L0::zetMetricGroupCalculateMetricValues;
    this->toolsMetricGroupExp.pfnCalculateMultipleMetricValuesExp = L0::zetMetricGroupCalculateMultipleMetricValuesExp;
    this->toolsMetricGroupExp.pfnGetGlobalTimestampsExp = L0::zetMetricGroupGetGlobalTimestampsExp;
    this->toolsMetricGroupExp.pfnGetExportDataExp = L0::zetMetricGroupGetExportDataExp;
    this->toolsMetricGroupExp.pfnCalculateMetricExportDataExp = L0::zetMetricGroupCalculateMetricExportDataExp;
    this->toolsMetricGroupExp.pfnCreateExp = L0::zetMetricGroupCreateExp;
    this->toolsMetricGroupExp.pfnAddMetricExp = L0::zetMetricGroupAddMetricExp;
    this->toolsMetricGroupExp.pfnRemoveMetricExp = L0::zetMetricGroupRemoveMetricExp;
    this->toolsMetricGroupExp.pfnCloseExp = L0::zetMetricGroupCloseExp;
    this->toolsMetricGroupExp.pfnDestroyExp = L0::zetMetricGroupDestroyExp;
    this->toolsMetricStreamer.pfnOpen = L0::zetMetricStreamerOpen;
    this->toolsMetricStreamer.pfnClose = L0::zetMetricStreamerClose;
    this->toolsMetricStreamer.pfnReadData = L0::zetMetricStreamerReadData;
    this->toolsMetricQueryPool.pfnCreate = L0::zetMetricQueryPoolCreate;
    this->toolsMetricQueryPool.pfnDestroy = L0::zetMetricQueryPoolDestroy;
    this->toolsMetricQuery.pfnCreate = L0::zetMetricQueryCreate;
    this->toolsMetricQuery.pfnDestroy = L0::zetMetricQueryDestroy;
    this->toolsMetricQuery.pfnReset = L0::zetMetricQueryReset;
    this->toolsMetricQuery.pfnGetData = L0::zetMetricQueryGetData;
    this->toolsTracerExp.pfnCreate = L0::zetTracerExpCreate;
    this->toolsTracerExp.pfnDestroy = L0::zetTracerExpDestroy;
    this->toolsTracerExp.pfnSetPrologues = L0::zetTracerExpSetPrologues;
    this->toolsTracerExp.pfnSetEpilogues = L0::zetTracerExpSetEpilogues;
    this->toolsTracerExp.pfnSetEnabled = L0::zetTracerExpSetEnabled;
    this->toolsDebug.pfnAttach = L0::zetDebugAttach;
    this->toolsDebug.pfnDetach = L0::zetDebugDetach;
    this->toolsDebug.pfnReadEvent = L0::zetDebugReadEvent;
    this->toolsDebug.pfnAcknowledgeEvent = L0::zetDebugAcknowledgeEvent;
    this->toolsDebug.pfnInterrupt = L0::zetDebugInterrupt;
    this->toolsDebug.pfnResume = L0::zetDebugResume;
    this->toolsDebug.pfnReadMemory = L0::zetDebugReadMemory;
    this->toolsDebug.pfnWriteMemory = L0::zetDebugWriteMemory;
    this->toolsDebug.pfnGetRegisterSetProperties = L0::zetDebugGetRegisterSetProperties;
    this->toolsDebug.pfnReadRegisters = L0::zetDebugReadRegisters;
    this->toolsDebug.pfnWriteRegisters = L0::zetDebugWriteRegisters;
    this->toolsDebug.pfnGetThreadRegisterSetProperties = L0::zetDebugGetThreadRegisterSetProperties;

    this->sysmanGlobal.pfnInit = L0::zesInit;
    this->sysmanDevice.pfnGetProperties = L0::zesDeviceGetProperties;
    this->sysmanDevice.pfnGetState = L0::zesDeviceGetState;
    this->sysmanDevice.pfnReset = L0::zesDeviceReset;
    this->sysmanDevice.pfnProcessesGetState = L0::zesDeviceProcessesGetState;
    this->sysmanDevice.pfnPciGetProperties = L0::zesDevicePciGetProperties;
    this->sysmanDevice.pfnPciGetState = L0::zesDevicePciGetState;
    this->sysmanDevice.pfnPciGetBars = L0::zesDevicePciGetBars;
    this->sysmanDevice.pfnPciGetStats = L0::zesDevicePciGetStats;
    this->sysmanDevice.pfnEnumDiagnosticTestSuites = L0::zesDeviceEnumDiagnosticTestSuites;
    this->sysmanDevice.pfnEnumEngineGroups = L0::zesDeviceEnumEngineGroups;
    this->sysmanDevice.pfnEventRegister = L0::zesDeviceEventRegister;
    this->sysmanDevice.pfnEnumFabricPorts = L0::zesDeviceEnumFabricPorts;
    this->sysmanDevice.pfnEnumFans = L0::zesDeviceEnumFans;
    this->sysmanDevice.pfnEnumFirmwares = L0::zesDeviceEnumFirmwares;
    this->sysmanDevice.pfnEnumFrequencyDomains = L0::zesDeviceEnumFrequencyDomains;
    this->sysmanDevice.pfnEnumLeds = L0::zesDeviceEnumLeds;
    this->sysmanDevice.pfnEnumMemoryModules = L0::zesDeviceEnumMemoryModules;
    this->sysmanDevice.pfnEnumPerformanceFactorDomains = L0::zesDeviceEnumPerformanceFactorDomains;
    this->sysmanDevice.pfnEnumPowerDomains = L0::zesDeviceEnumPowerDomains;
    this->sysmanDevice.pfnGetCardPowerDomain = L0::zesDeviceGetCardPowerDomain;
    this->sysmanDevice.pfnEnumPsus = L0::zesDeviceEnumPsus;
    this->sysmanDevice.pfnEnumRasErrorSets = L0::zesDeviceEnumRasErrorSets;
    this->sysmanDevice.pfnEnumSchedulers = L0::zesDeviceEnumSchedulers;
    this->sysmanDevice.pfnEnumStandbyDomains = L0::zesDeviceEnumStandbyDomains;
    this->sysmanDevice.pfnEnumTemperatureSensors = L0::zesDeviceEnumTemperatureSensors;
    this->sysmanDevice.pfnEccAvailable = L0::zesDeviceEccAvailable;
    this->sysmanDevice.pfnEccConfigurable = L0::zesDeviceEccConfigurable;
    this->sysmanDevice.pfnGetEccState = L0::zesDeviceGetEccState;
    this->sysmanDevice.pfnSetEccState = L0::zesDeviceSetEccState;
    this->sysmanDevice.pfnGet = L0::zesDeviceGet;
    this->sysmanDevice.pfnSetOverclockWaiver = L0::zesDeviceSetOverclockWaiver;
    this->sysmanDevice.pfnGetOverclockDomains = L0::zesDeviceGetOverclockDomains;
    this->sysmanDevice.pfnGetOverclockControls = L0::zesDeviceGetOverclockControls;
    this->sysmanDevice.pfnResetOverclockSettings = L0::zesDeviceResetOverclockSettings;
    this->sysmanDevice.pfnReadOverclockState = L0::zesDeviceReadOverclockState;
    this->sysmanDevice.pfnEnumOverclockDomains = L0::zesDeviceEnumOverclockDomains;
    this->sysmanDevice.pfnResetExt = L0::zesDeviceResetExt;
    this->sysmanDeviceExp.pfnGetSubDevicePropertiesExp = L0::zesDeviceGetSubDevicePropertiesExp;
    this->sysmanDeviceExp.pfnEnumActiveVFExp = L0::zesDeviceEnumActiveVFExp;
    this->sysmanDeviceExp.pfnEnumEnabledVFExp = L0::zesDeviceEnumEnabledVFExp;
    this->sysmanDriver.pfnEventListen = L0::zesDriverEventListen;
    this->sysmanDriver.pfnEventListenEx = L0::zesDriverEventListenEx;
    this->sysmanDriver.pfnGet = L0::zesDriverGet;
    this->sysmanDriver.pfnGetExtensionProperties = L0::zesDriverGetExtensionProperties;
    this->sysmanDriver.pfnGetExtensionFunctionAddress = L0::zesDriverGetExtensionFunctionAddress;
    this->sysmanDriverExp.pfnGetDeviceByUuidExp = L0::zesDriverGetDeviceByUuidExp;
    this->sysmanOverclock.pfnGetDomainProperties = L0::zesOverclockGetDomainProperties;
    this->sysmanOverclock.pfnGetDomainVFProperties = L0::zesOverclockGetDomainVFProperties;
    this->sysmanOverclock.pfnGetDomainControlProperties = L0::zesOverclockGetDomainControlProperties;
    this->sysmanOverclock.pfnGetControlCurrentValue = L0::zesOverclockGetControlCurrentValue;
    this->sysmanOverclock.pfnGetControlPendingValue = L0::zesOverclockGetControlPendingValue;
    this->sysmanOverclock.pfnSetControlUserValue = L0::zesOverclockSetControlUserValue;
    this->sysmanOverclock.pfnGetControlState = L0::zesOverclockGetControlState;
    this->sysmanOverclock.pfnGetVFPointValues = L0::zesOverclockGetVFPointValues;
    this->sysmanOverclock.pfnSetVFPointValues = L0::zesOverclockSetVFPointValues;
    this->sysmanScheduler.pfnGetProperties = L0::zesSchedulerGetProperties;
    this->sysmanScheduler.pfnGetCurrentMode = L0::zesSchedulerGetCurrentMode;
    this->sysmanScheduler.pfnGetTimeoutModeProperties = L0::zesSchedulerGetTimeoutModeProperties;
    this->sysmanScheduler.pfnGetTimesliceModeProperties = L0::zesSchedulerGetTimesliceModeProperties;
    this->sysmanScheduler.pfnSetTimeoutMode = L0::zesSchedulerSetTimeoutMode;
    this->sysmanScheduler.pfnSetTimesliceMode = L0::zesSchedulerSetTimesliceMode;
    this->sysmanScheduler.pfnSetExclusiveMode = L0::zesSchedulerSetExclusiveMode;
    this->sysmanScheduler.pfnSetComputeUnitDebugMode = L0::zesSchedulerSetComputeUnitDebugMode;
    this->sysmanScheduler.pfnGetProperties = L0::zesSchedulerGetProperties;
    this->sysmanScheduler.pfnGetCurrentMode = L0::zesSchedulerGetCurrentMode;
    this->sysmanScheduler.pfnGetTimeoutModeProperties = L0::zesSchedulerGetTimeoutModeProperties;
    this->sysmanScheduler.pfnGetTimesliceModeProperties = L0::zesSchedulerGetTimesliceModeProperties;
    this->sysmanScheduler.pfnSetTimeoutMode = L0::zesSchedulerSetTimeoutMode;
    this->sysmanScheduler.pfnSetTimesliceMode = L0::zesSchedulerSetTimesliceMode;
    this->sysmanScheduler.pfnSetExclusiveMode = L0::zesSchedulerSetExclusiveMode;
    this->sysmanScheduler.pfnSetComputeUnitDebugMode = L0::zesSchedulerSetComputeUnitDebugMode;
    this->sysmanPerformanceFactor.pfnGetProperties = L0::zesPerformanceFactorGetProperties;
    this->sysmanPerformanceFactor.pfnGetConfig = L0::zesPerformanceFactorGetConfig;
    this->sysmanPerformanceFactor.pfnSetConfig = L0::zesPerformanceFactorSetConfig;
    this->sysmanPower.pfnGetProperties = L0::zesPowerGetProperties;
    this->sysmanPower.pfnGetEnergyCounter = L0::zesPowerGetEnergyCounter;
    this->sysmanPower.pfnGetLimits = L0::zesPowerGetLimits;
    this->sysmanPower.pfnSetLimits = L0::zesPowerSetLimits;
    this->sysmanPower.pfnGetEnergyThreshold = L0::zesPowerGetEnergyThreshold;
    this->sysmanPower.pfnSetEnergyThreshold = L0::zesPowerSetEnergyThreshold;
    this->sysmanPower.pfnGetLimitsExt = L0::zesPowerGetLimitsExt;
    this->sysmanPower.pfnSetLimitsExt = L0::zesPowerSetLimitsExt;
    this->sysmanPower.pfnGetEnergyCounter = L0::zesPowerGetEnergyCounter;
    this->sysmanPower.pfnGetLimits = L0::zesPowerGetLimits;
    this->sysmanPower.pfnSetLimits = L0::zesPowerSetLimits;
    this->sysmanPower.pfnGetEnergyThreshold = L0::zesPowerGetEnergyThreshold;
    this->sysmanPower.pfnSetEnergyThreshold = L0::zesPowerSetEnergyThreshold;
    this->sysmanPower.pfnGetLimitsExt = L0::zesPowerGetLimitsExt;
    this->sysmanPower.pfnSetLimitsExt = L0::zesPowerSetLimitsExt;
    this->sysmanPower.pfnGetEnergyCounter = L0::zesPowerGetEnergyCounter;
    this->sysmanPower.pfnGetLimits = L0::zesPowerGetLimits;
    this->sysmanPower.pfnSetLimits = L0::zesPowerSetLimits;
    this->sysmanPower.pfnGetEnergyThreshold = L0::zesPowerGetEnergyThreshold;
    this->sysmanPower.pfnSetEnergyThreshold = L0::zesPowerSetEnergyThreshold;
    this->sysmanPower.pfnGetLimitsExt = L0::zesPowerGetLimitsExt;
    this->sysmanPower.pfnSetLimitsExt = L0::zesPowerSetLimitsExt;
    this->sysmanFrequency.pfnGetProperties = L0::zesFrequencyGetProperties;
    this->sysmanFrequency.pfnGetAvailableClocks = L0::zesFrequencyGetAvailableClocks;
    this->sysmanFrequency.pfnGetRange = L0::zesFrequencyGetRange;
    this->sysmanFrequency.pfnSetRange = L0::zesFrequencySetRange;
    this->sysmanFrequency.pfnGetState = L0::zesFrequencyGetState;
    this->sysmanFrequency.pfnGetThrottleTime = L0::zesFrequencyGetThrottleTime;
    this->sysmanFrequency.pfnOcGetCapabilities = L0::zesFrequencyOcGetCapabilities;
    this->sysmanFrequency.pfnOcGetFrequencyTarget = L0::zesFrequencyOcGetFrequencyTarget;
    this->sysmanFrequency.pfnOcSetFrequencyTarget = L0::zesFrequencyOcSetFrequencyTarget;
    this->sysmanFrequency.pfnOcGetVoltageTarget = L0::zesFrequencyOcGetVoltageTarget;
    this->sysmanFrequency.pfnOcSetVoltageTarget = L0::zesFrequencyOcSetVoltageTarget;
    this->sysmanFrequency.pfnOcSetMode = L0::zesFrequencyOcSetMode;
    this->sysmanFrequency.pfnOcGetMode = L0::zesFrequencyOcGetMode;
    this->sysmanFrequency.pfnOcGetIccMax = L0::zesFrequencyOcGetIccMax;
    this->sysmanFrequency.pfnOcSetIccMax = L0::zesFrequencyOcSetIccMax;
    this->sysmanFrequency.pfnOcGetTjMax = L0::zesFrequencyOcGetTjMax;
    this->sysmanFrequency.pfnOcSetTjMax = L0::zesFrequencyOcSetTjMax;
    this->sysmanEngine.pfnGetProperties = L0::zesEngineGetProperties;
    this->sysmanEngine.pfnGetActivity = L0::zesEngineGetActivity;
    this->sysmanEngine.pfnGetActivityExt = L0::zesEngineGetActivityExt;
    this->sysmanStandby.pfnGetProperties = L0::zesStandbyGetProperties;
    this->sysmanStandby.pfnGetMode = L0::zesStandbyGetMode;
    this->sysmanStandby.pfnSetMode = L0::zesStandbySetMode;
    this->sysmanFirmware.pfnGetProperties = L0::zesFirmwareGetProperties;
    this->sysmanFirmware.pfnFlash = L0::zesFirmwareFlash;
    this->sysmanFirmware.pfnGetFlashProgress = L0::zesFirmwareGetFlashProgress;
    this->sysmanFirmware.pfnGetConsoleLogs = L0::zesFirmwareGetConsoleLogs;
    this->sysmanFirmwareExp.pfnGetSecurityVersionExp = L0::zesFirmwareGetSecurityVersionExp;
    this->sysmanFirmwareExp.pfnSetSecurityVersionExp = L0::zesFirmwareSetSecurityVersionExp;
    this->sysmanMemory.pfnGetProperties = L0::zesMemoryGetProperties;
    this->sysmanMemory.pfnGetState = L0::zesMemoryGetState;
    this->sysmanMemory.pfnGetBandwidth = L0::zesMemoryGetBandwidth;
    this->sysmanFabricPort.pfnGetProperties = L0::zesFabricPortGetProperties;
    this->sysmanFabricPort.pfnGetLinkType = L0::zesFabricPortGetLinkType;
    this->sysmanFabricPort.pfnGetConfig = L0::zesFabricPortGetConfig;
    this->sysmanFabricPort.pfnSetConfig = L0::zesFabricPortSetConfig;
    this->sysmanFabricPort.pfnGetState = L0::zesFabricPortGetState;
    this->sysmanFabricPort.pfnGetThroughput = L0::zesFabricPortGetThroughput;
    this->sysmanFabricPort.pfnGetFabricErrorCounters = L0::zesFabricPortGetFabricErrorCounters;
    this->sysmanFabricPort.pfnGetMultiPortThroughput = L0::zesFabricPortGetMultiPortThroughput;
    this->sysmanTemperature.pfnGetProperties = L0::zesTemperatureGetProperties;
    this->sysmanTemperature.pfnGetConfig = L0::zesTemperatureGetConfig;
    this->sysmanTemperature.pfnSetConfig = L0::zesTemperatureSetConfig;
    this->sysmanTemperature.pfnGetState = L0::zesTemperatureGetState;
    this->sysmanPsu.pfnGetProperties = L0::zesPsuGetProperties;
    this->sysmanPsu.pfnGetState = L0::zesPsuGetState;
    this->sysmanFan.pfnGetProperties = L0::zesFanGetProperties;
    this->sysmanFan.pfnGetConfig = L0::zesFanGetConfig;
    this->sysmanFan.pfnSetDefaultMode = L0::zesFanSetDefaultMode;
    this->sysmanFan.pfnSetFixedSpeedMode = L0::zesFanSetFixedSpeedMode;
    this->sysmanFan.pfnSetSpeedTableMode = L0::zesFanSetSpeedTableMode;
    this->sysmanFan.pfnGetState = L0::zesFanGetState;
    this->sysmanLed.pfnGetProperties = L0::zesLedGetProperties;
    this->sysmanLed.pfnGetState = L0::zesLedGetState;
    this->sysmanLed.pfnSetState = L0::zesLedSetState;
    this->sysmanLed.pfnSetColor = L0::zesLedSetColor;
    this->sysmanRas.pfnGetProperties = L0::zesRasGetProperties;
    this->sysmanRas.pfnGetConfig = L0::zesRasGetConfig;
    this->sysmanRas.pfnSetConfig = L0::zesRasSetConfig;
    this->sysmanRas.pfnGetState = L0::zesRasGetState;
    this->sysmanRasExp.pfnGetStateExp = L0::zesRasGetStateExp;
    this->sysmanRasExp.pfnClearStateExp = L0::zesRasClearStateExp;
    this->sysmanDiagnostics.pfnGetProperties = L0::zesDiagnosticsGetProperties;
    this->sysmanDiagnostics.pfnGetTests = L0::zesDiagnosticsGetTests;
    this->sysmanDiagnostics.pfnRunTests = L0::zesDiagnosticsRunTests;
    this->sysmanVFManagementExp.pfnGetVFPropertiesExp = L0::zesVFManagementGetVFPropertiesExp;
    this->sysmanVFManagementExp.pfnGetVFMemoryUtilizationExp = L0::zesVFManagementGetVFMemoryUtilizationExp;
    this->sysmanVFManagementExp.pfnGetVFEngineUtilizationExp = L0::zesVFManagementGetVFEngineUtilizationExp;
    this->sysmanVFManagementExp.pfnSetVFTelemetryModeExp = L0::zesVFManagementSetVFTelemetryModeExp;
    this->sysmanVFManagementExp.pfnSetVFTelemetrySamplingIntervalExp = L0::zesVFManagementSetVFTelemetrySamplingIntervalExp;
    this->sysmanVFManagementExp.pfnGetVFCapabilitiesExp = L0::zesVFManagementGetVFCapabilitiesExp;
    this->sysmanVFManagementExp.pfnGetVFMemoryUtilizationExp2 = L0::zesVFManagementGetVFMemoryUtilizationExp2;
    this->sysmanVFManagementExp.pfnGetVFEngineUtilizationExp2 = L0::zesVFManagementGetVFEngineUtilizationExp2;
    this->sysmanVFManagementExp.pfnGetVFCapabilitiesExp2 = L0::zesVFManagementGetVFCapabilitiesExp2;

    this->runtimeGlobal.pfnGetLastErrorDescription = L0::zerGetLastErrorDescription;
    this->runtimeGlobal.pfnTranslateDeviceHandleToIdentifier = L0::zerTranslateDeviceHandleToIdentifier;
    this->runtimeGlobal.pfnTranslateIdentifierToDeviceHandle = L0::zerTranslateIdentifierToDeviceHandle;
    this->runtimeGlobal.pfnGetDefaultContext = L0::zerGetDefaultContext;
}
} // namespace L0
