//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/filters/http/checksum/v3alpha/checksum.proto

package v3alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ChecksumConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ChecksumConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChecksumConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ChecksumConfigMultiError,
// or nil if none found.
func (m *ChecksumConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *ChecksumConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetChecksums() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChecksumConfigValidationError{
						field:  fmt.Sprintf("Checksums[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChecksumConfigValidationError{
						field:  fmt.Sprintf("Checksums[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChecksumConfigValidationError{
					field:  fmt.Sprintf("Checksums[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for RejectUnmatched

	if len(errors) > 0 {
		return ChecksumConfigMultiError(errors)
	}

	return nil
}

// ChecksumConfigMultiError is an error wrapping multiple validation errors
// returned by ChecksumConfig.ValidateAll() if the designated constraints
// aren't met.
type ChecksumConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChecksumConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChecksumConfigMultiError) AllErrors() []error { return m }

// ChecksumConfigValidationError is the validation error returned by
// ChecksumConfig.Validate if the designated constraints aren't met.
type ChecksumConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChecksumConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChecksumConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChecksumConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChecksumConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChecksumConfigValidationError) ErrorName() string { return "ChecksumConfigValidationError" }

// Error satisfies the builtin error interface
func (e ChecksumConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChecksumConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChecksumConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChecksumConfigValidationError{}

// Validate checks the field values on ChecksumConfig_Checksum with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ChecksumConfig_Checksum) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChecksumConfig_Checksum with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ChecksumConfig_ChecksumMultiError, or nil if none found.
func (m *ChecksumConfig_Checksum) ValidateAll() error {
	return m.validate(true)
}

func (m *ChecksumConfig_Checksum) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ChecksumConfig_Checksum_Sha256_Pattern.MatchString(m.GetSha256()) {
		err := ChecksumConfig_ChecksumValidationError{
			field:  "Sha256",
			reason: "value does not match regex pattern \"^[a-fA-F0-9]{64}\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.Matcher.(type) {
	case *ChecksumConfig_Checksum_PathMatcher:
		if v == nil {
			err := ChecksumConfig_ChecksumValidationError{
				field:  "Matcher",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if m.GetPathMatcher() == nil {
			err := ChecksumConfig_ChecksumValidationError{
				field:  "PathMatcher",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetPathMatcher()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChecksumConfig_ChecksumValidationError{
						field:  "PathMatcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChecksumConfig_ChecksumValidationError{
						field:  "PathMatcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetPathMatcher()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChecksumConfig_ChecksumValidationError{
					field:  "PathMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ChecksumConfig_ChecksumMultiError(errors)
	}

	return nil
}

// ChecksumConfig_ChecksumMultiError is an error wrapping multiple validation
// errors returned by ChecksumConfig_Checksum.ValidateAll() if the designated
// constraints aren't met.
type ChecksumConfig_ChecksumMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChecksumConfig_ChecksumMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChecksumConfig_ChecksumMultiError) AllErrors() []error { return m }

// ChecksumConfig_ChecksumValidationError is the validation error returned by
// ChecksumConfig_Checksum.Validate if the designated constraints aren't met.
type ChecksumConfig_ChecksumValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChecksumConfig_ChecksumValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChecksumConfig_ChecksumValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChecksumConfig_ChecksumValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChecksumConfig_ChecksumValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChecksumConfig_ChecksumValidationError) ErrorName() string {
	return "ChecksumConfig_ChecksumValidationError"
}

// Error satisfies the builtin error interface
func (e ChecksumConfig_ChecksumValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChecksumConfig_Checksum.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChecksumConfig_ChecksumValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChecksumConfig_ChecksumValidationError{}

var _ChecksumConfig_Checksum_Sha256_Pattern = regexp.MustCompile("^[a-fA-F0-9]{64}")
