
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kjsonutils_wrapper.h"

// Argument includes
#include <QString>
#include <qjsonobject.h>
#include <qjsonvalue.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJsonUtils_Type = nullptr;
static PyTypeObject *Sbk_KJsonUtils_TypeF(void)
{
    return _Sbk_KJsonUtils_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KJsonUtils_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KJsonUtils");
    return -1;
}

static PyObject *Sbk_KJsonUtilsFunc_readTranslatedString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "readTranslatedString", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:readTranslatedString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJsonUtils::readTranslatedString(QJsonObject,QString,const QString&=)->QString
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // readTranslatedString(QJsonObject,QString,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            overloadId = 0; // readTranslatedString(QJsonObject,QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "readTranslatedString", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "readTranslatedString", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);
            }
        }
        ::QJsonObject cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readTranslatedString(QJsonObject,QString,QString)
            QString cppResult = ::KJsonUtils::readTranslatedString(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KJsonUtilsFunc_readTranslatedValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "readTranslatedValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:readTranslatedValue", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KJsonUtils::readTranslatedValue(QJsonObject,QString,const QJsonValue&=)->QJsonValue
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // readTranslatedValue(QJsonObject,QString,QJsonValue)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QJsonValue_IDX]), (pyArgs[2])))) {
            overloadId = 0; // readTranslatedValue(QJsonObject,QString,QJsonValue)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "readTranslatedValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"defaultValue", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QJsonValue_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "readTranslatedValue", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX]);
            }
        }
        ::QJsonObject cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QJsonValue cppArg2_local = QJsonValue();
        ::QJsonValue *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // readTranslatedValue(QJsonObject,QString,QJsonValue)
            QJsonValue cppResult = ::KJsonUtils::readTranslatedValue(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QJsonValue_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KJsonUtils_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJsonUtils_methods[] = {
    {"readTranslatedString", reinterpret_cast<PyCFunction>(Sbk_KJsonUtilsFunc_readTranslatedString), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"readTranslatedValue", reinterpret_cast<PyCFunction>(Sbk_KJsonUtilsFunc_readTranslatedValue), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KJsonUtils_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJsonUtils_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJsonUtils_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJsonUtils_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJsonUtils_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJsonUtils_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJsonUtils_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJsonUtils_spec = {
    "1:KCoreAddons.KJsonUtils",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJsonUtils_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKJsonUtils_SignatureStrings[] = {
    "KCoreAddons.KJsonUtils.readTranslatedString(jo:QJsonObject,key:QString,defaultValue:QString=QString())->QString",
    "KCoreAddons.KJsonUtils.readTranslatedValue(jo:QJsonObject,key:QString,defaultValue:typing.Union[PySide6.QtCore.QJsonValue, PySide6.QtCore.QJsonValue.Type, QLatin1String, bool, PySide6.QtCore.QJsonArray, QJsonObject, QString, char*, double, int, qint64]=QJsonValue())->PySide6.QtCore.QJsonValue",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKJsonUtils_SignatureByteSize = 200;
static constexpr uint8_t KCoreAddonsKJsonUtils_SignatureBytes[200] = {
    0x78, 0xda, 0x8d, 0x90, 0x41, 0x0b, 0x82, 0x30, 0x1c, 0xc5, 0xef, 0x7e, 0x8a, 0x1d, 0x35, 0x6c,
    0x10, 0x84, 0x07, 0xc1, 0x40, 0xba, 0x65, 0x50, 0x43, 0xeb, 0x12, 0x1d, 0xa6, 0x5b, 0x35, 0x1b,
    0x9b, 0x6d, 0xf3, 0xb0, 0x6f, 0xdf, 0x34, 0xa5, 0x0e, 0x09, 0x5e, 0xb6, 0xf1, 0x7f, 0x6f, 0xef,
    0xf7, 0xf8, 0x67, 0x5b, 0xa9, 0x68, 0x4a, 0x88, 0x14, 0x1a, 0x66, 0x3b, 0x2d, 0xc5, 0xc9, 0x30,
    0xae, 0xa1, 0xa2, 0x98, 0x14, 0x0a, 0x0b, 0xcd, 0xb1, 0xa1, 0x24, 0x37, 0x8a, 0x89, 0xbb, 0x5f,
    0xcb, 0x18, 0x75, 0x96, 0x43, 0x59, 0xd3, 0xca, 0x84, 0x4f, 0x6a, 0x63, 0xf4, 0x91, 0x42, 0x42,
    0x6f, 0xb8, 0xe5, 0xe6, 0x8c, 0x79, 0x4b, 0xc7, 0x61, 0x32, 0xdc, 0x7e, 0x10, 0x2c, 0x37, 0xc3,
    0xdb, 0xcb, 0xe6, 0xf0, 0xfa, 0x98, 0xd9, 0x38, 0x63, 0x1b, 0x37, 0x83, 0x27, 0xc1, 0xa4, 0xb8,
    0x1c, 0x6d, 0xce, 0x08, 0x8d, 0x20, 0x32, 0x1d, 0x08, 0xf6, 0x01, 0xbd, 0x2d, 0x04, 0x93, 0x12,
    0x2c, 0x6c, 0xe3, 0x74, 0xb4, 0xc7, 0x86, 0x89, 0xd5, 0x80, 0x00, 0xa5, 0x94, 0xfc, 0xff, 0xa7,
    0x54, 0x29, 0x6c, 0x9d, 0xff, 0xa7, 0x1c, 0x18, 0x9b, 0x81, 0xea, 0x81, 0xd5, 0x22, 0x04, 0x44,
    0xb6, 0x25, 0x77, 0xa1, 0x4c, 0x38, 0xf1, 0xe5, 0xce, 0x68, 0x7d, 0x4d, 0xbe, 0xc8, 0x7e, 0x27,
    0x93, 0x85, 0xbc, 0x37, 0xb7, 0x68, 0x91, 0xe6
};
#endif

PyTypeObject *init_KCoreAddonsKJsonUtils(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX].type;

    Shiboken::AutoDecRef Sbk_KJsonUtils_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KJsonUtils_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJsonUtils",
        "KJsonUtils",
        &Sbk_KJsonUtils_spec,
        nullptr,
        Sbk_KJsonUtils_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KJsonUtils_Type; // references _Sbk_KJsonUtils_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKJsonUtils_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKJsonUtils_SignatureBytes, KCoreAddonsKJsonUtils_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJsonUtils_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKJsonUtils_IDX].type = pyType;



    return pyType;
}
