
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kfontaction_wrapper.h"

// Wrappers providing overrides
#include "kselectaction_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Argument includes
#include <QString>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFontAction_Type = nullptr;
static PyTypeObject *Sbk_KFontAction_TypeF(void)
{
    return _Sbk_KFontAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KFontActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KFontActionWrapper::KFontActionWrapper(::QObject * parent) : KFontAction(parent)
{
}

KFontActionWrapper::KFontActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KFontAction(icon, text, parent)
{
}

KFontActionWrapper::KFontActionWrapper(const ::QString & text, ::QObject * parent) : KFontAction(text, parent)
{
}

KFontActionWrapper::KFontActionWrapper(uint fontListCriteria, ::QObject * parent) : KFontAction(fontListCriteria, parent)
{
}

void KFontActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KFontAction", funcName, gil, pyOverride, event);
}

void KFontActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontAction", funcName, gil, pyOverride, signal);
}

::QWidget * KFontActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KFontAction::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KFontAction", funcName, gil, pyOverride, parent);
}

void KFontActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KFontAction", funcName, gil, pyOverride, event);
}

void KFontActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KFontAction", funcName, gil, pyOverride, widget);
}

void KFontActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontAction", funcName, gil, pyOverride, signal);
}

bool KFontActionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KFontAction", funcName, gil, pyOverride, event);
}

bool KFontActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KFontAction", funcName, gil, pyOverride, watched, event);
}

void KFontActionWrapper::insertAction(::QAction * before, ::QAction * action)
{
    static const char *funcName = "insertAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::insertAction(before, action);
    }
    KSelectActionWrapper::sbk_o_insertAction("KFontAction", funcName, gil, pyOverride, before, action);
}

::QAction * KFontActionWrapper::removeAction(::QAction * action)
{
    static const char *funcName = "removeAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::removeAction(action);
    }
    return KSelectActionWrapper::sbk_o_removeAction("KFontAction", funcName, gil, pyOverride, action);
}

void KFontActionWrapper::slotActionTriggered(::QAction * action)
{
    static const char *funcName = "slotActionTriggered";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::slotActionTriggered(action);
    }
    KSelectActionWrapper::sbk_o_slotActionTriggered("KFontAction", funcName, gil, pyOverride, action);
}

void KFontActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontAction_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KFontAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KFontActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KFontAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KFontActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KFontAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KFontActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KFontActionWrapper *>(this));
    }
    return KFontAction::qt_metacast(_clname);
}

KFontActionWrapper::~KFontActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KFontAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFontAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFontAction >()))
        return -1;

    KFontActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KFontAction", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KFontAction::KFontAction(QObject*)
    // 1: KFontAction::KFontAction(QIcon,QString,QObject*)
    // 2: KFontAction::KFontAction(QString,QObject*)
    // 3: KFontAction::KFontAction(uint,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 3; // KFontAction(uint,QObject*)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KFontAction(QIcon,QString,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KFontAction(QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 2; // KFontAction(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KFontAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KFontAction(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontAction(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KFontAction(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
        case 3: // KFontAction(uint fontListCriteria, QObject *parent)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontAction(uint,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KFontAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KFontActionFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KFontAction::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontActionFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // font()const
        QString cppResult = const_cast<const ::KFontAction *>(cppSelf)->font();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontActionFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontAction::setFont(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setFont(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFont(QString)
            cppSelf->setFont(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KFontAction_PropertyStrings[] = {
    "font::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFontAction_methods[] = {
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KFontActionFunc_createWidget), METH_O, nullptr},
    {"font", reinterpret_cast<PyCFunction>(Sbk_KFontActionFunc_font), METH_NOARGS, nullptr},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_KFontActionFunc_setFont), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KFontAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KFontAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KFontActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KFontAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFontAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFontAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KFontAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFontAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFontAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFontAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFontAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFontAction_spec = {
    "1:KWidgetsAddons.KFontAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFontAction_slots
};

} //extern "C"

static void *Sbk_KFontAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KFontAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KFontAction_PythonToCpp_KFontAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFontAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KFontAction_PythonToCpp_KFontAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFontAction_TypeF()))
        return KFontAction_PythonToCpp_KFontAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KFontAction_PTR_CppToPython_KFontAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KFontAction *>(const_cast<void *>(cppIn)), Sbk_KFontAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFontAction_SignatureStrings[] = {
    "3:KWidgetsAddons.KFontAction(self,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,font:QString=None)",
    "2:KWidgetsAddons.KFontAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,font:QString=None)",
    "1:KWidgetsAddons.KFontAction(self,text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,font:QString=None)",
    "0:KWidgetsAddons.KFontAction(self,fontListCriteria:uint,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,font:QString=None)",
    "KWidgetsAddons.KFontAction.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KFontAction.font(self)->QString",
    "KWidgetsAddons.KFontAction.setFont(self,family:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KFontAction_SignatureByteSize = 231;
static constexpr uint8_t KFontAction_SignatureBytes[231] = {
    0x78, 0xda, 0xad, 0x92, 0x4f, 0x6b, 0x02, 0x31, 0x10, 0xc5, 0xef, 0x7e, 0x8a, 0x1e, 0xbb, 0x25,
    0x0d, 0xb6, 0x42, 0x0f, 0x81, 0x16, 0x44, 0x50, 0xca, 0x96, 0x6a, 0x90, 0xe2, 0xa1, 0xf4, 0x10,
    0x37, 0xb3, 0x32, 0xb2, 0x4e, 0x96, 0x64, 0xa4, 0xe6, 0xdb, 0x1b, 0xff, 0x16, 0x0a, 0xeb, 0x5e,
    0xf6, 0x36, 0xbc, 0x99, 0x37, 0xbf, 0x37, 0x30, 0x03, 0x95, 0x2f, 0xd0, 0xae, 0x80, 0xc3, 0xd0,
    0x5a, 0x47, 0x41, 0xe6, 0x63, 0x47, 0x3c, 0x2c, 0x18, 0x1d, 0xdd, 0x07, 0xa8, 0x4a, 0x51, 0x1b,
    0x0f, 0xc4, 0x6a, 0x16, 0xe7, 0x68, 0xe1, 0x45, 0x6a, 0x1e, 0x39, 0x0f, 0x52, 0x4f, 0x97, 0x6b,
    0x28, 0x58, 0x3c, 0xa8, 0x1c, 0xe2, 0xaf, 0xf3, 0x76, 0x4a, 0x55, 0x7c, 0xfd, 0x74, 0x04, 0xa2,
    0x4c, 0x0b, 0x94, 0x9e, 0xb3, 0x47, 0x5a, 0x1d, 0x95, 0xac, 0xf7, 0xdc, 0x4a, 0xc1, 0xc2, 0x91,
    0xe2, 0x58, 0x27, 0x8f, 0xfc, 0xa2, 0x24, 0x7f, 0xff, 0x01, 0x27, 0x5b, 0x94, 0xfa, 0x3d, 0x0d,
    0x88, 0xbb, 0x7f, 0xe2, 0x0c, 0x77, 0x1b, 0x53, 0xff, 0x08, 0x86, 0xdd, 0x15, 0xd9, 0x49, 0xe0,
    0xa7, 0xd6, 0xc0, 0x9d, 0x23, 0xfb, 0xad, 0xc8, 0x83, 0xe9, 0x03, 0x03, 0x8f, 0x3c, 0x32, 0x78,
    0x34, 0x6a, 0x8b, 0xc4, 0x9d, 0xb0, 0x9b, 0xc9, 0xb2, 0xf0, 0x60, 0x18, 0x4e, 0xfd, 0x86, 0x87,
    0x38, 0x9b, 0xa5, 0x3e, 0x15, 0xd9, 0xe3, 0x5b, 0x63, 0xef, 0x16, 0xe9, 0x90, 0xeb, 0x48, 0x48,
    0x0b, 0xce, 0xf1, 0x6e, 0x8d, 0x07, 0xe0, 0xf1, 0xc5, 0x21, 0x4a, 0xb3, 0xc1, 0x2a, 0x5e, 0xae,
    0xca, 0x7a, 0x7b, 0x6f, 0x72, 0x07, 0xf1
};
#endif

PyTypeObject *init_KFontAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KFontAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]))));

    _Sbk_KFontAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFontAction",
        "KFontAction*",
        &Sbk_KFontAction_spec,
        &Shiboken::callCppDestructor< KFontAction >,
        Sbk_KFontAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KFontAction_Type; // references _Sbk_KFontAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFontAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFontAction_SignatureBytes, KFontAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFontAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KFontAction_PythonToCpp_KFontAction_PTR,
        is_KFontAction_PythonToCpp_KFontAction_PTR_Convertible,
        KFontAction_PTR_CppToPython_KFontAction);

    Shiboken::Conversions::registerConverterName(converter, "KFontAction");
    Shiboken::Conversions::registerConverterName(converter, "KFontAction*");
    Shiboken::Conversions::registerConverterName(converter, "KFontAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFontAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KFontActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KFontAction_TypeF(), &Sbk_KFontAction_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KFontAction::staticMetaObject, sizeof(KFontActionWrapper));

    return pyType;
}
