/* SavedSearchDBTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SavedSearchDBTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecSavedSearchRow ParamSpecSavedSearchRow;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _ParamSpecSavedSearchRow {
	GParamSpec parent_instance;
};

static gpointer saved_search_row_parent_class = NULL;
static gpointer saved_search_db_table_parent_class = NULL;
static SavedSearchDBTable* saved_search_db_table_instance;
static SavedSearchDBTable* saved_search_db_table_instance = NULL;

static void saved_search_row_finalize (SavedSearchRow * obj);
static GType saved_search_row_get_type_once (void);
static SavedSearchDBTable* saved_search_db_table_new (void);
static SavedSearchDBTable* saved_search_db_table_construct (GType object_type);
static void saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                          SavedSearchID* id,
                                          SearchCondition* condition,
                                          GError** error);
static void saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                            SavedSearchID* search_id,
                                                            GError** error);
static void saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                        const gchar* table_name,
                                                        SavedSearchID* search_id,
                                                        GError** error);
static GeeList* saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                                      SavedSearchID* search_id,
                                                      GError** error);
static void saved_search_db_table_finalize (DatabaseTable * obj);
static GType saved_search_db_table_get_type_once (void);

void
saved_search_id_init (SavedSearchID *self,
                      gint64 id)
{
	memset (self, 0, sizeof (SavedSearchID));
	(*self).id = id;
}

gboolean
saved_search_id_is_invalid (SavedSearchID *self)
{
	gboolean result;
	result = (*self).id == SAVED_SEARCH_ID_INVALID;
	return result;
}

gboolean
saved_search_id_is_valid (SavedSearchID *self)
{
	gboolean result;
	result = (*self).id != SAVED_SEARCH_ID_INVALID;
	return result;
}

SavedSearchID*
saved_search_id_dup (const SavedSearchID* self)
{
	SavedSearchID* dup;
	dup = g_new0 (SavedSearchID, 1);
	memcpy (dup, self, sizeof (SavedSearchID));
	return dup;
}

void
saved_search_id_free (SavedSearchID* self)
{
	g_free (self);
}

static GType
saved_search_id_get_type_once (void)
{
	GType saved_search_id_type_id;
	saved_search_id_type_id = g_boxed_type_register_static ("SavedSearchID", (GBoxedCopyFunc) saved_search_id_dup, (GBoxedFreeFunc) saved_search_id_free);
	return saved_search_id_type_id;
}

GType
saved_search_id_get_type (void)
{
	static volatile gsize saved_search_id_type_id__once = 0;
	if (g_once_init_enter (&saved_search_id_type_id__once)) {
		GType saved_search_id_type_id;
		saved_search_id_type_id = saved_search_id_get_type_once ();
		g_once_init_leave (&saved_search_id_type_id__once, saved_search_id_type_id);
	}
	return saved_search_id_type_id__once;
}

SavedSearchRow*
saved_search_row_construct (GType object_type)
{
	SavedSearchRow* self = NULL;
	self = (SavedSearchRow*) g_type_create_instance (object_type);
	return self;
}

SavedSearchRow*
saved_search_row_new (void)
{
	return saved_search_row_construct (TYPE_SAVED_SEARCH_ROW);
}

static void
value_saved_search_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_saved_search_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		saved_search_row_unref (value->data[0].v_pointer);
	}
}

static void
value_saved_search_row_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = saved_search_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_saved_search_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_saved_search_row_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SavedSearchRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = saved_search_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_saved_search_row_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SavedSearchRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = saved_search_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_saved_search_row (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSavedSearchRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_saved_search_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_saved_search_row (GValue* value,
                            gpointer v_object)
{
	SavedSearchRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		saved_search_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_row_unref (old);
	}
}

void
value_take_saved_search_row (GValue* value,
                             gpointer v_object)
{
	SavedSearchRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_row_unref (old);
	}
}

static void
saved_search_row_class_init (SavedSearchRowClass * klass,
                             gpointer klass_data)
{
	saved_search_row_parent_class = g_type_class_peek_parent (klass);
	((SavedSearchRowClass *) klass)->finalize = saved_search_row_finalize;
}

static void
saved_search_row_instance_init (SavedSearchRow * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
saved_search_row_finalize (SavedSearchRow * obj)
{
	SavedSearchRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_ROW, SavedSearchRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_object_unref0 (self->conditions);
}

static GType
saved_search_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_saved_search_row_init, value_saved_search_row_free_value, value_saved_search_row_copy_value, value_saved_search_row_peek_pointer, "p", value_saved_search_row_collect_value, "p", value_saved_search_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchRow), 0, (GInstanceInitFunc) saved_search_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType saved_search_row_type_id;
	saved_search_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return saved_search_row_type_id;
}

GType
saved_search_row_get_type (void)
{
	static volatile gsize saved_search_row_type_id__once = 0;
	if (g_once_init_enter (&saved_search_row_type_id__once)) {
		GType saved_search_row_type_id;
		saved_search_row_type_id = saved_search_row_get_type_once ();
		g_once_init_leave (&saved_search_row_type_id__once, saved_search_row_type_id);
	}
	return saved_search_row_type_id__once;
}

gpointer
saved_search_row_ref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
saved_search_row_unref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SAVED_SEARCH_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static SavedSearchDBTable*
saved_search_db_table_construct (GType object_type)
{
	SavedSearchDBTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_;
	sqlite3_stmt* _tmp15_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	sqlite3_stmt* _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3_stmt* _tmp20_;
	sqlite3_stmt* _tmp21_;
	self = (SavedSearchDBTable*) database_table_construct (object_type);
	database_table_set_table_name ((DatabaseTable*) self, "SavedSearchDBTable");
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable " "(" "id INTEGER PRIMARY KEY, " "name TEXT UNIQUE NOT NULL, " "operator TEXT NOT NULL" ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable", res);
	}
	_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Text " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "text TEXT" ")");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Text", res);
	}
	_tmp4_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_MediaType " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "type TEXT NOT_NULL" ")");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp4_;
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_MediaType", res);
	}
	_tmp6_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Flagged " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "flag_state TEXT NOT NULL" ")");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp6_;
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Flagged", res);
	}
	_tmp8_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Modified " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "modified_state TEXT NOT NULL" ")");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp8_;
	_tmp9_ = stmt;
	res = sqlite3_step (_tmp9_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Modified", res);
	}
	_tmp10_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Date " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "date_one INTEGER NOT_NULL, " "date_two INTEGER NOT_NULL" ")");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp10_;
	_tmp11_ = stmt;
	res = sqlite3_step (_tmp11_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Date", res);
	}
	_tmp12_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Date_Index " "ON SavedSearchDBTable_Date(search_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp12_;
	_tmp13_ = stmt;
	res = sqlite3_step (_tmp13_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Date_Index", res);
	}
	_tmp14_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Text_Index " "ON SavedSearchDBTable_Text(search_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp14_;
	_tmp15_ = stmt;
	res = sqlite3_step (_tmp15_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Text_Index", res);
	}
	_tmp16_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_MediaType_Index " "ON SavedSearchDBTable_MediaType(search_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp16_;
	_tmp17_ = stmt;
	res = sqlite3_step (_tmp17_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_MediaType_Index", res);
	}
	_tmp18_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Flagged_Index " "ON SavedSearchDBTable_Flagged(search_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp18_;
	_tmp19_ = stmt;
	res = sqlite3_step (_tmp19_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Flagged_Index", res);
	}
	_tmp20_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Modified_Index " "ON SavedSearchDBTable_Modified(search_id)");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp20_;
	_tmp21_ = stmt;
	res = sqlite3_step (_tmp21_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Modified_Index", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static SavedSearchDBTable*
saved_search_db_table_new (void)
{
	return saved_search_db_table_construct (TYPE_SAVED_SEARCH_DB_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

SavedSearchDBTable*
saved_search_db_table_get_instance (void)
{
	SavedSearchDBTable* _tmp0_;
	SavedSearchDBTable* _tmp2_;
	SavedSearchDBTable* _tmp3_;
	SavedSearchDBTable* result;
	_tmp0_ = saved_search_db_table_instance;
	if (_tmp0_ == NULL) {
		SavedSearchDBTable* _tmp1_;
		_tmp1_ = saved_search_db_table_new ();
		_database_table_unref0 (saved_search_db_table_instance);
		saved_search_db_table_instance = _tmp1_;
	}
	_tmp2_ = saved_search_db_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SavedSearchRow*
saved_search_db_table_add (SavedSearchDBTable* self,
                           const gchar* name,
                           SearchOperator operator,
                           GeeArrayList* conditions,
                           GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint res = 0;
	sqlite3_stmt* _tmp5_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp6_;
	SavedSearchRow* _tmp7_;
	sqlite3* _tmp8_;
	SavedSearchRow* _tmp9_;
	gchar* _tmp10_;
	SavedSearchRow* _tmp11_;
	SavedSearchRow* _tmp12_;
	GeeList* _tmp13_;
	GError* _inner_error0_ = NULL;
	SavedSearchRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (conditions != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_text (_tmp1_, 1, name);
	_tmp2_ = stmt;
	_tmp3_ = search_operator_to_string (operator);
	_tmp4_ = _tmp3_;
	database_table_bind_text (_tmp2_, 2, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("SavedSearchDBTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp6_ = saved_search_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = database_table_db;
	saved_search_id_init (&_tmp7_->search_id, sqlite3_last_insert_rowid (_tmp8_));
	_tmp9_ = row;
	_tmp10_ = g_strdup (name);
	_g_free0 (_tmp9_->name);
	_tmp9_->name = _tmp10_;
	_tmp11_ = row;
	_tmp11_->operator = operator;
	_tmp12_ = row;
	_tmp13_ = _g_object_ref0 ((GeeList*) conditions);
	_g_object_unref0 (_tmp12_->conditions);
	_tmp12_->conditions = _tmp13_;
	{
		GeeArrayList* _sc_list = NULL;
		gint _sc_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _sc_index = 0;
		_sc_list = conditions;
		_tmp14_ = _sc_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_sc_size = _tmp16_;
		_sc_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			SearchCondition* sc = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			SavedSearchRow* _tmp21_;
			SavedSearchID _tmp22_;
			SearchCondition* _tmp23_;
			_sc_index = _sc_index + 1;
			_tmp17_ = _sc_index;
			_tmp18_ = _sc_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _sc_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _sc_index);
			sc = (SearchCondition*) _tmp20_;
			_tmp21_ = row;
			_tmp22_ = _tmp21_->search_id;
			_tmp23_ = sc;
			saved_search_db_table_add_condition (self, &_tmp22_, _tmp23_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_search_condition_unref0 (sc);
					_saved_search_row_unref0 (row);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_search_condition_unref0 (sc);
					_saved_search_row_unref0 (row);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_search_condition_unref0 (sc);
		}
	}
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gpointer
_search_condition_ref0 (gpointer self)
{
	return self ? search_condition_ref (self) : NULL;
}

static void
saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                     SavedSearchID* id,
                                     SearchCondition* condition,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (condition != NULL);
	if (IS_SEARCH_CONDITION_TEXT (condition)) {
		SearchConditionText* text = NULL;
		SearchConditionText* _tmp0_;
		sqlite3_stmt* stmt = NULL;
		sqlite3_stmt* _tmp1_;
		sqlite3_stmt* _tmp2_;
		SavedSearchID _tmp3_;
		sqlite3_stmt* _tmp4_;
		SearchConditionText* _tmp5_;
		SearchConditionSearchType _tmp6_;
		SearchConditionSearchType _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		sqlite3_stmt* _tmp10_;
		SearchConditionText* _tmp11_;
		SearchConditionTextContext _tmp12_;
		SearchConditionTextContext _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		sqlite3_stmt* _tmp16_;
		SearchConditionText* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gint res = 0;
		sqlite3_stmt* _tmp20_;
		_tmp0_ = _search_condition_ref0 (IS_SEARCH_CONDITION_TEXT (condition) ? ((SearchConditionText*) condition) : NULL);
		text = _tmp0_;
		_tmp1_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable_Text (search_id, search_type, context, " "text) VALUES (?, ?, ?, ?)");
		stmt = _tmp1_;
		_tmp2_ = stmt;
		_tmp3_ = *id;
		database_table_bind_int64 (_tmp2_, 1, _tmp3_.id);
		_tmp4_ = stmt;
		_tmp5_ = text;
		_tmp6_ = search_condition_get_search_type ((SearchCondition*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = search_condition_search_type_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		database_table_bind_text (_tmp4_, 2, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = stmt;
		_tmp11_ = text;
		_tmp12_ = search_condition_text_get_context (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = search_condition_text_context_to_string (_tmp13_);
		_tmp15_ = _tmp14_;
		database_table_bind_text (_tmp10_, 3, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = stmt;
		_tmp17_ = text;
		_tmp18_ = search_condition_text_get_text (_tmp17_);
		_tmp19_ = _tmp18_;
		database_table_bind_text (_tmp16_, 4, _tmp19_);
		_tmp20_ = stmt;
		res = sqlite3_step (_tmp20_);
		if (res != SQLITE_DONE) {
			database_table_throw_error ("SavedSearchDBTable_Text.add", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (text);
					return;
				} else {
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (text);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		_sqlite3_finalize0 (stmt);
		_search_condition_unref0 (text);
	} else {
		if (IS_SEARCH_CONDITION_MEDIA_TYPE (condition)) {
			SearchConditionMediaType* media_type = NULL;
			SearchConditionMediaType* _tmp21_;
			sqlite3_stmt* stmt = NULL;
			sqlite3_stmt* _tmp22_;
			sqlite3_stmt* _tmp23_;
			SavedSearchID _tmp24_;
			sqlite3_stmt* _tmp25_;
			SearchConditionMediaType* _tmp26_;
			SearchConditionSearchType _tmp27_;
			SearchConditionSearchType _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			sqlite3_stmt* _tmp31_;
			SearchConditionMediaType* _tmp32_;
			SearchConditionMediaTypeContext _tmp33_;
			SearchConditionMediaTypeContext _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			sqlite3_stmt* _tmp37_;
			SearchConditionMediaType* _tmp38_;
			SearchConditionMediaTypeMediaType _tmp39_;
			SearchConditionMediaTypeMediaType _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gint res = 0;
			sqlite3_stmt* _tmp43_;
			_tmp21_ = _search_condition_ref0 (IS_SEARCH_CONDITION_MEDIA_TYPE (condition) ? ((SearchConditionMediaType*) condition) : NULL);
			media_type = _tmp21_;
			_tmp22_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable_MediaType (search_id, search_type, cont" \
"ext, " "type) VALUES (?, ?, ?, ?)");
			stmt = _tmp22_;
			_tmp23_ = stmt;
			_tmp24_ = *id;
			database_table_bind_int64 (_tmp23_, 1, _tmp24_.id);
			_tmp25_ = stmt;
			_tmp26_ = media_type;
			_tmp27_ = search_condition_get_search_type ((SearchCondition*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = search_condition_search_type_to_string (_tmp28_);
			_tmp30_ = _tmp29_;
			database_table_bind_text (_tmp25_, 2, _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = stmt;
			_tmp32_ = media_type;
			_tmp33_ = search_condition_media_type_get_context (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = search_condition_media_type_context_to_string (_tmp34_);
			_tmp36_ = _tmp35_;
			database_table_bind_text (_tmp31_, 3, _tmp36_);
			_g_free0 (_tmp36_);
			_tmp37_ = stmt;
			_tmp38_ = media_type;
			_tmp39_ = search_condition_media_type_get_media_type (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = search_condition_media_type_media_type_to_string (_tmp40_);
			_tmp42_ = _tmp41_;
			database_table_bind_text (_tmp37_, 4, _tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = stmt;
			res = sqlite3_step (_tmp43_);
			if (res != SQLITE_DONE) {
				database_table_throw_error ("SavedSearchDBTable_MediaType.add", res, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (media_type);
						return;
					} else {
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (media_type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_sqlite3_finalize0 (stmt);
			_search_condition_unref0 (media_type);
		} else {
			if (IS_SEARCH_CONDITION_FLAGGED (condition)) {
				SearchConditionFlagged* flag_state = NULL;
				SearchConditionFlagged* _tmp44_;
				sqlite3_stmt* stmt = NULL;
				sqlite3_stmt* _tmp45_;
				sqlite3_stmt* _tmp46_;
				SavedSearchID _tmp47_;
				sqlite3_stmt* _tmp48_;
				SearchConditionFlagged* _tmp49_;
				SearchConditionSearchType _tmp50_;
				SearchConditionSearchType _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				sqlite3_stmt* _tmp54_;
				SearchConditionFlagged* _tmp55_;
				SearchConditionFlaggedState _tmp56_;
				SearchConditionFlaggedState _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gint res = 0;
				sqlite3_stmt* _tmp60_;
				_tmp44_ = _search_condition_ref0 (IS_SEARCH_CONDITION_FLAGGED (condition) ? ((SearchConditionFlagged*) condition) : NULL);
				flag_state = _tmp44_;
				_tmp45_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable_Flagged (search_id, search_type, " "flag_state) VALUES (?, ?, ?)");
				stmt = _tmp45_;
				_tmp46_ = stmt;
				_tmp47_ = *id;
				database_table_bind_int64 (_tmp46_, 1, _tmp47_.id);
				_tmp48_ = stmt;
				_tmp49_ = flag_state;
				_tmp50_ = search_condition_get_search_type ((SearchCondition*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = search_condition_search_type_to_string (_tmp51_);
				_tmp53_ = _tmp52_;
				database_table_bind_text (_tmp48_, 2, _tmp53_);
				_g_free0 (_tmp53_);
				_tmp54_ = stmt;
				_tmp55_ = flag_state;
				_tmp56_ = search_condition_flagged_get_state (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = search_condition_flagged_state_to_string (_tmp57_);
				_tmp59_ = _tmp58_;
				database_table_bind_text (_tmp54_, 3, _tmp59_);
				_g_free0 (_tmp59_);
				_tmp60_ = stmt;
				res = sqlite3_step (_tmp60_);
				if (res != SQLITE_DONE) {
					database_table_throw_error ("SavedSearchDBTable_Flagged.add", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_search_condition_unref0 (flag_state);
							return;
						} else {
							_sqlite3_finalize0 (stmt);
							_search_condition_unref0 (flag_state);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				_sqlite3_finalize0 (stmt);
				_search_condition_unref0 (flag_state);
			} else {
				if (IS_SEARCH_CONDITION_MODIFIED (condition)) {
					SearchConditionModified* modified_state = NULL;
					SearchConditionModified* _tmp61_;
					sqlite3_stmt* stmt = NULL;
					sqlite3_stmt* _tmp62_;
					sqlite3_stmt* _tmp63_;
					SavedSearchID _tmp64_;
					sqlite3_stmt* _tmp65_;
					SearchConditionModified* _tmp66_;
					SearchConditionSearchType _tmp67_;
					SearchConditionSearchType _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					sqlite3_stmt* _tmp71_;
					SearchConditionModified* _tmp72_;
					SearchConditionModifiedContext _tmp73_;
					SearchConditionModifiedContext _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					sqlite3_stmt* _tmp77_;
					SearchConditionModified* _tmp78_;
					SearchConditionModifiedState _tmp79_;
					SearchConditionModifiedState _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gint res = 0;
					sqlite3_stmt* _tmp83_;
					_tmp61_ = _search_condition_ref0 (IS_SEARCH_CONDITION_MODIFIED (condition) ? ((SearchConditionModified*) condition) : NULL);
					modified_state = _tmp61_;
					_tmp62_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable_Modified (search_id, search_type, conte" \
"xt, " "modified_state) VALUES (?, ?, ?, ?)");
					stmt = _tmp62_;
					_tmp63_ = stmt;
					_tmp64_ = *id;
					database_table_bind_int64 (_tmp63_, 1, _tmp64_.id);
					_tmp65_ = stmt;
					_tmp66_ = modified_state;
					_tmp67_ = search_condition_get_search_type ((SearchCondition*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = search_condition_search_type_to_string (_tmp68_);
					_tmp70_ = _tmp69_;
					database_table_bind_text (_tmp65_, 2, _tmp70_);
					_g_free0 (_tmp70_);
					_tmp71_ = stmt;
					_tmp72_ = modified_state;
					_tmp73_ = search_condition_modified_get_context (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = search_condition_modified_context_to_string (_tmp74_);
					_tmp76_ = _tmp75_;
					database_table_bind_text (_tmp71_, 3, _tmp76_);
					_g_free0 (_tmp76_);
					_tmp77_ = stmt;
					_tmp78_ = modified_state;
					_tmp79_ = search_condition_modified_get_state (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = search_condition_modified_state_to_string (_tmp80_);
					_tmp82_ = _tmp81_;
					database_table_bind_text (_tmp77_, 4, _tmp82_);
					_g_free0 (_tmp82_);
					_tmp83_ = stmt;
					res = sqlite3_step (_tmp83_);
					if (res != SQLITE_DONE) {
						database_table_throw_error ("SavedSearchDBTable_Modified.add", res, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == DATABASE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_sqlite3_finalize0 (stmt);
								_search_condition_unref0 (modified_state);
								return;
							} else {
								_sqlite3_finalize0 (stmt);
								_search_condition_unref0 (modified_state);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (modified_state);
				} else {
					if (IS_SEARCH_CONDITION_DATE (condition)) {
						SearchConditionDate* date = NULL;
						SearchConditionDate* _tmp84_;
						sqlite3_stmt* stmt = NULL;
						sqlite3_stmt* _tmp85_;
						sqlite3_stmt* _tmp86_;
						SavedSearchID _tmp87_;
						sqlite3_stmt* _tmp88_;
						SearchConditionDate* _tmp89_;
						SearchConditionSearchType _tmp90_;
						SearchConditionSearchType _tmp91_;
						gchar* _tmp92_;
						gchar* _tmp93_;
						sqlite3_stmt* _tmp94_;
						SearchConditionDate* _tmp95_;
						SearchConditionDateContext _tmp96_;
						SearchConditionDateContext _tmp97_;
						gchar* _tmp98_;
						gchar* _tmp99_;
						sqlite3_stmt* _tmp100_;
						SearchConditionDate* _tmp101_;
						GDateTime* _tmp102_;
						GDateTime* _tmp103_;
						sqlite3_stmt* _tmp104_;
						SearchConditionDate* _tmp105_;
						GDateTime* _tmp106_;
						GDateTime* _tmp107_;
						gint res = 0;
						sqlite3_stmt* _tmp108_;
						_tmp84_ = _search_condition_ref0 (IS_SEARCH_CONDITION_DATE (condition) ? ((SearchConditionDate*) condition) : NULL);
						date = _tmp84_;
						_tmp85_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable_Date (search_id, search_type, " "context, date_one, date_two) VALUES (?, ?, ?, ?, ?)");
						stmt = _tmp85_;
						_tmp86_ = stmt;
						_tmp87_ = *id;
						database_table_bind_int64 (_tmp86_, 1, _tmp87_.id);
						_tmp88_ = stmt;
						_tmp89_ = date;
						_tmp90_ = search_condition_get_search_type ((SearchCondition*) _tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = search_condition_search_type_to_string (_tmp91_);
						_tmp93_ = _tmp92_;
						database_table_bind_text (_tmp88_, 2, _tmp93_);
						_g_free0 (_tmp93_);
						_tmp94_ = stmt;
						_tmp95_ = date;
						_tmp96_ = search_condition_date_get_context (_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = search_condition_date_context_to_string (_tmp97_);
						_tmp99_ = _tmp98_;
						database_table_bind_text (_tmp94_, 3, _tmp99_);
						_g_free0 (_tmp99_);
						_tmp100_ = stmt;
						_tmp101_ = date;
						_tmp102_ = search_condition_date_get_date_one (_tmp101_);
						_tmp103_ = _tmp102_;
						database_table_bind_int64 (_tmp100_, 4, g_date_time_to_unix (_tmp103_));
						_tmp104_ = stmt;
						_tmp105_ = date;
						_tmp106_ = search_condition_date_get_date_two (_tmp105_);
						_tmp107_ = _tmp106_;
						database_table_bind_int64 (_tmp104_, 5, g_date_time_to_unix (_tmp107_));
						_tmp108_ = stmt;
						res = sqlite3_step (_tmp108_);
						if (res != SQLITE_DONE) {
							database_table_throw_error ("SavedSearchDBTable_Date.add", res, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == DATABASE_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_sqlite3_finalize0 (stmt);
									_search_condition_unref0 (date);
									return;
								} else {
									_sqlite3_finalize0 (stmt);
									_search_condition_unref0 (date);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
							}
						}
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (date);
					} else {
						g_assert_not_reached ();
					}
				}
			}
		}
	}
}

static void
saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                       SavedSearchID* search_id,
                                                       GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	SavedSearchID _tmp2_;
	SavedSearchID _tmp3_;
	SavedSearchID _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Text", &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_MediaType", &_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Flagged", &_tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Modified", &_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Date", &_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                   const gchar* table_name,
                                                   SavedSearchID* search_id,
                                                   GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	SavedSearchID _tmp5_;
	gint res = 0;
	sqlite3_stmt* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table_name != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = g_strdup_printf ("DELETE FROM %s WHERE search_id=?", table_name);
	_tmp1_ = _tmp0_;
	_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	stmt = _tmp3_;
	_tmp4_ = stmt;
	_tmp5_ = *search_id;
	database_table_bind_int64 (_tmp4_, 1, _tmp5_.id);
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = g_strdup_printf ("%s.remove", table_name);
		_tmp8_ = _tmp7_;
		database_table_throw_error (_tmp8_, res, &_inner_error0_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

static GeeList*
saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                             SavedSearchID* search_id,
                                             GError** error)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	SavedSearchID _tmp3_;
	sqlite3_stmt* _tmp15_;
	sqlite3_stmt* _tmp16_;
	SavedSearchID _tmp17_;
	sqlite3_stmt* _tmp29_;
	sqlite3_stmt* _tmp30_;
	SavedSearchID _tmp31_;
	sqlite3_stmt* _tmp41_;
	sqlite3_stmt* _tmp42_;
	SavedSearchID _tmp43_;
	sqlite3_stmt* _tmp55_;
	sqlite3_stmt* _tmp56_;
	SavedSearchID _tmp57_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SEARCH_CONDITION, (GBoxedCopyFunc) search_condition_ref, (GDestroyNotify) search_condition_unref, NULL, NULL, NULL);
	list = (GeeList*) _tmp0_;
	_tmp1_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT search_type, context, text FROM SavedSearchDBTable_Text " "WHERE search_id=?");
	stmt = _tmp1_;
	_tmp2_ = stmt;
	_tmp3_ = *search_id;
	database_table_bind_int64 (_tmp2_, 1, _tmp3_.id);
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp5_;
			SearchConditionText* condition = NULL;
			sqlite3_stmt* _tmp6_;
			const gchar* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			SearchConditionText* _tmp12_;
			GeeList* _tmp13_;
			SearchConditionText* _tmp14_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Text.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = stmt;
			_tmp7_ = (const gchar*) sqlite3_column_text (_tmp6_, 0);
			_tmp8_ = stmt;
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 2);
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
			_tmp12_ = search_condition_text_new (search_condition_search_type_from_string (_tmp7_), _tmp9_, search_condition_text_context_from_string (_tmp11_));
			condition = _tmp12_;
			_tmp13_ = list;
			_tmp14_ = condition;
			gee_collection_add ((GeeCollection*) _tmp13_, (SearchCondition*) _tmp14_);
			_search_condition_unref0 (condition);
		}
	}
	_tmp15_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT search_type, context, type FROM SavedSearchDBTable_MediaType " "WHERE search_id=?");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp15_;
	_tmp16_ = stmt;
	_tmp17_ = *search_id;
	database_table_bind_int64 (_tmp16_, 1, _tmp17_.id);
	{
		gboolean _tmp18_ = FALSE;
		_tmp18_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp19_;
			SearchConditionMediaType* condition = NULL;
			sqlite3_stmt* _tmp20_;
			const gchar* _tmp21_;
			sqlite3_stmt* _tmp22_;
			const gchar* _tmp23_;
			sqlite3_stmt* _tmp24_;
			const gchar* _tmp25_;
			SearchConditionMediaType* _tmp26_;
			GeeList* _tmp27_;
			SearchConditionMediaType* _tmp28_;
			if (!_tmp18_) {
			}
			_tmp18_ = FALSE;
			_tmp19_ = stmt;
			res = sqlite3_step (_tmp19_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_MediaType.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp20_ = stmt;
			_tmp21_ = (const gchar*) sqlite3_column_text (_tmp20_, 0);
			_tmp22_ = stmt;
			_tmp23_ = (const gchar*) sqlite3_column_text (_tmp22_, 1);
			_tmp24_ = stmt;
			_tmp25_ = (const gchar*) sqlite3_column_text (_tmp24_, 2);
			_tmp26_ = search_condition_media_type_new (search_condition_search_type_from_string (_tmp21_), search_condition_media_type_context_from_string (_tmp23_), search_condition_media_type_media_type_from_string (_tmp25_));
			condition = _tmp26_;
			_tmp27_ = list;
			_tmp28_ = condition;
			gee_collection_add ((GeeCollection*) _tmp27_, (SearchCondition*) _tmp28_);
			_search_condition_unref0 (condition);
		}
	}
	_tmp29_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT search_type, flag_state FROM SavedSearchDBTable_Flagged " "WHERE search_id=?");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp29_;
	_tmp30_ = stmt;
	_tmp31_ = *search_id;
	database_table_bind_int64 (_tmp30_, 1, _tmp31_.id);
	{
		gboolean _tmp32_ = FALSE;
		_tmp32_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp33_;
			SearchConditionFlagged* condition = NULL;
			sqlite3_stmt* _tmp34_;
			const gchar* _tmp35_;
			sqlite3_stmt* _tmp36_;
			const gchar* _tmp37_;
			SearchConditionFlagged* _tmp38_;
			GeeList* _tmp39_;
			SearchConditionFlagged* _tmp40_;
			if (!_tmp32_) {
			}
			_tmp32_ = FALSE;
			_tmp33_ = stmt;
			res = sqlite3_step (_tmp33_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Flagged.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp34_ = stmt;
			_tmp35_ = (const gchar*) sqlite3_column_text (_tmp34_, 0);
			_tmp36_ = stmt;
			_tmp37_ = (const gchar*) sqlite3_column_text (_tmp36_, 1);
			_tmp38_ = search_condition_flagged_new (search_condition_search_type_from_string (_tmp35_), search_condition_flagged_state_from_string (_tmp37_));
			condition = _tmp38_;
			_tmp39_ = list;
			_tmp40_ = condition;
			gee_collection_add ((GeeCollection*) _tmp39_, (SearchCondition*) _tmp40_);
			_search_condition_unref0 (condition);
		}
	}
	_tmp41_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT search_type, context, modified_state FROM SavedSearchDBTable_Mo" \
"dified " "WHERE search_id=?");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp41_;
	_tmp42_ = stmt;
	_tmp43_ = *search_id;
	database_table_bind_int64 (_tmp42_, 1, _tmp43_.id);
	{
		gboolean _tmp44_ = FALSE;
		_tmp44_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp45_;
			SearchConditionModified* condition = NULL;
			sqlite3_stmt* _tmp46_;
			const gchar* _tmp47_;
			sqlite3_stmt* _tmp48_;
			const gchar* _tmp49_;
			sqlite3_stmt* _tmp50_;
			const gchar* _tmp51_;
			SearchConditionModified* _tmp52_;
			GeeList* _tmp53_;
			SearchConditionModified* _tmp54_;
			if (!_tmp44_) {
			}
			_tmp44_ = FALSE;
			_tmp45_ = stmt;
			res = sqlite3_step (_tmp45_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Modified.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp46_ = stmt;
			_tmp47_ = (const gchar*) sqlite3_column_text (_tmp46_, 0);
			_tmp48_ = stmt;
			_tmp49_ = (const gchar*) sqlite3_column_text (_tmp48_, 1);
			_tmp50_ = stmt;
			_tmp51_ = (const gchar*) sqlite3_column_text (_tmp50_, 2);
			_tmp52_ = search_condition_modified_new (search_condition_search_type_from_string (_tmp47_), search_condition_modified_context_from_string (_tmp49_), search_condition_modified_state_from_string (_tmp51_));
			condition = _tmp52_;
			_tmp53_ = list;
			_tmp54_ = condition;
			gee_collection_add ((GeeCollection*) _tmp53_, (SearchCondition*) _tmp54_);
			_search_condition_unref0 (condition);
		}
	}
	_tmp55_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT search_type, context, date_one, date_two FROM SavedSearchDBTabl" \
"e_Date " "WHERE search_id=?");
	_sqlite3_finalize0 (stmt);
	stmt = _tmp55_;
	_tmp56_ = stmt;
	_tmp57_ = *search_id;
	database_table_bind_int64 (_tmp56_, 1, _tmp57_.id);
	{
		gboolean _tmp58_ = FALSE;
		_tmp58_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp59_;
			SearchConditionDate* condition = NULL;
			sqlite3_stmt* _tmp60_;
			const gchar* _tmp61_;
			sqlite3_stmt* _tmp62_;
			const gchar* _tmp63_;
			sqlite3_stmt* _tmp64_;
			GDateTime* _tmp65_;
			GDateTime* _tmp66_;
			sqlite3_stmt* _tmp67_;
			GDateTime* _tmp68_;
			GDateTime* _tmp69_;
			SearchConditionDate* _tmp70_;
			SearchConditionDate* _tmp71_;
			GeeList* _tmp72_;
			SearchConditionDate* _tmp73_;
			if (!_tmp58_) {
			}
			_tmp58_ = FALSE;
			_tmp59_ = stmt;
			res = sqlite3_step (_tmp59_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Date.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp60_ = stmt;
			_tmp61_ = (const gchar*) sqlite3_column_text (_tmp60_, 0);
			_tmp62_ = stmt;
			_tmp63_ = (const gchar*) sqlite3_column_text (_tmp62_, 1);
			_tmp64_ = stmt;
			_tmp65_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp64_, 2));
			_tmp66_ = _tmp65_;
			_tmp67_ = stmt;
			_tmp68_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp67_, 3));
			_tmp69_ = _tmp68_;
			_tmp70_ = search_condition_date_new (search_condition_search_type_from_string (_tmp61_), search_condition_date_context_from_string (_tmp63_), _tmp66_, _tmp69_);
			_tmp71_ = _tmp70_;
			_g_date_time_unref0 (_tmp69_);
			_g_date_time_unref0 (_tmp66_);
			condition = _tmp71_;
			_tmp72_ = list;
			_tmp73_ = condition;
			gee_collection_add ((GeeCollection*) _tmp72_, (SearchCondition*) _tmp73_);
			_search_condition_unref0 (condition);
		}
	}
	result = list;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                       SavedSearchRow* row,
                                       SavedSearchID* result,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint res = 0;
	sqlite3_stmt* _tmp6_;
	SavedSearchID search_id = {0};
	sqlite3* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = row->name;
	database_table_bind_text (_tmp1_, 1, _tmp2_);
	_tmp3_ = stmt;
	_tmp4_ = search_operator_to_string (row->operator);
	_tmp5_ = _tmp4_;
	database_table_bind_text (_tmp3_, 2, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("SavedSearchDBTable.create_from_row", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp7_ = database_table_db;
	saved_search_id_init (&search_id, sqlite3_last_insert_rowid (_tmp7_));
	{
		GeeList* _sc_list = NULL;
		GeeList* _tmp8_;
		gint _sc_size = 0;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _sc_index = 0;
		_tmp8_ = row->conditions;
		_sc_list = _tmp8_;
		_tmp9_ = _sc_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_sc_size = _tmp11_;
		_sc_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			SearchCondition* sc = NULL;
			GeeList* _tmp14_;
			gpointer _tmp15_;
			SavedSearchID _tmp16_;
			SearchCondition* _tmp17_;
			_sc_index = _sc_index + 1;
			_tmp12_ = _sc_index;
			_tmp13_ = _sc_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _sc_list;
			_tmp15_ = gee_list_get (_tmp14_, _sc_index);
			sc = (SearchCondition*) _tmp15_;
			_tmp16_ = search_id;
			_tmp17_ = sc;
			saved_search_db_table_add_condition (self, &_tmp16_, _tmp17_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_search_condition_unref0 (sc);
					_sqlite3_finalize0 (stmt);
					return;
				} else {
					_search_condition_unref0 (sc);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_search_condition_unref0 (sc);
		}
	}
	*result = search_id;
	_sqlite3_finalize0 (stmt);
	return;
}

void
saved_search_db_table_remove (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = *search_id;
	saved_search_db_table_remove_conditions_for_search_id (self, &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = *search_id;
	database_table_delete_by_id ((DatabaseTable*) self, _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

SavedSearchRow*
saved_search_db_table_get_row (SavedSearchDBTable* self,
                               SavedSearchID* search_id,
                               GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	SavedSearchID _tmp2_;
	gint res = 0;
	sqlite3_stmt* _tmp3_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp4_;
	SavedSearchRow* _tmp5_;
	SavedSearchID _tmp6_;
	SavedSearchRow* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	SavedSearchRow* _tmp11_;
	sqlite3_stmt* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	SavedSearchRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search_id != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT name, operator FROM SavedSearchDBTable WHERE id=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = *search_id;
	database_table_bind_int64 (_tmp1_, 1, _tmp2_.id);
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("SavedSearchDBTable.get_row", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp4_ = saved_search_row_new ();
	row = _tmp4_;
	_tmp5_ = row;
	_tmp6_ = *search_id;
	_tmp5_->search_id = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = stmt;
	_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 0);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp7_->name);
	_tmp7_->name = _tmp10_;
	_tmp11_ = row;
	_tmp12_ = stmt;
	_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 1);
	_tmp11_->operator = search_operator_from_string (_tmp13_);
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeList*
saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp1_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id, name, operator FROM SavedSearchDBTable");
	stmt = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_SAVED_SEARCH_ROW, (GBoxedCopyFunc) saved_search_row_ref, (GDestroyNotify) saved_search_row_unref, NULL, NULL, NULL);
	rows = (GeeList*) _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			SavedSearchRow* row = NULL;
			SavedSearchRow* _tmp4_;
			SavedSearchRow* _tmp5_;
			sqlite3_stmt* _tmp6_;
			SavedSearchRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			SavedSearchRow* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			GeeList* _tmp14_ = NULL;
			SavedSearchRow* _tmp15_;
			SavedSearchID _tmp16_;
			GeeList* _tmp17_;
			SavedSearchRow* _tmp18_;
			GeeList* _tmp19_;
			GeeList* _tmp20_;
			SavedSearchRow* _tmp21_;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = stmt;
			res = sqlite3_step (_tmp3_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp4_ = saved_search_row_new ();
			row = _tmp4_;
			_tmp5_ = row;
			_tmp6_ = stmt;
			saved_search_id_init (&_tmp5_->search_id, sqlite3_column_int64 (_tmp6_, 0));
			_tmp7_ = row;
			_tmp8_ = stmt;
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_tmp7_->name);
			_tmp7_->name = _tmp10_;
			_tmp11_ = row;
			_tmp12_ = stmt;
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 2);
			_tmp11_->operator = search_operator_from_string (_tmp13_);
			_tmp15_ = row;
			_tmp16_ = _tmp15_->search_id;
			_tmp17_ = saved_search_db_table_get_conditions_for_id (self, &_tmp16_, &_inner_error0_);
			_tmp14_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_saved_search_row_unref0 (row);
					_g_object_unref0 (rows);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_saved_search_row_unref0 (row);
					_g_object_unref0 (rows);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp18_ = row;
			_tmp19_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (_tmp18_->conditions);
			_tmp18_->conditions = _tmp19_;
			_tmp20_ = rows;
			_tmp21_ = row;
			gee_collection_add ((GeeCollection*) _tmp20_, _tmp21_);
			_g_object_unref0 (_tmp14_);
			_saved_search_row_unref0 (row);
		}
	}
	result = rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
saved_search_db_table_rename (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              const gchar* new_name,
                              GError** error)
{
	SavedSearchID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_id != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = *search_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "name", new_name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
saved_search_db_table_class_init (SavedSearchDBTableClass * klass,
                                  gpointer klass_data)
{
	saved_search_db_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = saved_search_db_table_finalize;
}

static void
saved_search_db_table_instance_init (SavedSearchDBTable * self,
                                     gpointer klass)
{
}

static void
saved_search_db_table_finalize (DatabaseTable * obj)
{
	SavedSearchDBTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable);
	DATABASE_TABLE_CLASS (saved_search_db_table_parent_class)->finalize (obj);
}

static GType
saved_search_db_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchDBTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_db_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchDBTable), 0, (GInstanceInitFunc) saved_search_db_table_instance_init, NULL };
	GType saved_search_db_table_type_id;
	saved_search_db_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "SavedSearchDBTable", &g_define_type_info, 0);
	return saved_search_db_table_type_id;
}

GType
saved_search_db_table_get_type (void)
{
	static volatile gsize saved_search_db_table_type_id__once = 0;
	if (g_once_init_enter (&saved_search_db_table_type_id__once)) {
		GType saved_search_db_table_type_id;
		saved_search_db_table_type_id = saved_search_db_table_get_type_once ();
		g_once_init_leave (&saved_search_db_table_type_id__once, saved_search_db_table_type_id);
	}
	return saved_search_db_table_type_id__once;
}

