// python wrapper for vtkPVFilePathEncodingHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVFilePathEncodingHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVFilePathEncodingHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVFilePathEncodingHelper_ClassNew(); }


static PyObject *
PyvtkPVFilePathEncodingHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVFilePathEncodingHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVFilePathEncodingHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVFilePathEncodingHelper *tempr = vtkPVFilePathEncodingHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVFilePathEncodingHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVFilePathEncodingHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVFilePathEncodingHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVFilePathEncodingHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_SetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPath(temp0);
    }
    else
    {
      op->vtkPVFilePathEncodingHelper::SetPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPath() :
      op->vtkPVFilePathEncodingHelper::GetPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_SetSecondaryPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSecondaryPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSecondaryPath(temp0);
    }
    else
    {
      op->vtkPVFilePathEncodingHelper::SetSecondaryPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetSecondaryPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSecondaryPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSecondaryPath() :
      op->vtkPVFilePathEncodingHelper::GetSecondaryPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetActiveGlobalId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveGlobalId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetActiveGlobalId() :
      op->vtkPVFilePathEncodingHelper::GetActiveGlobalId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_SetActiveGlobalId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveGlobalId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActiveGlobalId(temp0);
    }
    else
    {
      op->vtkPVFilePathEncodingHelper::SetActiveGlobalId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_MakeDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->MakeDirectory() :
      op->vtkPVFilePathEncodingHelper::MakeDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_DeleteDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeleteDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->DeleteDirectory() :
      op->vtkPVFilePathEncodingHelper::DeleteDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_OpenDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OpenDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->OpenDirectory() :
      op->vtkPVFilePathEncodingHelper::OpenDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_RenameDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenameDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->RenameDirectory() :
      op->vtkPVFilePathEncodingHelper::RenameDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_IsDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsDirectory() :
      op->vtkPVFilePathEncodingHelper::IsDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFilePathEncodingHelper_GetActiveFileIsReadable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveFileIsReadable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFilePathEncodingHelper *op = static_cast<vtkPVFilePathEncodingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetActiveFileIsReadable() :
      op->vtkPVFilePathEncodingHelper::GetActiveFileIsReadable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFilePathEncodingHelper_Methods[] = {
  {"IsTypeOf", PyvtkPVFilePathEncodingHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVFilePathEncodingHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVFilePathEncodingHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVFilePathEncodingHelper\nC++: static vtkPVFilePathEncodingHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVFilePathEncodingHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVFilePathEncodingHelper\nC++: vtkPVFilePathEncodingHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVFilePathEncodingHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVFilePathEncodingHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPath", PyvtkPVFilePathEncodingHelper_SetPath, METH_VARARGS,
   "SetPath(self, _arg:str) -> None\nC++: virtual void SetPath(const char *_arg)\n\nGet/Set the path that will be used by the helper\n"},
  {"GetPath", PyvtkPVFilePathEncodingHelper_GetPath, METH_VARARGS,
   "GetPath(self) -> str\nC++: virtual char *GetPath()\n\n"},
  {"SetSecondaryPath", PyvtkPVFilePathEncodingHelper_SetSecondaryPath, METH_VARARGS,
   "SetSecondaryPath(self, _arg:str) -> None\nC++: virtual void SetSecondaryPath(const char *_arg)\n\nGet/Set the secondary path that will potentially be used by the\nhelper\n"},
  {"GetSecondaryPath", PyvtkPVFilePathEncodingHelper_GetSecondaryPath, METH_VARARGS,
   "GetSecondaryPath(self) -> str\nC++: virtual char *GetSecondaryPath()\n\n"},
  {"GetActiveGlobalId", PyvtkPVFilePathEncodingHelper_GetActiveGlobalId, METH_VARARGS,
   "GetActiveGlobalId(self) -> int\nC++: virtual int GetActiveGlobalId()\n\nGet/Set the globalId of the vtkDirectory present of the server\nthat we will use to manipulate directories.\n"},
  {"SetActiveGlobalId", PyvtkPVFilePathEncodingHelper_SetActiveGlobalId, METH_VARARGS,
   "SetActiveGlobalId(self, _arg:int) -> None\nC++: virtual void SetActiveGlobalId(int _arg)\n\n"},
  {"MakeDirectory", PyvtkPVFilePathEncodingHelper_MakeDirectory, METH_VARARGS,
   "MakeDirectory(self) -> bool\nC++: bool MakeDirectory()\n\nCreate a directory named Path\n"},
  {"DeleteDirectory", PyvtkPVFilePathEncodingHelper_DeleteDirectory, METH_VARARGS,
   "DeleteDirectory(self) -> bool\nC++: bool DeleteDirectory()\n\nDelete a directory named Path\n"},
  {"OpenDirectory", PyvtkPVFilePathEncodingHelper_OpenDirectory, METH_VARARGS,
   "OpenDirectory(self) -> bool\nC++: bool OpenDirectory()\n\nOpen a directory named Path\n"},
  {"RenameDirectory", PyvtkPVFilePathEncodingHelper_RenameDirectory, METH_VARARGS,
   "RenameDirectory(self) -> bool\nC++: bool RenameDirectory()\n\nRename a directory named Path to SecondaryPath\n"},
  {"IsDirectory", PyvtkPVFilePathEncodingHelper_IsDirectory, METH_VARARGS,
   "IsDirectory(self) -> bool\nC++: bool IsDirectory()\n\nCheck is directory named Path exists.\n"},
  {"GetActiveFileIsReadable", PyvtkPVFilePathEncodingHelper_GetActiveFileIsReadable, METH_VARARGS,
   "GetActiveFileIsReadable(self) -> bool\nC++: bool GetActiveFileIsReadable()\n\nReturns if this->Path is a readable file.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVFilePathEncodingHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFilePathEncodingHelper_GetPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFilePathEncodingHelper_SetPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFilePathEncodingHelper_SetPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPath/SetPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("secondary_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFilePathEncodingHelper_GetSecondaryPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFilePathEncodingHelper_SetSecondaryPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFilePathEncodingHelper_SetSecondaryPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSecondaryPath/SetSecondaryPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_global_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFilePathEncodingHelper_GetActiveGlobalId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFilePathEncodingHelper_SetActiveGlobalId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFilePathEncodingHelper_SetActiveGlobalId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActiveGlobalId/SetActiveGlobalId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_file_is_readable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFilePathEncodingHelper_GetActiveFileIsReadable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveFileIsReadable\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVFilePathEncodingHelper_Doc =
  "vtkPVFilePathEncodingHelper - server side object used to check if\nmanipulate a directory\n\n"
  "Superclass: vtkObject\n\n"
  "Server side object to list, create and remove directory the main\n"
  "reason for this helper to exist is to convert the file path from utf8\n"
  "to locale encoding\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVFilePathEncodingHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVFilePathEncodingHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVFilePathEncodingHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVFilePathEncodingHelper_StaticNew()
{
  return vtkPVFilePathEncodingHelper::New();
}

PyObject *PyvtkPVFilePathEncodingHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVFilePathEncodingHelper_Type, PyvtkPVFilePathEncodingHelper_Methods,
    "vtkPVFilePathEncodingHelper",
 &PyvtkPVFilePathEncodingHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVFilePathEncodingHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVFilePathEncodingHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVFilePathEncodingHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVFilePathEncodingHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

