/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _XCOM_VP_H_RPCGEN
#define _XCOM_VP_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

/* Copyright (c) 2010, 2025, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#include "xcom/xcom_vp_platform.h"
#include "xcom/xcom_limits.h"
#include "xcom/xcom_profile.h"

enum xcom_proto {
	x_unknown_proto = 0,
	x_1_0 = 1,
	x_1_1 = 2,
	x_1_2 = 3,
	x_1_3 = 4,
	x_1_4 = 5,
	x_1_5 = 6,
	x_1_6 = 7,
	x_1_7 = 8,
	x_1_8 = 9,
	x_1_9 = 10
};
typedef enum xcom_proto xcom_proto;

enum delivery_status {
	delivery_ok = 0,
	delivery_failure = 1
};
typedef enum delivery_status delivery_status;

enum cons_type {
	cons_majority = 0,
	cons_all = 1
};
typedef enum cons_type cons_type;

enum cargo_type {
	unified_boot_type = 0,
	xcom_boot_type = 1,
	xcom_set_group = 2,
	app_type = 4,
	exit_type = 7,
	reset_type = 8,
	begin_trans = 9,
	prepared_trans = 10,
	abort_trans = 11,
	view_msg = 12,
	remove_reset_type = 13,
	add_node_type = 14,
	remove_node_type = 15,
	enable_arbitrator = 16,
	disable_arbitrator = 17,
	force_config_type = 18,
	x_terminate_and_exit = 19,
	set_cache_limit = 20,
	get_event_horizon_type = 21,
	set_event_horizon_type = 22,
	get_synode_app_data_type = 23,
	convert_into_local_server_type = 24,
	set_max_leaders = 25,
	set_leaders_type = 26,
	get_leaders_type = 27
};
typedef enum cargo_type cargo_type;

enum recover_action {
	rec_block = 0,
	rec_delay = 1,
	rec_send = 2
};
typedef enum recover_action recover_action;

enum pax_op {
	client_msg = 0,
	initial_op = 1,
	prepare_op = 2,
	ack_prepare_op = 3,
	ack_prepare_empty_op = 4,
	accept_op = 5,
	ack_accept_op = 6,
	learn_op = 7,
	recover_learn_op = 8,
	multi_prepare_op = 9,
	multi_ack_prepare_empty_op = 10,
	multi_accept_op = 11,
	multi_ack_accept_op = 12,
	multi_learn_op = 13,
	skip_op = 14,
	i_am_alive_op = 15,
	are_you_alive_op = 16,
	need_boot_op = 17,
	snapshot_op = 18,
	die_op = 19,
	read_op = 20,
	gcs_snapshot_op = 21,
	xcom_client_reply = 22,
	tiny_learn_op = 23,
	synode_request = 24,
	synode_allocated = 25,
	LAST_OP = 25 + 1
};
typedef enum pax_op pax_op;

enum pax_msg_type {
	normal = 0,
	no_op = 1,
	multi_no_op = 2
};
typedef enum pax_msg_type pax_msg_type;

enum client_reply_code {
	REQUEST_OK = 0,
	REQUEST_FAIL = 1,
	REQUEST_RETRY = 2,
	REQUEST_REDIRECT = 3
};
typedef enum client_reply_code client_reply_code;

enum start_t {
	IDLE = 0,
	BOOT = 1,
	RECOVER = 2
};
typedef enum start_t start_t;

typedef uint32_t xcom_event_horizon;

typedef uint32_t node_no;

typedef struct {
	u_int node_set_len;
	bool_t *node_set_val;
} node_set;

typedef uint32_t bit_mask;

struct bit_set {
	struct {
		u_int bits_len;
		bit_mask *bits_val;
	} bits;
};
typedef struct bit_set bit_set;
#define BITS_PER_BYTE 8
#define MASK_BITS ((bit_mask)(sizeof (bit_mask) * BITS_PER_BYTE)) /* bits per mask */
#define howmany_words(x, y) (((x)+((y)-1))/(y))

#define BIT_OP(__n, __p, __op, __inv) ((__p)->bits.bits_val[(__n)/MASK_BITS] __op __inv (1u << ((__n) % MASK_BITS)))
#define BIT_XOR(__n, __p) BIT_OP(__n, __p, ^=,(bit_mask))
#define BIT_SET(__n, __p) BIT_OP(__n, __p, |=,(bit_mask))
#define BIT_CLR(__n, __p) BIT_OP(__n, __p, &=,(bit_mask) ~)
#define BIT_ISSET(__n, __p) (BIT_OP(__n, __p, &,(bit_mask)) != 0ul)
#define BIT_ZERO(__p) memset((__p)->bits.bits_val, 0, (__p)->bits.bits_len * sizeof(*(__p)->bits.bits_val))
extern bit_set *new_bit_set(uint32_t bits);
extern bit_set *clone_bit_set(bit_set *orig);
extern void free_bit_set(bit_set *bs);
#ifndef CHECKED_DATA
#define CHECKED_DATA
typedef struct {
 u_int data_len;
 char *data_val;
} checked_data;
extern bool_t xdr_checked_data (XDR *, checked_data*);
#endif

struct blob {
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct blob blob;

struct x_proto_range {
	xcom_proto min_proto;
	xcom_proto max_proto;
};
typedef struct x_proto_range x_proto_range;

struct synode_no {
	uint32_t group_id;
	uint64_t msgno;
	node_no node;
};
typedef struct synode_no synode_no;

struct trans_id {
	synode_no cfg;
	uint32_t pc;
};
typedef struct trans_id trans_id;

enum paxos_role {
	P_PROP = 1,
	P_ACC = 2,
	P_LEARN = 4
};
typedef enum paxos_role paxos_role;

struct node_address {
	char *address;
	blob uuid;
	x_proto_range proto;
	uint32_t services;
};
typedef struct node_address node_address;

typedef struct {
	u_int node_list_len;
	node_address *node_list_val;
} node_list;

typedef struct {
	u_int node_no_array_len;
	node_no *node_no_array_val;
} node_no_array;

typedef struct {
	u_int synode_no_array_len;
	synode_no *synode_no_array_val;
} synode_no_array;

struct uncommitted_list {
	uint32_t active;
	synode_no_array vers;
};
typedef struct uncommitted_list uncommitted_list;

struct repository {
	synode_no vers;
	synode_no_array msg_list;
	uncommitted_list u_list;
};
typedef struct repository repository;

struct x_error {
	int32_t nodeid;
	int32_t code;
	char *message;
};
typedef struct x_error x_error;

struct trans_data {
	trans_id tid;
	int32_t pc;
	char *cluster_name;
	x_error errmsg;
};
typedef struct trans_data trans_data;

struct leader {
	char *address;
};
typedef struct leader leader;

typedef struct {
	u_int leader_array_len;
	leader *leader_array_val;
} leader_array;

struct app_u {
	cargo_type c_t;
	union {
		node_list nodes;
		checked_data data;
		trans_data td;
		node_set present;
		uint64_t cache_limit;
		xcom_event_horizon event_horizon;
		synode_no_array synodes;
		node_no max_leaders;
		leader_array leaders;
	} app_u_u;
};
typedef struct app_u app_u;

struct app_data {
	synode_no unique_id;
	uint32_t group_id;
	uint64_t lsn;
	synode_no app_key;
	cons_type consensus;
	double expiry_time;
	bool_t notused;
	bool_t log_it;
	bool_t chosen;
	recover_action recover;
	app_u body;
	struct app_data *next;
};
typedef struct app_data app_data;

typedef app_data *app_data_ptr;

typedef struct {
	u_int app_data_ptr_array_len;
	app_data_ptr *app_data_ptr_array_val;
} app_data_ptr_array;

typedef app_data_ptr *app_data_list;

struct key_range {
	synode_no k1;
	synode_no k2;
};
typedef struct key_range key_range;

struct ballot {
	int32_t cnt;
	node_no node;
};
typedef struct ballot ballot;

struct snapshot {
	synode_no vers;
	app_data_ptr_array snap;
	uncommitted_list u_list;
};
typedef struct snapshot snapshot;

struct config {
	synode_no start;
	synode_no boot_key;
	node_list nodes;
	node_set global_node_set;
	xcom_event_horizon event_horizon;
	node_no max_active_leaders;
	leader_array leaders;
};
typedef struct config config;

typedef config *config_ptr;

typedef struct {
	u_int configs_len;
	config_ptr *configs_val;
} configs;

struct gcs_snapshot {
	synode_no log_start;
	synode_no log_end;
	configs cfg;
	blob app_snap;
};
typedef struct gcs_snapshot gcs_snapshot;

struct synode_app_data {
	synode_no synode;
	checked_data data;
	synode_no origin;
};
typedef struct synode_app_data synode_app_data;

typedef struct {
	u_int synode_app_data_array_len;
	synode_app_data *synode_app_data_array_val;
} synode_app_data_array;

enum reply_type {
	leader_info = 0
};
typedef enum reply_type reply_type;

struct leader_info_data {
	node_no max_nr_leaders;
	leader_array preferred_leaders;
	leader_array actual_leaders;
};
typedef struct leader_info_data leader_info_data;

struct reply_data {
	reply_type rt;
	union {
		leader_info_data leaders;
	} reply_data_u;
};
typedef struct reply_data reply_data;

struct pax_msg {
	node_no to;
	node_no from;
	uint32_t group_id;
	synode_no max_synode;
	start_t start_type;
	ballot reply_to;
	ballot proposal;
	pax_op op;
	synode_no synode;
	pax_msg_type msg_type;
	bit_set *receivers;
	app_data *a;
	snapshot *snap;
	gcs_snapshot *gcs_snap;
	client_reply_code cli_err;
	bool_t force_delivery;
	int32_t refcnt;
	synode_no delivered_msg;
	xcom_event_horizon event_horizon;
	synode_app_data_array requested_synode_app_data;
	reply_data *rd;
};
typedef struct pax_msg pax_msg;
bool_t xdr_pax_msg_1_0(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_1(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_2(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_3(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_4(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_5(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_6(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_7(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_8(XDR *, pax_msg *);
bool_t xdr_pax_msg_1_9(XDR *, pax_msg *);
#ifdef __cplusplus
extern "C" void synthesize_leaders(leader_array *leaders);
extern "C" synode_no get_delivered_msg();
#else
extern void synthesize_leaders(leader_array *leaders);
extern synode_no get_delivered_msg();
#endif

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_xcom_proto (XDR *, xcom_proto*);
extern  bool_t xdr_delivery_status (XDR *, delivery_status*);
extern  bool_t xdr_cons_type (XDR *, cons_type*);
extern  bool_t xdr_cargo_type (XDR *, cargo_type*);
extern  bool_t xdr_recover_action (XDR *, recover_action*);
extern  bool_t xdr_pax_op (XDR *, pax_op*);
extern  bool_t xdr_pax_msg_type (XDR *, pax_msg_type*);
extern  bool_t xdr_client_reply_code (XDR *, client_reply_code*);
extern  bool_t xdr_start_t (XDR *, start_t*);
extern  bool_t xdr_xcom_event_horizon (XDR *, xcom_event_horizon*);
extern  bool_t xdr_node_no (XDR *, node_no*);
extern  bool_t xdr_node_set (XDR *, node_set*);
extern  bool_t xdr_bit_mask (XDR *, bit_mask*);
extern  bool_t xdr_bit_set (XDR *, bit_set*);
extern  bool_t xdr_blob (XDR *, blob*);
extern  bool_t xdr_x_proto_range (XDR *, x_proto_range*);
extern  bool_t xdr_synode_no (XDR *, synode_no*);
extern  bool_t xdr_trans_id (XDR *, trans_id*);
extern  bool_t xdr_paxos_role (XDR *, paxos_role*);
extern  bool_t xdr_node_address (XDR *, node_address*);
extern  bool_t xdr_node_list (XDR *, node_list*);
extern  bool_t xdr_node_no_array (XDR *, node_no_array*);
extern  bool_t xdr_synode_no_array (XDR *, synode_no_array*);
extern  bool_t xdr_uncommitted_list (XDR *, uncommitted_list*);
extern  bool_t xdr_repository (XDR *, repository*);
extern  bool_t xdr_x_error (XDR *, x_error*);
extern  bool_t xdr_trans_data (XDR *, trans_data*);
extern  bool_t xdr_leader (XDR *, leader*);
extern  bool_t xdr_leader_array (XDR *, leader_array*);
extern  bool_t xdr_app_u (XDR *, app_u*);
extern  bool_t xdr_app_data (XDR *, app_data*);
extern  bool_t xdr_app_data_ptr (XDR *, app_data_ptr*);
extern  bool_t xdr_app_data_ptr_array (XDR *, app_data_ptr_array*);
extern  bool_t xdr_app_data_list (XDR *, app_data_list*);
extern  bool_t xdr_key_range (XDR *, key_range*);
extern  bool_t xdr_ballot (XDR *, ballot*);
extern  bool_t xdr_snapshot (XDR *, snapshot*);
extern  bool_t xdr_config (XDR *, config*);
extern  bool_t xdr_config_ptr (XDR *, config_ptr*);
extern  bool_t xdr_configs (XDR *, configs*);
extern  bool_t xdr_gcs_snapshot (XDR *, gcs_snapshot*);
extern  bool_t xdr_synode_app_data (XDR *, synode_app_data*);
extern  bool_t xdr_synode_app_data_array (XDR *, synode_app_data_array*);
extern  bool_t xdr_reply_type (XDR *, reply_type*);
extern  bool_t xdr_leader_info_data (XDR *, leader_info_data*);
extern  bool_t xdr_reply_data (XDR *, reply_data*);
extern  bool_t xdr_pax_msg (XDR *, pax_msg*);

#else /* K&R C */
extern bool_t xdr_xcom_proto ();
extern bool_t xdr_delivery_status ();
extern bool_t xdr_cons_type ();
extern bool_t xdr_cargo_type ();
extern bool_t xdr_recover_action ();
extern bool_t xdr_pax_op ();
extern bool_t xdr_pax_msg_type ();
extern bool_t xdr_client_reply_code ();
extern bool_t xdr_start_t ();
extern bool_t xdr_xcom_event_horizon ();
extern bool_t xdr_node_no ();
extern bool_t xdr_node_set ();
extern bool_t xdr_bit_mask ();
extern bool_t xdr_bit_set ();
extern bool_t xdr_blob ();
extern bool_t xdr_x_proto_range ();
extern bool_t xdr_synode_no ();
extern bool_t xdr_trans_id ();
extern bool_t xdr_paxos_role ();
extern bool_t xdr_node_address ();
extern bool_t xdr_node_list ();
extern bool_t xdr_node_no_array ();
extern bool_t xdr_synode_no_array ();
extern bool_t xdr_uncommitted_list ();
extern bool_t xdr_repository ();
extern bool_t xdr_x_error ();
extern bool_t xdr_trans_data ();
extern bool_t xdr_leader ();
extern bool_t xdr_leader_array ();
extern bool_t xdr_app_u ();
extern bool_t xdr_app_data ();
extern bool_t xdr_app_data_ptr ();
extern bool_t xdr_app_data_ptr_array ();
extern bool_t xdr_app_data_list ();
extern bool_t xdr_key_range ();
extern bool_t xdr_ballot ();
extern bool_t xdr_snapshot ();
extern bool_t xdr_config ();
extern bool_t xdr_config_ptr ();
extern bool_t xdr_configs ();
extern bool_t xdr_gcs_snapshot ();
extern bool_t xdr_synode_app_data ();
extern bool_t xdr_synode_app_data_array ();
extern bool_t xdr_reply_type ();
extern bool_t xdr_leader_info_data ();
extern bool_t xdr_reply_data ();
extern bool_t xdr_pax_msg ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_XCOM_VP_H_RPCGEN */
