/*-------------------------------------------------------------------------
 *
 * pgstat_wait_event.c
 *    Generated wait events infrastructure code
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/backend/utils/activity/generate-wait_event_types.pl
 *
 *-------------------------------------------------------------------------
 */

static const char *
pgstat_get_wait_activity(WaitEventActivity w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_ARCHIVER_MAIN:
			 event_name = "ArchiverMain";
			 break;
		 case WAIT_EVENT_AUTOVACUUM_MAIN:
			 event_name = "AutovacuumMain";
			 break;
		 case WAIT_EVENT_BGWRITER_HIBERNATE:
			 event_name = "BgwriterHibernate";
			 break;
		 case WAIT_EVENT_BGWRITER_MAIN:
			 event_name = "BgwriterMain";
			 break;
		 case WAIT_EVENT_CHECKPOINTER_MAIN:
			 event_name = "CheckpointerMain";
			 break;
		 case WAIT_EVENT_CHECKPOINTER_SHUTDOWN:
			 event_name = "CheckpointerShutdown";
			 break;
		 case WAIT_EVENT_IO_WORKER_MAIN:
			 event_name = "IoWorkerMain";
			 break;
		 case WAIT_EVENT_LOGICAL_APPLY_MAIN:
			 event_name = "LogicalApplyMain";
			 break;
		 case WAIT_EVENT_LOGICAL_LAUNCHER_MAIN:
			 event_name = "LogicalLauncherMain";
			 break;
		 case WAIT_EVENT_LOGICAL_PARALLEL_APPLY_MAIN:
			 event_name = "LogicalParallelApplyMain";
			 break;
		 case WAIT_EVENT_RECOVERY_WAL_STREAM:
			 event_name = "RecoveryWalStream";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOTSYNC_MAIN:
			 event_name = "ReplicationSlotsyncMain";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOTSYNC_SHUTDOWN:
			 event_name = "ReplicationSlotsyncShutdown";
			 break;
		 case WAIT_EVENT_SYSLOGGER_MAIN:
			 event_name = "SysloggerMain";
			 break;
		 case WAIT_EVENT_WAL_RECEIVER_MAIN:
			 event_name = "WalReceiverMain";
			 break;
		 case WAIT_EVENT_WAL_SENDER_MAIN:
			 event_name = "WalSenderMain";
			 break;
		 case WAIT_EVENT_WAL_SUMMARIZER_WAL:
			 event_name = "WalSummarizerWal";
			 break;
		 case WAIT_EVENT_WAL_WRITER_MAIN:
			 event_name = "WalWriterMain";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

static const char *
pgstat_get_wait_bufferpin(WaitEventBufferPin w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_BUFFER_PIN:
			 event_name = "BufferPin";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

static const char *
pgstat_get_wait_client(WaitEventClient w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_CLIENT_READ:
			 event_name = "ClientRead";
			 break;
		 case WAIT_EVENT_CLIENT_WRITE:
			 event_name = "ClientWrite";
			 break;
		 case WAIT_EVENT_GSS_OPEN_SERVER:
			 event_name = "GssOpenServer";
			 break;
		 case WAIT_EVENT_LIBPQWALRECEIVER_CONNECT:
			 event_name = "LibpqwalreceiverConnect";
			 break;
		 case WAIT_EVENT_LIBPQWALRECEIVER_RECEIVE:
			 event_name = "LibpqwalreceiverReceive";
			 break;
		 case WAIT_EVENT_SSL_OPEN_SERVER:
			 event_name = "SslOpenServer";
			 break;
		 case WAIT_EVENT_WAIT_FOR_STANDBY_CONFIRMATION:
			 event_name = "WaitForStandbyConfirmation";
			 break;
		 case WAIT_EVENT_WAL_SENDER_WAIT_FOR_WAL:
			 event_name = "WalSenderWaitForWal";
			 break;
		 case WAIT_EVENT_WAL_SENDER_WRITE_DATA:
			 event_name = "WalSenderWriteData";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

static const char *
pgstat_get_wait_io(WaitEventIO w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_AIO_IO_COMPLETION:
			 event_name = "AioIoCompletion";
			 break;
		 case WAIT_EVENT_AIO_IO_URING_EXECUTION:
			 event_name = "AioIoUringExecution";
			 break;
		 case WAIT_EVENT_AIO_IO_URING_SUBMIT:
			 event_name = "AioIoUringSubmit";
			 break;
		 case WAIT_EVENT_BASEBACKUP_READ:
			 event_name = "BasebackupRead";
			 break;
		 case WAIT_EVENT_BASEBACKUP_SYNC:
			 event_name = "BasebackupSync";
			 break;
		 case WAIT_EVENT_BASEBACKUP_WRITE:
			 event_name = "BasebackupWrite";
			 break;
		 case WAIT_EVENT_BUFFILE_READ:
			 event_name = "BuffileRead";
			 break;
		 case WAIT_EVENT_BUFFILE_TRUNCATE:
			 event_name = "BuffileTruncate";
			 break;
		 case WAIT_EVENT_BUFFILE_WRITE:
			 event_name = "BuffileWrite";
			 break;
		 case WAIT_EVENT_CONTROL_FILE_READ:
			 event_name = "ControlFileRead";
			 break;
		 case WAIT_EVENT_CONTROL_FILE_SYNC:
			 event_name = "ControlFileSync";
			 break;
		 case WAIT_EVENT_CONTROL_FILE_SYNC_UPDATE:
			 event_name = "ControlFileSyncUpdate";
			 break;
		 case WAIT_EVENT_CONTROL_FILE_WRITE:
			 event_name = "ControlFileWrite";
			 break;
		 case WAIT_EVENT_CONTROL_FILE_WRITE_UPDATE:
			 event_name = "ControlFileWriteUpdate";
			 break;
		 case WAIT_EVENT_COPY_FILE_COPY:
			 event_name = "CopyFileCopy";
			 break;
		 case WAIT_EVENT_COPY_FILE_READ:
			 event_name = "CopyFileRead";
			 break;
		 case WAIT_EVENT_COPY_FILE_WRITE:
			 event_name = "CopyFileWrite";
			 break;
		 case WAIT_EVENT_DATA_FILE_EXTEND:
			 event_name = "DataFileExtend";
			 break;
		 case WAIT_EVENT_DATA_FILE_FLUSH:
			 event_name = "DataFileFlush";
			 break;
		 case WAIT_EVENT_DATA_FILE_IMMEDIATE_SYNC:
			 event_name = "DataFileImmediateSync";
			 break;
		 case WAIT_EVENT_DATA_FILE_PREFETCH:
			 event_name = "DataFilePrefetch";
			 break;
		 case WAIT_EVENT_DATA_FILE_READ:
			 event_name = "DataFileRead";
			 break;
		 case WAIT_EVENT_DATA_FILE_SYNC:
			 event_name = "DataFileSync";
			 break;
		 case WAIT_EVENT_DATA_FILE_TRUNCATE:
			 event_name = "DataFileTruncate";
			 break;
		 case WAIT_EVENT_DATA_FILE_WRITE:
			 event_name = "DataFileWrite";
			 break;
		 case WAIT_EVENT_DSM_ALLOCATE:
			 event_name = "DsmAllocate";
			 break;
		 case WAIT_EVENT_DSM_FILL_ZERO_WRITE:
			 event_name = "DsmFillZeroWrite";
			 break;
		 case WAIT_EVENT_LOCK_FILE_ADDTODATADIR_READ:
			 event_name = "LockFileAddtodatadirRead";
			 break;
		 case WAIT_EVENT_LOCK_FILE_ADDTODATADIR_SYNC:
			 event_name = "LockFileAddtodatadirSync";
			 break;
		 case WAIT_EVENT_LOCK_FILE_ADDTODATADIR_WRITE:
			 event_name = "LockFileAddtodatadirWrite";
			 break;
		 case WAIT_EVENT_LOCK_FILE_CREATE_READ:
			 event_name = "LockFileCreateRead";
			 break;
		 case WAIT_EVENT_LOCK_FILE_CREATE_SYNC:
			 event_name = "LockFileCreateSync";
			 break;
		 case WAIT_EVENT_LOCK_FILE_CREATE_WRITE:
			 event_name = "LockFileCreateWrite";
			 break;
		 case WAIT_EVENT_LOCK_FILE_RECHECKDATADIR_READ:
			 event_name = "LockFileRecheckdatadirRead";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_CHECKPOINT_SYNC:
			 event_name = "LogicalRewriteCheckpointSync";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_MAPPING_SYNC:
			 event_name = "LogicalRewriteMappingSync";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_MAPPING_WRITE:
			 event_name = "LogicalRewriteMappingWrite";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_SYNC:
			 event_name = "LogicalRewriteSync";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_TRUNCATE:
			 event_name = "LogicalRewriteTruncate";
			 break;
		 case WAIT_EVENT_LOGICAL_REWRITE_WRITE:
			 event_name = "LogicalRewriteWrite";
			 break;
		 case WAIT_EVENT_RELATION_MAP_READ:
			 event_name = "RelationMapRead";
			 break;
		 case WAIT_EVENT_RELATION_MAP_REPLACE:
			 event_name = "RelationMapReplace";
			 break;
		 case WAIT_EVENT_RELATION_MAP_WRITE:
			 event_name = "RelationMapWrite";
			 break;
		 case WAIT_EVENT_REORDER_BUFFER_READ:
			 event_name = "ReorderBufferRead";
			 break;
		 case WAIT_EVENT_REORDER_BUFFER_WRITE:
			 event_name = "ReorderBufferWrite";
			 break;
		 case WAIT_EVENT_REORDER_LOGICAL_MAPPING_READ:
			 event_name = "ReorderLogicalMappingRead";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOT_READ:
			 event_name = "ReplicationSlotRead";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOT_RESTORE_SYNC:
			 event_name = "ReplicationSlotRestoreSync";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOT_SYNC:
			 event_name = "ReplicationSlotSync";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOT_WRITE:
			 event_name = "ReplicationSlotWrite";
			 break;
		 case WAIT_EVENT_SLRU_FLUSH_SYNC:
			 event_name = "SlruFlushSync";
			 break;
		 case WAIT_EVENT_SLRU_READ:
			 event_name = "SlruRead";
			 break;
		 case WAIT_EVENT_SLRU_SYNC:
			 event_name = "SlruSync";
			 break;
		 case WAIT_EVENT_SLRU_WRITE:
			 event_name = "SlruWrite";
			 break;
		 case WAIT_EVENT_SNAPBUILD_READ:
			 event_name = "SnapbuildRead";
			 break;
		 case WAIT_EVENT_SNAPBUILD_SYNC:
			 event_name = "SnapbuildSync";
			 break;
		 case WAIT_EVENT_SNAPBUILD_WRITE:
			 event_name = "SnapbuildWrite";
			 break;
		 case WAIT_EVENT_TIMELINE_HISTORY_FILE_SYNC:
			 event_name = "TimelineHistoryFileSync";
			 break;
		 case WAIT_EVENT_TIMELINE_HISTORY_FILE_WRITE:
			 event_name = "TimelineHistoryFileWrite";
			 break;
		 case WAIT_EVENT_TIMELINE_HISTORY_READ:
			 event_name = "TimelineHistoryRead";
			 break;
		 case WAIT_EVENT_TIMELINE_HISTORY_SYNC:
			 event_name = "TimelineHistorySync";
			 break;
		 case WAIT_EVENT_TIMELINE_HISTORY_WRITE:
			 event_name = "TimelineHistoryWrite";
			 break;
		 case WAIT_EVENT_TWOPHASE_FILE_READ:
			 event_name = "TwophaseFileRead";
			 break;
		 case WAIT_EVENT_TWOPHASE_FILE_SYNC:
			 event_name = "TwophaseFileSync";
			 break;
		 case WAIT_EVENT_TWOPHASE_FILE_WRITE:
			 event_name = "TwophaseFileWrite";
			 break;
		 case WAIT_EVENT_VERSION_FILE_SYNC:
			 event_name = "VersionFileSync";
			 break;
		 case WAIT_EVENT_VERSION_FILE_WRITE:
			 event_name = "VersionFileWrite";
			 break;
		 case WAIT_EVENT_WALSENDER_TIMELINE_HISTORY_READ:
			 event_name = "WalsenderTimelineHistoryRead";
			 break;
		 case WAIT_EVENT_WAL_BOOTSTRAP_SYNC:
			 event_name = "WalBootstrapSync";
			 break;
		 case WAIT_EVENT_WAL_BOOTSTRAP_WRITE:
			 event_name = "WalBootstrapWrite";
			 break;
		 case WAIT_EVENT_WAL_COPY_READ:
			 event_name = "WalCopyRead";
			 break;
		 case WAIT_EVENT_WAL_COPY_SYNC:
			 event_name = "WalCopySync";
			 break;
		 case WAIT_EVENT_WAL_COPY_WRITE:
			 event_name = "WalCopyWrite";
			 break;
		 case WAIT_EVENT_WAL_INIT_SYNC:
			 event_name = "WalInitSync";
			 break;
		 case WAIT_EVENT_WAL_INIT_WRITE:
			 event_name = "WalInitWrite";
			 break;
		 case WAIT_EVENT_WAL_READ:
			 event_name = "WalRead";
			 break;
		 case WAIT_EVENT_WAL_SUMMARY_READ:
			 event_name = "WalSummaryRead";
			 break;
		 case WAIT_EVENT_WAL_SUMMARY_WRITE:
			 event_name = "WalSummaryWrite";
			 break;
		 case WAIT_EVENT_WAL_SYNC:
			 event_name = "WalSync";
			 break;
		 case WAIT_EVENT_WAL_SYNC_METHOD_ASSIGN:
			 event_name = "WalSyncMethodAssign";
			 break;
		 case WAIT_EVENT_WAL_WRITE:
			 event_name = "WalWrite";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

static const char *
pgstat_get_wait_ipc(WaitEventIPC w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_APPEND_READY:
			 event_name = "AppendReady";
			 break;
		 case WAIT_EVENT_ARCHIVE_CLEANUP_COMMAND:
			 event_name = "ArchiveCleanupCommand";
			 break;
		 case WAIT_EVENT_ARCHIVE_COMMAND:
			 event_name = "ArchiveCommand";
			 break;
		 case WAIT_EVENT_BACKEND_TERMINATION:
			 event_name = "BackendTermination";
			 break;
		 case WAIT_EVENT_BACKUP_WAIT_WAL_ARCHIVE:
			 event_name = "BackupWaitWalArchive";
			 break;
		 case WAIT_EVENT_BGWORKER_SHUTDOWN:
			 event_name = "BgworkerShutdown";
			 break;
		 case WAIT_EVENT_BGWORKER_STARTUP:
			 event_name = "BgworkerStartup";
			 break;
		 case WAIT_EVENT_BTREE_PAGE:
			 event_name = "BtreePage";
			 break;
		 case WAIT_EVENT_BUFFER_IO:
			 event_name = "BufferIo";
			 break;
		 case WAIT_EVENT_CHECKPOINT_DELAY_COMPLETE:
			 event_name = "CheckpointDelayComplete";
			 break;
		 case WAIT_EVENT_CHECKPOINT_DELAY_START:
			 event_name = "CheckpointDelayStart";
			 break;
		 case WAIT_EVENT_CHECKPOINT_DONE:
			 event_name = "CheckpointDone";
			 break;
		 case WAIT_EVENT_CHECKPOINT_START:
			 event_name = "CheckpointStart";
			 break;
		 case WAIT_EVENT_EXECUTE_GATHER:
			 event_name = "ExecuteGather";
			 break;
		 case WAIT_EVENT_HASH_BATCH_ALLOCATE:
			 event_name = "HashBatchAllocate";
			 break;
		 case WAIT_EVENT_HASH_BATCH_ELECT:
			 event_name = "HashBatchElect";
			 break;
		 case WAIT_EVENT_HASH_BATCH_LOAD:
			 event_name = "HashBatchLoad";
			 break;
		 case WAIT_EVENT_HASH_BUILD_ALLOCATE:
			 event_name = "HashBuildAllocate";
			 break;
		 case WAIT_EVENT_HASH_BUILD_ELECT:
			 event_name = "HashBuildElect";
			 break;
		 case WAIT_EVENT_HASH_BUILD_HASH_INNER:
			 event_name = "HashBuildHashInner";
			 break;
		 case WAIT_EVENT_HASH_BUILD_HASH_OUTER:
			 event_name = "HashBuildHashOuter";
			 break;
		 case WAIT_EVENT_HASH_GROW_BATCHES_DECIDE:
			 event_name = "HashGrowBatchesDecide";
			 break;
		 case WAIT_EVENT_HASH_GROW_BATCHES_ELECT:
			 event_name = "HashGrowBatchesElect";
			 break;
		 case WAIT_EVENT_HASH_GROW_BATCHES_FINISH:
			 event_name = "HashGrowBatchesFinish";
			 break;
		 case WAIT_EVENT_HASH_GROW_BATCHES_REALLOCATE:
			 event_name = "HashGrowBatchesReallocate";
			 break;
		 case WAIT_EVENT_HASH_GROW_BATCHES_REPARTITION:
			 event_name = "HashGrowBatchesRepartition";
			 break;
		 case WAIT_EVENT_HASH_GROW_BUCKETS_ELECT:
			 event_name = "HashGrowBucketsElect";
			 break;
		 case WAIT_EVENT_HASH_GROW_BUCKETS_REALLOCATE:
			 event_name = "HashGrowBucketsReallocate";
			 break;
		 case WAIT_EVENT_HASH_GROW_BUCKETS_REINSERT:
			 event_name = "HashGrowBucketsReinsert";
			 break;
		 case WAIT_EVENT_LOGICAL_APPLY_SEND_DATA:
			 event_name = "LogicalApplySendData";
			 break;
		 case WAIT_EVENT_LOGICAL_PARALLEL_APPLY_STATE_CHANGE:
			 event_name = "LogicalParallelApplyStateChange";
			 break;
		 case WAIT_EVENT_LOGICAL_SYNC_DATA:
			 event_name = "LogicalSyncData";
			 break;
		 case WAIT_EVENT_LOGICAL_SYNC_STATE_CHANGE:
			 event_name = "LogicalSyncStateChange";
			 break;
		 case WAIT_EVENT_MESSAGE_QUEUE_INTERNAL:
			 event_name = "MessageQueueInternal";
			 break;
		 case WAIT_EVENT_MESSAGE_QUEUE_PUT_MESSAGE:
			 event_name = "MessageQueuePutMessage";
			 break;
		 case WAIT_EVENT_MESSAGE_QUEUE_RECEIVE:
			 event_name = "MessageQueueReceive";
			 break;
		 case WAIT_EVENT_MESSAGE_QUEUE_SEND:
			 event_name = "MessageQueueSend";
			 break;
		 case WAIT_EVENT_MULTIXACT_CREATION:
			 event_name = "MultixactCreation";
			 break;
		 case WAIT_EVENT_PARALLEL_BITMAP_SCAN:
			 event_name = "ParallelBitmapScan";
			 break;
		 case WAIT_EVENT_PARALLEL_CREATE_INDEX_SCAN:
			 event_name = "ParallelCreateIndexScan";
			 break;
		 case WAIT_EVENT_PARALLEL_FINISH:
			 event_name = "ParallelFinish";
			 break;
		 case WAIT_EVENT_PROCARRAY_GROUP_UPDATE:
			 event_name = "ProcarrayGroupUpdate";
			 break;
		 case WAIT_EVENT_PROC_SIGNAL_BARRIER:
			 event_name = "ProcSignalBarrier";
			 break;
		 case WAIT_EVENT_PROMOTE:
			 event_name = "Promote";
			 break;
		 case WAIT_EVENT_RECOVERY_CONFLICT_SNAPSHOT:
			 event_name = "RecoveryConflictSnapshot";
			 break;
		 case WAIT_EVENT_RECOVERY_CONFLICT_TABLESPACE:
			 event_name = "RecoveryConflictTablespace";
			 break;
		 case WAIT_EVENT_RECOVERY_END_COMMAND:
			 event_name = "RecoveryEndCommand";
			 break;
		 case WAIT_EVENT_RECOVERY_PAUSE:
			 event_name = "RecoveryPause";
			 break;
		 case WAIT_EVENT_REPLICATION_ORIGIN_DROP:
			 event_name = "ReplicationOriginDrop";
			 break;
		 case WAIT_EVENT_REPLICATION_SLOT_DROP:
			 event_name = "ReplicationSlotDrop";
			 break;
		 case WAIT_EVENT_RESTORE_COMMAND:
			 event_name = "RestoreCommand";
			 break;
		 case WAIT_EVENT_SAFE_SNAPSHOT:
			 event_name = "SafeSnapshot";
			 break;
		 case WAIT_EVENT_SYNC_REP:
			 event_name = "SyncRep";
			 break;
		 case WAIT_EVENT_WAL_RECEIVER_EXIT:
			 event_name = "WalReceiverExit";
			 break;
		 case WAIT_EVENT_WAL_RECEIVER_WAIT_START:
			 event_name = "WalReceiverWaitStart";
			 break;
		 case WAIT_EVENT_WAL_SUMMARY_READY:
			 event_name = "WalSummaryReady";
			 break;
		 case WAIT_EVENT_XACT_GROUP_UPDATE:
			 event_name = "XactGroupUpdate";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

static const char *
pgstat_get_wait_timeout(WaitEventTimeout w)
{
	const char *event_name = "unknown wait event";

	switch (w)
	{
		 case WAIT_EVENT_BASE_BACKUP_THROTTLE:
			 event_name = "BaseBackupThrottle";
			 break;
		 case WAIT_EVENT_CHECKPOINT_WRITE_DELAY:
			 event_name = "CheckpointWriteDelay";
			 break;
		 case WAIT_EVENT_PG_SLEEP:
			 event_name = "PgSleep";
			 break;
		 case WAIT_EVENT_RECOVERY_APPLY_DELAY:
			 event_name = "RecoveryApplyDelay";
			 break;
		 case WAIT_EVENT_RECOVERY_RETRIEVE_RETRY_INTERVAL:
			 event_name = "RecoveryRetrieveRetryInterval";
			 break;
		 case WAIT_EVENT_REGISTER_SYNC_REQUEST:
			 event_name = "RegisterSyncRequest";
			 break;
		 case WAIT_EVENT_SPIN_DELAY:
			 event_name = "SpinDelay";
			 break;
		 case WAIT_EVENT_VACUUM_DELAY:
			 event_name = "VacuumDelay";
			 break;
		 case WAIT_EVENT_VACUUM_TRUNCATE:
			 event_name = "VacuumTruncate";
			 break;
		 case WAIT_EVENT_WAL_SUMMARIZER_ERROR:
			 event_name = "WalSummarizerError";
			 break;
			 /* no default case, so that compiler will warn */
	}

	return event_name;
}

