/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 433 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0600stdpair24000100QColor.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qcolor.sip"
#include <qcolor.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0600stdpair24000100QColor.cpp"


extern "C" {static void assign_QList_0600std_pair_2400_0100QColor(void *, Py_ssize_t, void *);}
static void assign_QList_0600std_pair_2400_0100QColor(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QList<std::pair< ::qreal, QColor>> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QList<std::pair< ::qreal, QColor>> *>(sipSrc);
}


extern "C" {static void *array_QList_0600std_pair_2400_0100QColor(Py_ssize_t);}
static void *array_QList_0600std_pair_2400_0100QColor(Py_ssize_t sipNrElem)
{
    return new QList<std::pair< ::qreal, QColor>>[sipNrElem];
}


extern "C" {static void *copy_QList_0600std_pair_2400_0100QColor(const void *, Py_ssize_t);}
static void *copy_QList_0600std_pair_2400_0100QColor(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QList<std::pair< ::qreal, QColor>>(reinterpret_cast<const QList<std::pair< ::qreal, QColor>> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0600std_pair_2400_0100QColor(void *, int, void *);}
static void release_QList_0600std_pair_2400_0100QColor(void *sipCppV, int, void *)
{
    QList<std::pair< ::qreal, QColor>> *sipCpp = reinterpret_cast<QList<std::pair< ::qreal, QColor>> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0600std_pair_2400_0100QColor(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0600std_pair_2400_0100QColor(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    QList<std::pair< ::qreal, QColor>> **sipCppPtr = reinterpret_cast<QList<std::pair< ::qreal, QColor>> **>(sipCppPtrV);

#line 464 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<std::pair<qreal, QColor> > *qv = new QList<std::pair<qreal, QColor> >;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *seq = PyIter_Next(iter);

        if (!seq)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        Py_ssize_t sub_len;

        if (PySequence_Check(seq) && !PyBytes_Check(sipPy) && !PyUnicode_Check(seq))
            sub_len = PySequence_Size(seq);
        else
            sub_len = -1;

        if (sub_len != 2)
        {
            if (sub_len < 0)
                PyErr_Format(PyExc_TypeError,
                        "index %zd has type '%s' but a 2 element non-string sequence is expected",
                        i, sipPyTypeName(Py_TYPE(seq)));
            else
                PyErr_Format(PyExc_TypeError,
                        "index %zd is a sequence of %zd sub-elements but 2 sub-elements are expected",
                        i, sub_len);

            Py_DECREF(seq);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        PyObject *itm1 = PySequence_GetItem(seq, 0);

        if (!itm1)
        {
            Py_DECREF(seq);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        PyErr_Clear();
        qreal s1 = PyFloat_AsDouble(itm1);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "the first sub-element of index %zd has type '%s' but 'float' is expected",
                    i, sipPyTypeName(Py_TYPE(itm1)));

            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        PyObject *itm2 = PySequence_GetItem(seq, 1);

        if (!itm2)
        {
            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        int state2;
        QColor *s2 = reinterpret_cast<QColor *>(
                sipForceConvertToType(itm2, sipType_QColor, sipTransferObj,
                        SIP_NOT_NONE, &state2, sipIsErr));
 
        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "the second sub-element of index %zd has type '%s' but 'QColor' is expected",
                    i, sipPyTypeName(Py_TYPE(itm2)));

            Py_DECREF(itm2);
            Py_DECREF(itm1);
            Py_DECREF(seq);
            delete qv;
            Py_DECREF(iter);

            return 0;
        }

        qv->append(std::pair<qreal, QColor>(s1, *s2));

        sipReleaseType(s2, sipType_QColor, state2);
        Py_DECREF(itm2);
        Py_DECREF(itm1);
        Py_DECREF(seq);
    }

    Py_DECREF(iter);
 
    *sipCppPtr = qv;
 
    return sipGetState(sipTransferObj);
#line 213 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0600stdpair24000100QColor.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0600std_pair_2400_0100QColor(void *, PyObject *);}
static PyObject *convertFrom_QList_0600std_pair_2400_0100QColor(void *sipCppV, PyObject *sipTransferObj)
{
    QList<std::pair< ::qreal, QColor>> *sipCpp = reinterpret_cast<QList<std::pair< ::qreal, QColor>> *>(sipCppV);

#line 437 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        const std::pair<qreal, QColor> &p = sipCpp->at(i);
        QColor *s2 = new QColor(p.second);
        PyObject *pobj = sipBuildResult(NULL, "(dN)", (double)p.first, s2,
                sipType_QColor, sipTransferObj);

        if (!pobj)
        {
            delete s2;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 247 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0600stdpair24000100QColor.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QList_0600std_pair_2400_0100QColor = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_2095,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_0600std_pair_2400_0100QColor,
    array_QList_0600std_pair_2400_0100QColor,
    copy_QList_0600std_pair_2400_0100QColor,
    release_QList_0600std_pair_2400_0100QColor,
    convertTo_QList_0600std_pair_2400_0100QColor,
    convertFrom_QList_0600std_pair_2400_0100QColor
};
