// ----------------------------------------------------------------------------
//
//  Copyright (C) 2024 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JFWPLAY_H
#define __JFWPLAY_H


#include <stdint.h>
#include <zita-jclient.h>
#include "audiofile.h"


class Jfwplay : public Jclient
{
public:

    Jfwplay (const char *client_name, const char *server_name, int nchan);
    virtual ~Jfwplay (void);

    enum {  MAXCHAN = 100 };

    int load_file (const char *filename);
    int close_file (void);
    int set_range (int64_t p0, int64_t p1);
    int set_state (int state);

    int64_t fsize (void) { return _fsize; }
    int     fchan (void) { return _fchan; }

private:

    int  init ();
    void fini ();
    int  jack_process (int nframes);
    void jack_freewheel (int state);

    int         _nchan;
    int         _fchan;
    int64_t     _fsize;
    float      *_fbuff;
    int64_t     _p0, _p1, _pc;
    Audiofile   _afile;
};


#endif
