// components/performance_manager/public/mojom/web_memory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-features.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/web_memory.mojom-shared.h"  // IWYU pragma: export
#include "components/performance_manager/public/mojom/web_memory.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "base/component_export.h"




namespace performance_manager::mojom {





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) WebMemoryAttribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryAttribution, T>::value>;
  using DataView = WebMemoryAttributionDataView;
  using Data_ = internal::WebMemoryAttribution_Data;
  using Scope = WebMemoryAttribution_Scope;

  template <typename... Args>
  static WebMemoryAttributionPtr New(Args&&... args) {
    return WebMemoryAttributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryAttributionPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryAttributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryAttribution>::Convert(*this);
  }


  WebMemoryAttribution();

  WebMemoryAttribution(
      WebMemoryAttribution::Scope scope,
      const std::optional<std::string>& url,
      const std::optional<std::string>& src,
      const std::optional<std::string>& id);


  ~WebMemoryAttribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryAttributionPtr>
  WebMemoryAttributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryAttribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryAttribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryAttribution_UnserializedMessageContext<
            UserType, WebMemoryAttribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryAttribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryAttribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryAttribution_UnserializedMessageContext<
            UserType, WebMemoryAttribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryAttribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebMemoryAttribution::Scope scope;
  
  std::optional<std::string> url;
  
  std::optional<std::string> src;
  
  std::optional<std::string> id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) WebMemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryUsage, T>::value>;
  using DataView = WebMemoryUsageDataView;
  using Data_ = internal::WebMemoryUsage_Data;

  template <typename... Args>
  static WebMemoryUsagePtr New(Args&&... args) {
    return WebMemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryUsage>::Convert(*this);
  }


  WebMemoryUsage();

  explicit WebMemoryUsage(
      uint64_t bytes);


  ~WebMemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryUsagePtr>
  WebMemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryUsage_UnserializedMessageContext<
            UserType, WebMemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryUsage_UnserializedMessageContext<
            UserType, WebMemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) WebMemoryBreakdownEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryBreakdownEntry, T>::value>;
  using DataView = WebMemoryBreakdownEntryDataView;
  using Data_ = internal::WebMemoryBreakdownEntry_Data;

  template <typename... Args>
  static WebMemoryBreakdownEntryPtr New(Args&&... args) {
    return WebMemoryBreakdownEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryBreakdownEntryPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryBreakdownEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryBreakdownEntry>::Convert(*this);
  }


  WebMemoryBreakdownEntry();

  WebMemoryBreakdownEntry(
      WebMemoryUsagePtr memory,
      WebMemoryUsagePtr canvas_memory,
      std::vector<WebMemoryAttributionPtr> attribution);

WebMemoryBreakdownEntry(const WebMemoryBreakdownEntry&) = delete;
WebMemoryBreakdownEntry& operator=(const WebMemoryBreakdownEntry&) = delete;

  ~WebMemoryBreakdownEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryBreakdownEntryPtr>
  WebMemoryBreakdownEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryBreakdownEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryBreakdownEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryBreakdownEntry_UnserializedMessageContext<
            UserType, WebMemoryBreakdownEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryBreakdownEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryBreakdownEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryBreakdownEntry_UnserializedMessageContext<
            UserType, WebMemoryBreakdownEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryBreakdownEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebMemoryUsagePtr memory;
  
  WebMemoryUsagePtr canvas_memory;
  
  std::vector<WebMemoryAttributionPtr> attribution;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) WebMemoryMeasurement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebMemoryMeasurement, T>::value>;
  using DataView = WebMemoryMeasurementDataView;
  using Data_ = internal::WebMemoryMeasurement_Data;
  using Mode = WebMemoryMeasurement_Mode;

  template <typename... Args>
  static WebMemoryMeasurementPtr New(Args&&... args) {
    return WebMemoryMeasurementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebMemoryMeasurementPtr From(const U& u) {
    return mojo::TypeConverter<WebMemoryMeasurementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebMemoryMeasurement>::Convert(*this);
  }


  WebMemoryMeasurement();

  WebMemoryMeasurement(
      std::vector<WebMemoryBreakdownEntryPtr> breakdown,
      WebMemoryUsagePtr detached_memory,
      WebMemoryUsagePtr shared_memory,
      WebMemoryUsagePtr blink_memory);

WebMemoryMeasurement(const WebMemoryMeasurement&) = delete;
WebMemoryMeasurement& operator=(const WebMemoryMeasurement&) = delete;

  ~WebMemoryMeasurement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebMemoryMeasurementPtr>
  WebMemoryMeasurementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebMemoryMeasurement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebMemoryMeasurement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebMemoryMeasurement_UnserializedMessageContext<
            UserType, WebMemoryMeasurement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebMemoryMeasurement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebMemoryMeasurement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebMemoryMeasurement_UnserializedMessageContext<
            UserType, WebMemoryMeasurement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebMemoryMeasurement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WebMemoryBreakdownEntryPtr> breakdown;
  
  WebMemoryUsagePtr detached_memory;
  
  WebMemoryUsagePtr shared_memory;
  
  WebMemoryUsagePtr blink_memory;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebMemoryAttributionPtr WebMemoryAttribution::Clone() const {
  return New(
      mojo::Clone(scope),
      mojo::Clone(url),
      mojo::Clone(src),
      mojo::Clone(id)
  );
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>*>
bool WebMemoryAttribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, WebMemoryAttribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
WebMemoryUsagePtr WebMemoryUsage::Clone() const {
  return New(
      mojo::Clone(bytes)
  );
}

template <typename T, WebMemoryUsage::EnableIfSame<T>*>
bool WebMemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  return true;
}

template <typename T, WebMemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  return false;
}
template <typename StructPtrType>
WebMemoryBreakdownEntryPtr WebMemoryBreakdownEntry::Clone() const {
  return New(
      mojo::Clone(memory),
      mojo::Clone(canvas_memory),
      mojo::Clone(attribution)
  );
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>*>
bool WebMemoryBreakdownEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->memory, other_struct.memory))
    return false;
  if (!mojo::Equals(this->canvas_memory, other_struct.canvas_memory))
    return false;
  if (!mojo::Equals(this->attribution, other_struct.attribution))
    return false;
  return true;
}

template <typename T, WebMemoryBreakdownEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.memory < rhs.memory)
    return true;
  if (rhs.memory < lhs.memory)
    return false;
  if (lhs.canvas_memory < rhs.canvas_memory)
    return true;
  if (rhs.canvas_memory < lhs.canvas_memory)
    return false;
  if (lhs.attribution < rhs.attribution)
    return true;
  if (rhs.attribution < lhs.attribution)
    return false;
  return false;
}
template <typename StructPtrType>
WebMemoryMeasurementPtr WebMemoryMeasurement::Clone() const {
  return New(
      mojo::Clone(breakdown),
      mojo::Clone(detached_memory),
      mojo::Clone(shared_memory),
      mojo::Clone(blink_memory)
  );
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>*>
bool WebMemoryMeasurement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->breakdown, other_struct.breakdown))
    return false;
  if (!mojo::Equals(this->detached_memory, other_struct.detached_memory))
    return false;
  if (!mojo::Equals(this->shared_memory, other_struct.shared_memory))
    return false;
  if (!mojo::Equals(this->blink_memory, other_struct.blink_memory))
    return false;
  return true;
}

template <typename T, WebMemoryMeasurement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.breakdown < rhs.breakdown)
    return true;
  if (rhs.breakdown < lhs.breakdown)
    return false;
  if (lhs.detached_memory < rhs.detached_memory)
    return true;
  if (rhs.detached_memory < lhs.detached_memory)
    return false;
  if (lhs.shared_memory < rhs.shared_memory)
    return true;
  if (rhs.shared_memory < lhs.shared_memory)
    return false;
  if (lhs.blink_memory < rhs.blink_memory)
    return true;
  if (rhs.blink_memory < lhs.blink_memory)
    return false;
  return false;
}


}  // performance_manager::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) StructTraits<::performance_manager::mojom::WebMemoryAttribution::DataView,
                                         ::performance_manager::mojom::WebMemoryAttributionPtr> {
  static bool IsNull(const ::performance_manager::mojom::WebMemoryAttributionPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::WebMemoryAttributionPtr* output) { output->reset(); }

  static decltype(::performance_manager::mojom::WebMemoryAttribution::scope) scope(
      const ::performance_manager::mojom::WebMemoryAttributionPtr& input) {
    return input->scope;
  }

  static const decltype(::performance_manager::mojom::WebMemoryAttribution::url)& url(
      const ::performance_manager::mojom::WebMemoryAttributionPtr& input) {
    return input->url;
  }

  static const decltype(::performance_manager::mojom::WebMemoryAttribution::src)& src(
      const ::performance_manager::mojom::WebMemoryAttributionPtr& input) {
    return input->src;
  }

  static const decltype(::performance_manager::mojom::WebMemoryAttribution::id)& id(
      const ::performance_manager::mojom::WebMemoryAttributionPtr& input) {
    return input->id;
  }

  static bool Read(::performance_manager::mojom::WebMemoryAttribution::DataView input, ::performance_manager::mojom::WebMemoryAttributionPtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) StructTraits<::performance_manager::mojom::WebMemoryUsage::DataView,
                                         ::performance_manager::mojom::WebMemoryUsagePtr> {
  static bool IsNull(const ::performance_manager::mojom::WebMemoryUsagePtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::WebMemoryUsagePtr* output) { output->reset(); }

  static decltype(::performance_manager::mojom::WebMemoryUsage::bytes) bytes(
      const ::performance_manager::mojom::WebMemoryUsagePtr& input) {
    return input->bytes;
  }

  static bool Read(::performance_manager::mojom::WebMemoryUsage::DataView input, ::performance_manager::mojom::WebMemoryUsagePtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) StructTraits<::performance_manager::mojom::WebMemoryBreakdownEntry::DataView,
                                         ::performance_manager::mojom::WebMemoryBreakdownEntryPtr> {
  static bool IsNull(const ::performance_manager::mojom::WebMemoryBreakdownEntryPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::WebMemoryBreakdownEntryPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::WebMemoryBreakdownEntry::memory)& memory(
      const ::performance_manager::mojom::WebMemoryBreakdownEntryPtr& input) {
    return input->memory;
  }

  static const decltype(::performance_manager::mojom::WebMemoryBreakdownEntry::canvas_memory)& canvas_memory(
      const ::performance_manager::mojom::WebMemoryBreakdownEntryPtr& input) {
    return input->canvas_memory;
  }

  static const decltype(::performance_manager::mojom::WebMemoryBreakdownEntry::attribution)& attribution(
      const ::performance_manager::mojom::WebMemoryBreakdownEntryPtr& input) {
    return input->attribution;
  }

  static bool Read(::performance_manager::mojom::WebMemoryBreakdownEntry::DataView input, ::performance_manager::mojom::WebMemoryBreakdownEntryPtr* output);
};


template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM) StructTraits<::performance_manager::mojom::WebMemoryMeasurement::DataView,
                                         ::performance_manager::mojom::WebMemoryMeasurementPtr> {
  static bool IsNull(const ::performance_manager::mojom::WebMemoryMeasurementPtr& input) { return !input; }
  static void SetToNull(::performance_manager::mojom::WebMemoryMeasurementPtr* output) { output->reset(); }

  static const decltype(::performance_manager::mojom::WebMemoryMeasurement::breakdown)& breakdown(
      const ::performance_manager::mojom::WebMemoryMeasurementPtr& input) {
    return input->breakdown;
  }

  static const decltype(::performance_manager::mojom::WebMemoryMeasurement::detached_memory)& detached_memory(
      const ::performance_manager::mojom::WebMemoryMeasurementPtr& input) {
    return input->detached_memory;
  }

  static const decltype(::performance_manager::mojom::WebMemoryMeasurement::shared_memory)& shared_memory(
      const ::performance_manager::mojom::WebMemoryMeasurementPtr& input) {
    return input->shared_memory;
  }

  static const decltype(::performance_manager::mojom::WebMemoryMeasurement::blink_memory)& blink_memory(
      const ::performance_manager::mojom::WebMemoryMeasurementPtr& input) {
    return input->blink_memory;
  }

  static bool Read(::performance_manager::mojom::WebMemoryMeasurement::DataView input, ::performance_manager::mojom::WebMemoryMeasurementPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_H_