// content/services/auction_worklet/public/mojom/seller_worklet.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_PARAMS_DATA_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace auction_worklet::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) ScoreAdClient_OnScoreAdComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double score;
  int32_t reject_reason;
  uint8_t bid_in_seller_currency_$flag : 1;
  uint8_t scoring_signals_data_version_$flag : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<internal::ComponentAuctionModifiedBidParams_Data> component_auction_modified_bid_params;
  double bid_in_seller_currency_$value;
  uint32_t scoring_signals_data_version_$value;
  uint8_t pad6_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> debug_loss_report_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> debug_win_report_url;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>>> pa_requests;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::RealTimeReportingContribution_Data>>> real_time_contributions;
  mojo::internal::Pointer<internal::SellerTimingMetrics_Data> score_ad_timing_metrics;
  mojo::internal::Pointer<internal::ScoreAdDependencyLatencies_Data> score_ad_dependency_latencies;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> errors;

 private:
  friend class mojo::internal::MessageFragment<ScoreAdClient_OnScoreAdComplete_Params_Data>;

  ScoreAdClient_OnScoreAdComplete_Params_Data();
  ~ScoreAdClient_OnScoreAdComplete_Params_Data() = delete;
};
static_assert(sizeof(ScoreAdClient_OnScoreAdComplete_Params_Data) == 104,
              "Bad sizeof(ScoreAdClient_OnScoreAdComplete_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SellerWorklet_ScoreAd_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> ad_metadata_json;
  double bid;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> bid_currency;
  mojo::internal::Pointer<::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data> auction_ad_config_non_shared_params;
  mojo::internal::Pointer<::auction_worklet::mojom::internal::TrustedSignalsCacheKey_Data> key_value_signals_cache_key;
  mojo::internal::Pointer<internal::CreativeInfoWithoutOwner_Data> ad;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CreativeInfoWithoutOwner_Data>>> ad_components;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_seller_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_seller_signals_header_ad_slot;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_auction_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_auction_signals_header_ad_slot;
  internal::ComponentAuctionOtherSeller_Data browser_signals_other_seller;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> component_expect_bid_currency;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_interest_group_owner;
  mojo::internal::Pointer<mojo::internal::String_Data> browser_signal_selected_buyer_and_seller_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> browser_signal_buyer_and_seller_reporting_id;
  uint32_t browser_signal_bidding_duration_msecs;
  uint8_t browser_signal_for_debugging_only_in_cooldown_or_lockout : 1;
  uint8_t pad17_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seller_timeout;
  uint64_t trace_id;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> bidder_joining_origin;
  mojo::internal::Interface_Data score_ad_client;

 private:
  friend class mojo::internal::MessageFragment<SellerWorklet_ScoreAd_Params_Data>;

  SellerWorklet_ScoreAd_Params_Data();
  ~SellerWorklet_ScoreAd_Params_Data() = delete;
};
static_assert(sizeof(SellerWorklet_ScoreAd_Params_Data) == 184,
              "Bad sizeof(SellerWorklet_ScoreAd_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SellerWorklet_SendPendingSignalsRequests_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<SellerWorklet_SendPendingSignalsRequests_Params_Data>;

  SellerWorklet_SendPendingSignalsRequests_Params_Data();
  ~SellerWorklet_SendPendingSignalsRequests_Params_Data() = delete;
};
static_assert(sizeof(SellerWorklet_SendPendingSignalsRequests_Params_Data) == 8,
              "Bad sizeof(SellerWorklet_SendPendingSignalsRequests_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SellerWorklet_ReportResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::AuctionAdConfigNonSharedParams_Data> auction_ad_config_non_shared_params;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_seller_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_seller_signals_header_ad_slot;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> direct_from_seller_auction_signals;
  mojo::internal::Pointer<mojo::internal::String_Data> direct_from_seller_auction_signals_header_ad_slot;
  internal::ComponentAuctionOtherSeller_Data browser_signals_other_seller;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> browser_signal_interest_group_owner;
  mojo::internal::Pointer<mojo::internal::String_Data> browser_signal_buyer_and_seller_reporting_id;
  mojo::internal::Pointer<mojo::internal::String_Data> browser_signal_selected_buyer_and_seller_reporting_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> browser_signal_render_url;
  double browser_signal_bid;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> browser_signal_bid_currency;
  double browser_signal_desirability;
  double browser_signal_highest_scoring_other_bid;
  mojo::internal::Pointer<::blink::mojom::internal::AdCurrency_Data> browser_signal_highest_scoring_other_bid_currency;
  mojo::internal::Pointer<internal::ComponentAuctionReportResultParams_Data> browser_signals_component_auction_report_result_params;
  uint8_t scoring_signals_data_version_$flag : 1;
  uint8_t pad16_[3];
  uint32_t scoring_signals_data_version_$value;
  uint64_t trace_id;

 private:
  friend class mojo::internal::MessageFragment<SellerWorklet_ReportResult_Params_Data>;

  SellerWorklet_ReportResult_Params_Data();
  ~SellerWorklet_ReportResult_Params_Data() = delete;
};
static_assert(sizeof(SellerWorklet_ReportResult_Params_Data) == 160,
              "Bad sizeof(SellerWorklet_ReportResult_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SellerWorklet_ReportResult_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> signals_for_winner;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> report_url;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> ad_beacon_map;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>>> pa_requests;
  mojo::internal::Pointer<internal::SellerTimingMetrics_Data> time_metrics;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> error_msgs;

 private:
  friend class mojo::internal::MessageFragment<SellerWorklet_ReportResult_ResponseParams_Data>;

  SellerWorklet_ReportResult_ResponseParams_Data();
  ~SellerWorklet_ReportResult_ResponseParams_Data() = delete;
};
static_assert(sizeof(SellerWorklet_ReportResult_ResponseParams_Data) == 56,
              "Bad sizeof(SellerWorklet_ReportResult_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SellerWorklet_ConnectDevToolsAgent_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data agent;
  uint32_t thread_index;

 private:
  friend class mojo::internal::MessageFragment<SellerWorklet_ConnectDevToolsAgent_Params_Data>;

  SellerWorklet_ConnectDevToolsAgent_Params_Data();
  ~SellerWorklet_ConnectDevToolsAgent_Params_Data() = delete;
};
static_assert(sizeof(SellerWorklet_ConnectDevToolsAgent_Params_Data) == 16,
              "Bad sizeof(SellerWorklet_ConnectDevToolsAgent_Params_Data)");

}  // namespace internal


class ScoreAdClient_OnScoreAdComplete_ParamsDataView {
 public:
  ScoreAdClient_OnScoreAdComplete_ParamsDataView() = default;

  ScoreAdClient_OnScoreAdComplete_ParamsDataView(
      internal::ScoreAdClient_OnScoreAdComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double score() const {
    return data_->score;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRejectReason(UserType* output) const {
    auto data_value = data_->reject_reason;
    return mojo::internal::Deserialize<::auction_worklet::mojom::RejectReason>(
        data_value, output);
  }
  ::auction_worklet::mojom::RejectReason reject_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::RejectReason>(data_->reject_reason));
  }
  inline void GetComponentAuctionModifiedBidParamsDataView(
      ComponentAuctionModifiedBidParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponentAuctionModifiedBidParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView, UserType>(),
    "Attempting to read the optional `component_auction_modified_bid_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadComponentAuctionModifiedBidParams` instead "
    "of `ReadComponentAuctionModifiedBidParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->component_auction_modified_bid_params.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::ComponentAuctionModifiedBidParamsDataView>(
        pointer, output, message_);
  }
  std::optional<double> bid_in_seller_currency() const {

    return data_->bid_in_seller_currency_$flag
        ? std::make_optional(data_->bid_in_seller_currency_$value)
        : std::nullopt;
  }
  std::optional<uint32_t> scoring_signals_data_version() const {

    return data_->scoring_signals_data_version_$flag
        ? std::make_optional(data_->scoring_signals_data_version_$value)
        : std::nullopt;
  }
  inline void GetDebugLossReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLossReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `debug_loss_report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugLossReportUrl` instead "
    "of `ReadDebugLossReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_loss_report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDebugWinReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugWinReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `debug_win_report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugWinReportUrl` instead "
    "of `ReadDebugWinReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_win_report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPaRequestsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaRequests(UserType* output) {
    
    auto* pointer = data_->pa_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetRealTimeContributionsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealTimeContributions(UserType* output) {
    
    auto* pointer = data_->real_time_contributions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>>(
        pointer, output, message_);
  }
  inline void GetScoreAdTimingMetricsDataView(
      SellerTimingMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScoreAdTimingMetrics(UserType* output) {
    
    auto* pointer = data_->score_ad_timing_metrics.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::SellerTimingMetricsDataView>(
        pointer, output, message_);
  }
  inline void GetScoreAdDependencyLatenciesDataView(
      ScoreAdDependencyLatenciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScoreAdDependencyLatencies(UserType* output) {
    
    auto* pointer = data_->score_ad_dependency_latencies.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::ScoreAdDependencyLatenciesDataView>(
        pointer, output, message_);
  }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ScoreAdClient_OnScoreAdComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerWorklet_ScoreAd_ParamsDataView {
 public:
  SellerWorklet_ScoreAd_ParamsDataView() = default;

  SellerWorklet_ScoreAd_ParamsDataView(
      internal::SellerWorklet_ScoreAd_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAdMetadataJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdMetadataJson(UserType* output) {
    
    auto* pointer = data_->ad_metadata_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double bid() const {
    return data_->bid;
  }
  inline void GetBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBidCurrency` instead "
    "of `ReadBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetAuctionAdConfigNonSharedParamsDataView(
      ::blink::mojom::AuctionAdConfigNonSharedParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionAdConfigNonSharedParams(UserType* output) {
    
    auto* pointer = data_->auction_ad_config_non_shared_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
        pointer, output, message_);
  }
  inline void GetKeyValueSignalsCacheKeyDataView(
      ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyValueSignalsCacheKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView, UserType>(),
    "Attempting to read the optional `key_value_signals_cache_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyValueSignalsCacheKey` instead "
    "of `ReadKeyValueSignalsCacheKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_value_signals_cache_key.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::TrustedSignalsCacheKeyDataView>(
        pointer, output, message_);
  }
  inline void GetAdDataView(
      CreativeInfoWithoutOwnerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAd(UserType* output) {
    
    auto* pointer = data_->ad.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView>(
        pointer, output, message_);
  }
  inline void GetAdComponentsDataView(
      mojo::ArrayDataView<CreativeInfoWithoutOwnerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponents(UserType* output) {
    
    auto* pointer = data_->ad_components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::CreativeInfoWithoutOwnerDataView>>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSellerSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSellerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_seller_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSellerSignals` instead "
    "of `ReadDirectFromSellerSellerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_seller_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSellerSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSellerSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_seller_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSellerSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerSellerSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_seller_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignals` instead "
    "of `ReadDirectFromSellerAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerAuctionSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalsOtherSellerDataView(
      ComponentAuctionOtherSellerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalsOtherSeller(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::ComponentAuctionOtherSellerDataView, UserType>(),
    "Attempting to read the optional `browser_signals_other_seller` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalsOtherSeller` instead "
    "of `ReadBrowserSignalsOtherSeller if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->browser_signals_other_seller.is_null() ? &data_->browser_signals_other_seller : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView>(
        pointer, output, message_);
  }
  inline void GetComponentExpectBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponentExpectBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `component_expect_bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadComponentExpectBidCurrency` instead "
    "of `ReadComponentExpectBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->component_expect_bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalInterestGroupOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalInterestGroupOwner(UserType* output) {
    
    auto* pointer = data_->browser_signal_interest_group_owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalSelectedBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalSelectedBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `browser_signal_selected_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalSelectedBuyerAndSellerReportingId` instead "
    "of `ReadBrowserSignalSelectedBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_selected_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `browser_signal_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalBuyerAndSellerReportingId` instead "
    "of `ReadBrowserSignalBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t browser_signal_bidding_duration_msecs() const {
    return data_->browser_signal_bidding_duration_msecs;
  }
  bool browser_signal_for_debugging_only_in_cooldown_or_lockout() const {
    return data_->browser_signal_for_debugging_only_in_cooldown_or_lockout;
  }
  inline void GetSellerTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSellerTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `seller_timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSellerTimeout` instead "
    "of `ReadSellerTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->seller_timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetBidderJoiningOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidderJoiningOrigin(UserType* output) {
    
    auto* pointer = data_->bidder_joining_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeScoreAdClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::auction_worklet::mojom::ScoreAdClientInterfaceBase>>(
            &data_->score_ad_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::SellerWorklet_ScoreAd_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerWorklet_SendPendingSignalsRequests_ParamsDataView {
 public:
  SellerWorklet_SendPendingSignalsRequests_ParamsDataView() = default;

  SellerWorklet_SendPendingSignalsRequests_ParamsDataView(
      internal::SellerWorklet_SendPendingSignalsRequests_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SellerWorklet_SendPendingSignalsRequests_Params_Data* data_ = nullptr;
};


class SellerWorklet_ReportResult_ParamsDataView {
 public:
  SellerWorklet_ReportResult_ParamsDataView() = default;

  SellerWorklet_ReportResult_ParamsDataView(
      internal::SellerWorklet_ReportResult_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAuctionAdConfigNonSharedParamsDataView(
      ::blink::mojom::AuctionAdConfigNonSharedParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuctionAdConfigNonSharedParams(UserType* output) {
    
    auto* pointer = data_->auction_ad_config_non_shared_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::AuctionAdConfigNonSharedParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSellerSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSellerSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_seller_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSellerSignals` instead "
    "of `ReadDirectFromSellerSellerSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_seller_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSellerSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSellerSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_seller_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSellerSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerSellerSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_seller_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignals` instead "
    "of `ReadDirectFromSellerAuctionSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerAuctionSignalsHeaderAdSlot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_auction_signals_header_ad_slot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerAuctionSignalsHeaderAdSlot` instead "
    "of `ReadDirectFromSellerAuctionSignalsHeaderAdSlot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalsOtherSellerDataView(
      ComponentAuctionOtherSellerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalsOtherSeller(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::ComponentAuctionOtherSellerDataView, UserType>(),
    "Attempting to read the optional `browser_signals_other_seller` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalsOtherSeller` instead "
    "of `ReadBrowserSignalsOtherSeller if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->browser_signals_other_seller.is_null() ? &data_->browser_signals_other_seller : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ComponentAuctionOtherSellerDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalInterestGroupOwnerDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalInterestGroupOwner(UserType* output) {
    
    auto* pointer = data_->browser_signal_interest_group_owner.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `browser_signal_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalBuyerAndSellerReportingId` instead "
    "of `ReadBrowserSignalBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalSelectedBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalSelectedBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `browser_signal_selected_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalSelectedBuyerAndSellerReportingId` instead "
    "of `ReadBrowserSignalSelectedBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_selected_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalRenderUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalRenderUrl(UserType* output) {
    
    auto* pointer = data_->browser_signal_render_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  double browser_signal_bid() const {
    return data_->browser_signal_bid;
  }
  inline void GetBrowserSignalBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `browser_signal_bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalBidCurrency` instead "
    "of `ReadBrowserSignalBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  double browser_signal_desirability() const {
    return data_->browser_signal_desirability;
  }
  double browser_signal_highest_scoring_other_bid() const {
    return data_->browser_signal_highest_scoring_other_bid;
  }
  inline void GetBrowserSignalHighestScoringOtherBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalHighestScoringOtherBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `browser_signal_highest_scoring_other_bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalHighestScoringOtherBidCurrency` instead "
    "of `ReadBrowserSignalHighestScoringOtherBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signal_highest_scoring_other_bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserSignalsComponentAuctionReportResultParamsDataView(
      ComponentAuctionReportResultParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserSignalsComponentAuctionReportResultParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView, UserType>(),
    "Attempting to read the optional `browser_signals_component_auction_report_result_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBrowserSignalsComponentAuctionReportResultParams` instead "
    "of `ReadBrowserSignalsComponentAuctionReportResultParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->browser_signals_component_auction_report_result_params.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::ComponentAuctionReportResultParamsDataView>(
        pointer, output, message_);
  }
  std::optional<uint32_t> scoring_signals_data_version() const {

    return data_->scoring_signals_data_version_$flag
        ? std::make_optional(data_->scoring_signals_data_version_$value)
        : std::nullopt;
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::SellerWorklet_ReportResult_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerWorklet_ReportResult_ResponseParamsDataView {
 public:
  SellerWorklet_ReportResult_ResponseParamsDataView() = default;

  SellerWorklet_ReportResult_ResponseParamsDataView(
      internal::SellerWorklet_ReportResult_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSignalsForWinnerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignalsForWinner(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `signals_for_winner` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSignalsForWinner` instead "
    "of `ReadSignalsForWinner if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->signals_for_winner.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `report_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportUrl` instead "
    "of `ReadReportUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAdBeaconMapDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdBeaconMap(UserType* output) {
    
    auto* pointer = data_->ad_beacon_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetPaRequestsDataView(
      mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaRequests(UserType* output) {
    
    auto* pointer = data_->pa_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetTimeMetricsDataView(
      SellerTimingMetricsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeMetrics(UserType* output) {
    
    auto* pointer = data_->time_metrics.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::SellerTimingMetricsDataView>(
        pointer, output, message_);
  }
  inline void GetErrorMsgsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMsgs(UserType* output) {
    
    auto* pointer = data_->error_msgs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SellerWorklet_ReportResult_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SellerWorklet_ConnectDevToolsAgent_ParamsDataView {
 public:
  SellerWorklet_ConnectDevToolsAgent_ParamsDataView() = default;

  SellerWorklet_ConnectDevToolsAgent_ParamsDataView(
      internal::SellerWorklet_ConnectDevToolsAgent_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAgent() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::DevToolsAgentAssociatedRequestDataView>(
            &data_->agent, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint32_t thread_index() const {
    return data_->thread_index;
  }
 private:
  internal::SellerWorklet_ConnectDevToolsAgent_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetComponentAuctionModifiedBidParamsDataView(
    ComponentAuctionModifiedBidParamsDataView* output) {
  auto pointer = data_->component_auction_modified_bid_params.Get();
  *output = ComponentAuctionModifiedBidParamsDataView(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetDebugLossReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->debug_loss_report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetDebugWinReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->debug_win_report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetPaRequestsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output) {
  auto pointer = data_->pa_requests.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetRealTimeContributionsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>* output) {
  auto pointer = data_->real_time_contributions.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::RealTimeReportingContributionDataView>(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetScoreAdTimingMetricsDataView(
    SellerTimingMetricsDataView* output) {
  auto pointer = data_->score_ad_timing_metrics.Get();
  *output = SellerTimingMetricsDataView(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetScoreAdDependencyLatenciesDataView(
    ScoreAdDependencyLatenciesDataView* output) {
  auto pointer = data_->score_ad_dependency_latencies.Get();
  *output = ScoreAdDependencyLatenciesDataView(pointer, message_);
}
inline void ScoreAdClient_OnScoreAdComplete_ParamsDataView::GetErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void SellerWorklet_ScoreAd_ParamsDataView::GetAdMetadataJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad_metadata_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetAuctionAdConfigNonSharedParamsDataView(
    ::blink::mojom::AuctionAdConfigNonSharedParamsDataView* output) {
  auto pointer = data_->auction_ad_config_non_shared_params.Get();
  *output = ::blink::mojom::AuctionAdConfigNonSharedParamsDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetKeyValueSignalsCacheKeyDataView(
    ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView* output) {
  auto pointer = data_->key_value_signals_cache_key.Get();
  *output = ::auction_worklet::mojom::TrustedSignalsCacheKeyDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetAdDataView(
    CreativeInfoWithoutOwnerDataView* output) {
  auto pointer = data_->ad.Get();
  *output = CreativeInfoWithoutOwnerDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetAdComponentsDataView(
    mojo::ArrayDataView<CreativeInfoWithoutOwnerDataView>* output) {
  auto pointer = data_->ad_components.Get();
  *output = mojo::ArrayDataView<CreativeInfoWithoutOwnerDataView>(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetDirectFromSellerSellerSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_seller_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetDirectFromSellerSellerSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_seller_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetDirectFromSellerAuctionSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBrowserSignalsOtherSellerDataView(
    ComponentAuctionOtherSellerDataView* output) {
  auto pointer = &data_->browser_signals_other_seller;
  *output = ComponentAuctionOtherSellerDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetComponentExpectBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->component_expect_bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBrowserSignalInterestGroupOwnerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_interest_group_owner.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBrowserSignalSelectedBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->browser_signal_selected_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBrowserSignalBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->browser_signal_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetSellerTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seller_timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SellerWorklet_ScoreAd_ParamsDataView::GetBidderJoiningOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->bidder_joining_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void SellerWorklet_ReportResult_ParamsDataView::GetAuctionAdConfigNonSharedParamsDataView(
    ::blink::mojom::AuctionAdConfigNonSharedParamsDataView* output) {
  auto pointer = data_->auction_ad_config_non_shared_params.Get();
  *output = ::blink::mojom::AuctionAdConfigNonSharedParamsDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetDirectFromSellerSellerSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_seller_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetDirectFromSellerSellerSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_seller_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetDirectFromSellerAuctionSignalsDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetDirectFromSellerAuctionSignalsHeaderAdSlotDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_from_seller_auction_signals_header_ad_slot.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalsOtherSellerDataView(
    ComponentAuctionOtherSellerDataView* output) {
  auto pointer = &data_->browser_signals_other_seller;
  *output = ComponentAuctionOtherSellerDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalInterestGroupOwnerDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->browser_signal_interest_group_owner.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->browser_signal_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalSelectedBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->browser_signal_selected_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalRenderUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->browser_signal_render_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->browser_signal_bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalHighestScoringOtherBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->browser_signal_highest_scoring_other_bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ParamsDataView::GetBrowserSignalsComponentAuctionReportResultParamsDataView(
    ComponentAuctionReportResultParamsDataView* output) {
  auto pointer = data_->browser_signals_component_auction_report_result_params.Get();
  *output = ComponentAuctionReportResultParamsDataView(pointer, message_);
}


inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetSignalsForWinnerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signals_for_winner.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetAdBeaconMapDataView(
    mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output) {
  auto pointer = data_->ad_beacon_map.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>(pointer, message_);
}
inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetPaRequestsDataView(
    mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>* output) {
  auto pointer = data_->pa_requests.Get();
  *output = mojo::ArrayDataView<::auction_worklet::mojom::PrivateAggregationRequestDataView>(pointer, message_);
}
inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetTimeMetricsDataView(
    SellerTimingMetricsDataView* output) {
  auto pointer = data_->time_metrics.Get();
  *output = SellerTimingMetricsDataView(pointer, message_);
}
inline void SellerWorklet_ReportResult_ResponseParamsDataView::GetErrorMsgsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->error_msgs.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}





}  // auction_worklet::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_SELLER_WORKLET_MOJOM_PARAMS_DATA_H_