// media/mojo/mojom/video_encoder_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_encoder_info.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace media::mojom {
class ResolutionRateLimitDataView;

class VideoEncoderInfoDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ResolutionRateLimitDataView> {
  using Data = ::media::mojom::internal::ResolutionRateLimit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncoderInfoDataView> {
  using Data = ::media::mojom::internal::VideoEncoderInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class ResolutionRateLimitDataView {
 public:
  ResolutionRateLimitDataView() = default;

  ResolutionRateLimitDataView(
      internal::ResolutionRateLimit_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSize(UserType* output) {
    
    auto* pointer = data_->frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  int32_t min_start_bitrate_bps() const {
    return data_->min_start_bitrate_bps;
  }
  int32_t min_bitrate_bps() const {
    return data_->min_bitrate_bps;
  }
  int32_t max_bitrate_bps() const {
    return data_->max_bitrate_bps;
  }
  uint32_t max_framerate_numerator() const {
    return data_->max_framerate_numerator;
  }
  uint32_t max_framerate_denominator() const {
    return data_->max_framerate_denominator;
  }
 private:
  internal::ResolutionRateLimit_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncoderInfoDataView {
 public:
  VideoEncoderInfoDataView() = default;

  VideoEncoderInfoDataView(
      internal::VideoEncoderInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImplementationNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImplementationName(UserType* output) {
    
    auto* pointer = data_->implementation_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_frame_delay() const {
    return data_->has_frame_delay;
  }
  int32_t frame_delay() const {
    return data_->frame_delay;
  }
  bool has_input_capacity() const {
    return data_->has_input_capacity;
  }
  int32_t input_capacity() const {
    return data_->input_capacity;
  }
  bool supports_native_handle() const {
    return data_->supports_native_handle;
  }
  bool has_trusted_rate_controller() const {
    return data_->has_trusted_rate_controller;
  }
  bool is_hardware_accelerated() const {
    return data_->is_hardware_accelerated;
  }
  bool supports_simulcast() const {
    return data_->supports_simulcast;
  }
  bool reports_average_qp() const {
    return data_->reports_average_qp;
  }
  uint32_t requested_resolution_alignment() const {
    return data_->requested_resolution_alignment;
  }
  bool apply_alignment_to_all_simulcast_layers() const {
    return data_->apply_alignment_to_all_simulcast_layers;
  }
  bool supports_frame_size_change() const {
    return data_->supports_frame_size_change;
  }
  inline void GetFpsAllocationDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFpsAllocation(UserType* output) {
    
    auto* pointer = data_->fps_allocation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetResolutionRateLimitsDataView(
      mojo::ArrayDataView<ResolutionRateLimitDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolutionRateLimits(UserType* output) {
    
    auto* pointer = data_->resolution_rate_limits.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::ResolutionRateLimitDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncoderInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ResolutionRateLimitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ResolutionRateLimitDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ResolutionRateLimit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_size)::BaseType> frame_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_frame_size, frame_size_fragment);
    fragment->frame_size.Set(
        frame_size_fragment.is_null() ? nullptr : frame_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_size in ResolutionRateLimit struct");
    fragment->min_start_bitrate_bps = Traits::min_start_bitrate_bps(input);
    fragment->min_bitrate_bps = Traits::min_bitrate_bps(input);
    fragment->max_bitrate_bps = Traits::max_bitrate_bps(input);
    fragment->max_framerate_numerator = Traits::max_framerate_numerator(input);
    fragment->max_framerate_denominator = Traits::max_framerate_denominator(input);
  }

  static bool Deserialize(::media::mojom::internal::ResolutionRateLimit_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ResolutionRateLimitDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncoderInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncoderInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEncoderInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::implementation_name(input)) in_implementation_name = Traits::implementation_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->implementation_name)::BaseType> implementation_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_implementation_name, implementation_name_fragment);
    fragment->implementation_name.Set(
        implementation_name_fragment.is_null() ? nullptr : implementation_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->implementation_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null implementation_name in VideoEncoderInfo struct");
    fragment->has_frame_delay = Traits::has_frame_delay(input);
    fragment->frame_delay = Traits::frame_delay(input);
    fragment->has_input_capacity = Traits::has_input_capacity(input);
    fragment->input_capacity = Traits::input_capacity(input);
    fragment->supports_native_handle = Traits::supports_native_handle(input);
    fragment->has_trusted_rate_controller = Traits::has_trusted_rate_controller(input);
    fragment->is_hardware_accelerated = Traits::is_hardware_accelerated(input);
    fragment->supports_simulcast = Traits::supports_simulcast(input);
    fragment->reports_average_qp = Traits::reports_average_qp(input);
    fragment->requested_resolution_alignment = Traits::requested_resolution_alignment(input);
    fragment->apply_alignment_to_all_simulcast_layers = Traits::apply_alignment_to_all_simulcast_layers(input);
    fragment->supports_frame_size_change = Traits::supports_frame_size_change(input);
    decltype(Traits::fps_allocation(input)) in_fps_allocation = Traits::fps_allocation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fps_allocation)::BaseType>
        fps_allocation_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fps_allocation_validate_params =
        mojo::internal::GetArrayValidator<5, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        in_fps_allocation, fps_allocation_fragment, &fps_allocation_validate_params);
    fragment->fps_allocation.Set(
        fps_allocation_fragment.is_null() ? nullptr : fps_allocation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fps_allocation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fps_allocation in VideoEncoderInfo struct");
    decltype(Traits::resolution_rate_limits(input)) in_resolution_rate_limits = Traits::resolution_rate_limits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resolution_rate_limits)::BaseType>
        resolution_rate_limits_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& resolution_rate_limits_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::ResolutionRateLimitDataView>>(
        in_resolution_rate_limits, resolution_rate_limits_fragment, &resolution_rate_limits_validate_params);
    fragment->resolution_rate_limits.Set(
        resolution_rate_limits_fragment.is_null() ? nullptr : resolution_rate_limits_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->resolution_rate_limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resolution_rate_limits in VideoEncoderInfo struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoEncoderInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoEncoderInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void ResolutionRateLimitDataView::GetFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoEncoderInfoDataView::GetImplementationNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->implementation_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoEncoderInfoDataView::GetFpsAllocationDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->fps_allocation.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void VideoEncoderInfoDataView::GetResolutionRateLimitsDataView(
    mojo::ArrayDataView<ResolutionRateLimitDataView>* output) {
  auto pointer = data_->resolution_rate_limits.Get();
  *output = mojo::ArrayDataView<ResolutionRateLimitDataView>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_