// services/audio/public/mojom/log_factory_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_LOG_FACTORY_MANAGER_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_LOG_FACTORY_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/log_factory_manager.mojom-features.h"  // IWYU pragma: export
#include "services/audio/public/mojom/log_factory_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/audio/public/mojom/log_factory_manager.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_logging.mojom-forward.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace audio::mojom {

class LogFactoryManagerProxy;

template <typename ImplRefTraits>
class LogFactoryManagerStub;

class LogFactoryManagerRequestValidator;


class LogFactoryManager
    : public LogFactoryManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LogFactoryManagerInterfaceBase;
  using Proxy_ = LogFactoryManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LogFactoryManagerStub<ImplRefTraits>;

  using RequestValidator_ = LogFactoryManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetLogFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetLogFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LogFactoryManager() = default;

  
  virtual void SetLogFactory(::mojo::PendingRemote<::media::mojom::AudioLogFactory> factory) = 0;
};



class  LogFactoryManagerProxy
    : public LogFactoryManager {
 public:
  using InterfaceType = LogFactoryManager;

  explicit LogFactoryManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetLogFactory(::mojo::PendingRemote<::media::mojom::AudioLogFactory> factory) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LogFactoryManagerStubDispatch {
 public:
  static bool Accept(LogFactoryManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LogFactoryManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LogFactoryManager>>
class LogFactoryManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LogFactoryManagerStub() = default;
  ~LogFactoryManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LogFactoryManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LogFactoryManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LogFactoryManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // audio::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_LOG_FACTORY_MANAGER_MOJOM_H_