// services/network/public/mojom/websocket.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/websocket.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/websocket.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* WebSocketMessageTypeToStringHelper(WebSocketMessageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebSocketMessageType::CONTINUATION:
      return "CONTINUATION";
    case WebSocketMessageType::TEXT:
      return "TEXT";
    case WebSocketMessageType::BINARY:
      return "{BINARY, LAST}";
    default:
      return nullptr;
  }
}

std::string WebSocketMessageTypeToString(WebSocketMessageType value) {
  const char *str = WebSocketMessageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebSocketMessageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebSocketMessageType value) {
  return os << WebSocketMessageTypeToString(value);
}

namespace internal {


// static
bool HttpHeader_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpHeader_Data* object =
      static_cast<const HttpHeader_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

HttpHeader_Data::HttpHeader_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketHandshakeRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketHandshakeRequest_Data* object =
      static_cast<const WebSocketHandshakeRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers_text, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers_text, validation_context,
                                         &headers_text_validate_params)) {
    return false;
  }

  return true;
}

WebSocketHandshakeRequest_Data::WebSocketHandshakeRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketHandshakeResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketHandshakeResponse_Data* object =
      static_cast<const WebSocketHandshakeResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_version, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_version, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status_text, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& status_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->status_text, validation_context,
                                         &status_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers_text, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers_text, validation_context,
                                         &headers_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selected_protocol, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selected_protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_protocol, validation_context,
                                         &selected_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extensions, validation_context,
                                         &extensions_validate_params)) {
    return false;
  }

  return true;
}

WebSocketHandshakeResponse_Data::WebSocketHandshakeResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketAuthenticationHandler_OnAuthRequired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketAuthenticationHandler_OnAuthRequired_Params_Data* object =
      static_cast<const WebSocketAuthenticationHandler_OnAuthRequired_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  return true;
}

WebSocketAuthenticationHandler_OnAuthRequired_Params_Data::WebSocketAuthenticationHandler_OnAuthRequired_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data* object =
      static_cast<const WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->credentials, validation_context))
    return false;

  return true;
}

WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data::WebSocketAuthenticationHandler_OnAuthRequired_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* object =
      static_cast<const WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketHandshakeClient_OnFailure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketHandshakeClient_OnFailure_Params_Data* object =
      static_cast<const WebSocketHandshakeClient_OnFailure_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

WebSocketHandshakeClient_OnFailure_Params_Data::WebSocketHandshakeClient_OnFailure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* object =
      static_cast<const WebSocketHandshakeClient_OnConnectionEstablished_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->readable, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->readable,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->writable, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->writable,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebSocketHandshakeClient_OnConnectionEstablished_Params_Data::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketClient_OnDataFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketClient_OnDataFrame_Params_Data* object =
      static_cast<const WebSocketClient_OnDataFrame_Params_Data*>(data);


  if (!::network::mojom::internal::WebSocketMessageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

WebSocketClient_OnDataFrame_Params_Data::WebSocketClient_OnDataFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketClient_OnDropChannel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketClient_OnDropChannel_Params_Data* object =
      static_cast<const WebSocketClient_OnDropChannel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reason, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reason_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reason, validation_context,
                                         &reason_validate_params)) {
    return false;
  }

  return true;
}

WebSocketClient_OnDropChannel_Params_Data::WebSocketClient_OnDropChannel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocketClient_OnClosingHandshake_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocketClient_OnClosingHandshake_Params_Data* object =
      static_cast<const WebSocketClient_OnClosingHandshake_Params_Data*>(data);

  return true;
}

WebSocketClient_OnClosingHandshake_Params_Data::WebSocketClient_OnClosingHandshake_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocket_SendMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocket_SendMessage_Params_Data* object =
      static_cast<const WebSocket_SendMessage_Params_Data*>(data);


  if (!::network::mojom::internal::WebSocketMessageType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

WebSocket_SendMessage_Params_Data::WebSocket_SendMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocket_StartReceiving_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocket_StartReceiving_Params_Data* object =
      static_cast<const WebSocket_StartReceiving_Params_Data*>(data);

  return true;
}

WebSocket_StartReceiving_Params_Data::WebSocket_StartReceiving_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebSocket_StartClosingHandshake_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebSocket_StartClosingHandshake_Params_Data* object =
      static_cast<const WebSocket_StartClosingHandshake_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reason, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reason_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reason, validation_context,
                                         &reason_validate_params)) {
    return false;
  }

  return true;
}

WebSocket_StartClosingHandshake_Params_Data::WebSocket_StartClosingHandshake_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::WebSocketMessageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::WebSocketMessageType value) {
  return std::move(context).WriteString(::network::mojom::WebSocketMessageTypeToString(value));
}

} // namespace perfetto