// services/viz/public/mojom/compositing/tiling.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/tiling.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* MissingTileReasonToStringHelper(MissingTileReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MissingTileReason::kOutOfMemory:
      return "kOutOfMemory";
    case MissingTileReason::kResourceNotReady:
      return "kResourceNotReady";
    default:
      return nullptr;
  }
}

std::string MissingTileReasonToString(MissingTileReason value) {
  const char *str = MissingTileReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MissingTileReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MissingTileReason value) {
  return os << MissingTileReasonToString(value);
}

namespace internal {
// static
bool TileContents_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TileContents_Data* object = static_cast<const TileContents_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TileContents_Tag::kMissingReason: {


      if (!::viz::mojom::internal::MissingTileReason_Data
            ::Validate(object->data.f_missing_reason, validation_context))
        return false;
      return true;
    }
    case TileContents_Tag::kResource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_resource, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_resource, validation_context))
        return false;
      return true;
    }
    case TileContents_Tag::kSolidColor: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_solid_color, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_solid_color, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TileContents");
      return false;
    }
  }
}


// static
bool TileResource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TileResource_Data* object =
      static_cast<const TileResource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource, validation_context))
    return false;

  return true;
}

TileResource_Data::TileResource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tile_Data* object =
      static_cast<const Tile_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->contents, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->contents, validation_context))
    return false;

  return true;
}

Tile_Data::Tile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tiling_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tiling_Data* object =
      static_cast<const Tiling_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raster_translation, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->raster_translation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raster_scale, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->raster_scale, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tile_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tile_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tiling_rect, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tiling_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tiles, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tiles, validation_context,
                                         &tiles_validate_params)) {
    return false;
  }

  return true;
}

Tiling_Data::Tiling_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::MissingTileReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::MissingTileReason value) {
  return std::move(context).WriteString(::viz::mojom::MissingTileReasonToString(value));
}

} // namespace perfetto