// services/network/public/mojom/no_vary_search.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/no_vary_search.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/no_vary_search.mojom-params-data.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared-message-ids.h"

#include "services/network/public/mojom/no_vary_search.mojom-import-headers.h"
#include "services/network/public/mojom/no_vary_search.mojom-test-utils.h"


namespace network::mojom {
NoVarySearch::NoVarySearch()
    : search_variance(),
      vary_on_key_order() {}

NoVarySearch::NoVarySearch(
    SearchParamsVariancePtr search_variance_in,
    bool vary_on_key_order_in)
    : search_variance(std::move(search_variance_in)),
      vary_on_key_order(std::move(vary_on_key_order_in)) {}

NoVarySearch::~NoVarySearch() = default;

void NoVarySearch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_variance"), this->search_variance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SearchParamsVariancePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vary_on_key_order"), this->vary_on_key_order,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NoVarySearch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchParamsVariance::SearchParamsVariance() : tag_(Tag::kNoVaryParams) {
  data_.no_vary_params = new std::vector<std::string>;
}

SearchParamsVariance::~SearchParamsVariance() {
  DestroyActive();
}


void SearchParamsVariance::set_no_vary_params(
    std::vector<std::string> no_vary_params) {
  if (tag_ == Tag::kNoVaryParams) {
    *(data_.no_vary_params) = std::move(no_vary_params);
  } else {
    DestroyActive();
    tag_ = Tag::kNoVaryParams;
    data_.no_vary_params = new std::vector<std::string>(
        std::move(no_vary_params));
  }
}
void SearchParamsVariance::set_vary_params(
    std::vector<std::string> vary_params) {
  if (tag_ == Tag::kVaryParams) {
    *(data_.vary_params) = std::move(vary_params);
  } else {
    DestroyActive();
    tag_ = Tag::kVaryParams;
    data_.vary_params = new std::vector<std::string>(
        std::move(vary_params));
  }
}

void SearchParamsVariance::DestroyActive() {
  switch (tag_) {

    case Tag::kNoVaryParams:

      delete data_.no_vary_params;
      break;
    case Tag::kVaryParams:

      delete data_.vary_params;
      break;
  }
}

bool SearchParamsVariance::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
NoVarySearchWithParseError::NoVarySearchWithParseError() : tag_(Tag::kNoVarySearch) {
  data_.no_vary_search = new NoVarySearchPtr;
}

NoVarySearchWithParseError::~NoVarySearchWithParseError() {
  DestroyActive();
}


void NoVarySearchWithParseError::set_no_vary_search(
    NoVarySearchPtr no_vary_search) {
  if (tag_ == Tag::kNoVarySearch) {
    *(data_.no_vary_search) = std::move(no_vary_search);
  } else {
    DestroyActive();
    tag_ = Tag::kNoVarySearch;
    data_.no_vary_search = new NoVarySearchPtr(
        std::move(no_vary_search));
  }
}
void NoVarySearchWithParseError::set_parse_error(
    NoVarySearchParseError parse_error) {
  if (tag_ != Tag::kParseError) {
    DestroyActive();
    tag_ = Tag::kParseError;
  }
  data_.parse_error = parse_error;
}

void NoVarySearchWithParseError::DestroyActive() {
  switch (tag_) {

    case Tag::kNoVarySearch:

      delete data_.no_vary_search;
      break;
    case Tag::kParseError:

      break;
  }
}

bool NoVarySearchWithParseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::NoVarySearch::DataView, ::network::mojom::NoVarySearchPtr>::Read(
    ::network::mojom::NoVarySearch::DataView input,
    ::network::mojom::NoVarySearchPtr* output) {
  bool success = true;
  ::network::mojom::NoVarySearchPtr result(::network::mojom::NoVarySearch::New());
  
      if (success && !input.ReadSearchVariance(&result->search_variance))
        success = false;
      if (success)
        result->vary_on_key_order = input.vary_on_key_order();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::SearchParamsVariance::DataView, ::network::mojom::SearchParamsVariancePtr>::Read(
    ::network::mojom::SearchParamsVariance::DataView input,
    ::network::mojom::SearchParamsVariancePtr* output) {
  using UnionType = ::network::mojom::SearchParamsVariance;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNoVaryParams: {
      std::vector<std::string> result_no_vary_params;
      if (!input.ReadNoVaryParams(&result_no_vary_params))
        return false;

      *output = UnionType::NewNoVaryParams(
          std::move(result_no_vary_params));
      break;
    }
    case Tag::kVaryParams: {
      std::vector<std::string> result_vary_params;
      if (!input.ReadVaryParams(&result_vary_params))
        return false;

      *output = UnionType::NewVaryParams(
          std::move(result_vary_params));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::network::mojom::NoVarySearchWithParseError::DataView, ::network::mojom::NoVarySearchWithParseErrorPtr>::Read(
    ::network::mojom::NoVarySearchWithParseError::DataView input,
    ::network::mojom::NoVarySearchWithParseErrorPtr* output) {
  using UnionType = ::network::mojom::NoVarySearchWithParseError;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNoVarySearch: {
      ::network::mojom::NoVarySearchPtr result_no_vary_search;
      if (!input.ReadNoVarySearch(&result_no_vary_search))
        return false;

      *output = UnionType::NewNoVarySearch(
          std::move(result_no_vary_search));
      break;
    }
    case Tag::kParseError: {
      ::network::mojom::NoVarySearchParseError result_parse_error;
      if (!input.ReadParseError(&result_parse_error))
        return false;

      *output = UnionType::NewParseError(result_parse_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif