// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class VideoCaptureTargetDataView;

class VideoCaptureSubTargetDataView;


}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::VideoCaptureTargetDataView> {
  using Data = ::viz::mojom::internal::VideoCaptureTarget_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::VideoCaptureSubTargetDataView> {
  using Data = ::viz::mojom::internal::VideoCaptureSubTarget_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class BufferFormatPreference : int32_t {
  
  kDefault = 0,
  
  kPreferGpuMemoryBuffer = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, BufferFormatPreference value);
inline bool IsKnownEnumValue(BufferFormatPreference value) {
  return internal::BufferFormatPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FrameSinkVideoConsumerFrameCallbacksInterfaceBase {};

using FrameSinkVideoConsumerFrameCallbacksPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
class FrameSinkVideoConsumerInterfaceBase {};

using FrameSinkVideoConsumerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoConsumerInterfaceBase>;
class FrameSinkVideoCapturerInterfaceBase {};

using FrameSinkVideoCapturerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoCapturerInterfaceBase>;
class FrameSinkVideoCaptureOverlayInterfaceBase {};

using FrameSinkVideoCaptureOverlayPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;


class VideoCaptureTargetDataView {
 public:
  VideoCaptureTargetDataView() = default;

  VideoCaptureTargetDataView(
      internal::VideoCaptureTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  inline void GetSubTargetDataView(
      VideoCaptureSubTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::VideoCaptureSubTargetDataView, UserType>(),
    "Attempting to read the optional `sub_target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubTarget` instead "
    "of `ReadSubTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->sub_target.is_null() ? &data_->sub_target : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::VideoCaptureSubTargetDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoCaptureTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureSubTargetDataView {
 public:
  using Tag = internal::VideoCaptureSubTarget_Data::VideoCaptureSubTarget_Tag;

  VideoCaptureSubTargetDataView() = default;

  VideoCaptureSubTargetDataView(
      internal::VideoCaptureSubTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_subtree_capture_id() const { return data_->tag == Tag::kSubtreeCaptureId; }
  inline void GetSubtreeCaptureIdDataView(
      ::viz::mojom::SubtreeCaptureIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSubtreeCaptureId(UserType* output) const {
    
    CHECK(is_subtree_capture_id());
    return mojo::internal::Deserialize<::viz::mojom::SubtreeCaptureIdDataView>(
        data_->data.f_subtree_capture_id.Get(), output, message_);
  }
  bool is_region_capture_crop_id() const { return data_->tag == Tag::kRegionCaptureCropId; }
  inline void GetRegionCaptureCropIdDataView(
      ::mojo_base::mojom::TokenDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegionCaptureCropId(UserType* output) const {
    
    CHECK(is_region_capture_crop_id());
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        data_->data.f_region_capture_crop_id.Get(), output, message_);
  }

 private:
  internal::VideoCaptureSubTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::BufferFormatPreference>
    : public mojo::internal::EnumHashImpl<::viz::mojom::BufferFormatPreference> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BufferFormatPreference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::BufferFormatPreference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::BufferFormatPreference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::VideoCaptureTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::VideoCaptureTargetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::VideoCaptureTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
        in_frame_sink_id, frame_sink_id_fragment);
    fragment->frame_sink_id.Set(
        frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_sink_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in VideoCaptureTarget struct");
    decltype(Traits::sub_target(input)) in_sub_target = Traits::sub_target(input);
    mojo::internal::MessageFragment<decltype(fragment->sub_target)>
        sub_target_fragment(fragment.message());
    sub_target_fragment.Claim(&fragment->sub_target);
    mojo::internal::Serialize<::viz::mojom::VideoCaptureSubTargetDataView>(
        in_sub_target, sub_target_fragment, true);
  }

  static bool Deserialize(::viz::mojom::internal::VideoCaptureTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::VideoCaptureTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::VideoCaptureSubTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::VideoCaptureSubTargetDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::VideoCaptureSubTarget_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::viz::mojom::VideoCaptureSubTargetDataView::Tag::kSubtreeCaptureId: {
        decltype(Traits::subtree_capture_id(input))
            in_subtree_capture_id = Traits::subtree_capture_id(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_subtree_capture_id)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView>(
            in_subtree_capture_id, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null subtree_capture_id in VideoCaptureSubTarget union");
        fragment->data.f_subtree_capture_id.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::viz::mojom::VideoCaptureSubTargetDataView::Tag::kRegionCaptureCropId: {
        decltype(Traits::region_capture_crop_id(input))
            in_region_capture_crop_id = Traits::region_capture_crop_id(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_region_capture_crop_id)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
            in_region_capture_crop_id, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null region_capture_crop_id in VideoCaptureSubTarget union");
        fragment->data.f_region_capture_crop_id.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::viz::mojom::internal::VideoCaptureSubTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::VideoCaptureSubTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void VideoCaptureTargetDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}
inline void VideoCaptureTargetDataView::GetSubTargetDataView(
    VideoCaptureSubTargetDataView* output) {
  auto pointer = &data_->sub_target;
  *output = VideoCaptureSubTargetDataView(pointer, message_);
}


inline void VideoCaptureSubTargetDataView::GetSubtreeCaptureIdDataView(
    ::viz::mojom::SubtreeCaptureIdDataView* output) const {
  CHECK(is_subtree_capture_id());
  *output = ::viz::mojom::SubtreeCaptureIdDataView(data_->data.f_subtree_capture_id.Get(), message_);
}
inline void VideoCaptureSubTargetDataView::GetRegionCaptureCropIdDataView(
    ::mojo_base::mojom::TokenDataView* output) const {
  CHECK(is_region_capture_crop_id());
  *output = ::mojo_base::mojom::TokenDataView(data_->data.f_region_capture_crop_id.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::BufferFormatPreference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::BufferFormatPreference value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SHARED_H_