/*=================================================================*/
/* Copyright (C)  2024  Greg Landrum and other RDKit contributors  */
/* Contributed by NextMove Software, Cambridge, UK.                */
/*                                                                 */
/*                                                                 */
/* @@ All Rights Reserved @@                                       */
/* The contents are covered by the terms of the                    */
/* BSD license, which is included in the file                      */
/* license.txt.                                                    */
/*=================================================================*/

// set of standard dots for computing the DCLV values
// based on a 320 faced polyhedron
#pragma once
#include <Geometry/point.h>

#define NUMDOTS 320

double standardArea = 12.3298;
double dotArea = 0.03853087;

// static const float standardDots[NUMDOTS][3] 
static const RDGeom::Point3D standardDots[NUMDOTS] = {
    {-0.577350f, -0.577350f, -0.577350f}, {-0.448278f, -0.547076f, -0.706934f},
    {-0.706934f, -0.448278f, -0.547076f}, {-0.547076f, -0.706934f, -0.448278f},
    {-0.286211f, -0.762327f, -0.580467f}, {-0.142204f, -0.816797f, -0.559125f},
    {-0.302648f, -0.639218f, -0.706968f}, {-0.400803f, -0.798035f, -0.449997f},
    {-0.580467f, -0.286211f, -0.762327f}, {-0.449997f, -0.400803f, -0.798035f},
    {-0.559125f, -0.142204f, -0.816797f}, {-0.706968f, -0.302648f, -0.639218f},
    {-0.762327f, -0.580467f, -0.286211f}, {-0.639218f, -0.706968f, -0.302648f},
    {-0.798035f, -0.449997f, -0.400803f}, {-0.816797f, -0.559125f, -0.142204f},
    {0.000000f, -0.356822f, -0.934172f},  {-0.159858f, -0.436909f, -0.885187f},
    {0.000000f, -0.178253f, -0.983985f},  {0.159858f, -0.436909f, -0.885187f},
    {0.000000f, -0.653004f, -0.757355f},  {0.000000f, -0.762480f, -0.647012f},
    {-0.158817f, -0.584279f, -0.795861f}, {0.158817f, -0.584279f, -0.795861f},
    {-0.294256f, -0.176888f, -0.939215f}, {-0.306166f, -0.345864f, -0.886928f},
    {-0.416921f, -0.087887f, -0.904684f}, {-0.147349f, -0.088893f, -0.985082f},
    {0.294256f, -0.176888f, -0.939215f},  {0.306166f, -0.345864f, -0.886928f},
    {0.147349f, -0.088893f, -0.985082f},  {0.416921f, -0.087887f, -0.904684f},
    {-0.356822f, -0.934172f, 0.000000f},  {-0.436909f, -0.885187f, -0.159858f},
    {-0.436909f, -0.885187f, 0.159858f},  {-0.178253f, -0.983985f, 0.000000f},
    {-0.176888f, -0.939215f, -0.294256f}, {-0.087887f, -0.904684f, -0.416921f},
    {-0.345864f, -0.886928f, -0.306166f}, {-0.088893f, -0.985082f, -0.147349f},
    {-0.653004f, -0.757355f, 0.000000f},  {-0.584279f, -0.795861f, -0.158817f},
    {-0.762480f, -0.647012f, 0.000000f},  {-0.584279f, -0.795861f, 0.158817f},
    {-0.176888f, -0.939215f, 0.294256f},  {-0.088893f, -0.985082f, 0.147349f},
    {-0.345864f, -0.886928f, 0.306166f},  {-0.087887f, -0.904684f, 0.416921f},
    {0.356822f, -0.934172f, 0.000000f},   {0.178253f, -0.983985f, 0.000000f},
    {0.436909f, -0.885187f, 0.159858f},   {0.436909f, -0.885187f, -0.159858f},
    {0.176888f, -0.939215f, -0.294256f},  {0.087887f, -0.904684f, -0.416921f},
    {0.088893f, -0.985082f, -0.147349f},  {0.345864f, -0.886928f, -0.306166f},
    {0.176888f, -0.939215f, 0.294256f},   {0.088893f, -0.985082f, 0.147349f},
    {0.087887f, -0.904684f, 0.416921f},   {0.345864f, -0.886928f, 0.306166f},
    {0.653004f, -0.757355f, 0.000000f},   {0.584279f, -0.795861f, -0.158817f},
    {0.584279f, -0.795861f, 0.158817f},   {0.762480f, -0.647012f, 0.000000f},
    {0.577350f, -0.577350f, -0.577350f},  {0.448278f, -0.547076f, -0.706934f},
    {0.706934f, -0.448278f, -0.547076f},  {0.547076f, -0.706934f, -0.448278f},
    {0.286211f, -0.762327f, -0.580467f},  {0.142204f, -0.816797f, -0.559125f},
    {0.302648f, -0.639218f, -0.706968f},  {0.400803f, -0.798035f, -0.449997f},
    {0.580467f, -0.286211f, -0.762327f},  {0.449997f, -0.400803f, -0.798035f},
    {0.559125f, -0.142204f, -0.816797f},  {0.706968f, -0.302648f, -0.639218f},
    {0.762327f, -0.580467f, -0.286211f},  {0.639218f, -0.706968f, -0.302648f},
    {0.798035f, -0.449997f, -0.400803f},  {0.816797f, -0.559125f, -0.142204f},
    {-0.934172f, 0.000000f, -0.356822f},  {-0.885187f, -0.159858f, -0.436909f},
    {-0.983985f, 0.000000f, -0.178253f},  {-0.885187f, 0.159858f, -0.436909f},
    {-0.757355f, 0.000000f, -0.653004f},  {-0.647012f, 0.000000f, -0.762480f},
    {-0.795861f, -0.158817f, -0.584279f}, {-0.795861f, 0.158817f, -0.584279f},
    {-0.939215f, -0.294256f, -0.176888f}, {-0.886928f, -0.306166f, -0.345864f},
    {-0.904684f, -0.416921f, -0.087887f}, {-0.985082f, -0.147349f, -0.088893f},
    {-0.939215f, 0.294256f, -0.176888f},  {-0.886928f, 0.306166f, -0.345864f},
    {-0.985082f, 0.147349f, -0.088893f},  {-0.904684f, 0.416921f, -0.087887f},
    {0.000000f, 0.356822f, -0.934172f},   {0.000000f, 0.178253f, -0.983985f},
    {0.159858f, 0.436909f, -0.885187f},   {-0.159858f, 0.436909f, -0.885187f},
    {-0.294256f, 0.176888f, -0.939215f},  {-0.416921f, 0.087887f, -0.904684f},
    {-0.147349f, 0.088893f, -0.985082f},  {-0.306166f, 0.345864f, -0.886928f},
    {0.294256f, 0.176888f, -0.939215f},   {0.147349f, 0.088893f, -0.985082f},
    {0.416921f, 0.087887f, -0.904684f},   {0.306166f, 0.345864f, -0.886928f},
    {0.000000f, 0.653004f, -0.757355f},   {-0.158817f, 0.584279f, -0.795861f},
    {0.158817f, 0.584279f, -0.795861f},   {0.000000f, 0.762480f, -0.647012f},
    {-0.577350f, 0.577350f, -0.577350f},  {-0.706934f, 0.448278f, -0.547076f},
    {-0.547076f, 0.706934f, -0.448278f},  {-0.448278f, 0.547076f, -0.706934f},
    {-0.580467f, 0.286211f, -0.762327f},  {-0.559125f, 0.142204f, -0.816797f},
    {-0.706968f, 0.302648f, -0.639218f},  {-0.449997f, 0.400803f, -0.798035f},
    {-0.762327f, 0.580467f, -0.286211f},  {-0.798035f, 0.449997f, -0.400803f},
    {-0.816797f, 0.559125f, -0.142204f},  {-0.639218f, 0.706968f, -0.302648f},
    {-0.286211f, 0.762327f, -0.580467f},  {-0.302648f, 0.639218f, -0.706968f},
    {-0.400803f, 0.798035f, -0.449997f},  {-0.142204f, 0.816797f, -0.559125f},
    {-0.577350f, -0.577350f, 0.577350f},  {-0.547076f, -0.706934f, 0.448278f},
    {-0.448278f, -0.547076f, 0.706934f},  {-0.706934f, -0.448278f, 0.547076f},
    {-0.762327f, -0.580467f, 0.286211f},  {-0.816797f, -0.559125f, 0.142204f},
    {-0.639218f, -0.706968f, 0.302648f},  {-0.798035f, -0.449997f, 0.400803f},
    {-0.286211f, -0.762327f, 0.580467f},  {-0.400803f, -0.798035f, 0.449997f},
    {-0.142204f, -0.816797f, 0.559125f},  {-0.302648f, -0.639218f, 0.706968f},
    {-0.580467f, -0.286211f, 0.762327f},  {-0.706968f, -0.302648f, 0.639218f},
    {-0.449997f, -0.400803f, 0.798035f},  {-0.559125f, -0.142204f, 0.816797f},
    {-0.934172f, 0.000000f, 0.356822f},   {-0.983985f, 0.000000f, 0.178253f},
    {-0.885187f, 0.159858f, 0.436909f},   {-0.885187f, -0.159858f, 0.436909f},
    {-0.939215f, -0.294256f, 0.176888f},  {-0.904684f, -0.416921f, 0.087887f},
    {-0.985082f, -0.147349f, 0.088893f},  {-0.886928f, -0.306166f, 0.345864f},
    {-0.939215f, 0.294256f, 0.176888f},   {-0.985082f, 0.147349f, 0.088893f},
    {-0.904684f, 0.416921f, 0.087887f},   {-0.886928f, 0.306166f, 0.345864f},
    {-0.757355f, 0.000000f, 0.653004f},   {-0.795861f, -0.158817f, 0.584279f},
    {-0.795861f, 0.158817f, 0.584279f},   {-0.647012f, 0.000000f, 0.762480f},
    {0.934172f, 0.000000f, -0.356822f},   {0.885187f, -0.159858f, -0.436909f},
    {0.983985f, 0.000000f, -0.178253f},   {0.885187f, 0.159858f, -0.436909f},
    {0.757355f, 0.000000f, -0.653004f},   {0.647012f, 0.000000f, -0.762480f},
    {0.795861f, -0.158817f, -0.584279f},  {0.795861f, 0.158817f, -0.584279f},
    {0.939215f, -0.294256f, -0.176888f},  {0.886928f, -0.306166f, -0.345864f},
    {0.904684f, -0.416921f, -0.087887f},  {0.985082f, -0.147349f, -0.088893f},
    {0.939215f, 0.294256f, -0.176888f},   {0.886928f, 0.306166f, -0.345864f},
    {0.985082f, 0.147349f, -0.088893f},   {0.904684f, 0.416921f, -0.087887f},
    {0.577350f, 0.577350f, -0.577350f},   {0.448278f, 0.547076f, -0.706934f},
    {0.547076f, 0.706934f, -0.448278f},   {0.706934f, 0.448278f, -0.547076f},
    {0.580467f, 0.286211f, -0.762327f},   {0.559125f, 0.142204f, -0.816797f},
    {0.449997f, 0.400803f, -0.798035f},   {0.706968f, 0.302648f, -0.639218f},
    {0.286211f, 0.762327f, -0.580467f},   {0.302648f, 0.639218f, -0.706968f},
    {0.142204f, 0.816797f, -0.559125f},   {0.400803f, 0.798035f, -0.449997f},
    {0.762327f, 0.580467f, -0.286211f},   {0.798035f, 0.449997f, -0.400803f},
    {0.639218f, 0.706968f, -0.302648f},   {0.816797f, 0.559125f, -0.142204f},
    {0.577350f, -0.577350f, 0.577350f},   {0.547076f, -0.706934f, 0.448278f},
    {0.706934f, -0.448278f, 0.547076f},   {0.448278f, -0.547076f, 0.706934f},
    {0.286211f, -0.762327f, 0.580467f},   {0.142204f, -0.816797f, 0.559125f},
    {0.400803f, -0.798035f, 0.449997f},   {0.302648f, -0.639218f, 0.706968f},
    {0.762327f, -0.580467f, 0.286211f},   {0.639218f, -0.706968f, 0.302648f},
    {0.816797f, -0.559125f, 0.142204f},   {0.798035f, -0.449997f, 0.400803f},
    {0.580467f, -0.286211f, 0.762327f},   {0.449997f, -0.400803f, 0.798035f},
    {0.706968f, -0.302648f, 0.639218f},   {0.559125f, -0.142204f, 0.816797f},
    {0.000000f, -0.356822f, 0.934172f},   {-0.159858f, -0.436909f, 0.885187f},
    {0.000000f, -0.178253f, 0.983985f},   {0.159858f, -0.436909f, 0.885187f},
    {0.000000f, -0.653004f, 0.757355f},   {0.000000f, -0.762480f, 0.647012f},
    {-0.158817f, -0.584279f, 0.795861f},  {0.158817f, -0.584279f, 0.795861f},
    {-0.294256f, -0.176888f, 0.939215f},  {-0.306166f, -0.345864f, 0.886928f},
    {-0.416921f, -0.087887f, 0.904684f},  {-0.147349f, -0.088893f, 0.985082f},
    {0.294256f, -0.176888f, 0.939215f},   {0.306166f, -0.345864f, 0.886928f},
    {0.147349f, -0.088893f, 0.985082f},   {0.416921f, -0.087887f, 0.904684f},
    {0.934172f, 0.000000f, 0.356822f},    {0.885187f, -0.159858f, 0.436909f},
    {0.885187f, 0.159858f, 0.436909f},    {0.983985f, 0.000000f, 0.178253f},
    {0.939215f, -0.294256f, 0.176888f},   {0.904684f, -0.416921f, 0.087887f},
    {0.886928f, -0.306166f, 0.345864f},   {0.985082f, -0.147349f, 0.088893f},
    {0.757355f, 0.000000f, 0.653004f},    {0.795861f, -0.158817f, 0.584279f},
    {0.647012f, 0.000000f, 0.762480f},    {0.795861f, 0.158817f, 0.584279f},
    {0.939215f, 0.294256f, 0.176888f},    {0.985082f, 0.147349f, 0.088893f},
    {0.886928f, 0.306166f, 0.345864f},    {0.904684f, 0.416921f, 0.087887f},
    {-0.577350f, 0.577350f, 0.577350f},   {-0.706934f, 0.448278f, 0.547076f},
    {-0.448278f, 0.547076f, 0.706934f},   {-0.547076f, 0.706934f, 0.448278f},
    {-0.762327f, 0.580467f, 0.286211f},   {-0.816797f, 0.559125f, 0.142204f},
    {-0.798035f, 0.449997f, 0.400803f},   {-0.639218f, 0.706968f, 0.302648f},
    {-0.580467f, 0.286211f, 0.762327f},   {-0.706968f, 0.302648f, 0.639218f},
    {-0.559125f, 0.142204f, 0.816797f},   {-0.449997f, 0.400803f, 0.798035f},
    {-0.286211f, 0.762327f, 0.580467f},   {-0.400803f, 0.798035f, 0.449997f},
    {-0.302648f, 0.639218f, 0.706968f},   {-0.142204f, 0.816797f, 0.559125f},
    {-0.356822f, 0.934172f, 0.000000f},   {-0.436909f, 0.885187f, -0.159858f},
    {-0.178253f, 0.983985f, 0.000000f},   {-0.436909f, 0.885187f, 0.159858f},
    {-0.653004f, 0.757355f, 0.000000f},   {-0.762480f, 0.647012f, 0.000000f},
    {-0.584279f, 0.795861f, -0.158817f},  {-0.584279f, 0.795861f, 0.158817f},
    {-0.176888f, 0.939215f, -0.294256f},  {-0.345864f, 0.886928f, -0.306166f},
    {-0.087887f, 0.904684f, -0.416921f},  {-0.088893f, 0.985082f, -0.147349f},
    {-0.176888f, 0.939215f, 0.294256f},   {-0.345864f, 0.886928f, 0.306166f},
    {-0.088893f, 0.985082f, 0.147349f},   {-0.087887f, 0.904684f, 0.416921f},
    {0.356822f, 0.934172f, 0.000000f},    {0.178253f, 0.983985f, 0.000000f},
    {0.436909f, 0.885187f, 0.159858f},    {0.436909f, 0.885187f, -0.159858f},
    {0.176888f, 0.939215f, -0.294256f},   {0.087887f, 0.904684f, -0.416921f},
    {0.088893f, 0.985082f, -0.147349f},   {0.345864f, 0.886928f, -0.306166f},
    {0.176888f, 0.939215f, 0.294256f},    {0.088893f, 0.985082f, 0.147349f},
    {0.087887f, 0.904684f, 0.416921f},    {0.345864f, 0.886928f, 0.306166f},
    {0.653004f, 0.757355f, 0.000000f},    {0.584279f, 0.795861f, -0.158817f},
    {0.584279f, 0.795861f, 0.158817f},    {0.762480f, 0.647012f, 0.000000f},
    {0.000000f, 0.356822f, 0.934172f},    {-0.159858f, 0.436909f, 0.885187f},
    {0.159858f, 0.436909f, 0.885187f},    {0.000000f, 0.178253f, 0.983985f},
    {-0.294256f, 0.176888f, 0.939215f},   {-0.416921f, 0.087887f, 0.904684f},
    {-0.306166f, 0.345864f, 0.886928f},   {-0.147349f, 0.088893f, 0.985082f},
    {0.000000f, 0.653004f, 0.757355f},    {-0.158817f, 0.584279f, 0.795861f},
    {0.000000f, 0.762480f, 0.647012f},    {0.158817f, 0.584279f, 0.795861f},
    {0.294256f, 0.176888f, 0.939215f},    {0.147349f, 0.088893f, 0.985082f},
    {0.306166f, 0.345864f, 0.886928f},    {0.416921f, 0.087887f, 0.904684f},
    {0.577350f, 0.577350f, 0.577350f},    {0.448278f, 0.547076f, 0.706934f},
    {0.706934f, 0.448278f, 0.547076f},    {0.547076f, 0.706934f, 0.448278f},
    {0.286211f, 0.762327f, 0.580467f},    {0.142204f, 0.816797f, 0.559125f},
    {0.302648f, 0.639218f, 0.706968f},    {0.400803f, 0.798035f, 0.449997f},
    {0.580467f, 0.286211f, 0.762327f},    {0.449997f, 0.400803f, 0.798035f},
    {0.559125f, 0.142204f, 0.816797f},    {0.706968f, 0.302648f, 0.639218f},
    {0.762327f, 0.580467f, 0.286211f},    {0.639218f, 0.706968f, 0.302648f},
    {0.798035f, 0.449997f, 0.400803f},    {0.816797f, 0.559125f, 0.142204f}};