// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/monitoring/v3/uptime_service.proto

package monitoringpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	UptimeCheckService_ListUptimeCheckConfigs_FullMethodName  = "/google.monitoring.v3.UptimeCheckService/ListUptimeCheckConfigs"
	UptimeCheckService_GetUptimeCheckConfig_FullMethodName    = "/google.monitoring.v3.UptimeCheckService/GetUptimeCheckConfig"
	UptimeCheckService_CreateUptimeCheckConfig_FullMethodName = "/google.monitoring.v3.UptimeCheckService/CreateUptimeCheckConfig"
	UptimeCheckService_UpdateUptimeCheckConfig_FullMethodName = "/google.monitoring.v3.UptimeCheckService/UpdateUptimeCheckConfig"
	UptimeCheckService_DeleteUptimeCheckConfig_FullMethodName = "/google.monitoring.v3.UptimeCheckService/DeleteUptimeCheckConfig"
	UptimeCheckService_ListUptimeCheckIps_FullMethodName      = "/google.monitoring.v3.UptimeCheckService/ListUptimeCheckIps"
)

// UptimeCheckServiceClient is the client API for UptimeCheckService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type UptimeCheckServiceClient interface {
	// Lists the existing valid Uptime check configurations for the project
	// (leaving out any invalid configurations).
	ListUptimeCheckConfigs(ctx context.Context, in *ListUptimeCheckConfigsRequest, opts ...grpc.CallOption) (*ListUptimeCheckConfigsResponse, error)
	// Gets a single Uptime check configuration.
	GetUptimeCheckConfig(ctx context.Context, in *GetUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error)
	// Creates a new Uptime check configuration.
	CreateUptimeCheckConfig(ctx context.Context, in *CreateUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error)
	// Updates an Uptime check configuration. You can either replace the entire
	// configuration with a new one or replace only certain fields in the current
	// configuration by specifying the fields to be updated via `updateMask`.
	// Returns the updated configuration.
	UpdateUptimeCheckConfig(ctx context.Context, in *UpdateUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error)
	// Deletes an Uptime check configuration. Note that this method will fail
	// if the Uptime check configuration is referenced by an alert policy or
	// other dependent configs that would be rendered invalid by the deletion.
	DeleteUptimeCheckConfig(ctx context.Context, in *DeleteUptimeCheckConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of IP addresses that checkers run from.
	ListUptimeCheckIps(ctx context.Context, in *ListUptimeCheckIpsRequest, opts ...grpc.CallOption) (*ListUptimeCheckIpsResponse, error)
}

type uptimeCheckServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUptimeCheckServiceClient(cc grpc.ClientConnInterface) UptimeCheckServiceClient {
	return &uptimeCheckServiceClient{cc}
}

func (c *uptimeCheckServiceClient) ListUptimeCheckConfigs(ctx context.Context, in *ListUptimeCheckConfigsRequest, opts ...grpc.CallOption) (*ListUptimeCheckConfigsResponse, error) {
	out := new(ListUptimeCheckConfigsResponse)
	err := c.cc.Invoke(ctx, UptimeCheckService_ListUptimeCheckConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *uptimeCheckServiceClient) GetUptimeCheckConfig(ctx context.Context, in *GetUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error) {
	out := new(UptimeCheckConfig)
	err := c.cc.Invoke(ctx, UptimeCheckService_GetUptimeCheckConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *uptimeCheckServiceClient) CreateUptimeCheckConfig(ctx context.Context, in *CreateUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error) {
	out := new(UptimeCheckConfig)
	err := c.cc.Invoke(ctx, UptimeCheckService_CreateUptimeCheckConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *uptimeCheckServiceClient) UpdateUptimeCheckConfig(ctx context.Context, in *UpdateUptimeCheckConfigRequest, opts ...grpc.CallOption) (*UptimeCheckConfig, error) {
	out := new(UptimeCheckConfig)
	err := c.cc.Invoke(ctx, UptimeCheckService_UpdateUptimeCheckConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *uptimeCheckServiceClient) DeleteUptimeCheckConfig(ctx context.Context, in *DeleteUptimeCheckConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, UptimeCheckService_DeleteUptimeCheckConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *uptimeCheckServiceClient) ListUptimeCheckIps(ctx context.Context, in *ListUptimeCheckIpsRequest, opts ...grpc.CallOption) (*ListUptimeCheckIpsResponse, error) {
	out := new(ListUptimeCheckIpsResponse)
	err := c.cc.Invoke(ctx, UptimeCheckService_ListUptimeCheckIps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UptimeCheckServiceServer is the server API for UptimeCheckService service.
// All implementations should embed UnimplementedUptimeCheckServiceServer
// for forward compatibility
type UptimeCheckServiceServer interface {
	// Lists the existing valid Uptime check configurations for the project
	// (leaving out any invalid configurations).
	ListUptimeCheckConfigs(context.Context, *ListUptimeCheckConfigsRequest) (*ListUptimeCheckConfigsResponse, error)
	// Gets a single Uptime check configuration.
	GetUptimeCheckConfig(context.Context, *GetUptimeCheckConfigRequest) (*UptimeCheckConfig, error)
	// Creates a new Uptime check configuration.
	CreateUptimeCheckConfig(context.Context, *CreateUptimeCheckConfigRequest) (*UptimeCheckConfig, error)
	// Updates an Uptime check configuration. You can either replace the entire
	// configuration with a new one or replace only certain fields in the current
	// configuration by specifying the fields to be updated via `updateMask`.
	// Returns the updated configuration.
	UpdateUptimeCheckConfig(context.Context, *UpdateUptimeCheckConfigRequest) (*UptimeCheckConfig, error)
	// Deletes an Uptime check configuration. Note that this method will fail
	// if the Uptime check configuration is referenced by an alert policy or
	// other dependent configs that would be rendered invalid by the deletion.
	DeleteUptimeCheckConfig(context.Context, *DeleteUptimeCheckConfigRequest) (*emptypb.Empty, error)
	// Returns the list of IP addresses that checkers run from.
	ListUptimeCheckIps(context.Context, *ListUptimeCheckIpsRequest) (*ListUptimeCheckIpsResponse, error)
}

// UnimplementedUptimeCheckServiceServer should be embedded to have forward compatible implementations.
type UnimplementedUptimeCheckServiceServer struct {
}

func (UnimplementedUptimeCheckServiceServer) ListUptimeCheckConfigs(context.Context, *ListUptimeCheckConfigsRequest) (*ListUptimeCheckConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUptimeCheckConfigs not implemented")
}
func (UnimplementedUptimeCheckServiceServer) GetUptimeCheckConfig(context.Context, *GetUptimeCheckConfigRequest) (*UptimeCheckConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUptimeCheckConfig not implemented")
}
func (UnimplementedUptimeCheckServiceServer) CreateUptimeCheckConfig(context.Context, *CreateUptimeCheckConfigRequest) (*UptimeCheckConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUptimeCheckConfig not implemented")
}
func (UnimplementedUptimeCheckServiceServer) UpdateUptimeCheckConfig(context.Context, *UpdateUptimeCheckConfigRequest) (*UptimeCheckConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUptimeCheckConfig not implemented")
}
func (UnimplementedUptimeCheckServiceServer) DeleteUptimeCheckConfig(context.Context, *DeleteUptimeCheckConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUptimeCheckConfig not implemented")
}
func (UnimplementedUptimeCheckServiceServer) ListUptimeCheckIps(context.Context, *ListUptimeCheckIpsRequest) (*ListUptimeCheckIpsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUptimeCheckIps not implemented")
}

// UnsafeUptimeCheckServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UptimeCheckServiceServer will
// result in compilation errors.
type UnsafeUptimeCheckServiceServer interface {
	mustEmbedUnimplementedUptimeCheckServiceServer()
}

func RegisterUptimeCheckServiceServer(s grpc.ServiceRegistrar, srv UptimeCheckServiceServer) {
	s.RegisterService(&UptimeCheckService_ServiceDesc, srv)
}

func _UptimeCheckService_ListUptimeCheckConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUptimeCheckConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).ListUptimeCheckConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_ListUptimeCheckConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).ListUptimeCheckConfigs(ctx, req.(*ListUptimeCheckConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UptimeCheckService_GetUptimeCheckConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUptimeCheckConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).GetUptimeCheckConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_GetUptimeCheckConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).GetUptimeCheckConfig(ctx, req.(*GetUptimeCheckConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UptimeCheckService_CreateUptimeCheckConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUptimeCheckConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).CreateUptimeCheckConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_CreateUptimeCheckConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).CreateUptimeCheckConfig(ctx, req.(*CreateUptimeCheckConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UptimeCheckService_UpdateUptimeCheckConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUptimeCheckConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).UpdateUptimeCheckConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_UpdateUptimeCheckConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).UpdateUptimeCheckConfig(ctx, req.(*UpdateUptimeCheckConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UptimeCheckService_DeleteUptimeCheckConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUptimeCheckConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).DeleteUptimeCheckConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_DeleteUptimeCheckConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).DeleteUptimeCheckConfig(ctx, req.(*DeleteUptimeCheckConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UptimeCheckService_ListUptimeCheckIps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUptimeCheckIpsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UptimeCheckServiceServer).ListUptimeCheckIps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UptimeCheckService_ListUptimeCheckIps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UptimeCheckServiceServer).ListUptimeCheckIps(ctx, req.(*ListUptimeCheckIpsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UptimeCheckService_ServiceDesc is the grpc.ServiceDesc for UptimeCheckService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UptimeCheckService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.UptimeCheckService",
	HandlerType: (*UptimeCheckServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListUptimeCheckConfigs",
			Handler:    _UptimeCheckService_ListUptimeCheckConfigs_Handler,
		},
		{
			MethodName: "GetUptimeCheckConfig",
			Handler:    _UptimeCheckService_GetUptimeCheckConfig_Handler,
		},
		{
			MethodName: "CreateUptimeCheckConfig",
			Handler:    _UptimeCheckService_CreateUptimeCheckConfig_Handler,
		},
		{
			MethodName: "UpdateUptimeCheckConfig",
			Handler:    _UptimeCheckService_UpdateUptimeCheckConfig_Handler,
		},
		{
			MethodName: "DeleteUptimeCheckConfig",
			Handler:    _UptimeCheckService_DeleteUptimeCheckConfig_Handler,
		},
		{
			MethodName: "ListUptimeCheckIps",
			Handler:    _UptimeCheckService_ListUptimeCheckIps_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/uptime_service.proto",
}
