/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	context "context"

	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsresourcev1alpha3 "k8s.io/client-go/applyconfigurations/resource/v1alpha3"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// DeviceTaintRulesGetter has a method to return a DeviceTaintRuleInterface.
// A group's client should implement this interface.
type DeviceTaintRulesGetter interface {
	DeviceTaintRules() DeviceTaintRuleInterface
}

// DeviceTaintRuleInterface has methods to work with DeviceTaintRule resources.
type DeviceTaintRuleInterface interface {
	Create(ctx context.Context, deviceTaintRule *resourcev1alpha3.DeviceTaintRule, opts v1.CreateOptions) (*resourcev1alpha3.DeviceTaintRule, error)
	Update(ctx context.Context, deviceTaintRule *resourcev1alpha3.DeviceTaintRule, opts v1.UpdateOptions) (*resourcev1alpha3.DeviceTaintRule, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, deviceTaintRule *resourcev1alpha3.DeviceTaintRule, opts v1.UpdateOptions) (*resourcev1alpha3.DeviceTaintRule, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*resourcev1alpha3.DeviceTaintRule, error)
	List(ctx context.Context, opts v1.ListOptions) (*resourcev1alpha3.DeviceTaintRuleList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *resourcev1alpha3.DeviceTaintRule, err error)
	Apply(ctx context.Context, deviceTaintRule *applyconfigurationsresourcev1alpha3.DeviceTaintRuleApplyConfiguration, opts v1.ApplyOptions) (result *resourcev1alpha3.DeviceTaintRule, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, deviceTaintRule *applyconfigurationsresourcev1alpha3.DeviceTaintRuleApplyConfiguration, opts v1.ApplyOptions) (result *resourcev1alpha3.DeviceTaintRule, err error)
	DeviceTaintRuleExpansion
}

// deviceTaintRules implements DeviceTaintRuleInterface
type deviceTaintRules struct {
	*gentype.ClientWithListAndApply[*resourcev1alpha3.DeviceTaintRule, *resourcev1alpha3.DeviceTaintRuleList, *applyconfigurationsresourcev1alpha3.DeviceTaintRuleApplyConfiguration]
}

// newDeviceTaintRules returns a DeviceTaintRules
func newDeviceTaintRules(c *ResourceV1alpha3Client) *deviceTaintRules {
	return &deviceTaintRules{
		gentype.NewClientWithListAndApply[*resourcev1alpha3.DeviceTaintRule, *resourcev1alpha3.DeviceTaintRuleList, *applyconfigurationsresourcev1alpha3.DeviceTaintRuleApplyConfiguration](
			"devicetaintrules",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *resourcev1alpha3.DeviceTaintRule { return &resourcev1alpha3.DeviceTaintRule{} },
			func() *resourcev1alpha3.DeviceTaintRuleList { return &resourcev1alpha3.DeviceTaintRuleList{} },
			gentype.PrefersProtobuf[*resourcev1alpha3.DeviceTaintRule](),
		),
	}
}
