// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGfxMetrics_h
#define mozilla_GleanGfxMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace performance_interaction {
  /**
   * generated from performance.interaction.keypress_present_latency
   * Time between receiving a keypress event in the event loop and compositing its result onto the screen. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric keypress_present_latency(1075);

  /**
   * generated from performance.interaction.mouseup_click_present_latency
   * Time between receiving a mouseup which follow by a mouseclick on the event loop and compositing its result onto the screen. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric mouseup_click_present_latency(1076);
}

namespace apz_zoom {
  /**
   * generated from apz_zoom.activity
   */
  enum class ActivityLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether non-RDM page had user-triggered zooming activity
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram APZ_ZOOM_ACTIVITY.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ActivityLabel> activity(4010);

  /**
   * generated from apz_zoom.pinchsource
   * Input device that triggered the zoom gesture (InputData::PinchGestureSource)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram APZ_ZOOM_PINCHSOURCE.
   */
  constexpr impl::CustomDistributionMetric pinchsource(4011);
}

namespace fontlist {
  /**
   * generated from fontlist.bad_fallback_font
   */
  enum class BadFallbackFontLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * system fallback font can't be used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BAD_FALLBACK_FONT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BadFallbackFontLabel> bad_fallback_font(4012);

  /**
   * generated from fontlist.bundledfonts_activate
   * Time(ms) spent activating additional fonts bundled with the product
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FONTLIST_BUNDLEDFONTS_ACTIVATE.
   */
  constexpr impl::TimingDistributionMetric bundledfonts_activate(4013);

  /**
   * generated from fontlist.dwritefont_delayedinit_collect
   * gfxDWriteFontList::DelayedInitFontList GetSystemFontCollection (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DWRITEFONT_DELAYEDINITFONTLIST_COLLECT.
   */
  constexpr impl::TimingDistributionMetric dwritefont_delayedinit_collect(4014);

  /**
   * generated from fontlist.dwritefont_delayedinit_count
   * gfxDWriteFontList::DelayedInitFontList Font Family Count
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DWRITEFONT_DELAYEDINITFONTLIST_COUNT.
   */
  constexpr impl::CustomDistributionMetric dwritefont_delayedinit_count(4015);

  /**
   * generated from fontlist.dwritefont_delayedinit_total
   * gfxDWriteFontList::DelayedInitFontList Total (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DWRITEFONT_DELAYEDINITFONTLIST_TOTAL.
   */
  constexpr impl::TimingDistributionMetric dwritefont_delayedinit_total(4016);

  /**
   * generated from fontlist.dwritefont_init_problem
   * DirectWrite system fontlist initialization problem (1=GDI interop, 2=system font collection, 3=no fonts)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DWRITEFONT_INIT_PROBLEM.
   */
  constexpr impl::CustomDistributionMetric dwritefont_init_problem(4017);

  /**
   * generated from fontlist.font_cache_hit
   */
  enum class FontCacheHitLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * font cache hit
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram FONT_CACHE_HIT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FontCacheHitLabel> font_cache_hit(4018);

  /**
   * generated from fontlist.initfacenamelists
   * Time(ms) spent on reading family names from all fonts
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FONTLIST_INITFACENAMELISTS.
   */
  constexpr impl::TimingDistributionMetric initfacenamelists(4019);

  /**
   * generated from fontlist.initotherfamilynames
   * Time(ms) spent on reading other family names from all fonts
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FONTLIST_INITOTHERFAMILYNAMES.
   */
  constexpr impl::TimingDistributionMetric initotherfamilynames(4020);

  /**
   * generated from fontlist.initotherfamilynames_no_deferring
   * Time(ms) spent on reading other family names from all fonts for no timeout case
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FONTLIST_INITOTHERFAMILYNAMES_NO_DEFERRING.
   */
  constexpr impl::TimingDistributionMetric initotherfamilynames_no_deferring(4021);

  /**
   * generated from fontlist.mac_init_total
   * gfxMacPlatformFontList::InitFontList Total (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MAC_INITFONTLIST_TOTAL.
   */
  constexpr impl::TimingDistributionMetric mac_init_total(4022);

  /**
   * generated from fontlist.system_font_fallback
   * System font fallback (us)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SYSTEM_FONT_FALLBACK.
   */
  constexpr impl::TimingDistributionMetric system_font_fallback(4023);

  /**
   * generated from fontlist.system_font_fallback_first
   * System font fallback, first call (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SYSTEM_FONT_FALLBACK_FIRST.
   */
  constexpr impl::TimingDistributionMetric system_font_fallback_first(4024);
}

namespace gfx {
  /**
   * generated from gfx.composite_frame_roundtrip_time
   * Time from vsync to finishing a composite in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram COMPOSITE_FRAME_ROUNDTRIP_TIME.
   */
  constexpr impl::TimingDistributionMetric composite_frame_roundtrip_time(4025);

  /**
   * generated from gfx.composite_swap_time
   * Time to do swap/present/commit in 100 microseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram COMPOSITE_SWAP_TIME.
   */
  constexpr impl::CustomDistributionMetric composite_swap_time(4026);

  /**
   * generated from gfx.composite_time
   * The time taken to composite a frame. On non-webrender this is the time taken in `CompositorBridgeParent::CompositeToTarget()`. On webrender, this is the time taken from the start of `WebRenderBridgeParent::CompositeToTarget()`, until the render thread has rendered the frame (in `RenderThread::HandleFrameOneDoc()`). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric composite_time(4027);

  /**
   * generated from gfx.content_failed_to_acquire_device
   * Failed to create a gfx content device. 0=content d3d11, 1=image d3d11, 2=d2d1.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram GFX_CONTENT_FAILED_TO_ACQUIRE_DEVICE.
   */
  constexpr impl::CustomDistributionMetric content_failed_to_acquire_device(4028);

  /**
   * generated from gfx.crash
   * Graphics Crash Reason (...)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram GFX_CRASH.
   */
  constexpr impl::CustomDistributionMetric crash(4029);

  /**
   * generated from gfx.device_reset_reason
   * GPU Device Reset Reason (ok, hung, removed, reset, internal error, invalid call, out of memory)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DEVICE_RESET_REASON.
   */
  constexpr impl::CustomDistributionMetric device_reset_reason(4030);

  /**
   * generated from gfx.forced_device_reset_reason
   * GPU Forced Device Reset Reason (OpenSharedHandle)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FORCED_DEVICE_RESET_REASON.
   */
  constexpr impl::CustomDistributionMetric forced_device_reset_reason(4031);

  /**
   * generated from gfx.graphics_driver_startup_test
   * Reports whether or not graphics drivers crashed during startup.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram GRAPHICS_DRIVER_STARTUP_TEST.
   */
  constexpr impl::CustomDistributionMetric graphics_driver_startup_test(4032);

  /**
   * generated from gfx.linux_window_protocol
   * Windowing protocol on Linux. Can be Wayland, WaylandDRM, XWayland, or X11 This metric was generated to correspond to the Legacy Telemetry scalar gfx.linux_window_protocol.
   */
  constexpr impl::StringMetric linux_window_protocol(4033);

  /**
   * generated from gfx.macos_video_low_power
   */
  enum class MacosVideoLowPowerLabel: uint16_t {
    eNotvideo = 0,
    eLowpower = 1,
    eFailmultiplevideo = 2,
    eFailwindowed = 3,
    eFailoverlaid = 4,
    eFailbacking = 5,
    eFailmacosversion = 6,
    eFailpref = 7,
    eFailsurface = 8,
    eFailenqueue = 9,
    e__Other__,
  };
  /**
   * MacOS video low power state achieved when enqueueing a video frame.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram GFX_MACOS_VIDEO_LOW_POWER.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MacosVideoLowPowerLabel> macos_video_low_power(4034);

  /**
   * generated from gfx.os_compositor
   * Boolean indicating whether the os compositor is being used by WebRender. Only collected in the first subsession. This metric was generated to correspond to the Legacy Telemetry scalar gfx.os_compositor.
   */
  constexpr impl::BooleanMetric os_compositor(4035);

  /**
   * generated from gfx.sanity_test
   * Reports results from the graphics sanity test to track which drivers are having problems (0=TEST_PASSED, 1=TEST_FAILED_RENDER, 2=TEST_FAILED_VIDEO, 3=TEST_CRASHED)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram GRAPHICS_SANITY_TEST.
   */
  constexpr impl::CustomDistributionMetric sanity_test(4036);

  /**
   * generated from gfx.scroll_present_latency
   * Time between receiving a scroll event on the event loop and compositing its result onto the screen (ms). (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric scroll_present_latency(4037);

  /**
   * generated from gfx.skipped_composites
   * Number of skipped composites, happening when rendering is too slow to keep up with content. This metric was generated to correspond to the Legacy Telemetry scalar gfx.skipped_composites.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> skipped_composites(4038);

  /**
   * generated from gfx.supports_hdr
   * Does the hardware support accurate display of HDR content This metric was generated to correspond to the Legacy Telemetry scalar gfx.supports_hdr.
   */
  constexpr impl::BooleanMetric supports_hdr(4039);
}

namespace gfx_adapter_primary {
  /**
   * generated from gfx.adapter.primary.description
   * Long form description of the Graphics adapter (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric description(4047);

  /**
   * generated from gfx.adapter.primary.device_id
   * Graphics adapter device identification (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric device_id(4048);

  /**
   * generated from gfx.adapter.primary.driver_date
   * Graphics adapter driver date (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric driver_date(4049);

  /**
   * generated from gfx.adapter.primary.driver_files
   * List of graphics adapter driver files (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric driver_files(4050);

  /**
   * generated from gfx.adapter.primary.driver_vendor
   * Graphics adapter driver vendor identification (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric driver_vendor(4051);

  /**
   * generated from gfx.adapter.primary.driver_version
   * Graphics adapter driver version (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric driver_version(4052);

  /**
   * generated from gfx.adapter.primary.ram
   * Graphics adapter dedicated memory (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric ram(4053);

  /**
   * generated from gfx.adapter.primary.subsystem_id
   * Graphics adapter subsystem identification (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric subsystem_id(4054);

  /**
   * generated from gfx.adapter.primary.vendor_id
   * Graphics adapter vendor identification (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric vendor_id(4055);
}

namespace gfx_checkerboard {
  /**
   * generated from gfx.checkerboard.duration
   * The duration of a checkerboard event. Checkerboarding is when painting has not kept up with asynchronous panning and zooming so the compositor has to display a "checkerboard pattern" (or in practice, the background color) rather than the actual page content. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric duration(4056);

  /**
   * generated from gfx.checkerboard.peak_pixel_count
   * The peak number of CSS pixels that checkerboarded during a checkerboard event. The minimum value of the largest histogram bucket is the size of a 4k display with maximum APZ zooming. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric peak_pixel_count(4057);

  /**
   * generated from gfx.checkerboard.potential_duration
   * The total amount of time that we could reasonably be checkerboarding. This is the union of two possibly-intersecting sets of time periods: The first set is that in which checkerboarding was actually happening, since by definition it could potentially be happening. The second set is that in which the APZC is actively transforming content in the compositor, since it could potentially transform it so as to display checkerboarding to the user. Combined with other information, this allows us to meaningfully say how frequently users actually enncounters checkerboarding. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric potential_duration(4058);

  /**
   * generated from gfx.checkerboard.severity
   * An opaque measurement of the severity of a checkerboard event. This doesn't have units, it's just useful for comparing two checkerboard events to see which one is worse, for some implementation-specific definition of "worse". The larger the value, the worse the checkerboarding. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric severity(4059);
}

namespace gfx_content {
  /**
   * generated from gfx.content.full_paint_time
   * Time spent in the full paint pipeline for content until it's ready for composition. For non-webrender this includes `paint_time`, plus rasterization if OMTP is enabled. For webrender, this includes `paint_time`, plus scene building time. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric full_paint_time(4060);

  /**
   * generated from gfx.content.large_paint_phase_weight_full
   */
  enum class LargePaintPhaseWeightFullLabel: uint16_t {
    eDl = 0,
    eWrdl = 1,
    eSb = 2,
    eFb = 3,
    e__Other__,
  };
  /**
   * Percentages of times for phases in an expensive content paint relative to the time spent in the entire expensive paint. ("dl" = Display list, "wrdl" = WebRender display list, "sb" = Scene building, "fb" = Frame building)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CONTENT_LARGE_PAINT_PHASE_WEIGHT_FULL.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, LargePaintPhaseWeightFullLabel> large_paint_phase_weight_full(4061);

  /**
   * generated from gfx.content.large_paint_phase_weight_partial
   */
  enum class LargePaintPhaseWeightPartialLabel: uint16_t {
    eDl = 0,
    eWrdl = 1,
    eSb = 2,
    eFb = 3,
    e__Other__,
  };
  /**
   * Percentages of times for phases in an expensive content paint relative to the time spent in the entire expensive paint. ("dl" = Display list, "wrdl" = WebRender display list, "sb" = Scene building, "fb" = Frame building)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CONTENT_LARGE_PAINT_PHASE_WEIGHT_PARTIAL.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, LargePaintPhaseWeightPartialLabel> large_paint_phase_weight_partial(4062);

  /**
   * generated from gfx.content.paint_time
   * Time spent in the main-thread paint pipeline for content. For non-webrender, this includes display list building, layer building, and when OMTP is disabled, rasterization. For webrender, this includes display list building, and webrender display list building. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric paint_time(4063);

  /**
   * generated from gfx.content.small_paint_phase_weight_full
   */
  enum class SmallPaintPhaseWeightFullLabel: uint16_t {
    eDl = 0,
    eWrdl = 1,
    eSb = 2,
    eFb = 3,
    e__Other__,
  };
  /**
   * Percentages of times for phases in a normal content paint relative to the time spent in the entire normal paint. ("dl" = Display list, "wrdl" = WebRender display list, "sb" = Scene building, "fb" = Frame building)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CONTENT_SMALL_PAINT_PHASE_WEIGHT_FULL.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, SmallPaintPhaseWeightFullLabel> small_paint_phase_weight_full(4064);

  /**
   * generated from gfx.content.small_paint_phase_weight_partial
   */
  enum class SmallPaintPhaseWeightPartialLabel: uint16_t {
    eDl = 0,
    eWrdl = 1,
    eSb = 2,
    eFb = 3,
    e__Other__,
  };
  /**
   * Percentages of times for phases in a normal content paint relative to the time spent in the entire normal paint. ("dl" = Display list, "wrdl" = WebRender display list, "sb" = Scene building, "fb" = Frame building)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram CONTENT_SMALL_PAINT_PHASE_WEIGHT_PARTIAL.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, SmallPaintPhaseWeightPartialLabel> small_paint_phase_weight_partial(4065);
}

namespace gfx_content_frame_time {
  /**
   * generated from gfx.content.frame_time.from_paint
   * The time, in percentage of a vsync interval, spent from beginning a paint in the content process until that frame is presented in the compositor. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric from_paint(4066);

  /**
   * generated from gfx.content.frame_time.from_vsync
   * The time, in percentage of a vsync interval, spent from the vsync that started a paint in the content process until that frame is presented in the compositor. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric from_vsync(4067);

  /**
   * generated from gfx.content.frame_time.reason
   */
  enum class ReasonLabel: uint16_t {
    eOnTime = 0,
    eNoVsync = 1,
    eMissedComposite = 2,
    eSlowComposite = 3,
    eMissedCompositeMid = 4,
    eMissedCompositeLong = 5,
    eMissedCompositeLow = 6,
    eNoVsyncNoId = 7,
    e__Other__,
  };
  /**
   * The reason that `gfx.content.frame_time.from_paint` recorded a slow (>200ms) result, if any. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ReasonLabel> reason(4068);

  /**
   * generated from gfx.content.frame_time.with_svg
   * The time, in percentage of a vsync interval, spent from beginning a paint in the content process until that frame is presented in the compositor, for frames that contained an SVG to be drawn by webrender. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric with_svg(4069);

  /**
   * generated from gfx.content.frame_time.without_resource_upload
   * The time, in percentage of a vsync interval, spent from beginning a paint in the content process until that frame is presented in the compositor by webrender, excluding time spent uploading resources. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric without_resource_upload(4070);

  /**
   * generated from gfx.content.frame_time.without_upload
   * The time, in percentage of a vsync interval, spent from beginning a paint in the content process until that frame is presented in the compositor by webrender, excluding time spent uploading any content. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric without_upload(4071);
}

namespace gfx_display {
  /**
   * generated from gfx.display.count
   * Amount of displays connected to the device (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric count(4072);

  /**
   * generated from gfx.display.primary_height
   * Height of the primary display, takes device rotation into account. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric primary_height(4073);

  /**
   * generated from gfx.display.primary_width
   * Width of the primary display, takes device rotation into account. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric primary_width(4074);

  /**
   * generated from gfx.display.scaling
   * Scaling percentage for the display where the first window is opened
   * This metric was generated to correspond to the Legacy Telemetry linear histogram DISPLAY_SCALING.
   */
  constexpr impl::CustomDistributionMetric scaling(4075);
}

namespace gfx_feature {
  /**
   * generated from gfx.feature.webrender
   * Whether webrender is enabled or disabled, and why. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric webrender(4076);
}

namespace gfx_hdr {
  /**
   * generated from gfx.hdr.windows_display_colorspace_bitfield
   * A bitfield representation of the available DXGI color spaces of the connected displays on Windows. See (https://docs.microsoft.com/en- us/windows/desktop/api/dxgicommon/ne-dxgicommon- dxgi_color_space_type) for definitions of color spaces. Each N'th bit of this scalar indicates whether the DXGI color space with index 'N' is available on at least one connected monitor. This metric was generated to correspond to the Legacy Telemetry scalar gfx.hdr.windows_display_colorspace_bitfield.
   */
  constexpr impl::QuantityMetric windows_display_colorspace_bitfield(4077);
}

namespace gfx_status {
  /**
   * generated from gfx.status.compositor
   * Name of the graphics compositor in use. Possible values are "opengl, d3d11, client, webrender or basic" (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric compositor(4078);

  /**
   * generated from gfx.status.headless
   * Boolean indicated whether graphics is running in headless (no display) mode (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::BooleanMetric headless(4079);

  /**
   * generated from gfx.status.last_compositor_gecko_version
   * The gecko version at the last time a compositor was initialized, and therefore when gfx_status_compositor was last updated. Due to gfx_status_compositor's user lifetime we see lots of unexpected values for the current gecko version. We believe this is because the user has not opened a tab since they were updated to a version where webrender should be enabled on their device. This can be used to verify that theory. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::StringMetric last_compositor_gecko_version(4080);
}

namespace gpu_process {
  /**
   * generated from gpu_process.crash_fallbacks
   */
  enum class CrashFallbacksLabel: uint16_t {
    eNone = 0,
    eDecodingDisabled = 1,
    eDisabled = 2,
    e__Other__,
  };
  /**
   * How often we use different fallbacks when the GPU process crashes
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CrashFallbacksLabel> crash_fallbacks(4081);

  /**
   * generated from gpu_process.feature_status
   * Current status of the GPU process feature
   */
  constexpr impl::StringMetric feature_status(4082);

  /**
   * generated from gpu_process.initialization_time
   * GPU process initialization (excluding XPCOM and fork time) time in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram GPU_PROCESS_INITIALIZATION_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric initialization_time(4083);

  /**
   * generated from gpu_process.launch_time
   * GPU process launch time in milliseconds
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram GPU_PROCESS_LAUNCH_TIME_MS_2.
   */
  constexpr impl::TimingDistributionMetric launch_time(4084);

  /**
   * generated from gpu_process.total_launch_attempts
   * The number of total GPU process launch attempts.
   */
  constexpr impl::QuantityMetric total_launch_attempts(4085);

  /**
   * generated from gpu_process.unstable_launch_attempts
   * The number of consecutive unstable launch attempts.
   */
  constexpr impl::QuantityMetric unstable_launch_attempts(4086);
}

namespace paint {
  /**
   * generated from paint.build_displaylist_time
   * The time to build a Gecko display list.
   */
  constexpr impl::TimingDistributionMetric build_displaylist_time(4087);
}

namespace webfont {
  /**
   * generated from webfont.compression_woff
   * Compression ratio of WOFF data (%)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBFONT_COMPRESSION_WOFF.
   */
  constexpr impl::CustomDistributionMetric compression_woff(4088);

  /**
   * generated from webfont.compression_woff2
   * Compression ratio of WOFF2 data (%)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBFONT_COMPRESSION_WOFF2.
   */
  constexpr impl::CustomDistributionMetric compression_woff2(4089);

  /**
   * generated from webfont.download_time
   * Time to download a webfont (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBFONT_DOWNLOAD_TIME.
   */
  constexpr impl::TimingDistributionMetric download_time(4090);

  /**
   * generated from webfont.fonttype
   * Font format type (woff/woff2/ttf/...)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBFONT_FONTTYPE.
   */
  constexpr impl::CustomDistributionMetric fonttype(4091);

  /**
   * generated from webfont.per_page
   * Number of fonts loaded at page load
   * This metric was generated to correspond to the Legacy Telemetry count histogram WEBFONT_PER_PAGE.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> per_page(4092);

  /**
   * generated from webfont.size
   * Size of font loaded (kb)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBFONT_SIZE.
   */
  constexpr impl::MemoryDistributionMetric size(4093);

  /**
   * generated from webfont.size_per_page
   * Size of all fonts loaded at page load (kb)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram WEBFONT_SIZE_PER_PAGE.
   */
  constexpr impl::MemoryDistributionMetric size_per_page(4094);

  /**
   * generated from webfont.srctype
   * Font src type loaded (1 = local, 2 = url, 3 = data)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBFONT_SRCTYPE.
   */
  constexpr impl::CustomDistributionMetric srctype(4095);
}

namespace wr {
  /**
   * generated from wr.framebuild_time
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric framebuild_time(4096);

  /**
   * generated from wr.gpu_wait_time
   * The time spent waiting for the GPU to complete previously issued drawing commands.
   */
  constexpr impl::TimingDistributionMetric gpu_wait_time(4097);

  /**
   * generated from wr.rasterize_blobs_time
   * The time to rasterize blobs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_blobs_time(4098);

  /**
   * generated from wr.rasterize_glyphs_time
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_glyphs_time(4099);

  /**
   * generated from wr.renderer_time
   * WebRender renderer time.
   */
  constexpr impl::TimingDistributionMetric renderer_time(4100);

  /**
   * generated from wr.renderer_time_no_sc
   * WebRender renderer time excluding frames in which shader compilation took place.
   */
  constexpr impl::TimingDistributionMetric renderer_time_no_sc(4101);

  /**
   * generated from wr.scenebuild_time
   * WebRender scene build time.
   */
  constexpr impl::TimingDistributionMetric scenebuild_time(4102);

  /**
   * generated from wr.sceneswap_time
   * WebRender scene swap time.
   */
  constexpr impl::TimingDistributionMetric sceneswap_time(4103);

  /**
   * generated from wr.shaderload_time
   * Time spent blocking on the shader compilation for LazilyCompiled shaders created with ASYNC_COMPILE or FULL_COMPILE.
   */
  constexpr impl::TimingDistributionMetric shaderload_time(4104);

  /**
   * generated from wr.texture_cache_update_time
   * Time taken by WebRender to update the texture cache.
   */
  constexpr impl::TimingDistributionMetric texture_cache_update_time(4105);

  /**
   * generated from wr.time_to_frame_build
   * Time elapsed between the construction of a transaction and the associated frame build beginning.
   */
  constexpr impl::TimingDistributionMetric time_to_frame_build(4106);

  /**
   * generated from wr.time_to_render_start
   * Time elapsed between the construction of a frame and the start of rendering.
   */
  constexpr impl::TimingDistributionMetric time_to_render_start(4107);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGfxMetrics_h
