// python wrapper for ttkPersistentGenerators
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkPersistentGenerators.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkPersistentGenerators(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkPersistentGenerators_ClassNew(); }


static PyObject *
PyttkPersistentGenerators_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkPersistentGenerators::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkPersistentGenerators::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkPersistentGenerators *tempr = ttkPersistentGenerators::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkPersistentGenerators *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkPersistentGenerators::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkPersistentGenerators::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkPersistentGenerators::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_SetPruneHandlesGenerators(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPruneHandlesGenerators");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPruneHandlesGenerators(temp0);
    }
    else
    {
      op->ttkPersistentGenerators::SetPruneHandlesGenerators(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_GetPruneHandlesGenerators(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPruneHandlesGenerators");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPruneHandlesGenerators() :
      op->ttkPersistentGenerators::GetPruneHandlesGenerators());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkPersistentGenerators::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistentGenerators_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistentGenerators *op = static_cast<ttkPersistentGenerators *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkPersistentGenerators::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkPersistentGenerators_Methods[] = {
  {"IsTypeOf", PyttkPersistentGenerators_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkPersistentGenerators_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkPersistentGenerators_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkPersistentGenerators\nC++: static ttkPersistentGenerators *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkPersistentGenerators_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkPersistentGenerators\nC++: ttkPersistentGenerators *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkPersistentGenerators_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkPersistentGenerators_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPruneHandlesGenerators", PyttkPersistentGenerators_SetPruneHandlesGenerators, METH_VARARGS,
   "SetPruneHandlesGenerators(self, _arg:bool) -> None\nC++: virtual void SetPruneHandlesGenerators(bool _arg)\n\n"},
  {"GetPruneHandlesGenerators", PyttkPersistentGenerators_GetPruneHandlesGenerators, METH_VARARGS,
   "GetPruneHandlesGenerators(self) -> bool\nC++: virtual bool GetPruneHandlesGenerators()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkPersistentGenerators_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkPersistentGenerators_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkPersistentGenerators_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("prune_handles_generators"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistentGenerators_GetPruneHandlesGenerators(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistentGenerators_SetPruneHandlesGenerators(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistentGenerators_SetPruneHandlesGenerators(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPruneHandlesGenerators/SetPruneHandlesGenerators\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistentGenerators_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistentGenerators_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistentGenerators_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkPersistentGenerators_Doc =
  "ttkPersistentGenerators - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date February 2022.\n\n"
  "TTK VTK-filter for the computation of persistent generators.\n\n"
  "Related publication\n\n"
  "\"Discrete Morse Sandwich: Fast Computation of Persistence Diagrams\n"
  "for Scalar Data -- An Algorithm and A Benchmark\"\n\n"
  "Pierre Guillou, Jules Vidal, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2023.\n\n"
  "arXiv:2206.13932, 2023.\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_at/\"\n"
  "  >Persistent Generators AT example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_casting/\"\n"
  "  >Persistent Generators Casting example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_darkSky/\"\n"
  "  >Persistent Generators DarkSky example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_fertility/\"\n"
  "  >Persistent Generators Fertility example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_householdAnalysis/\"\n"
  "  >Persistent Generators Household Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_periodicPicture/\"\n"
  "  >Persistent Generators Periodic Picture example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_skull/\"\n"
  "  >Persistent Generators Skull example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkPersistentGenerators_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkPersistentGenerators.ttkPersistentGenerators", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkPersistentGenerators_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkPersistentGenerators_StaticNew()
{
  return ttkPersistentGenerators::New();
}

PyObject *PyttkPersistentGenerators_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkPersistentGenerators_Type, PyttkPersistentGenerators_Methods,
    "ttkPersistentGenerators",
 &PyttkPersistentGenerators_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkPersistentGenerators_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkPersistentGenerators(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkPersistentGenerators_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkPersistentGenerators", o) != 0)
  {
    Py_DECREF(o);
  }

}

