// python wrapper for ttkTrackingFromFields
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTrackingFromFields.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTrackingFromFields(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTrackingFromFields_ClassNew(); }


static PyObject *
PyttkTrackingFromFields_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTrackingFromFields::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTrackingFromFields::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTrackingFromFields *tempr = ttkTrackingFromFields::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTrackingFromFields *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTrackingFromFields::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTrackingFromFields::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTrackingFromFields::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetSampling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSampling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSampling(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetSampling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetSampling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSampling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSampling() :
      op->ttkTrackingFromFields::GetSampling());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetStartTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStartTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStartTimestep(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetStartTimestep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetStartTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStartTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStartTimestep() :
      op->ttkTrackingFromFields::GetStartTimestep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetEndTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEndTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEndTimestep(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetEndTimestep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetEndTimestep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEndTimestep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEndTimestep() :
      op->ttkTrackingFromFields::GetEndTimestep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTolerance(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTolerance() :
      op->ttkTrackingFromFields::GetTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPX(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPX(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPX() :
      op->ttkTrackingFromFields::GetPX());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPY(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPY(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPY(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPY");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPY() :
      op->ttkTrackingFromFields::GetPY());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPZ(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPZ(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPZ(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPZ");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPZ() :
      op->ttkTrackingFromFields::GetPZ());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPE(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPE(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPE() :
      op->ttkTrackingFromFields::GetPE());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPS(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPS");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPS(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPS(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPS(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPS");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPS() :
      op->ttkTrackingFromFields::GetPS());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWassersteinMetric(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetWassersteinMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetWassersteinMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWassersteinMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetWassersteinMetric() :
      op->ttkTrackingFromFields::GetWassersteinMetric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetDistanceAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistanceAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistanceAlgorithm(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetDistanceAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetDistanceAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDistanceAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDistanceAlgorithm() :
      op->ttkTrackingFromFields::GetDistanceAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPVAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPVAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPVAlgorithm(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPVAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPVAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPVAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPVAlgorithm() :
      op->ttkTrackingFromFields::GetPVAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetUseGeometricSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseGeometricSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseGeometricSpacing(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetUseGeometricSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetUseGeometricSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseGeometricSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseGeometricSpacing() :
      op->ttkTrackingFromFields::GetUseGeometricSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpacing(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSpacing() :
      op->ttkTrackingFromFields::GetSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetDoPostProc(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDoPostProc");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDoPostProc(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetDoPostProc(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetDoPostProc(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDoPostProc");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDoPostProc() :
      op->ttkTrackingFromFields::GetDoPostProc());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_SetPostProcThresh(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPostProcThresh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPostProcThresh(temp0);
    }
    else
    {
      op->ttkTrackingFromFields::SetPostProcThresh(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromFields_GetPostProcThresh(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPostProcThresh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromFields *op = static_cast<ttkTrackingFromFields *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPostProcThresh() :
      op->ttkTrackingFromFields::GetPostProcThresh());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTrackingFromFields_Methods[] = {
  {"IsTypeOf", PyttkTrackingFromFields_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTrackingFromFields_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTrackingFromFields_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTrackingFromFields\nC++: static ttkTrackingFromFields *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTrackingFromFields_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTrackingFromFields\nC++: ttkTrackingFromFields *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTrackingFromFields_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTrackingFromFields_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSampling", PyttkTrackingFromFields_SetSampling, METH_VARARGS,
   "SetSampling(self, _arg:int) -> None\nC++: virtual void SetSampling(int _arg)\n\n"},
  {"GetSampling", PyttkTrackingFromFields_GetSampling, METH_VARARGS,
   "GetSampling(self) -> int\nC++: virtual int GetSampling()\n\n"},
  {"SetStartTimestep", PyttkTrackingFromFields_SetStartTimestep, METH_VARARGS,
   "SetStartTimestep(self, _arg:int) -> None\nC++: virtual void SetStartTimestep(int _arg)\n\n"},
  {"GetStartTimestep", PyttkTrackingFromFields_GetStartTimestep, METH_VARARGS,
   "GetStartTimestep(self) -> int\nC++: virtual int GetStartTimestep()\n\n"},
  {"SetEndTimestep", PyttkTrackingFromFields_SetEndTimestep, METH_VARARGS,
   "SetEndTimestep(self, _arg:int) -> None\nC++: virtual void SetEndTimestep(int _arg)\n\n"},
  {"GetEndTimestep", PyttkTrackingFromFields_GetEndTimestep, METH_VARARGS,
   "GetEndTimestep(self) -> int\nC++: virtual int GetEndTimestep()\n\n"},
  {"SetTolerance", PyttkTrackingFromFields_SetTolerance, METH_VARARGS,
   "SetTolerance(self, _arg:float) -> None\nC++: virtual void SetTolerance(double _arg)\n\n"},
  {"GetTolerance", PyttkTrackingFromFields_GetTolerance, METH_VARARGS,
   "GetTolerance(self) -> float\nC++: virtual double GetTolerance()\n\n"},
  {"SetPX", PyttkTrackingFromFields_SetPX, METH_VARARGS,
   "SetPX(self, _arg:float) -> None\nC++: virtual void SetPX(double _arg)\n\n"},
  {"GetPX", PyttkTrackingFromFields_GetPX, METH_VARARGS,
   "GetPX(self) -> float\nC++: virtual double GetPX()\n\n"},
  {"SetPY", PyttkTrackingFromFields_SetPY, METH_VARARGS,
   "SetPY(self, _arg:float) -> None\nC++: virtual void SetPY(double _arg)\n\n"},
  {"GetPY", PyttkTrackingFromFields_GetPY, METH_VARARGS,
   "GetPY(self) -> float\nC++: virtual double GetPY()\n\n"},
  {"SetPZ", PyttkTrackingFromFields_SetPZ, METH_VARARGS,
   "SetPZ(self, _arg:float) -> None\nC++: virtual void SetPZ(double _arg)\n\n"},
  {"GetPZ", PyttkTrackingFromFields_GetPZ, METH_VARARGS,
   "GetPZ(self) -> float\nC++: virtual double GetPZ()\n\n"},
  {"SetPE", PyttkTrackingFromFields_SetPE, METH_VARARGS,
   "SetPE(self, _arg:float) -> None\nC++: virtual void SetPE(double _arg)\n\n"},
  {"GetPE", PyttkTrackingFromFields_GetPE, METH_VARARGS,
   "GetPE(self) -> float\nC++: virtual double GetPE()\n\n"},
  {"SetPS", PyttkTrackingFromFields_SetPS, METH_VARARGS,
   "SetPS(self, _arg:float) -> None\nC++: virtual void SetPS(double _arg)\n\n"},
  {"GetPS", PyttkTrackingFromFields_GetPS, METH_VARARGS,
   "GetPS(self) -> float\nC++: virtual double GetPS()\n\n"},
  {"SetWassersteinMetric", PyttkTrackingFromFields_SetWassersteinMetric, METH_VARARGS,
   "SetWassersteinMetric(self, _arg:str) -> None\nC++: virtual void SetWassersteinMetric(const std::string &_arg)\n\n"},
  {"GetWassersteinMetric", PyttkTrackingFromFields_GetWassersteinMetric, METH_VARARGS,
   "GetWassersteinMetric(self) -> str\nC++: virtual std::string GetWassersteinMetric()\n\n"},
  {"SetDistanceAlgorithm", PyttkTrackingFromFields_SetDistanceAlgorithm, METH_VARARGS,
   "SetDistanceAlgorithm(self, _arg:str) -> None\nC++: virtual void SetDistanceAlgorithm(const std::string &_arg)\n\n"},
  {"GetDistanceAlgorithm", PyttkTrackingFromFields_GetDistanceAlgorithm, METH_VARARGS,
   "GetDistanceAlgorithm(self) -> str\nC++: virtual std::string GetDistanceAlgorithm()\n\n"},
  {"SetPVAlgorithm", PyttkTrackingFromFields_SetPVAlgorithm, METH_VARARGS,
   "SetPVAlgorithm(self, _arg:int) -> None\nC++: virtual void SetPVAlgorithm(int _arg)\n\n"},
  {"GetPVAlgorithm", PyttkTrackingFromFields_GetPVAlgorithm, METH_VARARGS,
   "GetPVAlgorithm(self) -> int\nC++: virtual int GetPVAlgorithm()\n\n"},
  {"SetUseGeometricSpacing", PyttkTrackingFromFields_SetUseGeometricSpacing, METH_VARARGS,
   "SetUseGeometricSpacing(self, _arg:bool) -> None\nC++: virtual void SetUseGeometricSpacing(bool _arg)\n\n"},
  {"GetUseGeometricSpacing", PyttkTrackingFromFields_GetUseGeometricSpacing, METH_VARARGS,
   "GetUseGeometricSpacing(self) -> bool\nC++: virtual bool GetUseGeometricSpacing()\n\n"},
  {"SetSpacing", PyttkTrackingFromFields_SetSpacing, METH_VARARGS,
   "SetSpacing(self, _arg:float) -> None\nC++: virtual void SetSpacing(double _arg)\n\n"},
  {"GetSpacing", PyttkTrackingFromFields_GetSpacing, METH_VARARGS,
   "GetSpacing(self) -> float\nC++: virtual double GetSpacing()\n\n"},
  {"SetDoPostProc", PyttkTrackingFromFields_SetDoPostProc, METH_VARARGS,
   "SetDoPostProc(self, _arg:bool) -> None\nC++: virtual void SetDoPostProc(bool _arg)\n\n"},
  {"GetDoPostProc", PyttkTrackingFromFields_GetDoPostProc, METH_VARARGS,
   "GetDoPostProc(self) -> bool\nC++: virtual bool GetDoPostProc()\n\n"},
  {"SetPostProcThresh", PyttkTrackingFromFields_SetPostProcThresh, METH_VARARGS,
   "SetPostProcThresh(self, _arg:float) -> None\nC++: virtual void SetPostProcThresh(double _arg)\n\n"},
  {"GetPostProcThresh", PyttkTrackingFromFields_GetPostProcThresh, METH_VARARGS,
   "GetPostProcThresh(self) -> float\nC++: virtual double GetPostProcThresh()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTrackingFromFields_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("sampling"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetSampling(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetSampling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetSampling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSampling/SetSampling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("start_timestep"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetStartTimestep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetStartTimestep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetStartTimestep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStartTimestep/SetStartTimestep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("end_timestep"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetEndTimestep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetEndTimestep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetEndTimestep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEndTimestep/SetEndTimestep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTolerance/SetTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("px"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPX(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPX(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPX(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPX/SetPX\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("py"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPY(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPY(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPY(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPY/SetPY\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pz"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPZ(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPZ(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPZ(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPZ/SetPZ\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pe"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPE(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPE(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPE(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPE/SetPE\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPS(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPS(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPS(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPS/SetPS\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("wasserstein_metric"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetWassersteinMetric(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetWassersteinMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetWassersteinMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWassersteinMetric/SetWassersteinMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_algorithm"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetDistanceAlgorithm(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetDistanceAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetDistanceAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDistanceAlgorithm/SetDistanceAlgorithm\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pv_algorithm"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPVAlgorithm(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPVAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPVAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPVAlgorithm/SetPVAlgorithm\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_geometric_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetUseGeometricSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetUseGeometricSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetUseGeometricSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseGeometricSpacing/SetUseGeometricSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpacing/SetSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("do_post_proc"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetDoPostProc(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetDoPostProc(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetDoPostProc(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDoPostProc/SetDoPostProc\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("post_proc_thresh"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromFields_GetPostProcThresh(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromFields_SetPostProcThresh(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromFields_SetPostProcThresh(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPostProcThresh/SetPostProcThresh\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTrackingFromFields_Doc =
  "ttkTrackingFromFields - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Maxime Soler <soler.maxime@total.com>\\date August 2018.\n\n"
  "TTK VTK-filter that takes an input time-varying data set (represented\n"
  "by a list of scalar fields) and which computes a tracking mesh.\n\n"
  "\\param Input Input time-dependent scalar field, either 2D or 3D,\n"
  "    regular\n"
  "grid or triangulation (vtkDataSet); time steps are obtained by\n"
  "GetPointData()->GetArray(i) in increasing time order.\n"
  "\\param Output Output persistence diagram (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Lifted Wasserstein Matcher for Fast and Robust Topology Tracking\"\n\n"
  "Maxime Soler, Melanie Plainchault, Bruno Conche, Julien Tierny\n\n"
  "Proc. of IEEE Symposium on Large Data Analysis and Visualization,\n"
  "2018\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/timeTracking/\">Ti\n"
  "  me tracking example\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTrackingFromFields_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTrackingFromFields.ttkTrackingFromFields", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTrackingFromFields_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTrackingFromFields_StaticNew()
{
  return ttkTrackingFromFields::New();
}

PyObject *PyttkTrackingFromFields_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTrackingFromFields_Type, PyttkTrackingFromFields_Methods,
    "ttkTrackingFromFields",
 &PyttkTrackingFromFields_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTrackingFromFields_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTrackingFromFields(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTrackingFromFields_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTrackingFromFields", o) != 0)
  {
    Py_DECREF(o);
  }

}

