//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdns

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Specifies the Azure subscription ID, which uniquely identifies the Microsoft Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewRecordSetsClient creates a new instance of RecordSetsClient.
func (c *ClientFactory) NewRecordSetsClient() *RecordSetsClient {
	subClient, _ := NewRecordSetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewResourceReferenceClient creates a new instance of ResourceReferenceClient.
func (c *ClientFactory) NewResourceReferenceClient() *ResourceReferenceClient {
	subClient, _ := NewResourceReferenceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewZonesClient creates a new instance of ZonesClient.
func (c *ClientFactory) NewZonesClient() *ZonesClient {
	subClient, _ := NewZonesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
