/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// GatewayClassLister helps list GatewayClasses.
// All objects returned here must be treated as read-only.
type GatewayClassLister interface {
	// List lists all GatewayClasses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1.GatewayClass, err error)
	// Get retrieves the GatewayClass from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisv1.GatewayClass, error)
	GatewayClassListerExpansion
}

// gatewayClassLister implements the GatewayClassLister interface.
type gatewayClassLister struct {
	listers.ResourceIndexer[*apisv1.GatewayClass]
}

// NewGatewayClassLister returns a new GatewayClassLister.
func NewGatewayClassLister(indexer cache.Indexer) GatewayClassLister {
	return &gatewayClassLister{listers.New[*apisv1.GatewayClass](indexer, apisv1.Resource("gatewayclass"))}
}
