/** @file
 * VirtualBox API class wrapper code for IDHCPServer.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_DHCPSERVER

#include "DHCPServerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DHCPServerWrap)

//
// IDHCPServer properties
//

STDMETHODIMP DHCPServerWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "DHCPServer::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "DHCPServer::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "DHCPServer::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "DHCPServer::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "DHCPServer::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPServer::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(IPAddress)(BSTR *aIPAddress)
{
    LogRelFlow(("{%p} %s: enter aIPAddress=%p\n", this, "DHCPServer::getIPAddress", aIPAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPAddress);
        BSTROutConverter TmpIPAddress(aIPAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_IPADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPAddress(TmpIPAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_IPADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpIPAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_IPADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_IPADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPAddress=%ls hrc=%Rhrc\n", this, "DHCPServer::getIPAddress", *aIPAddress, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(NetworkMask)(BSTR *aNetworkMask)
{
    LogRelFlow(("{%p} %s: enter aNetworkMask=%p\n", this, "DHCPServer::getNetworkMask", aNetworkMask));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkMask);
        BSTROutConverter TmpNetworkMask(aNetworkMask);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKMASK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkMask(TmpNetworkMask.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKMASK_RETURN(this, hrc, 0 /*normal*/,TmpNetworkMask.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKMASK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKMASK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkMask=%ls hrc=%Rhrc\n", this, "DHCPServer::getNetworkMask", *aNetworkMask, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(NetworkName)(BSTR *aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%p\n", this, "DHCPServer::getNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkName);
        BSTROutConverter TmpNetworkName(aNetworkName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkName=%ls hrc=%Rhrc\n", this, "DHCPServer::getNetworkName", *aNetworkName, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(LowerIP)(BSTR *aLowerIP)
{
    LogRelFlow(("{%p} %s: enter aLowerIP=%p\n", this, "DHCPServer::getLowerIP", aLowerIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLowerIP);
        BSTROutConverter TmpLowerIP(aLowerIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_LOWERIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLowerIP(TmpLowerIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_LOWERIP_RETURN(this, hrc, 0 /*normal*/,TmpLowerIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_LOWERIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_LOWERIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLowerIP=%ls hrc=%Rhrc\n", this, "DHCPServer::getLowerIP", *aLowerIP, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(UpperIP)(BSTR *aUpperIP)
{
    LogRelFlow(("{%p} %s: enter aUpperIP=%p\n", this, "DHCPServer::getUpperIP", aUpperIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUpperIP);
        BSTROutConverter TmpUpperIP(aUpperIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_UPPERIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUpperIP(TmpUpperIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_UPPERIP_RETURN(this, hrc, 0 /*normal*/,TmpUpperIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_UPPERIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_UPPERIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUpperIP=%ls hrc=%Rhrc\n", this, "DHCPServer::getUpperIP", *aUpperIP, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(GlobalConfig)(IDHCPGlobalConfig **aGlobalConfig)
{
    LogRelFlow(("{%p} %s: enter aGlobalConfig=%p\n", this, "DHCPServer::getGlobalConfig", aGlobalConfig));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGlobalConfig);
        ComTypeOutConverter<IDHCPGlobalConfig> TmpGlobalConfig(aGlobalConfig);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GLOBALCONFIG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGlobalConfig(TmpGlobalConfig.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GLOBALCONFIG_RETURN(this, hrc, 0 /*normal*/,(void *)TmpGlobalConfig.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GLOBALCONFIG_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GLOBALCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGlobalConfig=%p hrc=%Rhrc\n", this, "DHCPServer::getGlobalConfig", *aGlobalConfig, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(GroupConfigs)(ComSafeArrayOut(IDHCPGroupConfig *, aGroupConfigs))
{
    LogRelFlow(("{%p} %s: enter aGroupConfigs=%p\n", this, "DHCPServer::getGroupConfigs", aGroupConfigs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGroupConfigs);
        ArrayComTypeOutConverter<IDHCPGroupConfig> TmpGroupConfigs(ComSafeArrayOutArg(aGroupConfigs));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GROUPCONFIGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGroupConfigs(TmpGroupConfigs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GROUPCONFIGS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpGroupConfigs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GROUPCONFIGS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_GROUPCONFIGS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGroupConfigs=%zu hrc=%Rhrc\n", this, "DHCPServer::getGroupConfigs", ComSafeArraySize(*aGroupConfigs), hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(IndividualConfigs)(ComSafeArrayOut(IDHCPIndividualConfig *, aIndividualConfigs))
{
    LogRelFlow(("{%p} %s: enter aIndividualConfigs=%p\n", this, "DHCPServer::getIndividualConfigs", aIndividualConfigs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIndividualConfigs);
        ArrayComTypeOutConverter<IDHCPIndividualConfig> TmpIndividualConfigs(ComSafeArrayOutArg(aIndividualConfigs));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_INDIVIDUALCONFIGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIndividualConfigs(TmpIndividualConfigs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_INDIVIDUALCONFIGS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpIndividualConfigs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_INDIVIDUALCONFIGS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GET_INDIVIDUALCONFIGS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIndividualConfigs=%zu hrc=%Rhrc\n", this, "DHCPServer::getIndividualConfigs", ComSafeArraySize(*aIndividualConfigs), hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(InternalAndReservedAttribute1IDHCPServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(InternalAndReservedAttribute2IDHCPServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPServerWrap::COMGETTER(InternalAndReservedAttribute3IDHCPServer)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDHCPServer methods
//

STDMETHODIMP DHCPServerWrap::SetConfiguration(IN_BSTR aIPAddress,
                                              IN_BSTR aNetworkMask,
                                              IN_BSTR aFromIPAddress,
                                              IN_BSTR aToIPAddress)
{
    LogRelFlow(("{%p} %s: enter aIPAddress=%ls aNetworkMask=%ls aFromIPAddress=%ls aToIPAddress=%ls\n", this, "DHCPServer::setConfiguration", aIPAddress, aNetworkMask, aFromIPAddress, aToIPAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpIPAddress(aIPAddress);
        BSTRInConverter TmpNetworkMask(aNetworkMask);
        BSTRInConverter TmpFromIPAddress(aFromIPAddress);
        BSTRInConverter TmpToIPAddress(aToIPAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SETCONFIGURATION_ENTER(this, TmpIPAddress.str().c_str(), TmpNetworkMask.str().c_str(), TmpFromIPAddress.str().c_str(), TmpToIPAddress.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setConfiguration(TmpIPAddress.str(),
                                   TmpNetworkMask.str(),
                                   TmpFromIPAddress.str(),
                                   TmpToIPAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SETCONFIGURATION_RETURN(this, hrc, 0 /*normal*/, TmpIPAddress.str().c_str(), TmpNetworkMask.str().c_str(), TmpFromIPAddress.str().c_str(), TmpToIPAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SETCONFIGURATION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_SETCONFIGURATION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPServer::setConfiguration", hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::Start(IN_BSTR aTrunkName,
                                   IN_BSTR aTrunkType)
{
    LogRelFlow(("{%p} %s: enter aTrunkName=%ls aTrunkType=%ls\n", this, "DHCPServer::start", aTrunkName, aTrunkType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpTrunkName(aTrunkName);
        BSTRInConverter TmpTrunkType(aTrunkType);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_START_ENTER(this, TmpTrunkName.str().c_str(), TmpTrunkType.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = start(TmpTrunkName.str(),
                        TmpTrunkType.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_START_RETURN(this, hrc, 0 /*normal*/, TmpTrunkName.str().c_str(), TmpTrunkType.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_START_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_START_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPServer::start", hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::Stop()
{
    LogRelFlow(("{%p} %s: enter\n", this, "DHCPServer::stop"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_STOP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = stop();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_STOP_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_STOP_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_STOP_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPServer::stop", hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::Restart()
{
    LogRelFlow(("{%p} %s: enter\n", this, "DHCPServer::restart"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_RESTART_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = restart();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_RESTART_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_RESTART_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_RESTART_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPServer::restart", hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::FindLeaseByMAC(IN_BSTR aMac,
                                            LONG aType,
                                            BSTR *aAddress,
                                            BSTR *aState,
                                            LONG64 *aIssued,
                                            LONG64 *aExpire)
{
    LogRelFlow(("{%p} %s: enter aMac=%ls aType=%RI32 aAddress=%p aState=%p aIssued=%p aExpire=%p\n", this, "DHCPServer::findLeaseByMAC", aMac, aType, aAddress, aState, aIssued, aExpire));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAddress);
        CheckComArgOutPointerValidThrow(aState);
        CheckComArgOutPointerValidThrow(aIssued);
        CheckComArgOutPointerValidThrow(aExpire);


        BSTRInConverter TmpMac(aMac);
        
        BSTROutConverter TmpAddress(aAddress);
        BSTROutConverter TmpState(aState);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_FINDLEASEBYMAC_ENTER(this, TmpMac.str().c_str(), aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findLeaseByMAC(TmpMac.str(),
                                 aType,
                                 TmpAddress.str(),
                                 TmpState.str(),
                                 aIssued,
                                 aExpire);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_FINDLEASEBYMAC_RETURN(this, hrc, 0 /*normal*/, TmpMac.str().c_str(), aType, TmpAddress.str().c_str(), TmpState.str().c_str(), *aIssued, *aExpire);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_FINDLEASEBYMAC_RETURN(this, hrc, 1 /*hrc exception*/, 0, aType, 0, 0, *aIssued, *aExpire);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_FINDLEASEBYMAC_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aType, 0, 0, *aIssued, *aExpire);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAddress=%ls *aState=%ls *aIssued=%RI64 *aExpire=%RI64 hrc=%Rhrc\n", this, "DHCPServer::findLeaseByMAC", *aAddress, *aState, *aIssued, *aExpire, hrc));
    return hrc;
}

STDMETHODIMP DHCPServerWrap::GetConfig(DHCPConfigScope_T aScope,
                                       IN_BSTR aName,
                                       ULONG aSlot,
                                       BOOL aMayAdd,
                                       IDHCPConfig **aConfig)
{
    LogRelFlow(("{%p} %s: enter aScope=%RU32 aName=%ls aSlot=%RU32 aMayAdd=%RTbool aConfig=%p\n", this, "DHCPServer::getConfig", aScope, aName, aSlot, aMayAdd, aConfig));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aConfig);


        
        BSTRInConverter TmpName(aName);
        
        
        ComTypeOutConverter<IDHCPConfig> TmpConfig(aConfig);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GETCONFIG_ENTER(this, aScope, TmpName.str().c_str(), aSlot, aMayAdd != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getConfig(aScope,
                            TmpName.str(),
                            aSlot,
                            aMayAdd != FALSE,
                            TmpConfig.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GETCONFIG_RETURN(this, hrc, 0 /*normal*/, aScope, TmpName.str().c_str(), aSlot, aMayAdd != FALSE, (void *)TmpConfig.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GETCONFIG_RETURN(this, hrc, 1 /*hrc exception*/, aScope, 0, aSlot, aMayAdd != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPSERVER_GETCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/, aScope, 0, aSlot, aMayAdd != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aConfig=%p hrc=%Rhrc\n", this, "DHCPServer::getConfig", *aConfig, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DHCPServerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DHCPServerWrap, IDHCPServer)
#endif // VBOX_WITH_XPCOM
