/** @file
 * VirtualBox API class wrapper code for IMediumIO.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_MEDIUMIO

#include "MediumIOWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MediumIOWrap)

//
// IMediumIO properties
//

STDMETHODIMP MediumIOWrap::COMGETTER(Medium)(IMedium **aMedium)
{
    LogRelFlow(("{%p} %s: enter aMedium=%p\n", this, "MediumIO::getMedium", aMedium));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMedium);
        ComTypeOutConverter<IMedium> TmpMedium(aMedium);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_MEDIUM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMedium(TmpMedium.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_MEDIUM_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMedium.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_MEDIUM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_MEDIUM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMedium=%p hrc=%Rhrc\n", this, "MediumIO::getMedium", *aMedium, hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::COMGETTER(Writable)(BOOL *aWritable)
{
    LogRelFlow(("{%p} %s: enter aWritable=%p\n", this, "MediumIO::getWritable", aWritable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_WRITABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWritable(aWritable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_WRITABLE_RETURN(this, hrc, 0 /*normal*/,*aWritable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_WRITABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aWritable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_WRITABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aWritable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWritable=%RTbool hrc=%Rhrc\n", this, "MediumIO::getWritable", *aWritable, hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::COMGETTER(Explorer)(IVFSExplorer **aExplorer)
{
    LogRelFlow(("{%p} %s: enter aExplorer=%p\n", this, "MediumIO::getExplorer", aExplorer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExplorer);
        ComTypeOutConverter<IVFSExplorer> TmpExplorer(aExplorer);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_EXPLORER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExplorer(TmpExplorer.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_EXPLORER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpExplorer.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_EXPLORER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_GET_EXPLORER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExplorer=%p hrc=%Rhrc\n", this, "MediumIO::getExplorer", *aExplorer, hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute1IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute2IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute3IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute4IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute5IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute6IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute7IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::COMGETTER(InternalAndReservedAttribute8IMediumIO)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMediumIO methods
//

STDMETHODIMP MediumIOWrap::Read(LONG64 aOffset,
                                ULONG aSize,
                                ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aOffset=%RI64 aSize=%RU32 aData=%p\n", this, "MediumIO::read", aOffset, aSize, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_READ_ENTER(this, aOffset, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(aOffset,
                       aSize,
                       TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_READ_RETURN(this, hrc, 0 /*normal*/, aOffset, aSize, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_READ_RETURN(this, hrc, 1 /*hrc exception*/, aOffset, aSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_READ_RETURN(this, hrc, 9 /*unhandled exception*/, aOffset, aSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "MediumIO::read", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::Write(LONG64 aOffset,
                                 ComSafeArrayIn(BYTE, aData),
                                 ULONG *aWritten)
{
    LogRelFlow(("{%p} %s: enter aOffset=%RI64 aData=%zu aWritten=%p\n", this, "MediumIO::write", aOffset, aData, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_WRITE_ENTER(this, aOffset, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = write(aOffset,
                        TmpData.array(),
                        aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_WRITE_RETURN(this, hrc, 0 /*normal*/, aOffset, (uint32_t)TmpData.array().size(), NULL /*for now*/, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_WRITE_RETURN(this, hrc, 1 /*hrc exception*/, aOffset, 0, 0, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_WRITE_RETURN(this, hrc, 9 /*unhandled exception*/, aOffset, 0, 0, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "MediumIO::write", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::FormatFAT(BOOL aQuick)
{
    LogRelFlow(("{%p} %s: enter aQuick=%RTbool\n", this, "MediumIO::formatFAT", aQuick));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_FORMATFAT_ENTER(this, aQuick != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = formatFAT(aQuick != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_FORMATFAT_RETURN(this, hrc, 0 /*normal*/, aQuick != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_FORMATFAT_RETURN(this, hrc, 1 /*hrc exception*/, aQuick != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_FORMATFAT_RETURN(this, hrc, 9 /*unhandled exception*/, aQuick != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MediumIO::formatFAT", hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::InitializePartitionTable(PartitionTableType_T aFormat,
                                                    BOOL aWholeDiskInOneEntry)
{
    LogRelFlow(("{%p} %s: enter aFormat=%RU32 aWholeDiskInOneEntry=%RTbool\n", this, "MediumIO::initializePartitionTable", aFormat, aWholeDiskInOneEntry));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_INITIALIZEPARTITIONTABLE_ENTER(this, aFormat, aWholeDiskInOneEntry != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = initializePartitionTable(aFormat,
                                           aWholeDiskInOneEntry != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_INITIALIZEPARTITIONTABLE_RETURN(this, hrc, 0 /*normal*/, aFormat, aWholeDiskInOneEntry != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_INITIALIZEPARTITIONTABLE_RETURN(this, hrc, 1 /*hrc exception*/, aFormat, aWholeDiskInOneEntry != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_INITIALIZEPARTITIONTABLE_RETURN(this, hrc, 9 /*unhandled exception*/, aFormat, aWholeDiskInOneEntry != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MediumIO::initializePartitionTable", hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::ConvertToStream(IN_BSTR aFormat,
                                           ComSafeArrayIn(MediumVariant_T, aVariant),
                                           ULONG aBufferSize,
                                           IDataStream **aStream,
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aFormat=%ls aVariant=%zu aBufferSize=%RU32 aStream=%p aProgress=%p\n", this, "MediumIO::convertToStream", aFormat, aVariant, aBufferSize, aStream, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStream);
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpFormat(aFormat);
        ArrayInConverter<MediumVariant_T> TmpVariant(ComSafeArrayInArg(aVariant));
        
        ComTypeOutConverter<IDataStream> TmpStream(aStream);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CONVERTTOSTREAM_ENTER(this, TmpFormat.str().c_str(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, aBufferSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = convertToStream(TmpFormat.str(),
                                  TmpVariant.array(),
                                  aBufferSize,
                                  TmpStream.ptr(),
                                  TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CONVERTTOSTREAM_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), (uint32_t)TmpVariant.array().size(), NULL /*for now*/, aBufferSize, (void *)TmpStream.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CONVERTTOSTREAM_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aBufferSize, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CONVERTTOSTREAM_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aBufferSize, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStream=%p aProgress=%p hrc=%Rhrc\n", this, "MediumIO::convertToStream", *aStream, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::Close()
{
    LogRelFlow(("{%p} %s: enter\n", this, "MediumIO::close"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CLOSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = close();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CLOSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CLOSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MEDIUMIO_CLOSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "MediumIO::close", hrc));
    return hrc;
}

STDMETHODIMP MediumIOWrap::InternalAndReservedMethod1IMediumIO()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::InternalAndReservedMethod2IMediumIO()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::InternalAndReservedMethod3IMediumIO()
{
    return E_NOTIMPL;
}

STDMETHODIMP MediumIOWrap::InternalAndReservedMethod4IMediumIO()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumIOWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MediumIOWrap, IMediumIO)
#endif // VBOX_WITH_XPCOM
