/** @file
 * VirtualBox API class wrapper code for INATNetwork.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_NATNETWORK

#include "NATNetworkWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(NATNetworkWrap)

//
// INATNetwork properties
//

STDMETHODIMP NATNetworkWrap::COMGETTER(NetworkName)(BSTR *aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%p\n", this, "NATNetwork::getNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkName);
        BSTROutConverter TmpNetworkName(aNetworkName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORKNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkName=%ls hrc=%Rhrc\n", this, "NATNetwork::getNetworkName", *aNetworkName, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(NetworkName)(IN_BSTR aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%ls\n", this, "NATNetwork::setNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNetworkName(aNetworkName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORKNAME_ENTER(this, TmpNetworkName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setNetworkName", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "NATNetwork::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "NATNetwork::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(Network)(BSTR *aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%p\n", this, "NATNetwork::getNetwork", aNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);
        BSTROutConverter TmpNetwork(aNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetwork(TmpNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetwork=%ls hrc=%Rhrc\n", this, "NATNetwork::getNetwork", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(Network)(IN_BSTR aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%ls\n", this, "NATNetwork::setNetwork", aNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORK_ENTER(this, TmpNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetwork(TmpNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setNetwork", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(Gateway)(BSTR *aGateway)
{
    LogRelFlow(("{%p} %s: enter aGateway=%p\n", this, "NATNetwork::getGateway", aGateway));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGateway);
        BSTROutConverter TmpGateway(aGateway);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_GATEWAY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGateway(TmpGateway.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_GATEWAY_RETURN(this, hrc, 0 /*normal*/,TmpGateway.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_GATEWAY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_GATEWAY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGateway=%ls hrc=%Rhrc\n", this, "NATNetwork::getGateway", *aGateway, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(IPv6Enabled)(BOOL *aIPv6Enabled)
{
    LogRelFlow(("{%p} %s: enter aIPv6Enabled=%p\n", this, "NATNetwork::getIPv6Enabled", aIPv6Enabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPv6Enabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPv6Enabled(aIPv6Enabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6ENABLED_RETURN(this, hrc, 0 /*normal*/,*aIPv6Enabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aIPv6Enabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIPv6Enabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPv6Enabled=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getIPv6Enabled", *aIPv6Enabled, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(IPv6Enabled)(BOOL aIPv6Enabled)
{
    LogRelFlow(("{%p} %s: enter aIPv6Enabled=%RTbool\n", this, "NATNetwork::setIPv6Enabled", aIPv6Enabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6ENABLED_ENTER(this, aIPv6Enabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIPv6Enabled(aIPv6Enabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6ENABLED_RETURN(this, hrc, 0 /*normal*/,aIPv6Enabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aIPv6Enabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aIPv6Enabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setIPv6Enabled", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(IPv6Prefix)(BSTR *aIPv6Prefix)
{
    LogRelFlow(("{%p} %s: enter aIPv6Prefix=%p\n", this, "NATNetwork::getIPv6Prefix", aIPv6Prefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPv6Prefix);
        BSTROutConverter TmpIPv6Prefix(aIPv6Prefix);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6PREFIX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPv6Prefix(TmpIPv6Prefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6PREFIX_RETURN(this, hrc, 0 /*normal*/,TmpIPv6Prefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6PREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_IPV6PREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPv6Prefix=%ls hrc=%Rhrc\n", this, "NATNetwork::getIPv6Prefix", *aIPv6Prefix, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(IPv6Prefix)(IN_BSTR aIPv6Prefix)
{
    LogRelFlow(("{%p} %s: enter aIPv6Prefix=%ls\n", this, "NATNetwork::setIPv6Prefix", aIPv6Prefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpIPv6Prefix(aIPv6Prefix);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6PREFIX_ENTER(this, TmpIPv6Prefix.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIPv6Prefix(TmpIPv6Prefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6PREFIX_RETURN(this, hrc, 0 /*normal*/,TmpIPv6Prefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6PREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_IPV6PREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setIPv6Prefix", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(AdvertiseDefaultIPv6RouteEnabled)(BOOL *aAdvertiseDefaultIPv6RouteEnabled)
{
    LogRelFlow(("{%p} %s: enter aAdvertiseDefaultIPv6RouteEnabled=%p\n", this, "NATNetwork::getAdvertiseDefaultIPv6RouteEnabled", aAdvertiseDefaultIPv6RouteEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAdvertiseDefaultIPv6RouteEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ADVERTISEDEFAULTIPV6ROUTE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAdvertiseDefaultIPv6RouteEnabled(aAdvertiseDefaultIPv6RouteEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 0 /*normal*/,*aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 1 /*hrc exception*/,*aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAdvertiseDefaultIPv6RouteEnabled=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getadvertiseDefaultIPv6Route", *aAdvertiseDefaultIPv6RouteEnabled, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(AdvertiseDefaultIPv6RouteEnabled)(BOOL aAdvertiseDefaultIPv6RouteEnabled)
{
    LogRelFlow(("{%p} %s: enter aAdvertiseDefaultIPv6RouteEnabled=%RTbool\n", this, "NATNetwork::setAdvertiseDefaultIPv6RouteEnabled", aAdvertiseDefaultIPv6RouteEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ADVERTISEDEFAULTIPV6ROUTE_ENTER(this, aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAdvertiseDefaultIPv6RouteEnabled(aAdvertiseDefaultIPv6RouteEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 0 /*normal*/,aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 1 /*hrc exception*/,aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_ADVERTISEDEFAULTIPV6ROUTE_RETURN(this, hrc, 9 /*unhandled exception*/,aAdvertiseDefaultIPv6RouteEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setAdvertiseDefaultIPv6RouteEnabled", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(NeedDhcpServer)(BOOL *aNeedDhcpServer)
{
    LogRelFlow(("{%p} %s: enter aNeedDhcpServer=%p\n", this, "NATNetwork::getNeedDhcpServer", aNeedDhcpServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNeedDhcpServer);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NEEDDHCPSERVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNeedDhcpServer(aNeedDhcpServer);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NEEDDHCPSERVER_RETURN(this, hrc, 0 /*normal*/,*aNeedDhcpServer != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NEEDDHCPSERVER_RETURN(this, hrc, 1 /*hrc exception*/,*aNeedDhcpServer != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NEEDDHCPSERVER_RETURN(this, hrc, 9 /*unhandled exception*/,*aNeedDhcpServer != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNeedDhcpServer=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getNeedDhcpServer", *aNeedDhcpServer, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(NeedDhcpServer)(BOOL aNeedDhcpServer)
{
    LogRelFlow(("{%p} %s: enter aNeedDhcpServer=%RTbool\n", this, "NATNetwork::setNeedDhcpServer", aNeedDhcpServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NEEDDHCPSERVER_ENTER(this, aNeedDhcpServer != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNeedDhcpServer(aNeedDhcpServer != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NEEDDHCPSERVER_RETURN(this, hrc, 0 /*normal*/,aNeedDhcpServer != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NEEDDHCPSERVER_RETURN(this, hrc, 1 /*hrc exception*/,aNeedDhcpServer != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NEEDDHCPSERVER_RETURN(this, hrc, 9 /*unhandled exception*/,aNeedDhcpServer != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setNeedDhcpServer", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "NATNetwork::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "NATNetwork::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(PortForwardRules4)(ComSafeArrayOut(BSTR, aPortForwardRules4))
{
    LogRelFlow(("{%p} %s: enter aPortForwardRules4=%p\n", this, "NATNetwork::getPortForwardRules4", aPortForwardRules4));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPortForwardRules4);
        ArrayBSTROutConverter TmpPortForwardRules4(ComSafeArrayOutArg(aPortForwardRules4));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES4_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPortForwardRules4(TmpPortForwardRules4.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES4_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPortForwardRules4.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES4_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES4_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPortForwardRules4=%zu hrc=%Rhrc\n", this, "NATNetwork::getPortForwardRules4", ComSafeArraySize(*aPortForwardRules4), hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(LocalMappings)(ComSafeArrayOut(BSTR, aLocalMappings))
{
    LogRelFlow(("{%p} %s: enter aLocalMappings=%p\n", this, "NATNetwork::getLocalMappings", aLocalMappings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocalMappings);
        ArrayBSTROutConverter TmpLocalMappings(ComSafeArrayOutArg(aLocalMappings));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALMAPPINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocalMappings(TmpLocalMappings.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALMAPPINGS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpLocalMappings.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALMAPPINGS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALMAPPINGS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocalMappings=%zu hrc=%Rhrc\n", this, "NATNetwork::getLocalMappings", ComSafeArraySize(*aLocalMappings), hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(LocalhostReachable)(BOOL *aLocalhostReachable)
{
    LogRelFlow(("{%p} %s: enter aLocalhostReachable=%p\n", this, "NATNetwork::getLocalhostReachable", aLocalhostReachable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocalhostReachable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALHOSTREACHABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocalhostReachable(aLocalhostReachable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 0 /*normal*/,*aLocalhostReachable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aLocalhostReachable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aLocalhostReachable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocalhostReachable=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getLocalhostReachable", *aLocalhostReachable, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(LocalhostReachable)(BOOL aLocalhostReachable)
{
    LogRelFlow(("{%p} %s: enter aLocalhostReachable=%RTbool\n", this, "NATNetwork::setLocalhostReachable", aLocalhostReachable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOCALHOSTREACHABLE_ENTER(this, aLocalhostReachable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLocalhostReachable(aLocalhostReachable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 0 /*normal*/,aLocalhostReachable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 1 /*hrc exception*/,aLocalhostReachable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 9 /*unhandled exception*/,aLocalhostReachable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setLocalhostReachable", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(ForwardBroadcast)(BOOL *aForwardBroadcast)
{
    LogRelFlow(("{%p} %s: enter aForwardBroadcast=%p\n", this, "NATNetwork::getForwardBroadcast", aForwardBroadcast));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForwardBroadcast);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_FORWARDBROADCAST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getForwardBroadcast(aForwardBroadcast);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_FORWARDBROADCAST_RETURN(this, hrc, 0 /*normal*/,*aForwardBroadcast != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_FORWARDBROADCAST_RETURN(this, hrc, 1 /*hrc exception*/,*aForwardBroadcast != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_FORWARDBROADCAST_RETURN(this, hrc, 9 /*unhandled exception*/,*aForwardBroadcast != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForwardBroadcast=%RTbool hrc=%Rhrc\n", this, "NATNetwork::getForwardBroadcast", *aForwardBroadcast, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(ForwardBroadcast)(BOOL aForwardBroadcast)
{
    LogRelFlow(("{%p} %s: enter aForwardBroadcast=%RTbool\n", this, "NATNetwork::setForwardBroadcast", aForwardBroadcast));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_FORWARDBROADCAST_ENTER(this, aForwardBroadcast != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setForwardBroadcast(aForwardBroadcast != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_FORWARDBROADCAST_RETURN(this, hrc, 0 /*normal*/,aForwardBroadcast != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_FORWARDBROADCAST_RETURN(this, hrc, 1 /*hrc exception*/,aForwardBroadcast != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_FORWARDBROADCAST_RETURN(this, hrc, 9 /*unhandled exception*/,aForwardBroadcast != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setForwardBroadcast", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(NatMTU)(ULONG *aNatMTU)
{
    LogRelFlow(("{%p} %s: enter aNatMTU=%p\n", this, "NATNetwork::getNatMTU", aNatMTU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNatMTU);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMTU_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNatMTU(aNatMTU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMTU_RETURN(this, hrc, 0 /*normal*/,*aNatMTU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMTU_RETURN(this, hrc, 1 /*hrc exception*/,*aNatMTU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMTU_RETURN(this, hrc, 9 /*unhandled exception*/,*aNatMTU);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNatMTU=%RU32 hrc=%Rhrc\n", this, "NATNetwork::getNatMTU", *aNatMTU, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(NatMTU)(ULONG aNatMTU)
{
    LogRelFlow(("{%p} %s: enter aNatMTU=%RU32\n", this, "NATNetwork::setNatMTU", aNatMTU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMTU_ENTER(this, aNatMTU);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNatMTU(aNatMTU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMTU_RETURN(this, hrc, 0 /*normal*/,aNatMTU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMTU_RETURN(this, hrc, 1 /*hrc exception*/,aNatMTU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMTU_RETURN(this, hrc, 9 /*unhandled exception*/,aNatMTU);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setNatMTU", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(NatMRU)(ULONG *aNatMRU)
{
    LogRelFlow(("{%p} %s: enter aNatMRU=%p\n", this, "NATNetwork::getNatMRU", aNatMRU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNatMRU);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMRU_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNatMRU(aNatMRU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMRU_RETURN(this, hrc, 0 /*normal*/,*aNatMRU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMRU_RETURN(this, hrc, 1 /*hrc exception*/,*aNatMRU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_NATMRU_RETURN(this, hrc, 9 /*unhandled exception*/,*aNatMRU);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNatMRU=%RU32 hrc=%Rhrc\n", this, "NATNetwork::getNatMRU", *aNatMRU, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(NatMRU)(ULONG aNatMRU)
{
    LogRelFlow(("{%p} %s: enter aNatMRU=%RU32\n", this, "NATNetwork::setNatMRU", aNatMRU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMRU_ENTER(this, aNatMRU);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNatMRU(aNatMRU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMRU_RETURN(this, hrc, 0 /*normal*/,aNatMRU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMRU_RETURN(this, hrc, 1 /*hrc exception*/,aNatMRU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_NATMRU_RETURN(this, hrc, 9 /*unhandled exception*/,aNatMRU);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setNatMRU", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(LoopbackIp6)(LONG *aLoopbackIp6)
{
    LogRelFlow(("{%p} %s: enter aLoopbackIp6=%p\n", this, "NATNetwork::getLoopbackIp6", aLoopbackIp6));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLoopbackIp6);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOOPBACKIP6_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLoopbackIp6(aLoopbackIp6);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOOPBACKIP6_RETURN(this, hrc, 0 /*normal*/,*aLoopbackIp6);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOOPBACKIP6_RETURN(this, hrc, 1 /*hrc exception*/,*aLoopbackIp6);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_LOOPBACKIP6_RETURN(this, hrc, 9 /*unhandled exception*/,*aLoopbackIp6);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLoopbackIp6=%RI32 hrc=%Rhrc\n", this, "NATNetwork::getLoopbackIp6", *aLoopbackIp6, hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMSETTER(LoopbackIp6)(LONG aLoopbackIp6)
{
    LogRelFlow(("{%p} %s: enter aLoopbackIp6=%RI32\n", this, "NATNetwork::setLoopbackIp6", aLoopbackIp6));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOOPBACKIP6_ENTER(this, aLoopbackIp6);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLoopbackIp6(aLoopbackIp6);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOOPBACKIP6_RETURN(this, hrc, 0 /*normal*/,aLoopbackIp6);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOOPBACKIP6_RETURN(this, hrc, 1 /*hrc exception*/,aLoopbackIp6);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_SET_LOOPBACKIP6_RETURN(this, hrc, 9 /*unhandled exception*/,aLoopbackIp6);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::setLoopbackIp6", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(PortForwardRules6)(ComSafeArrayOut(BSTR, aPortForwardRules6))
{
    LogRelFlow(("{%p} %s: enter aPortForwardRules6=%p\n", this, "NATNetwork::getPortForwardRules6", aPortForwardRules6));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPortForwardRules6);
        ArrayBSTROutConverter TmpPortForwardRules6(ComSafeArrayOutArg(aPortForwardRules6));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES6_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPortForwardRules6(TmpPortForwardRules6.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES6_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPortForwardRules6.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES6_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_GET_PORTFORWARDRULES6_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPortForwardRules6=%zu hrc=%Rhrc\n", this, "NATNetwork::getPortForwardRules6", ComSafeArraySize(*aPortForwardRules6), hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute1INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute2INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute3INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute4INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute5INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute6INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute7INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::COMGETTER(InternalAndReservedAttribute8INATNetwork)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// INATNetwork methods
//

STDMETHODIMP NATNetworkWrap::AddLocalMapping(IN_BSTR aHostid,
                                             LONG aOffset)
{
    LogRelFlow(("{%p} %s: enter aHostid=%ls aOffset=%RI32\n", this, "NATNetwork::addLocalMapping", aHostid, aOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpHostid(aHostid);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDLOCALMAPPING_ENTER(this, TmpHostid.str().c_str(), aOffset);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addLocalMapping(TmpHostid.str(),
                                  aOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDLOCALMAPPING_RETURN(this, hrc, 0 /*normal*/, TmpHostid.str().c_str(), aOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDLOCALMAPPING_RETURN(this, hrc, 1 /*hrc exception*/, 0, aOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDLOCALMAPPING_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::addLocalMapping", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::AddPortForwardRule(BOOL aIsIpv6,
                                                IN_BSTR aRuleName,
                                                NATProtocol_T aProto,
                                                IN_BSTR aHostIP,
                                                USHORT aHostPort,
                                                IN_BSTR aGuestIP,
                                                USHORT aGuestPort)
{
    LogRelFlow(("{%p} %s: enter aIsIpv6=%RTbool aRuleName=%ls aProto=%RU32 aHostIP=%ls aHostPort=%RU16 aGuestIP=%ls aGuestPort=%RU16\n", this, "NATNetwork::addPortForwardRule", aIsIpv6, aRuleName, aProto, aHostIP, aHostPort, aGuestIP, aGuestPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpRuleName(aRuleName);
        
        BSTRInConverter TmpHostIP(aHostIP);
        
        BSTRInConverter TmpGuestIP(aGuestIP);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDPORTFORWARDRULE_ENTER(this, aIsIpv6 != FALSE, TmpRuleName.str().c_str(), aProto, TmpHostIP.str().c_str(), aHostPort, TmpGuestIP.str().c_str(), aGuestPort);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addPortForwardRule(aIsIpv6 != FALSE,
                                     TmpRuleName.str(),
                                     aProto,
                                     TmpHostIP.str(),
                                     aHostPort,
                                     TmpGuestIP.str(),
                                     aGuestPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDPORTFORWARDRULE_RETURN(this, hrc, 0 /*normal*/, aIsIpv6 != FALSE, TmpRuleName.str().c_str(), aProto, TmpHostIP.str().c_str(), aHostPort, TmpGuestIP.str().c_str(), aGuestPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDPORTFORWARDRULE_RETURN(this, hrc, 1 /*hrc exception*/, aIsIpv6 != FALSE, 0, aProto, 0, aHostPort, 0, aGuestPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_ADDPORTFORWARDRULE_RETURN(this, hrc, 9 /*unhandled exception*/, aIsIpv6 != FALSE, 0, aProto, 0, aHostPort, 0, aGuestPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::addPortForwardRule", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::RemovePortForwardRule(BOOL aIsIpv6,
                                                   IN_BSTR aRuleName)
{
    LogRelFlow(("{%p} %s: enter aIsIpv6=%RTbool aRuleName=%ls\n", this, "NATNetwork::removePortForwardRule", aIsIpv6, aRuleName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpRuleName(aRuleName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_REMOVEPORTFORWARDRULE_ENTER(this, aIsIpv6 != FALSE, TmpRuleName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removePortForwardRule(aIsIpv6 != FALSE,
                                        TmpRuleName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_REMOVEPORTFORWARDRULE_RETURN(this, hrc, 0 /*normal*/, aIsIpv6 != FALSE, TmpRuleName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_REMOVEPORTFORWARDRULE_RETURN(this, hrc, 1 /*hrc exception*/, aIsIpv6 != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_REMOVEPORTFORWARDRULE_RETURN(this, hrc, 9 /*unhandled exception*/, aIsIpv6 != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::removePortForwardRule", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::Start()
{
    LogRelFlow(("{%p} %s: enter\n", this, "NATNetwork::start"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_START_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = start();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_START_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_START_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_START_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::start", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::Stop()
{
    LogRelFlow(("{%p} %s: enter\n", this, "NATNetwork::stop"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_STOP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = stop();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_STOP_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_STOP_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATNETWORK_STOP_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATNetwork::stop", hrc));
    return hrc;
}

STDMETHODIMP NATNetworkWrap::InternalAndReservedMethod1INATNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::InternalAndReservedMethod2INATNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::InternalAndReservedMethod3INATNetwork()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATNetworkWrap::InternalAndReservedMethod4INATNetwork()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(NATNetworkWrap, INATNetwork)
#endif // VBOX_WITH_XPCOM
