/** @file
 * VirtualBox API class wrapper code for IUefiVariableStore.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_UEFIVARIABLESTORE

#include "UefiVariableStoreWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(UefiVariableStoreWrap)

//
// IUefiVariableStore properties
//

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(SecureBootEnabled)(BOOL *aSecureBootEnabled)
{
    LogRelFlow(("{%p} %s: enter aSecureBootEnabled=%p\n", this, "UefiVariableStore::getSecureBootEnabled", aSecureBootEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSecureBootEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_GET_SECUREBOOTENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSecureBootEnabled(aSecureBootEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_GET_SECUREBOOTENABLED_RETURN(this, hrc, 0 /*normal*/,*aSecureBootEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_GET_SECUREBOOTENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aSecureBootEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_GET_SECUREBOOTENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aSecureBootEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSecureBootEnabled=%RTbool hrc=%Rhrc\n", this, "UefiVariableStore::getSecureBootEnabled", *aSecureBootEnabled, hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::COMSETTER(SecureBootEnabled)(BOOL aSecureBootEnabled)
{
    LogRelFlow(("{%p} %s: enter aSecureBootEnabled=%RTbool\n", this, "UefiVariableStore::setSecureBootEnabled", aSecureBootEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_SET_SECUREBOOTENABLED_ENTER(this, aSecureBootEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSecureBootEnabled(aSecureBootEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_SET_SECUREBOOTENABLED_RETURN(this, hrc, 0 /*normal*/,aSecureBootEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_SET_SECUREBOOTENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aSecureBootEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_SET_SECUREBOOTENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aSecureBootEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::setSecureBootEnabled", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(InternalAndReservedAttribute1IUefiVariableStore)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(InternalAndReservedAttribute2IUefiVariableStore)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(InternalAndReservedAttribute3IUefiVariableStore)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(InternalAndReservedAttribute4IUefiVariableStore)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::COMGETTER(InternalAndReservedAttribute5IUefiVariableStore)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUefiVariableStore methods
//

STDMETHODIMP UefiVariableStoreWrap::AddVariable(IN_BSTR aName,
                                                IN_BSTR aOwner,
                                                ComSafeArrayIn(UefiVariableAttributes_T, aAttributes),
                                                ComSafeArrayIn(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aName=%ls aOwner=%ls aAttributes=%zu aData=%zu\n", this, "UefiVariableStore::addVariable", aName, aOwner, aAttributes, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        UuidInConverter TmpOwner(aOwner);
        ArrayInConverter<UefiVariableAttributes_T> TmpAttributes(ComSafeArrayInArg(aAttributes));
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDVARIABLE_ENTER(this, TmpName.str().c_str(), TmpOwner.uuid().toStringCurly().c_str(), (uint32_t)TmpAttributes.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addVariable(TmpName.str(),
                              TmpOwner.uuid(),
                              TmpAttributes.array(),
                              TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDVARIABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpOwner.uuid().toStringCurly().c_str(), (uint32_t)TmpAttributes.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDVARIABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDVARIABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::addVariable", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::DeleteVariable(IN_BSTR aName,
                                                   IN_BSTR aOwner)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aOwner=%ls\n", this, "UefiVariableStore::deleteVariable", aName, aOwner));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        UuidInConverter TmpOwner(aOwner);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_DELETEVARIABLE_ENTER(this, TmpName.str().c_str(), TmpOwner.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteVariable(TmpName.str(),
                                 TmpOwner.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_DELETEVARIABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpOwner.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_DELETEVARIABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_DELETEVARIABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::deleteVariable", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::ChangeVariable(IN_BSTR aName,
                                                   ComSafeArrayIn(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aName=%ls aData=%zu\n", this, "UefiVariableStore::changeVariable", aName, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_CHANGEVARIABLE_ENTER(this, TmpName.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = changeVariable(TmpName.str(),
                                 TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_CHANGEVARIABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_CHANGEVARIABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_CHANGEVARIABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::changeVariable", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::QueryVariableByName(IN_BSTR aName,
                                                        BSTR *aOwner,
                                                        ComSafeArrayOut(UefiVariableAttributes_T, aAttributes),
                                                        ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aName=%ls aOwner=%p aAttributes=%p aData=%p\n", this, "UefiVariableStore::queryVariableByName", aName, aOwner, aAttributes, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOwner);
        CheckComArgOutPointerValidThrow(aAttributes);
        CheckComArgOutPointerValidThrow(aData);


        BSTRInConverter TmpName(aName);
        UuidOutConverter TmpOwner(aOwner);
        ArrayOutConverter<UefiVariableAttributes_T> TmpAttributes(ComSafeArrayOutArg(aAttributes));
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLEBYNAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryVariableByName(TmpName.str(),
                                      TmpOwner.uuid(),
                                      TmpAttributes.array(),
                                      TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLEBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpOwner.uuid().toStringCurly().c_str(), (uint32_t)TmpAttributes.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLEBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLEBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOwner=%ls *aAttributes=%zu *aData=%zu hrc=%Rhrc\n", this, "UefiVariableStore::queryVariableByName", *aOwner, ComSafeArraySize(*aAttributes), ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::QueryVariables(ComSafeArrayOut(BSTR, aNames),
                                                   ComSafeArrayOut(BSTR, aOwners))
{
    LogRelFlow(("{%p} %s: enter aNames=%p aOwners=%p\n", this, "UefiVariableStore::queryVariables", aNames, aOwners));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNames);
        CheckComArgOutPointerValidThrow(aOwners);


        ArrayBSTROutConverter TmpNames(ComSafeArrayOutArg(aNames));
        ArrayUuidOutConverter TmpOwners(ComSafeArrayOutArg(aOwners));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryVariables(TmpNames.array(),
                                 TmpOwners.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpOwners.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_QUERYVARIABLES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNames=%zu *aOwners=%zu hrc=%Rhrc\n", this, "UefiVariableStore::queryVariables", ComSafeArraySize(*aNames), ComSafeArraySize(*aOwners), hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::EnrollOraclePlatformKey()
{
    LogRelFlow(("{%p} %s: enter\n", this, "UefiVariableStore::enrollOraclePlatformKey"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLORACLEPLATFORMKEY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enrollOraclePlatformKey();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLORACLEPLATFORMKEY_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLORACLEPLATFORMKEY_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLORACLEPLATFORMKEY_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::enrollOraclePlatformKey", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::EnrollPlatformKey(ComSafeArrayIn(BYTE, aPlatformKey),
                                                      IN_BSTR aOwner)
{
    LogRelFlow(("{%p} %s: enter aPlatformKey=%zu aOwner=%ls\n", this, "UefiVariableStore::enrollPlatformKey", aPlatformKey, aOwner));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BYTE> TmpPlatformKey(ComSafeArrayInArg(aPlatformKey));
        UuidInConverter TmpOwner(aOwner);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLPLATFORMKEY_ENTER(this, (uint32_t)TmpPlatformKey.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enrollPlatformKey(TmpPlatformKey.array(),
                                    TmpOwner.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLPLATFORMKEY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpPlatformKey.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLPLATFORMKEY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLPLATFORMKEY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::enrollPlatformKey", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::AddKek(ComSafeArrayIn(BYTE, aKeyEncryptionKey),
                                           IN_BSTR aOwner,
                                           SignatureType_T aSignatureType)
{
    LogRelFlow(("{%p} %s: enter aKeyEncryptionKey=%zu aOwner=%ls aSignatureType=%RU32\n", this, "UefiVariableStore::addKek", aKeyEncryptionKey, aOwner, aSignatureType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BYTE> TmpKeyEncryptionKey(ComSafeArrayInArg(aKeyEncryptionKey));
        UuidInConverter TmpOwner(aOwner);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDKEK_ENTER(this, (uint32_t)TmpKeyEncryptionKey.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addKek(TmpKeyEncryptionKey.array(),
                         TmpOwner.uuid(),
                         aSignatureType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDKEK_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpKeyEncryptionKey.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDKEK_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aSignatureType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDKEK_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aSignatureType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::addKek", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::AddSignatureToDb(ComSafeArrayIn(BYTE, aSignature),
                                                     IN_BSTR aOwner,
                                                     SignatureType_T aSignatureType)
{
    LogRelFlow(("{%p} %s: enter aSignature=%zu aOwner=%ls aSignatureType=%RU32\n", this, "UefiVariableStore::addSignatureToDb", aSignature, aOwner, aSignatureType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BYTE> TmpSignature(ComSafeArrayInArg(aSignature));
        UuidInConverter TmpOwner(aOwner);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODB_ENTER(this, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addSignatureToDb(TmpSignature.array(),
                                   TmpOwner.uuid(),
                                   aSignatureType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODB_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODB_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aSignatureType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODB_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aSignatureType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::addSignatureToDb", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::AddSignatureToDbx(ComSafeArrayIn(BYTE, aSignature),
                                                      IN_BSTR aOwner,
                                                      SignatureType_T aSignatureType)
{
    LogRelFlow(("{%p} %s: enter aSignature=%zu aOwner=%ls aSignatureType=%RU32\n", this, "UefiVariableStore::addSignatureToDbx", aSignature, aOwner, aSignatureType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BYTE> TmpSignature(ComSafeArrayInArg(aSignature));
        UuidInConverter TmpOwner(aOwner);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODBX_ENTER(this, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addSignatureToDbx(TmpSignature.array(),
                                    TmpOwner.uuid(),
                                    aSignatureType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODBX_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODBX_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aSignatureType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETODBX_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aSignatureType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::addSignatureToDbx", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::EnrollDefaultMsSignatures()
{
    LogRelFlow(("{%p} %s: enter\n", this, "UefiVariableStore::enrollDefaultMsSignatures"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLDEFAULTMSSIGNATURES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enrollDefaultMsSignatures();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLDEFAULTMSSIGNATURES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLDEFAULTMSSIGNATURES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ENROLLDEFAULTMSSIGNATURES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::enrollDefaultMsSignatures", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::AddSignatureToMok(ComSafeArrayIn(BYTE, aSignature),
                                                      IN_BSTR aOwner,
                                                      SignatureType_T aSignatureType)
{
    LogRelFlow(("{%p} %s: enter aSignature=%zu aOwner=%ls aSignatureType=%RU32\n", this, "UefiVariableStore::addSignatureToMok", aSignature, aOwner, aSignatureType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BYTE> TmpSignature(ComSafeArrayInArg(aSignature));
        UuidInConverter TmpOwner(aOwner);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETOMOK_ENTER(this, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addSignatureToMok(TmpSignature.array(),
                                    TmpOwner.uuid(),
                                    aSignatureType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETOMOK_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSignature.array().size(), NULL /*for now*/, TmpOwner.uuid().toStringCurly().c_str(), aSignatureType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETOMOK_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, aSignatureType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_UEFIVARIABLESTORE_ADDSIGNATURETOMOK_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, aSignatureType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "UefiVariableStore::addSignatureToMok", hrc));
    return hrc;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod1IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod2IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod3IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod4IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod5IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod6IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod7IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod8IUefiVariableStore()
{
    return E_NOTIMPL;
}

STDMETHODIMP UefiVariableStoreWrap::InternalAndReservedMethod9IUefiVariableStore()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UefiVariableStoreWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(UefiVariableStoreWrap, IUefiVariableStore)
#endif // VBOX_WITH_XPCOM
