/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLTransaction.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSQLStatementCallback.h"
#include "JSSQLStatementErrorCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSQLTransactionPrototypeFunction_executeSql);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSQLTransactionConstructor);

class JSSQLTransactionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLTransactionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLTransactionPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLTransactionPrototype>(vm)) JSSQLTransactionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLTransactionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLTransactionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLTransactionPrototype, JSSQLTransactionPrototype::Base);

using JSSQLTransactionDOMConstructor = JSDOMConstructorNotConstructable<JSSQLTransaction>;

template<> const ClassInfo JSSQLTransactionDOMConstructor::s_info = { "SQLTransaction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransactionDOMConstructor) };

template<> JSValue JSSQLTransactionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLTransactionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SQLTransaction"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSQLTransaction::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSSQLTransactionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLTransactionConstructor, 0 } },
    HashTableValue { "executeSql"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSQLTransactionPrototypeFunction_executeSql, 1 } },
};

const ClassInfo JSSQLTransactionPrototype::s_info = { "SQLTransaction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransactionPrototype) };

void JSSQLTransactionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLTransaction::info(), JSSQLTransactionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSQLTransaction::s_info = { "SQLTransaction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransaction) };

JSSQLTransaction::JSSQLTransaction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLTransaction>&& impl)
    : JSDOMWrapper<SQLTransaction>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SQLTransaction>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSQLTransaction::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSQLTransactionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSQLTransactionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSQLTransaction::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLTransaction>(vm, globalObject);
}

JSValue JSSQLTransaction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLTransactionDOMConstructor, DOMConstructorID::SQLTransaction>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLTransaction::destroy(JSC::JSCell* cell)
{
    JSSQLTransaction* thisObject = static_cast<JSSQLTransaction*>(cell);
    thisObject->JSSQLTransaction::~JSSQLTransaction();
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLTransactionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLTransactionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLTransaction::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsSQLTransactionPrototypeFunction_executeSqlBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSQLTransaction>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sqlStatementConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (sqlStatementConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto argumentsConversionResult = convertOptionalWithDefault<IDLNullable<IDLSequence<IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLNullable<IDLSequence<IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>> { return Converter<IDLNullable<IDLSequence<IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>>::ReturnType { }; });
    if (argumentsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto callbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLStatementCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "callback"_s, "SQLTransaction"_s, "executeSql"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLStatementErrorCallback>>>(*lexicalGlobalObject, argument3.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback"_s, "SQLTransaction"_s, "executeSql"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.executeSql(sqlStatementConversionResult.releaseReturnValue(), argumentsConversionResult.releaseReturnValue(), callbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSQLTransactionPrototypeFunction_executeSql, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSQLTransaction>::call<jsSQLTransactionPrototypeFunction_executeSqlBody>(*lexicalGlobalObject, *callFrame, "executeSql");
}

JSC::GCClient::IsoSubspace* JSSQLTransaction::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSQLTransaction, UseCustomHeapCellType::No>(vm, "JSSQLTransaction"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSQLTransaction.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSQLTransaction = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSQLTransaction.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSQLTransaction = std::forward<decltype(space)>(space); }
    );
}

void JSSQLTransaction::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLTransaction*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLTransactionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLTransactionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLTransaction = static_cast<JSSQLTransaction*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSQLTransaction->protectedWrapped().ptr(), jsSQLTransaction);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLTransaction>&& impl)
{
    return createWrapper<SQLTransaction>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLTransaction& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLTransaction* JSSQLTransaction::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLTransaction*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
